/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.B1000Types;
import edu.iris.dmc.seedcodec.Cdsn;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.Sro;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.iris.dmc.seedcodec.Utility;

public class Codec
implements B1000Types {
    public DecompressedData decompress(int type, byte[] b, int numSamples, boolean swapBytes) throws CodecException, UnsupportedCompressionType {
        DecompressedData out;
        if (numSamples == 0) {
            return new DecompressedData(new int[0]);
        }
        int offset = 0;
        switch (type) {
            case 1: 
            case 32: {
                if (b.length < 2 * numSamples) {
                    throw new CodecException("Not enough bytes for " + numSamples + " 16 bit data points, only " + b.length + " bytes.");
                }
                short[] stemp = new short[numSamples];
                for (int i = 0; i < stemp.length; ++i) {
                    stemp[i] = Utility.bytesToShort(b[offset], b[offset + 1], swapBytes);
                    offset += 2;
                }
                out = new DecompressedData(stemp);
                break;
            }
            case 2: {
                if (b.length < 3 * numSamples) {
                    throw new CodecException("Not enough bytes for " + numSamples + " 24 bit data points, only " + b.length + " bytes.");
                }
                int[] itemp = new int[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    itemp[i] = Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], swapBytes);
                    offset += 3;
                }
                out = new DecompressedData(itemp);
                break;
            }
            case 3: {
                if (b.length < 4 * numSamples) {
                    throw new CodecException("Not enough bytes for " + numSamples + " 32 bit data points, only " + b.length + " bytes.");
                }
                int[] itemp = new int[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    itemp[i] = Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3], swapBytes);
                    offset += 4;
                }
                out = new DecompressedData(itemp);
                break;
            }
            case 4: {
                if (b.length < 4 * numSamples) {
                    throw new CodecException("Not enough bytes for " + numSamples + " 32 bit data points, only " + b.length + " bytes.");
                }
                float[] ftemp = new float[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    ftemp[i] = Float.intBitsToFloat(Utility.bytesToInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3], swapBytes));
                    offset += 4;
                }
                out = new DecompressedData(ftemp);
                break;
            }
            case 5: {
                if (b.length < 8 * numSamples) {
                    throw new CodecException("Not enough bytes for " + numSamples + " 64 bit data points, only " + b.length + " bytes.");
                }
                double[] dtemp = new double[numSamples];
                for (int i = 0; i < numSamples; ++i) {
                    dtemp[i] = Double.longBitsToDouble(Utility.bytesToLong(b[offset], b[offset + 1], b[offset + 2], b[offset + 3], b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7], swapBytes));
                    offset += 8;
                }
                out = new DecompressedData(dtemp);
                break;
            }
            case 10: {
                int[] itemp = Steim1.decode(b, numSamples, swapBytes, 0);
                out = new DecompressedData(itemp);
                break;
            }
            case 11: {
                int[] itemp = Steim2.decode(b, numSamples, swapBytes, 0);
                out = new DecompressedData(itemp);
                break;
            }
            case 16: {
                int[] itemp = Cdsn.decode(b, numSamples, swapBytes);
                out = new DecompressedData(itemp);
                break;
            }
            case 30: {
                int[] itemp = Sro.decode(b, numSamples, swapBytes);
                out = new DecompressedData(itemp);
                break;
            }
            default: {
                throw new UnsupportedCompressionType("Type " + type + " is not supported at this time.");
            }
        }
        return out;
    }

    public int getDecompressedType(int type) throws UnsupportedCompressionType {
        if (type == 2 || type == 3 || type == 10 || type == 11 || type == 16 || type == 30) {
            return 3;
        }
        if (type == 1 || type == 32) {
            return 1;
        }
        if (type == 4) {
            return 4;
        }
        if (type == 5) {
            return 5;
        }
        throw new UnsupportedCompressionType("Type " + type + " is not supported at this time.");
    }

    public byte[] encodeAsBytes(short[] data) {
        byte[] dataBytes = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            dataBytes[2 * i] = (byte)((data[i] & 0xFF00) >> 8);
            dataBytes[2 * i + 1] = (byte)(data[i] & 0xFF);
        }
        return dataBytes;
    }

    public byte[] encodeAsBytes(int[] data) {
        byte[] dataBytes = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            dataBytes[4 * i] = (byte)((data[i] & 0xFF000000) >> 24);
            dataBytes[4 * i + 1] = (byte)((data[i] & 0xFF0000) >> 16);
            dataBytes[4 * i + 2] = (byte)((data[i] & 0xFF00) >> 8);
            dataBytes[4 * i + 3] = (byte)(data[i] & 0xFF);
        }
        return dataBytes;
    }

    public byte[] encodeAsBytes(float[] data) {
        int[] tmp = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            tmp[i] = Float.floatToIntBits(data[i]);
        }
        return this.encodeAsBytes(tmp);
    }

    public byte[] encodeAsBytes(double[] data) {
        byte[] dataBytes = new byte[data.length * 8];
        int byteOffset = 0;
        for (int i = 0; i < data.length; ++i) {
            long val = Double.doubleToLongBits(data[i]);
            byteOffset = 8 * i;
            dataBytes[byteOffset] = (byte)((val & 0xFF00000000000000L) >> 56);
            dataBytes[byteOffset + 1] = (byte)((val & 0xFF000000000000L) >> 48);
            dataBytes[byteOffset + 2] = (byte)((val & 0xFF0000000000L) >> 40);
            dataBytes[byteOffset + 3] = (byte)((val & 0xFF00000000L) >> 32);
            dataBytes[byteOffset + 4] = (byte)((val & 0xFF000000L) >> 24);
            dataBytes[byteOffset + 5] = (byte)((val & 0xFF0000L) >> 16);
            dataBytes[byteOffset + 6] = (byte)((val & 0xFF00L) >> 8);
            dataBytes[byteOffset + 7] = (byte)(val & 0xFFL);
        }
        return dataBytes;
    }
}

