/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import java.text.DecimalFormat;

public class MagnitudeUtil {
    static DecimalFormat numberFormat = new DecimalFormat("0.0");

    public static String toString(Magnitude m) {
        return numberFormat.format(m.value) + " " + m.type;
    }

    public static boolean areEqual(Magnitude a, Magnitude b) {
        if (a == b) {
            return true;
        }
        return a.contributor.equals(b.contributor) && a.type.equals(b.type) && a.value == b.value;
    }

    public static boolean areEqual(Magnitude[] a, Magnitude[] b) {
        if (a.length == b.length) {
            for (int i = 0; i < a.length; ++i) {
                if (MagnitudeUtil.areEqual(a[i], b[i])) continue;
                boolean found = false;
                for (int j = 0; j < a.length && !found; ++j) {
                    if (!MagnitudeUtil.areEqual(a[i], b[j])) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int hash(Magnitude m) {
        int result = 63;
        result += result * 37 + m.contributor.hashCode();
        result += result * 37 + m.type.hashCode();
        result += result * 37 + Float.floatToIntBits(m.value);
        return result;
    }

    public static int hash(Magnitude[] mags) {
        int result = 0;
        for (int i = 0; i < mags.length; ++i) {
            result += MagnitudeUtil.hash(mags[i]);
        }
        return result;
    }
}

