/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.gps;

import gov.usgs.proj.Projection;
import gov.usgs.vdx.in.gps.Stacov;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.text.ParseException;

public class StacovToSQL {
    private static boolean circleFilter(double[] circleFilter, double longitude, double latitude) {
        if (circleFilter != null) {
            int k = 0;
            int nCircles = circleFilter.length / 3;
            boolean result = false;
            while (!result & k < nCircles) {
                double radius = circleFilter[k * 3] * 1000.0;
                double phi = circleFilter[k * 3 + 1];
                double lambda = circleFilter[k * 3 + 2];
                result = radius > Projection.distanceBetween(new Point2D.Double(phi, lambda), new Point2D.Double(longitude, latitude));
                ++k;
            }
            return result;
        }
        return true;
    }

    private static boolean boxFilter(double[] boxFilter, double longitude, double latitude) {
        if (boxFilter != null) {
            int k = 0;
            int nBoxes = boxFilter.length / 4;
            boolean result = false;
            while (!result & k < nBoxes) {
                double minLon = boxFilter[k * 4];
                double maxLon = boxFilter[k * 4 + 1];
                double minLat = boxFilter[k * 4 + 2];
                double maxLat = boxFilter[k * 4 + 3];
                result = longitude >= minLon & longitude <= maxLon & latitude >= minLat & latitude <= maxLat;
                ++k;
            }
            return result;
        }
        return true;
    }

    private static boolean stationFilter(String[] Stations, String code) {
        if (Stations != null) {
            int k = 0;
            boolean result = false;
            while (!result & k < Stations.length) {
                if (code.toLowerCase().compareTo(Stations[k].toLowerCase()) == 0) {
                    result = true;
                }
                ++k;
            }
            return result;
        }
        return true;
    }

    public static void main(String[] args) throws FileNotFoundException, ParseException {
        int i;
        int rankID = 1;
        double[] circleFilter = null;
        double[] boxFilter = null;
        String Circle = "";
        String Box = "";
        String[] stations = null;
        boolean notAlreadyPrinted = true;
        if (args.length == 0) {
            System.out.println("Usage: StacovToSQL options stacovfile ...");
            System.out.println("");
            System.out.println("Reads stacov files and writes SQL statements to the standard output");
            System.out.println("suitable for insertion into a VALVE GPS database.  Multiple stacov");
            System.out.println("files may be given.");
            System.out.println("");
            System.out.println("Arguments:");
            System.out.println("");
            System.out.println("  --rankID=<rank>");
            System.out.println("     Assigns the rankID of the inserted solution. If omitted, the");
            System.out.println("     default is 1.");
            System.out.println("");
            System.out.println("  --box=<minLon>,<maxLon>,<minLat>,<maxLat>");
            System.out.println("     Defines a geographic box filter. Stations within this box pass");
            System.out.println("     through the filter. Longitude and latitude are given in decimal");
            System.out.println("     degrees.");
            System.out.println("");
            System.out.println("  --circle=<radius>,<Lon>,<Lat>");
            System.out.println("     Defines a geographic circle filter. Stations within this circle");
            System.out.println("     pass throught the filter. Longitude and latitude are given in");
            System.out.println("     decimal degrees. Radius is given in kilometers.");
            System.out.println("");
            System.out.println("  --stations=<sta1>,<sta2>, ...");
            System.out.println("     Defines a stations filter. Stations on the list will pass");
            System.out.println("     through the filter.");
            System.out.println("");
            System.out.println("Notes:");
            System.out.println("");
            System.out.println("  Multiple geographic filters may be defined. Only one station filter");
            System.out.println("  may be defined.");
            System.out.println(" ");
            System.out.println("  Including a station name using the --stations argument does not    ");
            System.out.println("  guarantee the station will appear in the output.  It may be blocked");
            System.out.println("  by a geographic filter.");
            System.out.println("");
            System.out.println("  The 'circle' is actually a spherical cap, meaning that the");
            System.out.println("  radius value is a great circle distance.  Distance is computed on a");
            System.out.println("  sphere of radius = 6378137 meters. Likewise, the 'box' is");
            System.out.println("  really a latitude-longitude rectangle on a sphere.");
            System.out.println("");
            System.out.println("  The arguments can be given in any order. White space separates the");
            System.out.println("  argument.");
            System.out.println("");
            System.out.println("Version 0.9, June 30, 2011, report bugs to: pcervelli@usgs.gov");
            System.out.println("");
            return;
        }
        int c = 0;
        while (args[c].startsWith("--")) {
            String key = args[c].split("=")[0].substring(2);
            String value = args[c].split("=")[1];
            if (key.toLowerCase().startsWith("c")) {
                Circle = Circle + value + ",";
            } else if (key.toLowerCase().startsWith("b")) {
                Box = Box + value + ",";
            } else if (key.toLowerCase().startsWith("s")) {
                stations = value.split(",");
            } else if (key.toLowerCase().startsWith("r")) {
                rankID = Integer.parseInt(value);
            }
            ++c;
        }
        if (Circle.length() > 0) {
            String[] Circles = Circle.split(",");
            circleFilter = new double[Circles.length];
            for (i = 0; i < Circles.length; ++i) {
                circleFilter[i] = Double.parseDouble(Circles[i]);
            }
        }
        if (Box.length() > 0) {
            String[] Boxes = Box.split(",");
            boxFilter = new double[Boxes.length];
            for (i = 0; i < Boxes.length; ++i) {
                boxFilter[i] = Double.parseDouble(Boxes[i]);
            }
        }
        for (i = c; i < args.length; ++i) {
            Stacov stacov = new Stacov(args[i]);
            notAlreadyPrinted = true;
            if (!stacov.isValid) continue;
            for (int j = 0; j < stacov.nStations; ++j) {
                double[] llh = stacov.llh(j);
                boolean condition = circleFilter == null | boxFilter == null ? StacovToSQL.circleFilter(circleFilter, llh[0], llh[1]) & StacovToSQL.boxFilter(boxFilter, llh[0], llh[1]) & StacovToSQL.stationFilter(stations, stacov.code[j]) : StacovToSQL.circleFilter(circleFilter, llh[0], llh[1]) | StacovToSQL.boxFilter(boxFilter, llh[0], llh[1]) & StacovToSQL.stationFilter(stations, stacov.code[j]);
                if (!condition) continue;
                if (notAlreadyPrinted) {
                    System.out.printf("INSERT IGNORE INTO sources (name,j2ksec0,j2ksec1,rid) VALUES (\"%s\",%f,%f,%s);\n", stacov.name, stacov.j2ksec0, stacov.j2ksec1, rankID);
                    System.out.printf("SELECT sid FROM sources WHERE name=\"%s\" AND j2ksec0=%f AND j2ksec1=%f AND rid=%s INTO @sourceID;\n", stacov.name, stacov.j2ksec0, stacov.j2ksec1, rankID);
                    notAlreadyPrinted = false;
                }
                System.out.printf("INSERT IGNORE INTO channels (code,lon,lat,height) VALUES (\"%s\",%20.15f,%20.15f,%20.15f);\n", stacov.code[j], llh[0], llh[1], llh[2]);
                System.out.printf("SELECT cid FROM channels WHERE code=\"%s\" INTO @channelID;\n", stacov.code[j]);
                System.out.printf("INSERT INTO solutions VALUES (@sourceID,@channelID,%.17e,%.17e,%.17e,%.17e,%.17e,%.17e,%.17e,%.17e,%.17e);\n", stacov.data[0][j], stacov.data[1][j], stacov.data[2][j], stacov.covariance[0][j], stacov.covariance[1][j], stacov.covariance[2][j], stacov.covariance[3][j], stacov.covariance[4][j], stacov.covariance[5][j]);
            }
        }
    }
}

