/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.gps;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.vdx.data.gps.SQLGPSDataSource;

public class ImportSum {
    private SQLGPSDataSource dataSource = new SQLGPSDataSource();

    public ImportSum(String prefix, String name) {
        ConfigFile params = new ConfigFile();
        params.put("vdx.driver", "com.mysql.jdbc.Driver");
        params.put("vdx.url", "jdbc:mysql://localhost/?user=vdx&password=vdx");
        params.put("vdx.prefix", prefix);
        params.put("vdx.name", name);
    }

    public void importSum(String fn) {
        ResourceReader rr = ResourceReader.getResourceReader(fn);
        if (rr == null) {
            return;
        }
        String[] ss = rr.nextLine().split("\t");
        String bm = ss[1].toUpperCase();
        ss = rr.nextLine().split("\t");
        double dlat = Double.parseDouble(ss[1].trim());
        double sign = 1.0;
        if (dlat < 0.0) {
            sign = -1.0;
        }
        dlat = Math.abs(dlat);
        double lat = dlat + Double.parseDouble(ss[2].trim()) / 60.0 + Double.parseDouble(ss[3].trim()) / 3600.0;
        lat *= sign;
        ss = rr.nextLine().split("\t");
        double dlon = Double.parseDouble(ss[1].trim());
        sign = 1.0;
        if (dlon < 0.0) {
            sign = -1.0;
        }
        dlon = Math.abs(dlon);
        double lon = dlon + Double.parseDouble(ss[2].trim()) / 60.0 + Double.parseDouble(ss[3].trim()) / 3600.0;
        ss = rr.nextLine().split("\t");
        double height = Double.parseDouble(ss[1].trim());
        this.dataSource.createChannel(bm, bm, lon *= sign, lat, height, 1);
        System.out.printf("%s %f %f %f\n", bm, lon, lat, height);
        rr.close();
    }

    public static void main(String[] args) {
        ImportSum is = new ImportSum(args[0], args[1]);
        for (int i = 2; i < args.length; ++i) {
            is.importSum(args[i]);
        }
    }
}

