/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tilt.ptx;

import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Logger;

public class PTXRecord {
    protected static final Logger logger = Log.getLogger("gov.usgs.vdx.data.tilt.ptx.PTXRecord");
    public static final double VOLTS_PER_COUNT = 2.980232E-7;
    public static final int MAX_BIT = 0xFFFFFF;
    private byte[] buffer;

    public PTXRecord(byte[] b) {
        this.buffer = b;
    }

    private long createInt(byte b0, byte b1, byte b2, byte b3) {
        return b0 & 0xFF | (b1 & 0xFF) << 8 & 0xFF00 | (b2 & 0xFF) << 16 & 0xFF0000 | (b3 & 0xFF) << 24 & 0xFF000000 & 0xFFFFFFFF;
    }

    public int getNumBytes() {
        return (int)this.createInt(this.buffer[0], this.buffer[1], (byte)0, (byte)0);
    }

    public long getStartTime() {
        return this.createInt(this.buffer[5], this.buffer[4], this.buffer[3], this.buffer[2]);
    }

    public int getTemperature() {
        return (int)this.createInt(this.buffer[6], this.buffer[7], this.buffer[8], (byte)0);
    }

    public int getVoltage() {
        return (int)this.createInt(this.buffer[9], this.buffer[10], this.buffer[11], (byte)0);
    }

    public int getHeading() {
        return (int)this.createInt(this.buffer[12], this.buffer[13], (byte)0, (byte)0);
    }

    public int getSecondsPerSample() {
        return (int)this.createInt(this.buffer[14], (byte)0, (byte)0, (byte)0);
    }

    public int getGain() {
        return this.buffer[15] + 1;
    }

    public int getSerialNumber() {
        return (int)this.createInt(this.buffer[16], this.buffer[17], (byte)0, (byte)0);
    }

    public int getVersion() {
        return this.buffer[18];
    }

    public int getRezeroInfo() {
        return this.buffer[19];
    }

    public int getXCalibration() {
        return (int)this.createInt(this.buffer[20], this.buffer[21], this.buffer[22], (byte)0);
    }

    public int getYCalibration() {
        return (int)this.createInt(this.buffer[23], this.buffer[24], this.buffer[25], (byte)0);
    }

    public String getLocationName() {
        return Util.bytesToString(this.buffer, 26, 8);
    }

    public int[][] getData() {
        int samples = (this.getNumBytes() - 34) / 6;
        int[][] result = new int[samples][2];
        for (int i = 0; i < samples; ++i) {
            result[i][0] = (int)this.createInt(this.buffer[34 + i * 6 + 2], this.buffer[34 + i * 6 + 1], this.buffer[34 + i * 6], (byte)0);
            result[i][1] = (int)this.createInt(this.buffer[34 + i * 6 + 5], this.buffer[34 + i * 6 + 4], this.buffer[34 + i * 6 + 3], (byte)0);
        }
        return result;
    }

    public double[][] getImportData() {
        int samples = (this.getNumBytes() - 34) / 6;
        double[][] result = new double[samples][5];
        int[][] data = this.getData();
        double t0 = Util.ewToJ2K(this.getStartTime());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT-8:00"));
        for (int i = 0; i < samples; ++i) {
            result[i][0] = t0 + (double)(i * this.getSecondsPerSample());
            result[i][1] = (double)data[i][0] * 5000.0 / 1.6777215E7 - 2500.0;
            result[i][2] = (double)data[i][1] * 5000.0 / 1.6777215E7 - 2500.0;
            result[i][3] = (double)this.getVoltage() * 3.2782552E-6;
            result[i][4] = (double)this.getTemperature() * 2.980232E-5;
        }
        return result;
    }

    public String toString() {
        return "numBytes=" + this.getNumBytes() + "\n" + "startTime=" + this.getStartTime() + "\n" + "temperature=" + this.getTemperature() + "\n" + "voltage=" + this.getVoltage() + "\n" + "heading=" + this.getHeading() + "\n" + "secondsPerSample=" + this.getSecondsPerSample() + "\n" + "gain=" + this.getGain() + "\n" + "serialNumber=" + this.getSerialNumber() + "\n" + "version=" + this.getVersion() + "\n" + "rezeroInfo=" + this.getRezeroInfo() + "\n" + "xCalibration=" + this.getXCalibration() + "\n" + "yCalibration=" + this.getYCalibration() + "\n" + "locationName=" + this.getLocationName() + "\n";
    }
}

