/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class SeedlinkReader {
    PushbackInputStream in;
    DataInputStream inData;
    BufferedOutputStream out;
    private Socket socket;
    boolean verbose = false;
    String host;
    int port;
    int timeoutSeconds;
    List<String> sentCommands = new ArrayList<String>();
    private PrintWriter verboseWriter;
    public static final String EMPTY = "";
    public static final String DATA_TYPE = "D";
    public static final String DATA_COMMAND = "DATA";
    public static final String TIME_COMMAND = "TIME";
    public static final String DEFAULT_HOST = "rtserve.iris.washington.edu";
    public static final int DEFAULT_PORT = 18000;
    public static final int DEFAULT_TIMEOUT_SECOND = 120;
    public static final String INFO_ID = "ID";
    public static final String INFO_CAPABILITIES = "CAPABILITIES";
    public static final String INFO_STATIONS = "STATIONS";
    public static final String INFO_STREAMS = "STREAMS";
    public static final String INFO_GAPS = "GAPS";
    public static final String INFO_CONNECTIONS = "CONNECTIONS";
    public static final String INFO_ALL = "ALL";

    public SeedlinkReader() throws UnknownHostException, IOException {
        this(DEFAULT_HOST, 18000);
    }

    public SeedlinkReader(String host) throws UnknownHostException, IOException {
        this(host, 18000);
    }

    public SeedlinkReader(String host, int port) throws UnknownHostException, IOException {
        this(host, port, 120);
    }

    public SeedlinkReader(String host, int port, int timeoutSeconds) throws UnknownHostException, IOException {
        this(host, port, timeoutSeconds, false);
    }

    public SeedlinkReader(String host, int port, int timeoutSeconds, boolean verbose) throws UnknownHostException, IOException {
        this.host = host;
        this.port = port;
        this.verbose = verbose;
        this.timeoutSeconds = timeoutSeconds;
        this.initConnection();
    }

    private void initConnection() throws UnknownHostException, IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(this.timeoutSeconds * 1000);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()), 3);
        this.inData = new DataInputStream(this.in);
    }

    public boolean hasNext() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        byte[] startBits = new byte[3];
        if (this.isVerbose()) {
            this.verboseWriter.println("hasNext(): blocking read for " + startBits.length + " bytes, available=" + this.in.available());
        }
        startBits[0] = (byte)this.in.read();
        startBits[1] = (byte)this.in.read();
        startBits[2] = (byte)this.in.read();
        String start = new String(startBits);
        if (start.equals("END")) {
            if (this.isVerbose()) {
                this.verboseWriter.println("hasNext(): end received");
            }
            return false;
        }
        this.in.unread(startBits);
        return true;
    }

    public boolean available() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        return this.in.available() > 256;
    }

    public int availableBytes() throws IOException {
        return this.in.available();
    }

    public String getInfoString() throws IOException, SeedlinkException, SeedFormatException {
        return this.getInfoString(INFO_STREAMS);
    }

    public String getInfoString(String infoType) throws IOException, SeedlinkException, SeedFormatException {
        return this.getInfoString(infoType, true);
    }

    public String getInfoString(String infoType, boolean addNewlines) throws IOException, SeedlinkException, SeedFormatException {
        SeedlinkPacket infoPacket;
        this.info(infoType);
        StringBuilder infoPacketContents = new StringBuilder();
        do {
            infoPacket = this.next();
            String s = new String(infoPacket.getMiniSeed().getData());
            infoPacketContents.append(s);
        } while (infoPacket.isInfoContinuesPacket());
        String infoString = infoPacketContents.toString();
        if (addNewlines) {
            infoString = infoString.replaceAll("><", ">\n<").trim();
        }
        return infoString;
    }

    public SeedlinkPacket next() throws IOException, SeedlinkException {
        if (!this.hasNext()) {
            throw new SeedlinkException("no more seed link packets from last command");
        }
        return this.readPacket();
    }

    public SeedlinkPacket readPacket() throws IOException, SeedlinkException {
        if (this.isVerbose()) {
            this.verboseWriter.println("readPacket(): blocking read for 520 bytes, available=" + this.in.available());
        }
        byte[] bits = new byte[520];
        this.inData.readFully(bits);
        SeedlinkPacket slp = new SeedlinkPacket(bits);
        if (this.isVerbose()) {
            String packetString = EMPTY;
            try {
                DataRecord dr = slp.getMiniSeed();
                packetString = " Got a packet: " + slp.getSeqNum() + "  " + dr.getHeader().getNetworkCode() + "  " + dr.getHeader().getStationIdentifier() + "  " + dr.getHeader().getLocationIdentifier() + "  " + dr.getHeader().getChannelIdentifier() + "  " + dr.getHeader().getStartTime();
            }
            catch (SeedFormatException e) {
                packetString = "SeedFormatExcpetion parsing packet: " + slp.getSeqNum() + e.getMessage();
            }
            this.verboseWriter.println(packetString);
        }
        return slp;
    }

    public void info(String level) throws IOException {
        this.send("INFO " + level);
    }

    public void endHandshake() throws IOException {
        this.send("END");
    }

    public void close() {
        try {
            this.send("BYE");
        }
        catch (Throwable se) {
            // empty catch block
        }
        try {
            this.in.close();
            this.out.close();
        }
        catch (Throwable se) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void reconnect() throws IOException, SeedlinkException {
        this.close();
        this.initConnection();
        for (String cmd : this.sentCommands) {
            this.internalSendCmd(cmd);
        }
        this.endHandshake();
    }

    public String[] sendHello() throws IOException, SeedlinkException {
        this.send("HELLO");
        String[] lines = new String[]{this.readLine(), this.readLine()};
        return lines;
    }

    protected String readLine() throws IOException, SeedlinkException {
        StringBuffer buf = new StringBuffer();
        int next = this.in.read();
        while (next != 13) {
            while (next != 13 && this.in.available() > 0) {
                buf.append((char)next);
                next = this.in.read();
                if (next != -1) continue;
                throw new SeedlinkException("read returned -1, socket closed???");
            }
            if (!this.isVerbose()) continue;
            this.verboseWriter.println(buf);
        }
        next = this.in.read();
        if (next != 10) {
            throw new SeedlinkException("Got \\r but not followed by \\n buf: '" + buf.toString() + "' next: " + next);
        }
        return buf.toString();
    }

    public void sendCmd(String cmd) throws IOException, SeedlinkException {
        this.internalSendCmd(cmd);
        this.sentCommands.add(cmd);
    }

    public void select(String network, String station, String location, String channel) throws SeedlinkException, IOException {
        this.select(network, station, location, channel, DATA_TYPE);
    }

    public void select(String network, String station, String location, String channel, String type) throws SeedlinkException, IOException {
        this.sendCmd("STATION " + station + " " + network);
        this.sendCmd("SELECT " + location + channel + "." + type);
    }

    public void startData() throws SeedlinkException, IOException {
        this.startData(EMPTY, EMPTY);
    }

    public void startData(String start, String end) throws SeedlinkException, IOException {
        if (start.length() == 0) {
            this.sendCmd(DATA_COMMAND);
        } else if (end.length() == 0) {
            this.sendCmd("TIME " + start);
        } else {
            this.sendCmd("TIME " + start + " " + end);
        }
        this.endHandshake();
    }

    protected void internalSendCmd(String cmd) throws IOException, SeedlinkException {
        this.send(cmd);
        String line = this.readLine();
        if (!line.equals("OK")) {
            throw new SeedlinkException("Command " + cmd + " did not return OK");
        }
    }

    void send(String cmd) throws IOException {
        if (this.isVerbose()) {
            this.verboseWriter.println("send '" + cmd + "'");
        }
        this.out.write((cmd + "\r").getBytes());
        this.out.flush();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out);
        }
    }

    public PrintWriter getVerboseWriter() {
        return this.verboseWriter;
    }

    public void setVerboseWriter(PrintWriter verboseWriter) {
        this.verboseWriter = verboseWriter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

