/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.plot.HelicorderSettings;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.AbstractHttpCommand;
import gov.usgs.winston.server.cmd.http.HttpBaseCommand;
import java.nio.ByteBuffer;
import java.util.TimeZone;
import java.util.logging.Level;

public final class HttpHeliCommand
extends AbstractHttpCommand
implements HttpBaseCommand {
    private static final int MAX_HOURS = 144;
    private static final int MIN_HOURS = 1;
    private static final int DEFAULT_H = 800;
    private static final int DEFAULT_W = 800;
    private static final int DEFAULT_TC = 30;
    private static final double MAX_TC = 21600.0;
    private static final boolean DEFAULT_SC = true;
    private static final boolean DEFAULT_FC = false;
    private static final boolean DEFAULT_LB = false;
    private static final String DEFAULT_BR = "auto";
    private static final String DEFAULT_CV = "auto";
    private static final String DEFAULT_T1 = "-12";
    private static final String DEFAULT_T2 = "now";

    public HttpHeliCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    protected void sendResponse() {
        CodeTimer ct = new CodeTimer("HttpHeliCommand");
        String error = "";
        HelicorderSettings settings = new HelicorderSettings();
        settings.channel = (String)this.arguments.get("code");
        if (settings.channel == null) {
            error = "Error: you must specify a channel (code).";
        } else {
            settings.channel = settings.channel.replace('_', '$');
            if (settings.channel.indexOf(";") != -1) {
                error = "Error: illegal characters in channel (code).";
            }
        }
        String tz = Util.stringToString((String)this.arguments.get("tz"), "UTC");
        settings.timeZone = TimeZone.getTimeZone(tz);
        settings.endTime = this.getEndTime((String)this.arguments.get("t2"));
        if (settings.endTime == Double.NaN) {
            error = error + "Error: could not parse end time (t2). Should be " + "yyyyMMddHHmm" + ".";
        }
        settings.startTime = this.getStartTime((String)this.arguments.get("t1"), settings.endTime, 3600L);
        if (settings.startTime == Double.NaN) {
            error = error + "Error: cannot parse start time. Should be yyyyMMddHHmm or -HH. I received " + (String)this.arguments.get("t1");
        }
        if (settings.endTime - settings.startTime > 518400.0) {
            error = error + "Error: Plot must not be more that 144 hours long";
        } else if (settings.endTime - settings.startTime < 3600.0) {
            error = error + "Error: Plot cannot be less than 1 hour long";
        }
        settings.timeChunk = Util.stringToDouble((String)this.arguments.get("tc"), 30.0) * 60.0;
        if (settings.timeChunk <= 0.0 || settings.timeChunk > 21600.0) {
            error = error + "Error: time chunk (tc) must be greater than 0 and less than " + 21600.0 + ".";
        }
        int width = Util.stringToInt((String)this.arguments.get("w"), 800);
        int height = Util.stringToInt((String)this.arguments.get("h"), 800);
        settings.setSizeFromPlotSize(width, height);
        if (settings.height * settings.width <= 0 || settings.height * settings.width > this.wws.httpMaxSize()) {
            error = error + "Error: product of width (w) and height (h) must be between 1 and " + this.wws.httpMaxSize() + ".";
        }
        settings.showClip = Util.stringToBoolean((String)this.arguments.get("sc"), true);
        settings.forceCenter = Util.stringToBoolean((String)this.arguments.get("fc"), false);
        settings.barRange = Util.stringToInt((String)this.arguments.get("br"), -1);
        settings.clipValue = Util.stringToInt((String)this.arguments.get("cv"), -1);
        settings.largeChannelDisplay = Util.stringToBoolean((String)this.arguments.get("lb"));
        settings.minimumAxis = Util.stringToBoolean((String)this.arguments.get("min"));
        if (settings.minimumAxis) {
            settings.setMinimumSizes();
        }
        if (error.length() > 0) {
            ct.stop();
            this.writeSimpleHTML(error);
        } else {
            HelicorderData heliData = null;
            try {
                heliData = this.data.getHelicorderData(settings.channel, settings.startTime, settings.endTime, 0);
            }
            catch (UtilException e) {
                // empty catch block
            }
            ct.stop();
            if (this.wws.getSlowCommandTime() > 0 && ct.getRunTimeMillis() > (double)this.wws.getSlowCommandTime() * 0.75) {
                this.wws.log(Level.INFO, String.format("slow db query (%1.2f ms) http/heli " + settings.channel + " " + settings.startTime + " -> " + settings.endTime + " (" + this.decimalFormat.format(settings.endTime - settings.startTime) + ") ", ct.getRunTimeMillis()), this.socketChannel);
            }
            if (heliData == null || heliData.rows() <= 0) {
                this.writeSimpleHTML("Error: could not get helicorder data, check channel (code).");
            } else {
                ct.start();
                HttpResponse response = new HttpResponse("image/png");
                response.setVersion(this.request.getVersion());
                if (this.wws.httpRefreshInterval() > 0) {
                    response.setHeader("Refresh:", this.wws.httpRefreshInterval() + "; url=" + this.request.getResource());
                }
                try {
                    byte[] png = settings.createPlot(heliData).getPNGBytes();
                    response.setLength(png.length);
                    this.netTools.writeString(response.getHeaderString(), this.socketChannel);
                    this.netTools.writeByteBuffer(ByteBuffer.wrap(png), this.socketChannel);
                }
                catch (PlotException e) {
                    e.printStackTrace();
                    error = error + "Error: Can not create plot.";
                }
                ct.stop();
                if (this.wws.getSlowCommandTime() > 0 && ct.getRunTimeMillis() > (double)this.wws.getSlowCommandTime() * 0.75) {
                    this.wws.log(Level.INFO, String.format("slow network (%1.2f ms) http/heli? " + settings.channel + " " + settings.startTime + " -> " + settings.endTime + " (" + this.decimalFormat.format(settings.endTime - settings.startTime) + ") ", ct.getRunTimeMillis()), this.socketChannel);
                }
            }
        }
    }

    @Override
    public String getUsage(HttpRequest req) {
        StringBuilder output = new StringBuilder();
        output.append("<script>function buildHeliUrl() {var urlDiv = document.getElementById(\"heliUrl\");\nvar heliW = document.getElementById(\"heliW\");\nvar heliH = document.getElementById(\"heliH\");\nvar heliTC = document.getElementById(\"heliTC\");\nvar heliBR = document.getElementById(\"heliBR\");\nvar heliCV = document.getElementById(\"heliCV\");\nvar heliSC = document.getElementById(\"heliSC\");\nvar heliFC = document.getElementById(\"heliFC\");\nvar heliLB = document.getElementById(\"heliLB\");\nvar heliTZ = document.getElementById(\"heliTZ\");\nvar heliT1 = document.getElementById(\"heliT1\");\nvar heliT2 = document.getElementById(\"heliT2\");\nvar heliCODE = document.getElementById(\"heliCODE\");\nvar a = document.createElement('a');\nvar linkUrl = \"http://" + req.getHeader("Host") + "/heli?\";\n");
        output.append("linkUrl += \"code=\" + heliCODE.value;");
        output.append("if (heliT1.value != \"-12\" && heliT1.value != \"\") { linkUrl += \"&t1=\" + heliT1.value;}\n");
        output.append("if (heliT2.value != \"now\" && heliT2.value != \"\") { linkUrl += \"&t2=\" + heliT2.value;}\n");
        output.append("if (heliW.value != \"800\" && heliW.value != \"\") { linkUrl += \"&w=\" + heliW.value;}\n");
        output.append("if (heliH.value != \"800\" && heliH.value != \"\") { linkUrl += \"&h=\" + heliH.value;}\n");
        output.append("if (heliTC.value != \"30\" && heliTC.value != \"\") { linkUrl += \"&tc=\" + heliTC.value;}\n");
        output.append("if (heliBR.value != \"auto\" && heliBR.value != \"\") { linkUrl += \"&br=\" + heliBR.value;}\n");
        output.append("if (heliCV.value != \"auto\" && heliCV.value != \"\") { linkUrl += \"&cv=\" + heliCV.value;}\n");
        output.append("if (heliSC.checked == \"\") { linkUrl += \"&sc=0\";}\n");
        output.append("if (heliFC.checked != \"\") { linkUrl += \"&fc=1\";}\n");
        output.append("if (heliLB.checked != \"\") { linkUrl += \"&lb=1\";}\n");
        output.append("if (heliTZ.value != \"UTC\") { linkUrl += \"&tz=\" + heliTZ.value;}\n");
        output.append("linkUrl = linkUrl.replace(\"?&\", \"?\");\n");
        output.append("linkUrl = linkUrl.replace(/\\?$/, \"\");\n");
        output.append("a.href = linkUrl;\na.text = linkUrl;\na.textContent = linkUrl; \nwhile(urlDiv.hasChildNodes()) {urlDiv.removeChild(urlDiv.lastChild);}urlDiv.appendChild(a);\nheliCV.disabled = !heliSC.checked;}</script>\n");
        output.append("Returns a helicorder plot. \n");
        output.append("<div class=\"tabContentTitle\">URL Builder</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<FORM>\n");
        output.append("<div class=\"left\">\n");
        output.append("<div class=\"left\">Channel<BR>");
        output.append("<select id=\"heliCODE\" onchange=\"buildHeliUrl()\" name=\"code\" class=\"channel\" size=8></select></div>\n");
        output.append("<div class=\"right\">Time zone<br>");
        output.append("<select onchange=\"buildHeliUrl()\" class=\"timeZone\" id=\"heliTZ\" name=\"tz\" size=8></select></div>\n");
        output.append("<div class=\"clear\"></div>");
        output.append("<P><br><p><div class=\"left\"><div class=\"timeInput\"><label for=\"t1\">Start Time</label></div><input type=text id=\"heliT1\" onchange=\"buildHeliUrl()\" name=\"t1\" size=10 value=\"-12\"></div><br>");
        output.append("<div class=\"clear\"></div>\n");
        output.append("<div class=\"left\"><div class=\"timeInput\"><label for=\"t2\">End Time</label></div><input type=text id=\"heliT2\" onchange=\"buildHeliUrl()\" name=\"t2\" size=10 value=\"now\"></div><br>");
        output.append("</div>\n");
        output.append("<div class=\"right\" style=\"padding-right:15px;\">\n");
        output.append("<div class=\"input\"><label for=\"w\">Width</label><input type=text id=\"heliW\" onchange=\"buildHeliUrl()\" name=\"w\" size=3 value=\"800\"></div>");
        output.append("<div class=\"input\"><label for=\"h\">Height</label><input type=text id=\"heliH\" onchange=\"buildHeliUrl()\" name=\"h\" size=3 value=\"800\"></div>");
        output.append("<div class=\"input\"><label for=\"tc\">Time Chunk</label><input type=text id=\"heliTC\" onchange=\"buildHeliUrl()\" name=\"tc\" size=3 value=\"30\"></div>");
        output.append("<div class=\"input\"><label for=\"br\">Bar Range</label><input type=text id=\"heliBR\" onchange=\"buildHeliUrl()\" name=\"br\" size=3 value=\"auto\"></div>");
        output.append("<div class=\"input\"><label for=\"sc\">Show clip?</label><input class=\"checkbox\" type=checkbox id=\"heliSC\" onchange=\"buildHeliUrl()\" name=\"sc\" checked></div>");
        output.append("<div class=\"input\"><label for=\"cv\">Clip Value</label><input type=text id=\"heliCV\" onchange=\"buildHeliUrl()\" name=\"cv\" size=3 value=\"auto\"></div>");
        output.append("<div class=\"input\"><label for=\"fc\">Force center?</label><input class=\"checkbox\" type=checkbox id=\"heliFC\" onchange=\"buildHeliUrl()\" name=\"fc\"></div>");
        output.append("<div class=\"input\"><label for=\"fc\">Display Label?</label><input class=\"checkbox\" type=checkbox id=\"heliLB\" onchange=\"buildHeliUrl()\" name=\"lb\" checked></div>");
        output.append("</div></FORM><div class=\"clear\"></div>\n");
        output.append("<HR class=\"urlBuilder\"><b>URL:</b><BR><div id=\"heliUrl\"></div>");
        output.append("</div>");
        output.append("<div class=\"tabContentTitle\">Arguments</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<code>w</code>: <b>Width</b> in pixels of the returned image (default = 800).<br><br><code>h</code>: <b>Height</b> in pixels of the returned image (default = 800).<br><br><code>tc</code>: <b>Time Chunk</b> length of x axis in minutes (default = 30).<br><br><code>t1</code>: <b>Start Time</b> The start time (local) of the helicorder as given by the number of hours before present or a specific time in the format YYYYMMDDHHMM.  Note that, in the first case, this is a negative number (default = -12).<br><br><code>t2</code>: <b>End Time</b> The end time (local) of the helicorder as given by the format YYYYMMDDHHMM or 'now' (default = 'now').<br><br><code>tz</code>: <b>Time Zone</b> The time zone, a complete list of time zones that WWS understands is shown below.<br><br><code>sc</code>: <b>Show Clip</b> Whether to show a clipped value as red, 1 is yes, 0 is no (default = " + this.boolToInt(true) + ").<br><br>" + "<code>fc</code>: <b>Force Center</b> Whether to center traces, 1 is yes, 0 is no (default = " + this.boolToInt(false) + ").<br><br>" + "<code>br</code>: <b>Bar Range</b> Controls the size of helicorder lines (default = auto).<br><br>" + "<code>cv</code>: <b>Clip Value</b> Sets the number of counts above which to clip (default = auto).<br><br>" + "<code>lb</code>: <b>Label</b> Whether to display a large label, 1 is yes, 0 is no (default = 0).<br><br>" + "The WWS does basic argument checking to prevent malignant attacks (like SQL injection) or just silly requests (like a 10000 x 10000 pixel graph).");
        output.append("</div>");
        return output.toString();
    }

    @Override
    public String getAnchor() {
        return "heli";
    }

    @Override
    public String getTitle() {
        return "Helicorder";
    }

    @Override
    public String getCommand() {
        return "/heli";
    }
}

