/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.ValueScaler;

class CommentText
implements RrdGraphConstants {
    private final String text;
    String resolvedText;
    String marker;
    boolean enabled;
    int x;
    int y;

    CommentText(String text) {
        this.text = text;
    }

    void resolveText(DataProcessor dproc, ValueScaler valueScaler) {
        this.resolvedText = this.text;
        this.marker = "";
        if (this.resolvedText != null) {
            String[] stringArray = MARKERS;
            int n = MARKERS.length;
            int n2 = 0;
            while (n2 < n) {
                String aMARKERS = stringArray[n2];
                if (this.resolvedText.endsWith(aMARKERS)) {
                    this.marker = aMARKERS;
                    this.resolvedText = this.resolvedText.substring(0, this.resolvedText.length() - this.marker.length());
                    this.trimIfGlue();
                    break;
                }
                ++n2;
            }
        }
        this.enabled = this.resolvedText != null;
    }

    void trimIfGlue() {
        if (this.marker.equals("\\g")) {
            this.resolvedText = this.resolvedText.trim();
        }
    }

    boolean isPrint() {
        return false;
    }

    boolean isValidGraphElement() {
        return !this.isPrint() && this.enabled;
    }
}

