/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;

public class TimeInterval
extends QuantityImpl {
    public TimeInterval(Quantity interval) {
        this(interval.value, UnitImpl.createUnitImpl(interval.the_units));
    }

    public TimeInterval(MicroSecondDate begin, MicroSecondDate end) {
        this((double)(end.getMicroSecondTime() - begin.getMicroSecondTime()), UnitImpl.MICROSECOND);
    }

    public TimeInterval(double f, UnitImpl the_unit) {
        super(f, the_unit);
        if (!the_unit.isConvertableTo(UnitImpl.TIME)) {
            throw new IllegalArgumentException("TimeInterval " + f + " " + this.the_units + " does not have units of time.");
        }
    }

    public static TimeInterval createTimeInterval(Quantity q) {
        if (q instanceof TimeInterval) {
            return (TimeInterval)q;
        }
        return new TimeInterval(q);
    }

    public QuantityImpl convertTo(UnitImpl newUnit) {
        QuantityImpl q = super.convertTo(newUnit);
        return new TimeInterval(q);
    }

    public QuantityImpl multiplyBy(double f) {
        QuantityImpl newq = super.multiplyBy(f);
        return new TimeInterval(newq);
    }

    public QuantityImpl divideBy(double f) {
        QuantityImpl newq = super.divideBy(f);
        return new TimeInterval(newq);
    }

    public TimeInterval add(TimeInterval t) {
        QuantityImpl newq = super.add(t);
        return new TimeInterval(newq);
    }

    public TimeInterval subtract(TimeInterval t) {
        QuantityImpl newq = super.subtract(t);
        return new TimeInterval(newq);
    }
}

