/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.util.Util;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class MenuItem
implements Comparable<MenuItem> {
    public final int pin;
    public final String station;
    public final String channel;
    public final String network;
    public final String location;
    public final double startTime;
    public final double endTime;
    public final String dataType;

    public MenuItem(String item) {
        String[] ss = item.split(" ");
        this.pin = Integer.parseInt(ss[0]);
        this.station = ss[1];
        this.channel = ss[2];
        this.network = ss[3];
        if (ss.length == 7) {
            this.location = null;
            this.startTime = Double.parseDouble(ss[4]);
            this.endTime = Double.parseDouble(ss[5]);
            this.dataType = ss[6];
        } else {
            this.location = ss[4];
            this.startTime = Double.parseDouble(ss[5]);
            this.endTime = Double.parseDouble(ss[6]);
            this.dataType = ss[7];
        }
    }

    public boolean isSCN(String s, String c, String n) {
        return this.station.equals(s) && this.channel.equals(c) && this.network.equals(n);
    }

    public String toFullString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String t1 = df.format(Util.j2KToDate(Util.ewToJ2K(this.startTime)));
        String t2 = df.format(Util.j2KToDate(Util.ewToJ2K(this.endTime)));
        return String.format("%4d %16s %3s %14.2f (%s) %14.2f (%s)", this.pin, this.getSCNL("_"), this.dataType, this.startTime, t1, this.endTime, t2);
    }

    public String toString() {
        return this.getSCN("_");
    }

    @Override
    public int compareTo(MenuItem omi) {
        return this.getSCN("_").compareTo(omi.getSCN("_"));
    }

    public boolean match(String s, String c, String n, String l) {
        if (s != null && !s.equals("*") && !Pattern.matches(s, this.station)) {
            return false;
        }
        if (c != null && !c.equals("*") && !Pattern.matches(c, this.channel)) {
            return false;
        }
        if (n != null && !n.equals("*") && !Pattern.matches(n, this.network)) {
            return false;
        }
        if (l == null) {
            return this.location == null || this.location.equals("--");
        }
        if (l.equals("*")) {
            return true;
        }
        if (this.location == null) {
            return false;
        }
        return Pattern.matches(l, this.location);
    }

    public String getSCNL(String d) {
        return this.getSCN(d) + d + (this.location == null ? "--" : this.location);
    }

    public String getSCN(String d) {
        return this.station + d + this.channel + d + this.network;
    }

    public String getSCNSCNL(String d) {
        if (this.location == null || this.location.equals("--")) {
            return this.getSCN(d);
        }
        return this.getSCNL(d);
    }
}

