/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentPolynomial;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Response {
    List<ResponseStage> responseStageList = new ArrayList<ResponseStage>();
    private InstrumentSensitivity instrumentSensitivity;
    private InstrumentPolynomial instrumentPolynomial;
    private String resourceId;

    public Response(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Response", reader);
        this.resourceId = StaxUtil.pullAttributeIfExists(startE, "resourceId");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Stage")) {
                    this.responseStageList.add(new ResponseStage(reader));
                    continue;
                }
                if (elName.equals("InstrumentSensitivity")) {
                    this.instrumentSensitivity = new InstrumentSensitivity(reader);
                    continue;
                }
                if (elName.equals("InstrumentPolynomial")) {
                    this.instrumentPolynomial = new InstrumentPolynomial(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public List<ResponseStage> getResponseStageList() {
        return this.responseStageList;
    }

    public InstrumentSensitivity getInstrumentSensitivity() {
        return this.instrumentSensitivity;
    }

    public InstrumentPolynomial getInstrumentPolynomial() {
        return this.instrumentPolynomial;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

