/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.ListStationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Network
extends BaseNodeType {
    int totalNumStations;
    int selectedNumStations;
    StationIterator stations = new ListStationIterator(new ArrayList<Station>());

    public Network(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Network", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("TotalNumberStations")) {
                    this.totalNumStations = StaxUtil.pullInt(reader, "TotalNumberStations");
                    continue;
                }
                if (elName.equals("SelectedNumberStations")) {
                    this.selectedNumStations = StaxUtil.pullInt(reader, "SelectedNumberStations");
                    continue;
                }
                if (elName.equals("Station")) {
                    this.stations = new StationIterator(reader, this.getCode());
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public StationIterator getStations() {
        return this.stations;
    }

    public int getTotalNumStations() {
        return this.totalNumStations;
    }

    public int getSelectedNumStations() {
        return this.selectedNumStations;
    }

    public String toString() {
        return this.getCode();
    }
}

