/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.rsam;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.in.ImportBob;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportEWRSAM {
    private static final String CONFIG_FILE = "importEWRSAM.config";
    private int year;
    public ConfigFile params;

    public ImportEWRSAM(String cf, int y) {
        this.params = new ConfigFile(cf);
        if (!this.params.wasSuccessfullyRead()) {
            System.out.println(cf + ": could not read config file.");
            System.exit(1);
        }
        this.year = y;
    }

    private void processDir(String dirName, String fileType) {
        File dir = null;
        dir = new File(dirName);
        try {
            ImportEWRSAM.validateDirectory(dir);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        for (File f : dir.listFiles()) {
            this.process(f, fileType);
        }
    }

    public void process() {
        String dirName = this.params.getString("valueDir");
        if (dirName != null) {
            this.processDir(dirName, "ewrsamValues");
        }
        if ((dirName = this.params.getString("eventDir")) != null) {
            this.processDir(dirName, "ewrsamEvents");
        }
    }

    private void process(File f, String t) {
        int fileYear;
        String channel;
        Pattern p1 = Pattern.compile("(\\w{4})(\\d{4})\\.DAT$");
        Matcher m1 = p1.matcher(f.getName());
        Pattern p2 = Pattern.compile("(\\w{4}):(\\w{3}4?):(\\w{2})(\\d{4})\\.DAT$");
        Matcher m2 = p2.matcher(f.getName());
        if (m1.matches()) {
            channel = m1.group(1);
            if (channel.matches("\\w{3}_")) {
                channel = channel.substring(0, 3);
            }
            channel = this.params.getString(channel);
            fileYear = Integer.parseInt(m1.group(2));
        } else if (m2.matches()) {
            channel = m2.group(1) + "$" + m2.group(2) + "$" + m2.group(3);
            fileYear = Integer.parseInt(m2.group(4));
        } else {
            System.out.println("ignoring poorly named file " + f);
            return;
        }
        if (this.year != -1 && fileYear != this.year) {
            return;
        }
        System.out.println("importing " + channel + " " + t + " data for the year " + fileYear + " from file " + f.getAbsolutePath());
        ImportBob ib = new ImportBob(this.params.getString("vdxConfig"), fileYear, this.params.getString("prefix"), t);
        ib.process(channel, f.getAbsolutePath());
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static void main(String[] as) {
        Calendar startTime = Calendar.getInstance();
        String cf = CONFIG_FILE;
        int y = -2;
        System.out.println("Starting import at " + startTime.toString());
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-c");
        kvs.add("-y");
        flags.add("-a");
        flags.add("-Y");
        Arguments args = new Arguments(as, flags, kvs);
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        if (args.contains("-y")) {
            y = Integer.parseInt(args.get("-y"));
        } else if (args.flagged("-Y")) {
            y = startTime.get(1);
        } else if (args.flagged("-a")) {
            y = -1;
        }
        if (args.contains("-h") || y == -2) {
            System.err.println("java gov.usgs.vdx.data.rsam.ImportEWRSAM [-c <configFile>] [-Y | -y <year> | -a]");
            System.err.println("\t-c <configFile>\tconfig to use, Default: importEWRSAM.config");
            System.err.println("\t-Y\timport data for this year");
            System.err.println("\t-y <year>\timport data for given year");
            System.err.println("\t-a\timport all data");
            System.exit(-1);
        }
        ImportEWRSAM in = new ImportEWRSAM(cf, y);
        in.process();
        Calendar endTime = Calendar.getInstance();
        double ellapsedTime = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 1000L;
        System.out.println("Import finished at " + endTime.toString());
        System.out.println("Elapsed time: " + ellapsedTime + " seconds");
    }
}

