/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tilt;

import gov.usgs.math.DownsamplingType;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.tilt.TiltData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SQLTiltDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "tilt";
    public static final boolean channels = true;
    public static final boolean translations = true;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = true;
    public static final boolean menuColumns = true;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "xTilt", "East", "microrad", false, true, false), new Column(2, "yTilt", "North", "microrad", false, true, false), new Column(3, "holeTemp", "Hole Temp.", "celsius", false, true, true), new Column(4, "boxTemp", "Box Temp.", "celsius", false, true, true), new Column(5, "instVolt", "Inst. Voltage", "volts", false, true, true), new Column(6, "gndVolt", "Gnd. Voltage", "volts", false, true, false), new Column(7, "rainfall", "Rainfall", "mm", false, true, true)};
    public static final Column[] MENU_COLUMNS = new Column[]{new Column(1, "radial", "Radial", "microrad", true, true, false), new Column(2, "tangential", "Tangential", "microrad", true, true, false), new Column(3, "xTilt", "East", "microrad", false, true, false), new Column(4, "yTilt", "North", "microrad", false, true, false), new Column(5, "magnitude", "Magnitude", "microrad", false, true, false), new Column(6, "azimuth", "Azimuth", "microrad", false, true, false), new Column(7, "holeTemp", "Hole Temp.", "celsius", false, true, true), new Column(8, "boxTemp", "Box Temp.", "celsius", false, true, true), new Column(9, "instVolt", "Inst. Voltage", "volts", false, true, true), new Column(10, "rainfall", "Rainfall", "mm", false, true, true)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return true;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return true;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            int i;
            this.defaultCreateDatabase(true, true, false, true, true, true);
            for (i = 0; i < DATA_COLUMNS.length; ++i) {
                this.defaultInsertColumn(DATA_COLUMNS[i]);
            }
            for (i = 0; i < MENU_COLUMNS.length; ++i) {
                this.defaultInsertMenuColumn(MENU_COLUMNS[i]);
            }
            this.defaultCreateTranslation();
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.st.execute("ALTER TABLE channels\t ADD azimuth DOUBLE DEFAULT 0");
            this.st.execute("ALTER TABLE translations ADD azimuth DOUBLE DEFAULT 0");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTiltDataSource.createDatabase() failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active, int tid, double azimuth) {
        Channel channel = new Channel(0, channelCode, channelName, lon, lat, height, active, azimuth);
        return this.defaultCreateTiltChannel(channel, tid, azimuth, true, true, true, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals("columns")) {
            return new TextResult(this.defaultGetMenuColumns(true));
        }
        if (action.equals("azimuths")) {
            return new TextResult(this.getAzimuths());
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("ch"));
            int rid = Integer.parseInt(params.get("rk"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            return this.getTiltData(cid, rid, st, et, this.getMaxRows(), ds, dsInt);
        }
        if (action.equals("supptypes")) {
            return this.getSuppTypes(true);
        }
        if (action.equals("suppdata")) {
            return this.getSuppData(params, false);
        }
        if (action.equals("metadata")) {
            return this.getMetaData(params, false);
        }
        return null;
    }

    public RequestResult getTiltData(int cid, int rid, double st, double et, int maxrows, DownsamplingType ds, int dsInt) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        BinaryResult result = null;
        int columnsReturned = 0;
        try {
            int i;
            double[] dataRow;
            this.database.useDatabase(this.dbName);
            Channel channel = this.defaultGetChannel(cid, false);
            columnsReturned = 8;
            int tempmaxrows = rid != 0 ? maxrows : maxrows * this.defaultGetNumberOfRanks();
            this.sql = "SELECT j2ksec, c.rid, ";
            this.sql = this.sql + "       COS(RADIANS(b.azimuth))  * (xTilt * cxTilt + dxTilt) + SIN(RADIANS(b.azimuth)) * (yTilt * cyTilt + dyTilt), ";
            this.sql = this.sql + "       -SIN(RADIANS(b.azimuth)) * (xTilt * cxTilt + dxTilt) + COS(RADIANS(b.azimuth)) * (yTilt * cyTilt + dyTilt), ";
            this.sql = this.sql + "       holeTemp * choleTemp + dholeTemp, ";
            this.sql = this.sql + "       boxTemp  * cboxTemp  + dboxTemp,  ";
            this.sql = this.sql + "       instVolt * cinstVolt + dinstVolt, ";
            this.sql = this.sql + "       rainfall * crainfall + drainfall  ";
            this.sql = this.sql + "FROM " + channel.getCode() + " a ";
            this.sql = this.sql + "       INNER JOIN translations  b ON a.tid = b.tid ";
            this.sql = this.sql + "       INNER JOIN ranks         c ON a.rid = c.rid ";
            this.sql = this.sql + "WHERE  j2ksec >= ? ";
            this.sql = this.sql + "AND    j2ksec <= ? ";
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 FROM " + channel.getCode() + " a INNER JOIN ranks c on a.rid = c.rid ";
            this.sqlCount = this.sqlCount + "WHERE j2ksec >= ? AND j2ksec <= ? ";
            if (rid != 0) {
                this.sql = this.sql + "AND   c.rid = ? ";
                this.sqlCount = this.sqlCount + "AND c.rid = ? ";
            }
            this.sql = this.sql + "ORDER BY j2ksec ASC";
            this.sqlCount = this.sqlCount + "ORDER BY j2ksec ASC";
            if (rid == 0) {
                this.sql = this.sql + ", c.rank DESC";
                this.sqlCount = this.sqlCount + ", c.rank DESC";
            }
            if (rid != 0) {
                try {
                    this.sql = SQLTiltDataSource.getDownsamplingSQL(this.sql, "j2ksec", ds, dsInt);
                }
                catch (UtilException e) {
                    return SQLTiltDataSource.getErrorResult("Can't downsample dataset: " + e.getMessage());
                }
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (tempmaxrows + 1);
                if (ds.equals((Object)DownsamplingType.NONE)) {
                    this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (tempmaxrows + 1) + ") as T");
                    this.ps.setDouble(1, st);
                    this.ps.setDouble(2, et);
                    if (rid != 0) {
                        this.ps.setInt(3, rid);
                    }
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > tempmaxrows) {
                        return SQLTiltDataSource.getErrorResult("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
                    }
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            if (ds.equals((Object)DownsamplingType.MEAN)) {
                this.ps.setDouble(1, st);
                this.ps.setInt(2, dsInt);
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
                if (rid != 0) {
                    this.ps.setInt(5, rid);
                }
            } else {
                this.ps.setDouble(1, st);
                this.ps.setDouble(2, et);
                if (rid != 0) {
                    this.ps.setInt(3, rid);
                }
            }
            this.rs = this.ps.executeQuery();
            if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLTiltDataSource.getResultSetSize(this.rs) > tempmaxrows) {
                throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.vdxName + "' exceeded. Please downsample further.");
            }
            double tempJ2ksec = Double.MAX_VALUE;
            while (this.rs.next()) {
                if (Double.compare(tempJ2ksec, this.rs.getDouble(1)) != 0) {
                    dataRow = new double[columnsReturned];
                    for (i = 0; i < columnsReturned; ++i) {
                        dataRow[i] = this.getDoubleNullCheck(this.rs, i + 1);
                    }
                    pts.add(dataRow);
                }
                tempJ2ksec = this.rs.getDouble(1);
            }
            this.rs.close();
            if (pts.size() == 0) {
                dataRow = new double[columnsReturned];
                for (i = 0; i < columnsReturned; ++i) {
                    dataRow[i] = Double.NaN;
                }
                pts.add(dataRow);
            }
            result = new BinaryResult(new TiltData(pts));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTiltDataSource.getTiltData()", e);
        }
        return result;
    }

    public List<String> getAzimuths() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT cid, azimuth FROM channels ORDER BY cid").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%f", this.rs.getInt(1), this.rs.getDouble(2)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTiltDataSource.getAzimuths() failed.", e);
        }
        return result;
    }

    public double getNominalAzimuth(String channelCode) {
        double result = 0.0;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT azimuth FROM channels WHERE code = ?");
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            this.rs.next();
            result = this.rs.getDouble(1);
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTiltDataSource.getNominalAzimuth() failed.", e);
        }
        return result;
    }
}

