/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SelectOption;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.HypocenterList;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.logging.Level;

public class SQLHypocenterDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "hypocenters";
    public static final boolean channels = false;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = false;
    public static final boolean menuColumns = false;
    public static final String REMARK = "remark";
    public static final String MAGTYPE = "magtype";
    public static final SelectOption[] REMARK_OPTIONS = new SelectOption[]{new SelectOption(1, "F", "Felt (F)"), new SelectOption(2, "B", "Explosion/Collapse (B)"), new SelectOption(3, "L", "Long Period (L)"), new SelectOption(4, "T", "Tremor (T)"), new SelectOption(5, "Q", "Quarry (Q)"), new SelectOption(6, "N", "Nuclear (N")};
    public static final SelectOption[] MAGTYPE_OPTIONS = new SelectOption[]{new SelectOption(1, "B", "Body Wave Magnitude (B)"), new SelectOption(2, "C", "Coda Amplitude Magnitude (C)"), new SelectOption(3, "D", "Coda Duration Magnitude (D)"), new SelectOption(4, "E", "Energy Magnitude (E)"), new SelectOption(5, "G", "MAGNUM (G)"), new SelectOption(1, "H", "Hand Entered (H)"), new SelectOption(2, "L", "Local Magnitude (L)"), new SelectOption(3, "O", "Moment Magnitude (O)"), new SelectOption(4, "P", "P-Wave Magnitude (P)"), new SelectOption(5, "S", "Surface Wave Magnitude (S)"), new SelectOption(6, "X", "External (X)")};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return false;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return false;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            SelectOption so;
            int i;
            this.defaultCreateDatabase(false, false, false, true, false, false);
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.sql = "CREATE TABLE hypocenters (j2ksec DOUBLE NOT NULL, eid VARCHAR(45) NOT NULL, rid INT NOT NULL, ";
            this.sql = this.sql + "   lat DOUBLE NOT NULL, lon DOUBLE NOT NULL, depth DOUBLE NOT NULL, ";
            this.sql = this.sql + "   prefmag DOUBLE, ampmag DOUBLE, codamag DOUBLE, ";
            this.sql = this.sql + "   nphases INT, azgap INT, dmin DOUBLE, rms DOUBLE, nstimes INT, herr DOUBLE, verr DOUBLE, ";
            this.sql = this.sql + "   magtype VARCHAR(1), rmk VARCHAR(1), PRIMARY KEY(eid,rid), KEY index_j2ksec (j2ksec))";
            this.st.execute(this.sql);
            this.sql = "CREATE TABLE options_remark (id INT PRIMARY KEY AUTO_INCREMENT, ";
            this.sql = this.sql + "   idx INT NOT NULL, code VARCHAR(1) NOT NULL, name VARCHAR(255) NOT NULL)";
            this.st.execute(this.sql);
            this.sql = "CREATE TABLE options_magtype (id INT PRIMARY KEY AUTO_INCREMENT, ";
            this.sql = this.sql + "   idx INT NOT NULL, code VARCHAR(1) NOT NULL, name VARCHAR(255) NOT NULL)";
            this.st.execute(this.sql);
            for (i = 0; i < REMARK_OPTIONS.length; ++i) {
                so = REMARK_OPTIONS[i];
                this.sql = "INSERT INTO options_remark (idx, code, name) VALUES(?,?,?)";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setInt(1, so.getIndex());
                this.ps.setString(2, so.getCode());
                this.ps.setString(3, so.getName());
                this.ps.execute();
            }
            for (i = 0; i < MAGTYPE_OPTIONS.length; ++i) {
                so = MAGTYPE_OPTIONS[i];
                this.sql = "INSERT INTO options_magtype (idx, code, name) VALUES(?,?,?)";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setInt(1, so.getIndex());
                this.ps.setString(2, so.getCode());
                this.ps.setString(3, so.getName());
                this.ps.execute();
            }
            logger.log(Level.INFO, "SQLHypocenterDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded.");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLHypocenterDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals(REMARK) || action.equals(MAGTYPE)) {
            return new TextResult(this.defaultGetOptions(action));
        }
        if (action.equals("data")) {
            int rid = Integer.parseInt(params.get("rk"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            double west = Double.parseDouble(params.get("west"));
            double east = Double.parseDouble(params.get("east"));
            double south = Double.parseDouble(params.get("south"));
            double north = Double.parseDouble(params.get("north"));
            double minDepth = Double.parseDouble(params.get("minDepth"));
            double maxDepth = Double.parseDouble(params.get("maxDepth"));
            double minMag = Double.parseDouble(params.get("minMag"));
            double maxMag = Double.parseDouble(params.get("maxMag"));
            Integer minNPhases = Integer.parseInt(params.get("minNPhases"));
            Integer maxNPhases = Integer.parseInt(params.get("maxNPhases"));
            double minRMS = Double.parseDouble(params.get("minRMS"));
            double maxRMS = Double.parseDouble(params.get("maxRMS"));
            double minHerr = Double.parseDouble(params.get("minHerr"));
            double maxHerr = Double.parseDouble(params.get("maxHerr"));
            double minVerr = Double.parseDouble(params.get("minVerr"));
            double maxVerr = Double.parseDouble(params.get("maxVerr"));
            String rmk = params.get("rmk");
            double minStDst = Double.parseDouble(params.get("minStDst"));
            double maxStDst = Double.parseDouble(params.get("maxStDst"));
            double maxGap = Double.parseDouble(params.get("maxGap"));
            HypocenterList data = null;
            try {
                data = this.getHypocenterData(rid, st, et, west, east, south, north, minDepth, maxDepth, minMag, maxMag, minNPhases, maxNPhases, minRMS, maxRMS, minHerr, maxHerr, minVerr, maxVerr, rmk, minStDst, maxStDst, maxGap, this.getMaxRows());
            }
            catch (UtilException e) {
                return SQLHypocenterDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else if (action.equals("metadata")) {
            return this.getMetaData(params, false);
        }
        return null;
    }

    public HypocenterList getHypocenterData(int rid, double st, double et, double west, double east, double south, double north, double minDepth, double maxDepth, double minMag, double maxMag, Integer minNPhases, Integer maxNPhases, double minRMS, double maxRMS, double minHerr, double maxHerr, double minVerr, double maxVerr, String rmk, double minStDst, double maxStDst, double maxGap, int maxrows) throws UtilException {
        ArrayList<Hypocenter> pts = new ArrayList<Hypocenter>();
        HypocenterList result = null;
        try {
            this.database.useDatabase(this.dbName);
            int tempmaxrows = rid != 0 ? maxrows : maxrows * this.defaultGetNumberOfRanks();
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 ";
            this.sql = "SELECT a.j2ksec, a.rid, a.lat, a.lon, a.depth, a.prefmag, ";
            this.sql = this.sql + "       a.ampmag, a.codamag, a.nphases, a.azgap, a.dmin, a.rms, ";
            this.sql = this.sql + "       a.nstimes, a.herr, a.verr, a.magtype, a.rmk, a.eid ";
            this.sql = this.sql + "FROM   hypocenters a, ranks c ";
            this.sql = this.sql + "WHERE  a.rid = c.rid ";
            this.sql = this.sql + "AND    a.j2ksec  >= ? AND a.j2ksec  <= ? ";
            this.sql = west <= east ? this.sql + "AND a.lon >= ? AND a.lon <= ? " : this.sql + "AND (a.lon >= ? OR a.lon <= ?) ";
            this.sql = this.sql + "AND    a.lat     >= ? AND a.lat     <= ? ";
            this.sql = this.sql + "AND    a.depth   >= ? AND a.depth   <= ? ";
            this.sql = this.sql + "AND    a.prefmag >= ? AND a.prefmag <= ? ";
            this.sql = this.sql + "AND    a.nphases >= ? AND a.nphases <= ? ";
            this.sql = this.sql + "AND    a.rms     >= ? AND a.rms     <= ? ";
            this.sql = this.sql + "AND    a.herr    >= ? AND a.herr    <= ? ";
            this.sql = this.sql + "AND    a.verr    >= ? AND a.verr    <= ? ";
            this.sql = this.sql + "AND    a.dmin    >= ? AND a.dmin\t<= ? ";
            this.sql = this.sql + "AND    a.azgap   <= ? ";
            this.sql = this.sql + "AND    a.prefmag IS NOT NULL ";
            if (!rmk.equals("")) {
                this.sql = this.sql + "AND    a.rmk = '" + rmk + "' ";
            }
            if (rid != 0) {
                this.sql = this.sql + "AND    c.rid  = ? ";
            }
            this.sql = this.sql + "ORDER BY eid ASC";
            if (rid == 0) {
                this.sql = this.sql + ", c.rank DESC";
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (tempmaxrows + 1);
                this.ps = this.database.getPreparedStatement(this.sqlCount + this.sql.substring(this.sql.indexOf("FROM")) + ") as T");
                this.ps.setDouble(1, st);
                this.ps.setDouble(2, et);
                this.ps.setDouble(3, west);
                this.ps.setDouble(4, east);
                this.ps.setDouble(5, south);
                this.ps.setDouble(6, north);
                this.ps.setDouble(7, minDepth);
                this.ps.setDouble(8, maxDepth);
                this.ps.setDouble(9, minMag);
                this.ps.setDouble(10, maxMag);
                this.ps.setInt(11, minNPhases);
                this.ps.setInt(12, maxNPhases);
                this.ps.setDouble(13, minRMS);
                this.ps.setDouble(14, maxRMS);
                this.ps.setDouble(15, minHerr);
                this.ps.setDouble(16, maxHerr);
                this.ps.setDouble(17, minVerr);
                this.ps.setDouble(18, maxVerr);
                this.ps.setDouble(19, minStDst);
                this.ps.setDouble(20, maxStDst);
                this.ps.setDouble(21, maxGap);
                if (rid != 0) {
                    this.ps.setInt(22, rid);
                }
                this.rs = this.ps.executeQuery();
                if (this.rs.next() && this.rs.getInt(1) > tempmaxrows) {
                    throw new UtilException("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded.");
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, st);
            this.ps.setDouble(2, et);
            this.ps.setDouble(3, west);
            this.ps.setDouble(4, east);
            this.ps.setDouble(5, south);
            this.ps.setDouble(6, north);
            this.ps.setDouble(7, minDepth);
            this.ps.setDouble(8, maxDepth);
            this.ps.setDouble(9, minMag);
            this.ps.setDouble(10, maxMag);
            this.ps.setInt(11, minNPhases);
            this.ps.setInt(12, maxNPhases);
            this.ps.setDouble(13, minRMS);
            this.ps.setDouble(14, maxRMS);
            this.ps.setDouble(15, minHerr);
            this.ps.setDouble(16, maxHerr);
            this.ps.setDouble(17, minVerr);
            this.ps.setDouble(18, maxVerr);
            this.ps.setDouble(19, minStDst);
            this.ps.setDouble(20, maxStDst);
            this.ps.setDouble(21, maxGap);
            if (rid != 0) {
                this.ps.setInt(22, rid);
            }
            this.rs = this.ps.executeQuery();
            String tempEid = "";
            while (this.rs.next()) {
                if (!tempEid.equals(this.rs.getString(18))) {
                    double j2ksec = this.getDoubleNullCheck(this.rs, 1);
                    rid = this.rs.getInt(2);
                    double lat = this.getDoubleNullCheck(this.rs, 3);
                    double lon = this.getDoubleNullCheck(this.rs, 4);
                    double depth = this.getDoubleNullCheck(this.rs, 5);
                    double mag = this.getDoubleNullCheck(this.rs, 6);
                    double ampmag = this.getDoubleNullCheck(this.rs, 7);
                    double codamag = this.getDoubleNullCheck(this.rs, 8);
                    int nphases = this.getIntNullCheck(this.rs, 9);
                    int azgap = this.getIntNullCheck(this.rs, 10);
                    double dmin = this.getDoubleNullCheck(this.rs, 11);
                    double rms = this.getDoubleNullCheck(this.rs, 12);
                    int nstimes = this.getIntNullCheck(this.rs, 13);
                    double herr = this.getDoubleNullCheck(this.rs, 14);
                    double verr = this.getDoubleNullCheck(this.rs, 15);
                    String magtype = this.rs.getString(16);
                    String rs_rmk = this.rs.getString(17);
                    pts.add(new Hypocenter(j2ksec, null, rid, lat, lon, depth, mag, ampmag, codamag, nphases, azgap, dmin, rms, nstimes, herr, verr, magtype, rs_rmk));
                }
                tempEid = this.rs.getString(18);
            }
            this.rs.close();
            if (pts.size() > 0) {
                Collections.sort(pts, new Comparator<Hypocenter>(){

                    @Override
                    public int compare(Hypocenter h1, Hypocenter h2) {
                        if (h1.j2ksec > h2.j2ksec) {
                            return 1;
                        }
                        return -1;
                    }
                });
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLHypocenterDataSource.getHypocenterData() failed.", e);
        }
        result = new HypocenterList(pts);
        return result;
    }

    public int insertHypocenter(Hypocenter hc) {
        int result = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "REPLACE INTO hypocenters ";
            this.sql = this.sql + "       (j2ksec, eid, rid, lat, lon, depth, prefmag, ampmag, codamag, ";
            this.sql = this.sql + "        nphases, azgap, dmin, rms, nstimes, herr, verr, magtype, rmk) ";
            this.sql = this.sql + "VALUES (?,?,?,round(?, 4),round(?, 4),round(?, 2),round(?, 2),round(?, 2),round(?, 2),?,?,?,?,?,?,?,?,?)";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, hc.j2ksec);
            this.ps.setString(2, hc.eid);
            this.ps.setInt(3, hc.rid);
            this.ps.setDouble(4, hc.lat);
            this.ps.setDouble(5, hc.lon);
            this.ps.setDouble(6, hc.depth);
            if (Double.isNaN(hc.prefmag)) {
                this.ps.setNull(7, 8);
            } else {
                this.ps.setDouble(7, hc.prefmag);
            }
            if (Double.isNaN(hc.ampmag)) {
                this.ps.setNull(8, 8);
            } else {
                this.ps.setDouble(8, hc.ampmag);
            }
            if (Double.isNaN(hc.codamag)) {
                this.ps.setNull(9, 8);
            } else {
                this.ps.setDouble(9, hc.codamag);
            }
            if (hc.nphases == null) {
                this.ps.setNull(10, 4);
            } else {
                this.ps.setInt(10, hc.nphases);
            }
            if (hc.azgap == null) {
                this.ps.setNull(11, 4);
            } else {
                this.ps.setInt(11, hc.azgap);
            }
            if (Double.isNaN(hc.dmin)) {
                this.ps.setNull(12, 8);
            } else {
                this.ps.setDouble(12, hc.dmin);
            }
            if (Double.isNaN(hc.rms)) {
                this.ps.setNull(13, 8);
            } else {
                this.ps.setDouble(13, hc.rms);
            }
            if (hc.nstimes == null) {
                this.ps.setNull(14, 4);
            } else {
                this.ps.setInt(14, hc.nstimes);
            }
            if (Double.isNaN(hc.herr)) {
                this.ps.setNull(15, 8);
            } else {
                this.ps.setDouble(15, hc.herr);
            }
            if (Double.isNaN(hc.verr)) {
                this.ps.setNull(16, 8);
            } else {
                this.ps.setDouble(16, hc.verr);
            }
            if (hc.magtype == null) {
                this.ps.setNull(17, 12);
            } else {
                this.ps.setString(17, hc.magtype);
            }
            if (hc.rmk == null) {
                this.ps.setNull(18, 12);
            } else {
                this.ps.setString(18, hc.rmk);
            }
            result = this.ps.executeUpdate();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLHypocenterDataSource.insertHypocenter() failed.", e);
        }
        return result;
    }
}

