/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.gps;

import gov.usgs.math.DownsamplingType;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.gps.DataPoint;
import gov.usgs.vdx.data.gps.GPSData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SQLGPSDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "gps";
    public static final boolean channels = true;
    public static final boolean translations = false;
    public static final boolean channelTypes = true;
    public static final boolean ranks = true;
    public static final boolean columns = false;
    public static final boolean menuColumns = true;
    public static final Column[] MENU_COLUMNS = new Column[]{new Column(1, "east", "East", "meters", true, false, false), new Column(2, "north", "North", "meters", true, false, false), new Column(3, "up", "Up", "meters", true, false, false), new Column(4, "length", "Length", "meters", false, false, false)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return true;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return false;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return true;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            this.defaultCreateDatabase(true, false, true, true, false, true);
            for (int i = 0; i < MENU_COLUMNS.length; ++i) {
                this.defaultInsertMenuColumn(MENU_COLUMNS[i]);
            }
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.st.execute("CREATE TABLE sources (sid INT AUTO_INCREMENT,name VARCHAR(255), hash VARCHAR(32),j2ksec0 DOUBLE NOT NULL, j2ksec1 DOUBLE NOT NULL,rid INT,PRIMARY KEY (sid, j2ksec0, j2ksec1),UNIQUE KEY (name, j2ksec0, j2ksec1, rid),KEY index_j2ksec0 (j2ksec0), KEY index_j2ksec1 (j2ksec1))");
            this.st.execute("CREATE TABLE solutions (sid INT, cid INT,x DOUBLE, y DOUBLE, z DOUBLE,sxx DOUBLE, syy DOUBLE, szz DOUBLE,sxy DOUBLE, sxz DOUBLE, syz DOUBLE,PRIMARY KEY (sid, cid))");
            logger.log(Level.INFO, "SQLGPSDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded.");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLGPSDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active) {
        return this.defaultCreateChannel(channelCode, channelName, lon, lat, height, active, 0, true, false, true, false);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(true));
        }
        if (action.equals("channelTypes")) {
            return new TextResult(this.defaultGetChannelTypes());
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals("columns")) {
            return new TextResult(this.defaultGetMenuColumns(true));
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("ch"));
            int rid = Integer.parseInt(params.get("rk"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            GPSData data = null;
            try {
                data = this.getGPSData(cid, rid, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return SQLGPSDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else {
            if (action.equals("supptypes")) {
                return this.getSuppTypes(true);
            }
            if (action.equals("suppdata")) {
                return this.getSuppData(params, true);
            }
            if (action.equals("metadata")) {
                return this.getMetaData(params, true);
            }
        }
        return null;
    }

    public Channel getChannel(String channelCode) {
        return this.defaultGetChannel(channelCode, true);
    }

    public List<Channel> getChannelsList() {
        return this.defaultGetChannelsList(true);
    }

    public GPSData getGPSData(int cid, int rid, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        GPSData result = null;
        try {
            DataPoint dp;
            this.database.useDatabase(this.dbName);
            ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
            int tempmaxrows = rid != 0 ? maxrows : maxrows * this.defaultGetNumberOfRanks();
            this.sql = "SELECT (j2ksec0 + j2ksec1) / 2, d.rid, x, y, z, sxx, syy, szz, sxy, sxz, syz ";
            this.sql = this.sql + "FROM   solutions a INNER JOIN channels b ON a.cid = b.cid INNER JOIN sources  c ON a.sid = c.sid INNER JOIN ranks    d ON c.rid = d.rid WHERE  b.cid    = ? AND    (c.j2ksec0 + c.j2ksec1) / 2 >= ? AND    (c.j2ksec0 + c.j2ksec1) / 2 <= ? ";
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 FROM solutions a INNER JOIN channels b ON a.cid = b.cid INNER JOIN sources c ON a.sid = c.sid INNER JOIN ranks d ON c.rid = d.rid WHERE b.cid = ? AND (c.j2ksec0 + c.j2ksec1) / 2 >= ? AND (c.j2ksec0 + c.j2ksec1) / 2 <= ? ";
            if (rid != 0) {
                this.sql = this.sql + "AND   d.rid = ? ";
                this.sqlCount = this.sqlCount + "AND d.rid = ? ";
            }
            this.sql = this.sql + "ORDER BY 1 ASC, d.rank DESC";
            this.sqlCount = this.sqlCount + "ORDER BY 1 ASC, d.rank DESC";
            if (rid != 0) {
                try {
                    this.sql = SQLGPSDataSource.getDownsamplingSQL(this.sql, "(j2ksec0 + j2ksec1) / 2", ds, dsInt);
                }
                catch (UtilException e) {
                    throw new UtilException("Can't downsample dataset: " + e.getMessage());
                }
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (tempmaxrows + 1);
                if (ds.equals((Object)DownsamplingType.NONE)) {
                    this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (tempmaxrows + 1) + ") as T");
                    this.ps.setInt(1, cid);
                    this.ps.setDouble(2, st);
                    this.ps.setDouble(3, et);
                    if (rid != 0) {
                        this.ps.setInt(4, rid);
                    }
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > tempmaxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
                    }
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            if (ds.equals((Object)DownsamplingType.MEAN)) {
                this.ps.setDouble(1, st);
                this.ps.setInt(2, dsInt);
                this.ps.setInt(3, cid);
                this.ps.setDouble(4, st);
                this.ps.setDouble(5, et);
                if (rid != 0) {
                    this.ps.setInt(6, rid);
                }
            } else {
                this.ps.setInt(1, cid);
                this.ps.setDouble(2, st);
                this.ps.setDouble(3, et);
                if (rid != 0) {
                    this.ps.setInt(4, rid);
                }
            }
            this.rs = this.ps.executeQuery();
            if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLGPSDataSource.getResultSetSize(this.rs) > tempmaxrows) {
                throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.vdxName + "' exceeded. Please downsample further.");
            }
            double tempJ2ksec = Double.MAX_VALUE;
            while (this.rs.next()) {
                if (Double.compare(tempJ2ksec, this.rs.getDouble(1)) != 0) {
                    dp = new DataPoint();
                    dp.t = this.getDoubleNullCheck(this.rs, 1);
                    dp.r = this.getDoubleNullCheck(this.rs, 2);
                    dp.x = this.getDoubleNullCheck(this.rs, 3);
                    dp.y = this.getDoubleNullCheck(this.rs, 4);
                    dp.z = this.getDoubleNullCheck(this.rs, 5);
                    dp.sxx = this.getDoubleNullCheck(this.rs, 6);
                    dp.syy = this.getDoubleNullCheck(this.rs, 7);
                    dp.szz = this.getDoubleNullCheck(this.rs, 8);
                    dp.sxy = this.getDoubleNullCheck(this.rs, 9);
                    dp.sxz = this.getDoubleNullCheck(this.rs, 10);
                    dp.syz = this.getDoubleNullCheck(this.rs, 11);
                    dataPoints.add(dp);
                }
                tempJ2ksec = this.rs.getDouble(1);
            }
            this.rs.close();
            if (dataPoints.size() == 0) {
                dp = new DataPoint();
                dp.t = Double.NaN;
                dp.r = Double.NaN;
                dp.x = Double.NaN;
                dp.y = Double.NaN;
                dp.z = Double.NaN;
                dp.sxx = Double.NaN;
                dp.syy = Double.NaN;
                dp.szz = Double.NaN;
                dp.sxy = Double.NaN;
                dp.sxz = Double.NaN;
                dp.syz = Double.NaN;
                dataPoints.add(dp);
            }
            result = new GPSData(dataPoints);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLGPSDataSource.getGPSData(" + cid + "," + rid + "," + st + "," + et + ") failed.", e);
        }
        return result;
    }

    public int insertSource(String name, String hash, double t0, double t1, int rid) {
        int sid = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT sid FROM sources WHERE hash = ? ");
            this.ps.setString(1, hash);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                sid = this.rs.getInt(1);
            }
            this.rs.close();
            if (sid > 0) {
                return -1;
            }
            this.ps = this.database.getPreparedStatement("SELECT sid FROM sources WHERE j2ksec0 = ? AND j2ksec1 = ? AND rid = ?");
            this.ps.setDouble(1, t0);
            this.ps.setDouble(2, t1);
            this.ps.setInt(3, rid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                sid = this.rs.getInt(1);
                this.ps = this.database.getPreparedStatement("DELETE FROM solutions WHERE sid = ?");
                this.ps.setInt(1, sid);
                int delcount = this.ps.executeUpdate();
                this.ps = this.database.getPreparedStatement("DELETE FROM sources WHERE sid = ?");
                this.ps.setInt(1, sid);
                this.ps.executeUpdate();
                Rank rank = this.defaultGetRank(rid);
                logger.severe("deleted " + name + " rank " + rank.getName() + " (" + delcount + " solutions)");
            }
            this.ps = this.database.getPreparedStatement("INSERT INTO sources (name, hash, j2ksec0, j2ksec1, rid) VALUES (?,?,?,?,?)");
            this.ps.setString(1, name);
            this.ps.setString(2, hash);
            this.ps.setDouble(3, t0);
            this.ps.setDouble(4, t1);
            this.ps.setInt(5, rid);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                sid = this.rs.getInt(1);
            }
            this.rs.close();
            return sid;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLGPSDataSource.insertSource() failed.", e);
            return sid;
        }
    }

    public int insertSourceSimple(String name, double t0, double t1, int rid) {
        int sid = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT sid FROM sources WHERE j2ksec0 = ? AND j2ksec1 = ? AND rid = ?");
            this.ps.setDouble(1, t0);
            this.ps.setDouble(2, t1);
            this.ps.setInt(3, rid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                sid = this.rs.getInt(1);
                this.ps = this.database.getPreparedStatement("DELETE FROM solutions WHERE sid = ?");
                this.ps.setInt(1, sid);
                int delcount = this.ps.executeUpdate();
                this.ps = this.database.getPreparedStatement("DELETE FROM sources WHERE sid = ?");
                this.ps.setInt(1, sid);
                this.ps.executeUpdate();
                Rank rank = this.defaultGetRank(rid);
                logger.severe("deleted j2ksec0:" + String.valueOf(t0) + " / j2ksec1:" + String.valueOf(t1) + " / rank:" + rank.getName() + " (" + delcount + " solutions)");
            }
            this.ps = this.database.getPreparedStatement("INSERT INTO sources (name, j2ksec0, j2ksec1, rid) VALUES (?,?,?,?)");
            this.ps.setString(1, name);
            this.ps.setDouble(2, t0);
            this.ps.setDouble(3, t1);
            this.ps.setInt(4, rid);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                sid = this.rs.getInt(1);
            }
            this.rs.close();
            return sid;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLGPSDataSource.insertSource() failed.", e);
            return sid;
        }
    }

    public void insertSolution(int sid, int cid, DataPoint dp) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT INTO solutions VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            this.ps.setInt(1, sid);
            this.ps.setInt(2, cid);
            this.ps.setDouble(3, dp.x);
            this.ps.setDouble(4, dp.y);
            this.ps.setDouble(5, dp.z);
            this.ps.setDouble(6, dp.sxx);
            this.ps.setDouble(7, dp.syy);
            this.ps.setDouble(8, dp.szz);
            this.ps.setDouble(9, dp.sxy);
            this.ps.setDouble(10, dp.sxz);
            this.ps.setDouble(11, dp.syz);
            this.ps.execute();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLGPSDataSource.insertSolution() failed.", e);
        }
    }
}

