      SUBROUTINE HYDEL (MODB)
C--READ IN STATION DELAYS FOR HYPOINVERSE AFTER READING IN MAIN STATION FILE
C--USE ONLY STATION SITE AND NET CODES SO ALL COMPONENTS & LOCS WILL MATCH

C--MODB IS AN INSTRUCTION CODE:
C  -1    READ IN LIST OF ALTERNATE STATIONS (INDICATED BY A IN COL. 7)
C   0    READ IN ALL DELAY MODELS FROM ONE FILE
C   1-LM READ IN DELAYS FOR THIS MODEL NUMBER ONLY

      INCLUDE 'common.inc'
C--MAX OF 31 DELAYS READABLE IF ALL DELAYS ARE IN ONE FILE
      DIMENSION PD(31)
      CHARACTER STA*5,SNET*2,CH*1
      NDLZ=0
      LMM=LM
      IF (LMM.GT.31) LMM=31

C--ERROR MESSAGE
      IF (JSTA.EQ.0) THEN
        WRITE (6,1002)
1002    FORMAT (' *** ERROR: YOU CANT READ DELAYS BEFORE ',
     2  'READING THE STATION FILE')
        CLOSE (13)
        IRES=-42
        RETURN
      END IF

      IF (MODB.EQ.-1) THEN
C++++++++++++ READ IN THE LIST OF STATIONS TO USE ALTERNATE MODEL +++++++++++
C--LOOP TO READ IN THE STATION CODES AND ALTERNATE FLAGS
10      READ (13,1010,ERR=80,END=90) STA,SNET,CH
1010    FORMAT (A5,1X,A2,2X,A1)

C--LOOK FOR STATION IN MASTER TABLE. CHANGE ALL COMPONENTS IN TABLE.
C--REPORT NO MISMATCH ERRORS
        DO J=1,JSTA
          IF (STA(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2    SNET(1:NETLET) .EQ. JNET(J)(1:NETLET) .AND.
     3    CH.EQ.'A') THEN

            JLMOD(J)=.TRUE.
            NDLZ=NDLZ+1
          END IF
        END DO
        GOTO 10

      ELSE IF (MODB.EQ.0) THEN
C++++++++++++ READ IN ALTERNATE STATIONS & DELAYS FOR ALL MODELS +++++++++++
C--LOOP TO READ IN THE ARRAY OF DELAYS
20      READ (13,1020,ERR=80,END=90) STA,SNET,CH,PD
1020    FORMAT (A5,1X,A2,2X,A1,40F4.2)

C--LOOK FOR STATION IN MASTER TABLE. 
C--REQUIRE A 4-LETTER MATCH BUT REPORT NO MISMATCH ERRORS
        DO J=1,JSTA
          IF (STA(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2    SNET(1:NETLET) .EQ. JNET(J)(1:NETLET)) THEN
            IF (CH.EQ.'A') JLMOD(J)=.TRUE.
            DO I=1,LMM
              JPD(I,J)=NINT(PD(I)*100.)
            END DO
            NDLZ=NDLZ+1
          END IF
        END DO
        GOTO 20
      ELSE

C++++++++++++ READ IN DELAYS FOR ONE MODEL +++++++++++
C--LOOP TO READ IN DELAYS
30      READ (13,1030,ERR=80,END=90) STA,SNET,PD1
1030    FORMAT (A5,1X,A2,1X,F5.2)

C--LOOK FOR STATION IN MASTER TABLE. 
C--REPORT NO MISMATCH ERRORS
        DO J=1,JSTA
          IF (STA(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2    SNET(1:NETLET) .EQ. JNET(J)(1:NETLET)) THEN
            JPD(MODB,J)=NINT(PD1*100.)
            NDLZ=NDLZ+1
          END IF
        END DO
        GOTO 30
      END IF

C--DATA FORMAT OR READ ERROR
80    WRITE (6,1001) STA
1001  FORMAT (' *** ERROR READING DELAY FILE AT STATION ',A)
      IRES=-75

C--DONE READING FILE
90    CLOSE (13)
      IF (MODB.GE.0) WRITE (6,
     2 '(I6,'' STATION DELAYS SET FOR MODEL'',I3)') NDLZ,MODB
      IF (MODB.LT.0) WRITE (6,
     2 '('' ALTERNATE STATUS SET FOR'',I4,'' STATIONS'')') NDLZ
      RETURN
      END
