/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.IntVector;
import gov.usgs.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TextDataFile
extends SeismicDataFile {
    protected TextDataFile(String fileName) {
        super(fileName, "TXT^");
    }

    @Override
    public void read() throws IOException {
        IntVector iv = new IntVector(5000, 10000);
        BufferedReader in = new BufferedReader(new FileReader(this.fileName));
        Wave sw = new Wave();
        String line = in.readLine();
        double startTime = Double.parseDouble(line.substring(0, line.indexOf(" ")));
        sw.setStartTime(Util.ewToJ2K(startTime / 1000.0));
        iv.add(Integer.parseInt(line.substring(line.indexOf(" ") + 1)));
        line = in.readLine();
        double nt = Double.parseDouble(line.substring(0, line.indexOf(" ")));
        sw.setSamplingRate(1.0 / ((nt - startTime) / 1000.0));
        iv.add(Integer.parseInt(line.substring(line.indexOf(" ") + 1)));
        while (line != null) {
            iv.add(Integer.parseInt(line.substring(line.indexOf(" ") + 1)));
            line = in.readLine();
        }
        sw.buffer = iv.getResizedInts();
        in.close();
        this.waves.put(this.fileName, sw);
    }

    @Override
    public void write() throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.fileName)));
        for (Wave wave : this.waves.values()) {
            double ct = Util.j2KToEW(wave.getStartTime());
            for (int i = 0; i < wave.buffer.length; ++i) {
                out.println(Math.round(ct * 1000.0) + " " + wave.buffer[i]);
                ct += wave.getSamplingPeriod();
            }
        }
        out.close();
    }
}

