/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.MSeedQueryReader;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class MSeedQueryClient {
    protected QueryParams params;
    protected MSeedQueryReader reader;

    public MSeedQueryClient(String[] args) throws SeisFileException {
        BasicConfigurator.configure();
        this.params = this.initQueryParams(args);
    }

    QueryParams initQueryParams(String[] args) throws SeisFileException {
        QueryParams params = new QueryParams(args);
        Logger.getRootLogger().setLevel(Level.WARN);
        if (params.isVerbose()) {
            Logger.getLogger((String)"root").setLevel(Level.DEBUG);
        }
        if (params.isPrintHelp()) {
            System.out.println(this.getHelp());
            System.exit(0);
        } else if (params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            System.exit(0);
        }
        return params;
    }

    public void readData() throws SeedFormatException, IOException, SeisFileException {
        if (this.params.isVerbose()) {
            this.reader.setVerbose(this.params.isVerbose());
        }
        PrintWriter out = new PrintWriter(System.out, true);
        List<DataRecord> data = this.reader.read(this.params.getNetwork(), this.params.getStation(), this.params.getLocation(), this.params.getChannel(), this.params.getBegin(), this.params.getEnd());
        for (DataRecord dr : data) {
            if (this.params.getDataOutputStream() != null) {
                dr.write(this.params.getDataOutputStream());
            }
            if (this.params.getDataOutputStream() != null && !this.params.isVerbose()) continue;
            dr.writeASCII(out, "    ");
            out.flush();
        }
        if (this.params.isVerbose() && data.size() == 0) {
            out.println("No Data.");
            out.flush();
        }
        if (this.params.getDataOutputStream() != null) {
            this.params.getDataOutputStream().flush();
        }
        if (this.params.isVerbose()) {
            out.println("Finished: " + new Date());
        }
    }

    public abstract String getHelp();
}

