@echo off
rem # recoverid.cmd                                   2005/3/31:LDD
rem # Usage: recoverid eventid target-host
rem # Requires these non-DOS commands: c:\local\bin\grep, safecopy.cmd

rem # This script is to aid in recovering events identified at a remote
rem # node when network communications has been broken between the node
rem # and the main processing center.

rem # Set machine-specific paths:
rem #----------------------------
rem # Set EVENT_DIR to the directory where event messages are being
rem # automatically stashed away.
rem #
rem # Set OUTDIR_BASE to the base name of the directories being polled
rem # by various sendfileII modules for shipping recovered data to
rem # machines back in Menlo Park. The target directory will be 
rem # generated by tacking target-host (%2) on the end of OUTDIR_BASE.


setlocal
set EVENT_DIR=c:\earthworm\run\arc
set OUTDIR_BASE=c:\earthworm\run\send2

if "%1" EQU ""     goto Usage
if "%2" EQU ""     goto Usage
if "%2" EQU "ew03" goto ValidTarget
if "%2" EQU "ew04" goto ValidTarget

:Usage

@echo "  Usage: recoverid <eventid> <target-host>"
@echo
@echo "  where: <eventid>     = id of the event to recover"
@echo "         <target-host> = ew03 or ew04 (current MASTER system)"
@echo " "
@echo "Example: recoverid 6110543 ew04"
goto Done

:ValidTarget

set TARGET=%OUTDIR_BASE%%2

rem # Build list of files which contain eventid:
rem #-------------------------------------------

cd %EVENT_DIR%
c:\local\bin\grep -l -s %1 * > tmp.filelist

rem # List files and give user a chance to abort:
rem #--------------------------------------------

@echo Events in the following data file(s) will be sent to %2:
for /F %%2 in (tmp.filelist) do @echo   %%2
@echo Press Cntl-C to abort or 
pause

rem # For each target directory, call safecopy for each data file.
rem # Safecopy makes an interim copy of the file in temporary workspace, 
rem # then move it into the output directory. The extra step is required
rem # to ensure that sendfileII gets a complete file to ship to getfileII.
rem #---------------------------------------------------------------------

for /F %%2 in (tmp.filelist) do (for %%3 in (%TARGET%); do call safecopy %%2 %%3)

@echo File copy complete!
del tmp.filelist

:Done

endlocal
