	PROGRAM SQUIRREL 		! source begins at about line 100
C
C	Douglas D. Given
C	U.S.G.S., O.E.V.E
C	525 So. Wilson Ave.
C	Pasadena, CA  91106
C
C FUNCTION:
c	Do continuous writes of real-time data buffers to 4mm DAT tape (& other)
c	Object: create full digital backup of network data, replace FM drives,
c	        allow retrieval of teleseisms, etc.
c
c	Don't use MAILPERSON, don't want to be exposed to failure if 
c	MAILPERSON stops. This way we only depend on CORE to keep going.
c
c	NOTE: LIB$GLUE:MT.FOR has bugs, so we use our own local MT.FOR source
c	SUBROUTINE MTEOF_1 in LIB$GLUE:MT.FOR writes a single EOF mark,
c	SUBROUTINE MTEOF writes 2 then backs up over one!
c ======================================================================
C What SQUIRREL does with "MODE" stop and idle flags
c
c	To gain some real-time control of SQUIRREL I use the SLING flag in the 
c	WEB (W.KSLI_STOP). Since SLING doesn't really exist they aren't used by
c	anybody else. We also watch the MODE (W.KSTOP) flag for system control.
c
c	COMMAND			ACTION
c	$ MODE STOP or		
c	  MODE SLING_STOP	Write WEB right now, dismount tape, stop
c
c	$ MODE IDLE		Write WEB right now, dismount tape, wait for
c				 MODE (K.STOP) to change
c				  if MODE GO, resume on next device
c				  if MODE STOP or SLING_STOP, quit
c	$ MODE SLING_IDLE or	Write WEB right now, dismount tape, clear the
c	  MODE SQRL_IDLE or	flag and resume on next device (swap device)
c	  MODE SQUIRREL_IDLE 	(used to make current tape available)
c
c	We us internal variable, ISTAT to keep track of our current status.
c	ISTAT = 0	all systems go
c	ISTAT = 1	MODE SLING_IDLE close file, change tape and continue
c	ISTAT = 2	MODE IDLE close file, change tape & wait for W.KSTOP=0
c	ISTAT = 3	MODE STOP or MODE SLING_STOP close all and quit
c
c	We can't test W.KSTOP everywhere because it is changed by other 
c	programs and we need to remember if we are recovering from a stop or 
c	idle condition. 
c ======================================================================
c SOME WORDS ABOUT WHAT IS DONE WHEN THE END OF THE TAPE IS REACHED, ETC.
c
c	There are four situations that might occur at at the end of a tape:
c
c	1) We hit the EOT foil while writing data to a tape file. 
C	ACTION: back up 'min_bpf' records into the part of the tape before
c	 the EOT, update 'w.lsli_end' value to reflect the true file length, 
c	 write the WEB, write EOV, and mount the next tape.
c	 NOTE: 'w.lsli_end' is the only WEB value we this program changes. I 
c	       would prefer to use a special value but don't want to change the
c	       WEB definition. It seems safe because SLING to tape isn't used 
c	       anywhere.
c
c	2) We hit the EOT foil while writing data to a tape file that did not
c	   yet contain more than 'min_bpf' records.
c	ACTION: chuck the whole file. Back up to the end of the last file and 
c	 write the EOV. Resume on the next tape.
c
c	3) An orderly shutdown of the system was ordered.
c	ACTION: write out all the remaining buffers in memory, write EOV and
c	 exit.
c
c	4) An error occurs that we can't recover from.
c	ACTION: update 'w.lsli_end' to the true file length, write the WEB,
c	 write EOV, and exit. Notify someone that process is failing.
c
C NOTE: I USE IOSB RETURNS FROM THE MT ROUTINE AND NOT IRES BECAUSE I NEED
C	TO DISTINGUISH BETWEEN EOF, EOV AND EOT
C
c INTERACTION WITH WEB REGION
c	We take the liberty of changing the values of two variables in the WEB.
c	W.KSLI_STOP and W.LSLI_END.
c
c DEVICE ERRORS, BAD DEVICES, ETC.
c	A tape may fail to mount for many reasons; no tape in drive, drive in 
c	use by another user, bad drive or media, tape rewinding. When a device
c	returns an error we skip it and move to the next device. An error count
c	for each device is kept in SQ.KERR(ndev). It is reset to '0' each time
c	the device is successfully mounted. MAIL is sent and a .LOG entry made
c	each time a mount error is detected. If the error count ever exceeds
c	MAXERR that device is taken 'out-of-service' and no further attempts 
c	are made to mount it. If all devices go out-of-service the program
c	exits.
c ======================================================================
c	25-JUL-1991 DDG - am going to see if We can get the drives to stream
c	or at least not work as hard by writing out in bursts after a delay of
c	LAG_BUFS (25% of the WEB data space; e.g. if you have 200 buffers in 
c	memory we will do a write cycle every 50 buffers of elapse time.)
c	This has the potential to get us too far behind during a tape change or
c	some other system event that puts us behind but may be an acceptable 
c	trade off if it extends the life of the DAT drives. However, the buffer-
c	ing on the SCSI controller may be optimizing tape motion already and 
c	the software bursts may have no effect.
c
c## DDG - 15-AUG-1995: added option to unload tape after rewind

	IMPLICIT REAL*8 (D)
	IMPLICIT INTEGER*4 (L)
	IMPLICIT BYTE (C)

	INCLUDE 'WEB$INCLUDE'		!WEB parameter structure
	INCLUDE 'LIB$RT:BUFFERS.INC'	!Data buffer structure
	INCLUDE 'SQUIRREL.INC'		!SQUIRREL structures
	INCLUDE 'MT.INC'		!Mag tape structures
	INCLUDE '($SSDEF)'		!IOSB return parameter names

	INTEGER	  GO_SET
	INTEGER	  STOP_SET
	INTEGER   IDLE_SET

	PARAMETER (GO_SET   = 0)	!go   flag value for readablity
	PARAMETER (STOP_SET1= 1)	!stop flag value for readablity
	PARAMETER (STOP_SET2= 2)	!stop flag value for readablity
	PARAMETER (IDLE_SET = 10)	!idle flag value for readablity

	PARAMETER (MIN_BPF  = 4)	!minimum buffers per file for a 'keeper'
	PARAMETER (MAXERR   = 10)	!device error before giving up

	PARAMETER (MIN_SPB  =  5)
 
	BYTE CLOG(30), CSTR(40)

	CHARACTER*22 C22
	CHARACTER*80 C80

	INTEGER*2 I2			!generic I2 converter

	LOGICAL 	NEW_RUN /.TRUE./

C .. INITIALIZATION

	ISTAT = 0			!SYSTEM GO

	IER = 10
	IUNIT = 11
	SQ.OUT_FILE = 'HOT:SQUIRREL.TYP'
	OPEN(	UNIT=IUNIT,			!open status output file
	1	FILE=SQ.OUT_FILE,
	1	STATUS='NEW',
	1	SHARED,
	1	BUFFERCOUNT=2,
	1	ERR=910)

c .. write starting message

	CALL TIME_STAMP ('** SQUIRREL starting (systime):', IUNIT)

c ... link to the WEB/data memory region of the active on-line system
	ILINK = 2			!link to web and buffers
	ILOCK = 0			!don't lock. (1 -> lock).
	JUNIT = 0			!don't output messages from linknlock

	CALL LINKNLOCK(JUNIT, ILINK, ILOCK, LSTAT, LRES)

	IER = 20
	IF (LRES .LT. 1) THEN
	  WRITE(IUNIT, 2) LSTAT, LRES
    2	  FORMAT(1X, 'SQUIRREL... error from LINKNLOCK: lstat= ', i9,
	1	 1x, ', lres= ', i9)
	  GOTO 910
	END IF

c .. read the initiallizer file

	CALL READ_INI (IUNIT, IRES)
	IER = 30
	IF (IRES .LT. 1) GOTO 910

c ... set time base from WEB parameters
	CALL SET_TIME (IRES)			!set/reset time base
	IER = 40
	IF (IRES .LT. 0) GOTO 920

	CALL DATE22 (TIME.DTBASE, %REF(C22))
	WRITE (IUNIT, 1030) C22, TIME.CTYPE
 1030	FORMAT (' SQUIRREL time synched to: ', A22, 1X, A6)

c .. initiallize some WEB related stuff

	SECDLY = 4.0 * W.KSPB / W.KRATE / W.KFACT  !time to wait for new buffer
						   ! wait 4x buffer length

						!give cushion to earliest buffer
	LBCUSH = 20 * W.KRATE / REAL(W.KSPB)	!convert from 20 sec to buffers

c .. calc words in WEB region and DIO area
c	(NOTE: '/256 * 256' needed to round to right integer)

	NWORDS_DIO = ((W.NWDIO + 255) / 256) * 256

	NWORDS_WEB = ((W.NWPAR + 255) / 256) * 256

c ... The MT routines cannot do a block write of more then 65535 bytes, :. must
c     truncate WEB if it is too big. Hope this only clips off padding. Must fix  
c     MT routines later. DDG 27-SEP-1995 

	NWORDS_WEB = MIN(NWORDS_WEB, 32767)		!DDG 27-SEP-1995 

c ... initialize a few variables

	KTAPE = 0			!tape counter
	KFILE = 0			!file counter
	KBUF  = 0			!buffer counter

	KDEV = 1			!tape device pointer, use 1st device
	KBAD = 0			!bad device counter

	LAG_BUFS = W.NBUF * SQ.HIGHWATER   !only write when WEB data area is some
					   ! % full
	SEC_LAG  = LAG_BUFS*(W.KSPB/REAL(W.KRATE))

	WRITE (IUNIT, *) ' LAG_BUFS = ', LAG_BUFS
	1	        ,'  SEC_LAG = ', SEC_LAG

c .. check WEB STOP/IDLE flags before we waste any more effort
	IER = 50
	IF (W.KSLI_STOP .EQ. STOP_SET1) THEN
	  WRITE (IUNIT, *) ' *** SQUIRREL_STOP flag is set. SQUIRREL stopping.'
	  GOTO 920				!bail
	ELSE IF (W.KSTOP .EQ. STOP_SET1 .OR.
	1		W.KSTOP .EQ. STOP_SET2) THEN
	  WRITE (IUNIT, *) ' *** MODE STOP flag is set. SQUIRREL stopping.'
	  GOTO 920				!bail
	ELSE IF (W.KSLI_STOP .EQ. IDLE_SET) THEN
	  W.KSLI_STOP = GO_SET			!clear SLING IDLE flag, continue
	ELSE IF (W.KSTOP .EQ. IDLE_SET) THEN
	  ISTAT = 2
	  GOTO 220				!goto idle loop
	END IF
c ......................................................................
c	Beginning of a tape (1st or new or return from IDLE condition)

  50	CONTINUE

	IF (ISTAT .EQ. 2) THEN			!MODE IDLE occurred
	  CALL TIME_STAMP ('Waiting for IDLE to clear: ', IUNIT)

	  DO WHILE (W.KSTOP .EQ. IDLE_SET) 	!SYSTEM IDLE loop
	    IF (W.KSLI_STOP .EQ. STOP_SET1 .OR. 
	1	    W.KSTOP .EQ. STOP_SET1 .OR.
	1	    W.KSTOP .EQ. STOP_SET2) GOTO 920   !shutdown 
	    CALL DELAY(SECDLY)			
	  END DO

	  DO WHILE (W.KSLI_STOP .EQ. IDLE_SET) 	!SQUIRREL IDLE loop
	    IF (W.KSLI_STOP .EQ. STOP_SET1 .OR. 
	1	    W.KSTOP .EQ. STOP_SET1 .OR.
	1	    W.KSTOP .EQ. STOP_SET2) GOTO 920   !shutdown 
	    CALL DELAY(SECDLY)			
	  END DO

	  CALL TIME_STAMP ('MODE IDLE condition cleared at: ', IUNIT)
	  ISTAT = 0

	  NEW_RUN = .TRUE.			!Start from scratch

	END IF

c ... check for stop
	IF (W.KSTOP     .NE. GO_SET .OR. 
	1   W.KSLI_STOP .NE. GO_SET) GOTO 150

c   .. skip device if error count exceeds MAXERR 
	LCDEV = LENTRUE(SQ.CDEV_NAME(KDEV))		!stuff name in byte str

	IF (SQ.KERR(KDEV) .GE. MAXERR) THEN		!notify and skip
	  WRITE (IUNIT, *) '** Skipping ', SQ.CDEV_NAME(KDEV)(:LCDEV), 
	1	' MOUNT ERROR COUNT =', SQ.KERR(KDEV)
	  KDEV = KDEV + 1
	  IF (KDEV .GT. SQ.NDEV) KDEV = 1
	  GOTO 50			
	END IF

c .. mount tape foreign, assign channel (deassign old channel if there was one)

	CALL LIB$MOVC3 (LCDEV, %REF(SQ.CDEV_NAME(KDEV)), CSTR)
	CSTR(LCDEV+1) = 0

	CALL MTMNT (SQ.KCHAN(KDEV), CSTR, IUNIT, IRES) 
	IER = 60

c .. if error on mount, notify and try next device in line
	IF (IRES .LT. 1) THEN			!error on mount or assign
	  IER = 65

	  SQ.KERR(KDEV) = SQ.KERR(KDEV) + 1	!inc error counter

C     ... write to SQUIRREL.TYP file
	  CALL TIME_STAMP ('%%%%% SQUIRREL ERROR %%%%% ', IUNIT)
	  WRITE (IUNIT, *) '%%%%% ', SQ.CDEV_NAME(KDEV)(:LCDEV), 
	1	' MOUNT ERROR COUNT =', SQ.KERR(KDEV), IRES,' %%%%%'
 
C     ... If first error, write to TROUBLE file
c	  (NOTE: HOT and SQUIRREL$TROUBLE must be defined /SYSTEM or /GROUP.
c		 LIB$SPAWN will NOT work if SQUIRREL is run /detached w/o CLI)

	  IF (SQ.KERR(KDEV) .EQ. 1) THEN

	    OPEN (20, FILE='HOT:SQTRB.LIS', STATUS='NEW')
	    CALL TIME_STAMP ('%%%%% SQUIRREL ERROR %%%%% ', 20)
	    WRITE (20, *)    '%%%%% ', SQ.CDEV_NAME(KDEV)(:LCDEV), 
	1	' MOUNT ERROR COUNT =', SQ.KERR(KDEV), IRES, ' %%%%%'
	    CALL GETMSG(20, LSTAT)			!was IOSB(1)
	    CLOSE (20)

C ... CHANGED FROM MAIL TO MORE FLEXIBLE .COM FILE - DDG 15-AUG-1995 
C	  LSTAT = LIB$SPAWN
C	1 ('MAIL /SUB="SQUIRREL TROUBLE" HOT:SQTRB.LIS "@DIS$TROUBLE"')
C	  IF (.NOT. LSTAT) CALL GETMSG(IUNIT, LSTAT)

C ... EXECUTE TROUBLE .COM FILE, GIVE DEVICE NAME AS PARAMETER
	    C80 = '@SQUIRREL$TROUBLE ' // SQ.CDEV_NAME(KDEV)(:LCDEV)

	    LSTAT = LIB$SPAWN (C80)
	    IF (.NOT. LSTAT) CALL GETMSG(IUNIT, LSTAT)

	  END IF

c ... if a device exceeds MAXERR consider device 'out-of-service'
	  IF (SQ.KERR(KDEV) .GE. MAXERR) THEN	!notify and try next device
	    KBAD = KBAD + 1			!inc bad device counter

	    IF (KBAD .GE. SQ.NDEV) THEN		!all devices bad, bail
	      WRITE (IUNIT, *) '%%%%% SQUIRREL ERROR %%%%%'
	      WRITE (IUNIT, *) 
	1		'  All defined devices are out-of-service.'
	      GOTO 920				!EXIT
	    END IF
	  END IF

	  KDEV = KDEV + 1			!inc. device and continue
	  IF (KDEV .GT. SQ.NDEV) KDEV = 1	! wrapped, return to 1st device
	  GOTO 50				! try mounting new device

	END IF

c ... good mount
	SQ.KERR(KDEV) = 0			!reset device error counter
	KFILE = 0				!reset file counter
	KTAPE = KTAPE + 1			!count tapes written
	LBEHIND = 0				!MAX buffers behind

	WRITE (IUNIT, *) 
	CALL TIME_STAMP ('** New tape at (systime):', IUNIT)
  
c ... SET/RESET time base from WEB parameters

	CALL SET_TIME (IRES)			!set/reset time base
	IER = 51
	IF (IRES .LT. 0) GOTO 920

	CALL DATE22 (TIME.DTBASE, %REF(C22))
	WRITE (IUNIT, 1030) C22, TIME.CTYPE

	WRITE (IUNIT, 510) SQ.CDEV_NAME(KDEV)(:LCDEV), KTAPE
  510	FORMAT (' Device name is ', A<LCDEV>, '  Tape # ', I4,/)

c ... skip ahead if 'sq.skip' is non-zero. This is for debugging so I don't
c	have to wait 5 hours to test EOT logic

	IF (NEW_RUN .AND. SQ.SKIP .GT. 0) THEN		!do on 1st tape only

	  CALL TIME_STAMP (' ', IUNIT)
	  WRITE (IUNIT, 520) SQ.SKIP
  520	  FORMAT (' Beginning skip of ', I4,' FILES.')

	  I2 = SQ.SKIP
	  CALL MTSPF (SQ.KCHAN(KDEV), I2, IUNIT, IRES)	
	  IER = 70
	  IF (IRES .EQ. -3) THEN
	    WRITE (IUNIT, *) 'Hit EOT during skip operation.'
	    SQ.SKIP = -SQ.SKIP
	    GOTO 50				!new tape
	  END IF

	  IF (IRES .LT. -3) GOTO 910	!ignore EOV 

	  CALL TIME_STAMP ('Skip done:', IUNIT)

	END IF

c......................................................................
c	TOP OF THE FILE LOOP

 100	CONTINUE

	KBUF = 0			!reset 'buffers output' counter
	KFILE = KFILE + 1		!increment file counter

c .. if 'NEW_RUN' then we want to start at the earliest available buffer
c    (do this calc. AFTER mounting tape because earliest available buffer is 
c     changing while we wait for mount to complete). We still need to allow a
c     cushion, 'lsec', for the time it takes to write the WEB, etc.

	IF (NEW_RUN) THEN		!first time through
	  SQ.LBSTART = W.LBUF - W.NBUF + LBCUSH		!earliest buffer + lbcush

	  IF (SQ.LBSTART .LT. LBCUSH) SQ.LBSTART = 1	!system just started
	  LBON  = SQ.LBSTART				!1st buffer of 1st file

	  NEW_RUN = .FALSE.

	ELSE				!not first time through
	  LBON  = LBOFF + 1		!start at next buffer past last one done
	END IF

c    .. check buffer for near wrap condition
  110	  CONTINUE		!goto target if 1st 'LBON' is overwritten
	
	IF ((W.LBUF - W.NBUF) .GT. (LBON - LBCUSH)) THEN

C	      ... increase cushion by 50%
	  LBON = W.LBUF - W.NBUF + (LBCUSH * 1.5)	!reset start buffer

	  WRITE (IUNIT, *) '** FORCING Reset of LBON to ', LBON, 
	1			' at W.LBUF = ', W.LBUF	

	END IF

c    .. calc. last buffer and last RTC in the file 
c	(put last RTC in the WEB for reference when we play it back)

	LBOFF = LBON + SQ.LFILE - 1		!last buffer of 1st file
	W.LSLI_END = LBOFF * W.KSPB		!last RTC of last buffer

	LRTC = ((LBON - 1) * W.KSPB) + 1	!RTC of 1st sample 
	DT_FILE = DT_OF_RTC(LRTC)	 	!start sec of file

c ..  write the WEB region out to the tape

	CALL MTWR (SQ.KCHAN(KDEV), NWORDS_WEB, %REF(W.WEB_ID), 
	1	IUNIT, IRES)
	IER = 100

c ..  SS$_ENDOFFILE and SS$_ENDOFVOLUME return IRES = 1, 2
	IF (IOSB(1) .EQ. SS$_ENDOFTAPE) GOTO 800	!hit EOT foil
	IF (IOSB(1) .EQ. SS$_CTRLERR)   GOTO 800	!past foil
	IF (IRES .LT. 0) GOTO 900			!error

c .. remember start time of tape
	IF (KFILE .EQ. 1) THEN
	  LRTC_FIRST = ((LBON-1) * W.KSPB) + 1
	  DT_TAPE_START = DT_OF_RTC(LRTC_FIRST) 

	  CALL DATE22 (DT_TAPE_START, %REF(C22))
	  WRITE (IUNIT, 8100) SQ.CDEV_NAME(KDEV)(:LCDEV), C22, TIME.CTYPE
 8100	  FORMAT ('>>Beginning-of-Tape: ', A<LCDEV>, ' at ', A22, 1X, A6)
	END IF

	CALL DATE22 (DT_FILE, %REF(C22))
	WRITE (IUNIT, 1000) KFILE, C22, LBON, W.LBUF-LBON+1
 1000	FORMAT (/'>File #', I3, ' BEGINS at ', A22, 
	1	' (LBON =', I8, ') ', I9, ' behind.')
 
	LB = LBON			!set buffer index to beginning buffer

c ...... Top of buffer write loop

	DO WHILE (LB .LE. LBOFF)	!DO from 'lbon' to 'lboff'

c ...   IF we've caught up to real time
	  IF (LB .GT. W.LBUF) THEN
C ...   wait for buffers to pile up to the SQ.HIGHWATER level then do a burst 
c	of writes
	    NEXT_BURST = LB + LAG_BUFS
	    DO WHILE (W.LBUF .LT. NEXT_BURST)	!wait for buffers to accumulate
c       ... check for a stop or idle flag			
	      IF (W.KSTOP     .NE. GO_SET .OR. 
	1	  W.KSLI_STOP .NE. GO_SET) GOTO 150
	      CALL DELAY(SECDLY)		!w/o this we check too often
	    END DO
	  END IF

	  IBUF = INTERBUFF(LB)		!get internal buffer number

	  LBEHIND = MAX(LBEHIND, W.LBUF - LB)

c ... handle case where requested buffer has been overwritten, FIFO wrapped
	  IF (IBUF .LT. 0) THEN	

	    WRITE (IUNIT, *) 
	1	'** FIFO WRAP: First buffer of new file overwritten = ', LB
	    WRITE (IUNIT, *) '   We''re', LBEHIND, ' buffers behind'

	    IF (KBUF .EQ. 0) THEN	!this was 1st buffer in file, trash 
	      IER= 200			! previous file header (WEB)

C	  ... skip back over WEB block so we can rewrite it
	      CALL MTSPB (SQ.KCHAN(KDEV), -1, IUNIT, LSKIP, IRES)	
	      IER = 210			
	      IF (IRES .LT. -3) GOTO 900		!ignore EOT, EOV, EOF

C	      ... increase cushion by 50%
	      LBON = W.LBUF - W.NBUF + (LBCUSH * 1.5)	!reset start buffer

	      WRITE (IUNIT, *) '** FORCING Reset of LBON to ', LBON, 
	1			' at W.LBUF = ', W.LBUF	

	      GOTO 110			!no buffers written yet, start over

	    ELSE		!mid file close file and continue
	      IER = 210
	      LBOFF = LB			!set last buffer = current buffer
	      GOTO 200			
	    END IF

	  END IF

c .. write the buffer out as one record
	  CALL MTWR (SQ.KCHAN(KDEV), NWORDS_DIO, %REF(IO.D(IBUF)), 
	1	IUNIT, IRES)
	  IER = 220
	  LBUF_SAV = IO.D(IBUF).H.LBUF
	  IF(LB .NE. LBUF_SAV) THEN
	    LB_DIFF = LBUF_SAV - LB
	    WRITE(IUNIT, 211) LB, LBUF_SAV, LB_DIFF
  211	    FORMAT(1X, 'ERROR: LB= ', I9, ', LBUF_SAV= ', I9,
	1	   1X, 'SAV - LB= ', i9)
	  ENDIF

	  IF (IOSB(1) .EQ. SS$_ENDOFTAPE) GOTO 800	!hit EOT foil
	  IF (IOSB(1) .EQ. SS$_CTRLERR)   GOTO 800	!past foil
	  IF (IRES .LT. 0) GOTO 900			!error

	  KBUF = KBUF + 1			!kount buffers output
	  LB = LB + 1				!increment long buffer

C	.. CHECK FOR PROCESS STOP FLAGS
c	   if set, close the tape file right now, write last WEB and exit.
c	   If IDLE close the file, write WEB and switch to next tape drive
c	   as soon as the IDLE condition is cleared

C  ... if we're in a STOP or IDLE mode identify source and jump out of loop

  150	  CONTINUE

	  IF (W.KSTOP .NE. GO_SET .OR. 		!MODE IDLE OR STOP
	1     W.KSLI_STOP .NE. GO_SET) THEN	!SQUIRREL IDLE OR STOP

	    IF (W.KSTOP .EQ. STOP_SET1 .OR.			!mode stop
	1		W.KSTOP .EQ. STOP_SET2) THEN

	      CALL TIME_STAMP ('MODE STOP ordered at (systime) ', IUNIT)
	      ISTAT = 3

	    ELSE IF (W.KSTOP .EQ. IDLE_SET) THEN		!mode idle 

	      CALL TIME_STAMP ('MODE IDLE ordered at (systime) ', IUNIT)
	      ISTAT = 2

	    ELSE IF (W.KSLI_STOP .EQ. STOP_SET1) THEN		!sling_stop

	      CALL TIME_STAMP ('SQUIRREL_STOP ordered at (systime) ', IUNIT)
	      ISTAT = 3

	    ELSE IF (W.KSLI_STOP .EQ. IDLE_SET) THEN		!sling_idle 

	      CALL TIME_STAMP 
	1      ('SQUIRREL_IDLE ordered (tape swap) at (systime) ', IUNIT)
	      ISTAT = 1					! swap tapes

	    ELSE

	      CALL TIME_STAMP ('Unclassified STOP at (systime) ', IUNIT)
	      ISTAT = 4

	    END IF

	    LBOFF = LB			!set last buffer = current buffer
	    GOTO 200			! jump out of loop	
	  END IF

	END DO

c ...... Bottom of buffer loop
c ...... if we fell through to here we have finished a file or STOP or IDLE

  200	CONTINUE

c ..  calculate last RTC written out and check against expected

	LTMP = (LB-1) * W.KSPB			!real ending RTC

	IF (LTMP .NE. W.LSLI_END) THEN		!mismatch
	  WRITE (IUNIT, *) ' Ending RTC mismatch: expected =', 
	1	W.LSLI_END, ' GOT =', LTMP
	  WRITE (IUNIT, *) ' Buffer =', LB 

	  W.LSLI_END = LTMP			!reset w.lsli_end to real end
	END IF

c ..  write the WEB region out to the tape (again)

	CALL MTWR (SQ.KCHAN(KDEV), NWORDS_WEB, %REF(W.WEB_ID), 
	1	IUNIT, IRES)
	IER = 230

	IF (IOSB(1) .EQ. SS$_ENDOFTAPE) GOTO 800	!hit EOT foil
	IF (IOSB(1) .EQ. SS$_CTRLERR)   GOTO 800	!past foil
	IF (IRES .LT. 0) GOTO 900			!error

c .. close the file

	CALL MTEOF_1 (SQ.KCHAN(KDEV), IUNIT, IRES)
	IER = 240

	IF (IOSB(1) .EQ. SS$_ENDOFTAPE) GOTO 800	!hit EOT foil
	IF (IOSB(1) .EQ. SS$_CTRLERR)   GOTO 800	!past foil
	IF (IRES .LT. 0) GOTO 900			!error

	DT_FILE = DT_OF_RTC(W.LSLI_END)			!stop sec of file

	CALL DATE22 (DT_FILE, %REF(C22))

	WRITE (IUNIT, 2200) KFILE, C22, LBOFF, LBEHIND
 2200	FORMAT (' File #', I3, ' ENDS   at ', A22, 
	1	' (LBOFF=', I8, ') ', I9, ' behind.')

c  ... handle MODE SLING_IDLE or MODE IDLE condition if necessary
  220	CONTINUE

	IF (ISTAT .EQ. 3) THEN
	  GOTO 920 					!shutdown ordered 
	ELSE IF (ISTAT .EQ. 1) THEN			!SLING_IDLE
	  ISTAT = 0					!reset flags
	  W.KSLI_STOP = GO_SET				! automatically
	  GOTO 850
	ELSE IF (ISTAT .EQ. 2) THEN			!MODE IDLE
	  GOTO 850					!close tape, start new one
	END IF

	GOTO 100				!next file

c ------------------------------------------------------------------------
c .. END-OF-TAPE
c	Normally we just plow right through EOF and EOV because they can
c	be left over from previous uses of the tape. The only thing we react
c	to is hitting the foil (SS$_ENDOFTAPE) or running out of tape 
C	(SS$_CTRLERR). Once the SS$_ENDOFTAPE error is returned it is returned
c	by ANY attemp to write to the tape. The only way to clear the error is 
c	to deaccess the device. Therefore, we must ignore errors returned from
c	attempts to write from this point on.
c	At end-of-tape we backup 'MIN_BPF' blocks, to give us some room to 
c	finish in, update W.LSLI_END in the WEB (the number of the last RTC in
c	file), and write the WEB where the last good data buffer had been. We 
c	then write EOF.
c	If (kbuf .le. min_bpf) there weren't enough data buffers written to 
c	keep the file so we backup to the start of the deficient file and 
c	write the EOF and start next file on next tape at the right buffer.

  800	CONTINUE

	IF (KBUF .LE. MIN_SPB) THEN	!.le. min_spb buffers written, trash 
					! this file, lbon remains unchanged

	    WRITE (IUNIT, *) ' Last file on tape too short, snuff it.'

c 	(reverse skip leaves us positioned AT END of previous file before TM)
	    CALL MTSPF (SQ.KCHAN(KDEV), -1, IUNIT, IRES)	
	    IER = 800			
	    IF (IRES .LT. -3) GOTO 900		!ignore EOT, EOV, EOF

	ELSE IF (KBUF .GT. MIN_BPF) THEN	!truncated file

	    I2 = - MIN_BPF		!I know, this isn't necess. w/ param

c	.. space back 'min_bpf' blocks (the EOT counts as a block)
	    CALL MTSPB (SQ.KCHAN(KDEV), I2, IUNIT, LSKIP, IRES)	
	    IER = 820			
	    IF (IRES .LT. -3) GOTO 900		!ignore EOT, EOV, EOF

	    LBOFF = LB - I2 - 1			!set lboff to last good buffer
						! -1 for incompleted block
	    W.LSLI_END = LBOFF * W.KSPB		!set WEB value

	    WRITE (IUNIT, *) ' Last file on tape truncated,',
	1	LBOFF-LBON, ' buffers long.'

c ..  write the WEB region out to the tape (again)

	    CALL MTWR (SQ.KCHAN(KDEV), NWORDS_WEB, %REF(W.WEB_ID), 
	1		IUNIT, IRES)
	    IER = 830
	    IF (IRES .LT. -3) GOTO 900		!ignore EOT, EOV, EOF

	    DT_FILE = DT_OF_RTC(W.LSLI_END)		!stop sec of file
	    CALL DATE22 (DT_FILE, %REF(C22))
	    WRITE (IUNIT, 2200) KFILE, C22, LBOFF, W.LBUF-LBOFF

	END IF 

	CALL MTEOF_1 (SQ.KCHAN(KDEV), IUNIT, IRES)
	IER = 840

C ... write EOT
 850	CONTINUE
	CALL MTEOF_1 (SQ.KCHAN(KDEV), IUNIT, IRES)	!write 2nd TM for EOV
	IER = 850

c ... rewind, tape without waiting, deassign channel, don't unload 
	CALL DISMOUNT (KDEV, IUNIT, IRES)
	IER = 870			
	IF (IRES .LT. 0) GOTO 900

c .. figure stop time of tape
	DT_TAPE_STOP = DT_OF_RTC(LBOFF * W.KSPB)

c ... write an output message

	CALL DATE22 (DT_TAPE_STOP, %REF(C22))
	WRITE (IUNIT, 8200) SQ.CDEV_NAME(KDEV)(:LCDEV), C22, TIME.CTYPE,
	1		KTAPE, KFILE, LBEHIND
 8200	FORMAT ('>>End-of-Tape      : ', A<LCDEV>, ' at ', A22, 1X, A6,/,
	1	'  Tape # ', I4, '  contains ', I5, 
	1	' files, and got no more then ', I6, ' buffers behind',/)

	CALL TIME_STAMP (' ** Tape complete at (systime):', IUNIT)

c .. increment device and continue
	KDEV = KDEV + 1			
	IF (KDEV .GT. SQ.NDEV) KDEV = 1		!wrapped, return to 1st device
	GOTO 50

C ...........................................................................
C ... NON-FATAL ERROR PATH, notify and try next tape device
  900	CONTINUE

	WRITE(IUNIT, 9000) IER,	IRES
 9000	FORMAT(' -- SQUIRREL -- NON-FATAL ERROR : IER = ', 
	1	I6, ' IRES = ', I6)

	WRITE (IUNIT, *) 
	1       '  Output to device ',SQ.CDEV_NAME(KDEV)(:LCDEV), 
	1	' terminated abnormally. Last WEB block not written.'
	WRITE (IUNIT, *) 
	1	'  SQ.KCHAN(KDEV)=', SQ.KCHAN(KDEV), 
	1	' KFILE=', KFILE, ' KBUF=', KBUF
	WRITE (IUNIT, *) 
	1	'  LBON=', LBON,' LBOFF=', LBOFF, ' W.LBUF=', W.LBUF,
	1	' LB=', LB

	CALL DISMOUNT (KDEV, IUNIT, IRES)	!ignore any errors

c .. set LBOFF to buffer where error occured (start of next tape (LBON) will be 
c    set = LBOFF + 1 at the top of the tape loop)
	LBOFF = LB - 1

c .. figure stop time of tape
	DT_TAPE_STOP = DT_OF_RTC(LBOFF * W.KSPB)
	CALL DATE22 (DT_TAPE_STOP, %REF(C22))
	WRITE (IUNIT, 8105) SQ.CDEV_NAME(KDEV)(:LCDEV), C22, TIME.CTYPE
 8105	FORMAT (' Tape in ', A<LCDEV>, ' stops at  ', A22, 1X, A6, 
	1	' with errors.')

c .. increment device and continue

	KDEV = KDEV + 1			
	IF (KDEV .GT. SQ.NDEV) KDEV = 1		!wrapped, return to 1st device
	GOTO 50					!start new tape

c ... ERROR path, notify and quit
  910	CONTINUE
	WRITE(IUNIT, 9100) IER,	IRES
 9100	FORMAT(' -- SQUIRREL -- FATAL ERROR : ier = ', 
	1	I6, ' IRES = ', I6)

	IF (SQ.KCHAN(KDEV) .GT. 0) THEN		!tape file open
	  WRITE (IUNIT, *) 
	1     ' Tape file closed by error: device= ',sq.cdev_name(kdev)
	  WRITE (IUNIT, *) 
	1	'  SQ.KCHAN(KDEV)=', SQ.KCHAN(KDEV), 
	1	' KFILE=', KFILE, ' KBUF=', KBUF
	  WRITE (IUNIT, *) 
	1	'  LBON=', LBON,' LBOFF=', LBOFF, ' W.LBUF=', W.LBUF,
	1	' LB=', LB

	  CALL MTEOF_1 (SQ.KCHAN(KDEV), IUNIT, IRES)
	END IF

c ... EXIT path
 920	CONTINUE

c ... rewind, tape without waiting, deassign channel, don't unload 
	CALL DISMOUNT (KDEV, IUNIT, IRES)

c .. figure stop time of tape
	DT_TAPE_STOP = DT_OF_RTC(LBOFF * W.KSPB)
	CALL DATE22 (DT_TAPE_STOP, %REF(C22))
	WRITE (IUNIT, 8108) SQ.CDEV_NAME(KDEV)(:LCDEV), C22, TIME.CTYPE
 8108	FORMAT (' Tape in ', A<LCDEV>, ' stops at  ', A22, 1X, A6, 
	1	' due to STOP order.')

c ... if we linked to WEB, release the pages in an orderly fashion
	CALL TIME_STAMP (' ** SQUIRREL unlinking WEB at:', IUNIT)

	IF (LRES .GE. 1) THEN	
	  SECDLY = 0.9 * REAL(W.KSPB) / W.KRATE / W.KFACT
	  CALL UNLINK (JUNIT, ILINK, SECDLY, LSTAT, LRES)
	END IF

	CALL TIME_STAMP (' ** SQUIRREL stopped at (systime):', IUNIT)

c .. close output
	CLOSE(IUNIT)

	CALL EXIT

	END

c ----------------------------------------------------------------------
	SUBROUTINE DISMOUNT 
	1		(KDEV, 		!index of device in SQUIRREL struct.
	1		 IUNIT, 	!unit # for error messages
	1		 IRES)		!status return

c	Rewind, dismount, but don't unload the tape defined by KDEV in the 
c	SQUIRREL.INC structure. Don't want to wait for this to complete so issue
c	an AST to dismount and deassign channel after rewind is done. Main 
c	program can continue during rewind

	INCLUDE 'SQUIRREL.INC'
	INCLUDE 'MT.INC'
	INCLUDE '($IODEF)'
	INCLUDE '($SSDEF)'

	EXTERNAL DISMOU_AST		!AST name
	INTEGER*4 SYS$QIO

c .. clear the IOSB
	DO I=1, 4
	  IOSB(I) = 0
	END DO

c .. define QIO function flag
C	IO_FUNC = io$_rewind .OR. io$m_nowait
	IO_FUNC = io$_rewind 		!cause QIO completion to wait for rewind

c .. set parameters for use in AST, passed in COMMON
	AST.CDEV  = SQ.CDEV_NAME(KDEV)
	AST.KCHAN = SQ.KCHAN(KDEV)
	AST.IRES  = 0
	AST.LRES  = 0

c .. issue the QIO w/o wait, AST will be called at completion
	LRES = SYS$QIO(
	1  %VAL(0)		,	!event flag
	1  %VAL(SQ.KCHAN(KDEV))	,	!channel number
	1  %VAL(IO_FUNC)	,	!function
	1  IOSB			,	
	1  DISMOU_AST		,	!AST address (name)
	1  			,	!AST parameter 
	1  ,,,,,)

	IF (.NOT. LRES) THEN
	  IF (IUNIT .GT. 0) THEN
	    WRITE(IUNIT, 100) LRES
  100	    FORMAT(' ** DISMOUNT ERROR: on QIO submit: lres ', i9)
	    CALL GETMSG (IUNIT, LSTAT)
	  ENDIF
	  IRES = -1
	ENDIF

	RETURN
	END

C ----------------------------------------------------------------------
c			     vvvvv  ^^^^
	SUBROUTINE READ_INI (IUNIT, IRES)

c .... read the initalization file (logical INI$SQUIRREL or squirrel.ini if no 
c	logical is defined))
c	Call only AFTER LINKNLOCK, we need the WEB values here

c	The values are stored and passed in the 'SQUIRREL.INC' common

	INCLUDE 'WEB$INCLUDE'
	INCLUDE 'SQUIRREL.INC'

	COMMON/GRG/ KYR, KMO, KDA, KHR, KMN	!date conversion

	CHARACTER*80 CSTR		!KOM subroutine work space
	CHARACTER*20 CTMP

c NOTE: the units used for some of these parameters internal to the program
c	may NOT be the same as those used to specify them in the .INI

c .. set default values for params, to use if not defined in .INI

c	variable	default value	internal units		.ini units
C			(inter/exter)
C	--------	-------------	--------------		----------
C
C	SQ.LBSTART	0/0		BUFFER NUMBER		TIME (hrmn)
C	SQ.LFILE	CALC'ED/120	BUFFERS			SECONDS
C	SQ.CDEV_NAME(N)	"TAPE"		DEVICE TYPE		- same -
C	SQ.HIGHWATER	0.25		FRACTION OF WEB MEMORY  - same -

c .. define defaults

	SQ.LBSTART 	= 0
	SQ.LFILE 	= 120 * W.KRATE / REAL(W.KSPB)		!120 secs
	SQ.CDEV_NAME(1)	= 'MUA0:'
	SQ.NDEV		= 1
	SQ.SKIP		= 0		!files to skip before starting
	SQ.HIGHWATER	= 0.25		!WEB FIFO "fill level" before writing	
	SQ.UNLOAD	= .FALSE.

c .. open the file, try logical INI$SQUIRREL 1st then local file SQUIRREL.INI
	IER = 10
	JUNIT = 20
	OPEN(UNIT=JUNIT,
	1  FILE='INI$SQUIRREL',		!logical name of initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=40)			!no definition, try SQUIRREL.INI

	GOTO 50

  40	CONTINUE

	WRITE (IUNIT, *) 
	1	' INI$SQUIRREL not defined trying file []SQUIRREL.INI'

	IER = 20
	OPEN(UNIT=JUNIT,
	1  FILE='SQUIRREL.INI',	   !try literal name for local initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=910)

c .. read in the initializer file
   50	CONTINUE

	CALL KOMRD(JUNIT, IRES)			!get a line
	IF(IRES .EQ. -10) GOTO 60		!end of file
	IF(IRES .EQ. 0) GOTO 50			!blank or comment line, skip it
	IER = 50
	IF(IRES .LT. 0) GOTO 910

	CALL KOMSTR(20, %REF(CSTR), IRES)	!interpret 1st token
	IER = 52
	IF(IRES .LT. 1) GOTO 910

c .. command interpretation

c .. <FILE_LENGTH> - length (in sec) of each individual file on tape

	IF (ITS ('FILE_L!')) then		!file length
	  CALL KOMINT (LSEC, IRES)
	  IER = 63
	  IF (IRES .LT. 0) GOTO 910

	  SQ.LFILE = LSEC * W.KRATE / REAL(W.KSPB)	!convert to buffers

c .. <SKIP> - Skip 'n' files before beginning to write (for debugging so I 
c		don't have to wait 5 hours to test EOT logic)

	ELSE IF (ITS ('SKIP')) THEN			!files to skip 
	  CALL KOMINT (SQ.SKIP, IRES)
	  IER = 66
	  IF (IRES .LT. 0) GOTO 910

c .. <UNLOAD> or <NOUNLOAD> - Set flag for unload on no unload after rewind

	ELSE IF (ITS ('UNLOAD')) THEN	
	  SQ.UNLOAD = .TRUE.

	ELSE IF (ITS ('NOUNL!')) THEN	
	  SQ.UNLOAD = .FALSE.

c.. <DEVICES> - list of devices to write out to
C    Max allowable device name length is 20 characters, logical names are OK

	ELSE IF (ITS ('DEV!')) then		!Tape

	  SQ.NDEV = 0

 610	  CALL KOMSTR (20, %REF(CTMP), IRES)	!get device name(s)
	  IER = 64
	  IF (IRES .LT. 0) THEN
	    GOTO 910				!error
	  ELSE IF (IRES .GT. 0) THEN
	    IF (SQ.NDEV .EQ. MAXDEV) THEN	!too many devices defined
	      WRITE (IUNIT, *) 
	1	' ** Maximum device count of ', MAXDEV, ' exceeded.'
	      WRITE (IUNIT, *) 
	1	'    Subsequent device definitions ignored.'
	    ELSE
	      SQ.NDEV = SQ.NDEV + 1		!inc. device count 
	      L = IRES

c	... must have ":" at end for SYS$ASSIGN to work properly
	      IF (CTMP(L:L) .NE. ':') THEN
	        L = L + 1
	        CTMP(L:L) = ':' 		!append ":" if not present
	      END IF
	      SQ.CDEV_NAME(SQ.NDEV) = CTMP(:L)
	      GOTO 610				!get another device?
	    END IF
	  END IF				!else, no more devices in list

c .. <HIGHWATER> - This is a fraction, once this portion of the whole WEB data 
c	FIFO in memory is full begin writting to tape. If this is too small the 
c	tape thrashes, if it is too large we could get too far behind during a
c	file close or tape change and wrap the FIFO.

	ELSE IF (ITS ('HIGHW!')) THEN		!fraction of FIFO
	  CALL KOMVAL (SQ.HIGHWATER, IRES)
	  IER = 69
	  IF (IRES .LT. 0) GOTO 910

c .. bad input
	ELSE
	  WRITE (IUNIT, *) ' ** Nonsense input line /',CSTR(:IRES), '/'
	END IF

	GOTO 50			!MORE, MORE AND STILL NOT SATIFIED...

c .. end of the init file

  60 	CLOSE (JUNIT)

c .. regurg results

	  WRITE (IUNIT, *) ' SQ.OUT_FILE  = ', SQ.OUT_FILE, 
	1		' (THIS FILE)'
	  WRITE (IUNIT, *) ' SQ.LFILE     = ', SQ.LFILE, ' (BUFFERS)'
	  WRITE (IUNIT, *) '                ', LSEC , ' (SECONDS)'
	  WRITE (IUNIT, *) ' SQ.LBSTART   = ', SQ.LBSTART
	  WRITE (IUNIT, *) ' SQ.SKIP      = ', SQ.SKIP
	  WRITE (IUNIT, *) ' SQ.HIGHWATER = ', SQ.HIGHWATER, 
	1					' FRACTION OF WEB FIFO'
	  IF (SQ.UNLOAD) THEN
	    WRITE (IUNIT, *) ' SQ.UNLOAD    = .TRUE.'
	  ELSE
	    WRITE (IUNIT, *) ' SQ.UNLOAD    = .FALSE.'
	  ENDIF

	  TMP = (SQ.HIGHWATER * W.NBUF)/ (W.KRATE / REAL(W.KSPB)) !convert to SEC
	  WRITE (IUNIT, *) '                ', TMP, ' SECONDS'

	  IF (SQ.NDEV .EQ. 0) THEN
	    WRITE (IUNIT, *) '** ERROR: no output device defined.'
	    IER = 70
	    GOTO 910
	  ELSE
	    WRITE (IUNIT, *) 
	1	' The following', SQ.NDEV, 
	1	' output device(s) have been defined:'
	    DO I = 1, SQ.NDEV
	      WRITE (IUNIT, *) I, '  ', SQ.CDEV_NAME(I)
	    END DO
	  END IF

	IRES = 1

	RETURN
	
C ... ERROR PATH

  910	CONTINUE

	IRES = - IER

	RETURN
	END

