	PROGRAM PACKRAT
	IMPLICIT NONE
	INCLUDE 'WEB$INCLUDE'		!WEB parameter structure
	INCLUDE 'LIB$RT:BUFFERS.INC'	!Data buffer structure
	INCLUDE 'PACKRAT.INC'		!PACKRAT structures
	INCLUDE '($SSDEF)'		!IOSB return parameter names

	INTEGER*4	LIB$SET_LOGICAL

	INTEGER*4 NULL_LUN/0/
	INTEGER*4 LIST_LUN/6/
	INTEGER*4 EVT_LUN /10/
	INTEGER*4 TYP_LUN /11/
	INTEGER*4 ALARM_LUN /13/
	INTEGER*4 SEQ_LUN /19/
C	INTEGER*4 TERM_LUN /23/
	INTEGER*4 IUNIT

        CHARACTER*(*)	CMAIL_COMMAND
	PARAMETER	(CMAIL_COMMAND = 'MAIL /SUB="PACKRAT TROUBLE"'//
	1		' SQRL$DIR:PACKRAT.ALARM "@SQRL$MAIL_DIS"')
	CHARACTER*(*)	MAIL_FILE
	PARAMETER	(MAIL_FILE = 'SQRL$DIR:PACKRAT.ALARM')

	INTEGER*4 TOTAL_WORDS
	INTEGER*4 IN_BLOCKS
	INTEGER*4 BLOCKS_ALLOCATED, EOF_BLOCK
	INTEGER*2 FFB
	COMMON/ RMS_DATA/ BLOCKS_ALLOCATED, EOF_BLOCK, FFB	! Lib$glue:Block_io 

	INTEGER*4	LENTRUE
	REAL*8		DT_OF_RTC
	REAL*4		T_START, T_ELAPSED, T_LAST_CHK

	CHARACTER*(*)	GO_FLG
	CHARACTER*(*)	STOP_FLG
	CHARACTER*(*)	SWITCH_FLG
	CHARACTER*(*)	INIT_FLG
	PARAMETER (GO_FLG   = 'GO')
	PARAMETER (STOP_FLG = 'STOP')
	PARAMETER (SWITCH_FLG = 'SWITCH')
	PARAMETER (INIT_FLG = 'INIT')
	CHARACTER*8 JOB_FLG

	LOGICAL TIME_TEAR_FLG /.FALSE./
	LOGICAL TYP_OPEN_FLG /.FALSE./
        LOGICAL REREAD_INIT_FLG /.FALSE./
	LOGICAL	ERR_FLG /.FALSE./
	LOGICAL	SUBTRACT_FILE_FLG /.FALSE./
	LOGICAL MOUNT_FLG
	LOGICAL OPEN_ERR_FLG
 
C	BYTE CSTR(40)
	CHARACTER*22 C22
        CHARACTER*20 CURRENT_DEV        !Current device name

	CHARACTER*80	FILENAME
	INTEGER*4 	NC_LOG, NC_DIR, NC_TYP, NC_FILE, NC_ID
	INTEGER*4	TAPE_ID
	CHARACTER*80	CMESS

	CHARACTER*80	FILE_STR

C	CHARACTER*32	DEV_STR
C	CHARACTER*12	TABLE /'LNM$FILE_DEV'/
C	CHARACTER*80	CVALUE

	CHARACTER*10	CTAPE
	CHARACTER*15	CNODE
	INTEGER*4	NNODE
	INTEGER*4	IEND

	INTEGER*4 IER, IRES, JRES, I
	INTEGER*4 LID
	INTEGER*4 LFLAG
	INTEGER*4 LBLOCKS
	INTEGER*4 LBASE_IN
	INTEGER*4 LDIFF
C*
	INTEGER*4 KTAPE
	INTEGER*4 KFILE
	INTEGER*4 KBUF
	INTEGER*4 KBAD
	INTEGER*4 KDEV
	INTEGER*4 LCDEV
	INTEGER*4 NWORDS_WEB
	INTEGER*4 NWORDS_DIO
	INTEGER*4 LBON
	INTEGER*4 LRTC_FIRST1
	INTEGER*4 LRTC_FIRST2
	INTEGER*4 LRTC_FIRST
	INTEGER*4 DATA_WORDS
	INTEGER*4 DATA_BUFFERS
	INTEGER*4 SAMPLES
	INTEGER*4 LRTC_END1
	INTEGER*4 LRTC_END2
	INTEGER*4 LBOFF
	INTEGER*4 LRTC_END
	INTEGER*4 LB
	INTEGER*4 LBUF
	INTEGER*4 LRTC_LAST
	INTEGER*4 LB_END
	REAL*4 FILE_BYTES_OUT
	REAL*4 TOTAL_GB_WRITTEN
	REAL*8 DT_FILE

C .. Check for existance of event scheduling file
	CALL FIND_FILE ('CUSP$IN:CUSP.KIN', CMESS, IRES)
	IF (IRES .LT. 1) THEN
	  STOP 'NO EVENT SCHEDULING FILE (CUSP.KIN) EXISTS IN CUSP$IN.'
	END IF 

C .. Set intitial count
	JOB_FLG = GO_FLG
	FILENAME= ' '
	KTAPE = 1			!tape counter
	IUNIT = LIST_LUN

c .. Assume words in WEB region 
	NWORDS_WEB = MAXREG	! ((W.NWPAR + 255) / 256) * 256

c .. write starting message
	CALL TIME_STAMP ('**PACKRAT starting (systime):', IUNIT)

c .. read the initiallizer file
10	CONTINUE
	KFILE = 0			!file counter
	KBUF  = 0			!buffer counter
	KBAD = 0			!bad devices
	MOUNT_FLG = .TRUE.

	CALL READ_INIT_PACKRAT (IUNIT, IRES)
	IER = 5
	IF (IRES .LT. 1) THEN
	  CMESS = 'UNABLE TO READ PACKRAT$DCK FILE??'
	  GOTO 910
	END IF
	NC_LOG = LENTRUE(PR.TYP_FILE)
	NC_DIR = LENTRUE(PR.DIRECT)
C	CALL TRANSLATE_STRING(PR.DIRECT(:NC_DIR), TABLE, CVALUE, IRES)
C	IER = 10
C	IF (IRES .GT. 0) THEN
C	  NC_DIR = IRES
C	ELSE IF (IRES .LT. 0) THEN
C	  CMESS = 'CANNOT TRANSLATE PR.DIRECT.'
C	  GOTO 910
C	END IF
C	IRES = LIB$SET_LOGICAL('CUSP$IN', CVALUE(:NC_DIR))	! PR.DIRECT(:NC_DIR))
	IER = 15
	IRES = LIB$SET_LOGICAL('CUSP$IN', PR.DIRECT(:NC_DIR))
	IF (.NOT. IRES) THEN
	  CALL GETMSG(IUNIT, IRES)
	  CMESS = 'UNABLE TO SET CUSP$IN TO PR.DIRECT?'
	  GOTO 910
	END IF

C ... see if device list has been changed during this run
c	If it has, resume on device following current device in new list
c	If last device isn't in new list start at 1st device in new list
	KDEV = 1
	IF (CURRENT_DEV(1:1) .NE. ' ') THEN
	  DO I = 1, DEV.KNT
	    IF (CURRENT_DEV .EQ. DEV.NAME(I)) THEN
	      KDEV = I + 1
	      IF (KDEV .GT. DEV.KNT) KDEV = 1
	    END IF
	  END DO
	END IF

c ......................................................................
c	Beginning of a tape
50	CONTINUE
	KFILE = 0				!reset file counter
	TOTAL_GB_WRITTEN = 0.
	FILE_BYTES_OUT = 0.

	NNODE = 0
	CALL GET_NODE_INFO(CNODE, NNODE, IRES)
	WRITE(UNIT=CNODE,FMT='(A6,I6)') 'NODE#:', NNODE

C .. Open new .typ file for all data written to current device
	FILENAME = PR.TYP_FILE(:NC_LOG) // '_' // CHAR(0)
	NC_TYP = NC_LOG + 1
	IF (MOUNT_FLG) THEN
	  CALL NXTSEQ('SQRLTAP', TAPE_ID, IRES)
	  IF (IRES .LT. 1) THEN
	    CMESS = 'UNABLE TO GET NEXT TAPE ID FROM SEQ FILE.'
	    GOTO 910
	  END IF
	END IF
	CALL CONINTC(FILENAME, TAPE_ID, IRES)
	FILENAME = FILENAME(:IRES) //  '.TYP'
	NC_TYP = LENTRUE(FILENAME)

	IER = 20
	IUNIT = TYP_LUN
	CLOSE(UNIT=IUNIT)
	CMESS = 'UNABLE TO OPEN .TYP LOG FILE.'
	TYP_OPEN_FLG  = .FALSE.
	OPEN(	UNIT=IUNIT,			!open status output file
	1	FILE=FILENAME,
	1	STATUS='UNKNOWN',
	1	ACCESS= 'APPEND',
	1	SHARED,
	1	BUFFERCOUNT=2,
	1	ERR=910)
	TYP_OPEN_FLG  = .TRUE.
	CMESS = ' '

55	CONTINUE
	JOB_FLG = GO_FLG
	CURRENT_DEV = DEV.NAME(KDEV)
	LCDEV = LENTRUE(CURRENT_DEV)
   
c   .. skip device if error count exceeds PR.MAXERR 
	IF (DEV.KERR(KDEV) .GE. PR.MAXERR) THEN		!notify and skip
	  CALL TIME_STAMP ('*PACKRAT MAXERR COUNT:', LIST_LUN)
	  WRITE (LIST_LUN, FMT='(3A, I2, A, I6, /)')
	1	 ' 	SKIPPING:', DEV.NAME(KDEV)(1:LCDEV),
	1	' ERROR COUNT=', DEV.KERR(KDEV),
	1	' TAPE_ID:', TAPE_ID
	  KDEV = KDEV + 1
	  IF (KDEV .GT. DEV.KNT) KDEV = 1
	  MOUNT_FLG = .FALSE.
	  GOTO 55		
	END IF

c .. mount tape foreign, assign channel (deassign old channel if there was one)
	IF (PR.STACKER_FLAG .AND. KFILE .NE. 0) CALL LIB$WAIT(PR.STACK_WAIT)
	CALL MTMNT (PR.KCHAN(KDEV), DEV.NAME(KDEV), NULL_LUN, IRES) 
	IF (IRES .LT. 1) THEN			!error on mount or assign
	  IER = 40
	  DEV.KERR(KDEV) = DEV.KERR(KDEV) + 1   !.inc device error counter
	  CALL TIME_STAMP ('*PACKRAT MTMNT ERROR', LIST_LUN)
	  WRITE (UNIT=CMESS, FMT='(3A,I)') 'FOR:', DEV.NAME(KDEV)(:LCDEV),
	1	' MTMNT ERROR COUNT=', DEV.KERR(KDEV)
	  CALL SEND_MAIL(LIST_LUN, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
	  JRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (JRES .NE. SS$_VOLINV .OR. JRES .NE. SS$_DEVMOUNT)
	1	CALL GETMSG(LIST_LUN, JRES)
	  WRITE (LIST_LUN, FMT='(3A, I2, A, I6, /)')
	1	 ' 	SKIPPING:', DEV.NAME(KDEV)(1:LCDEV),
	1	' ERROR COUNT=', DEV.KERR(KDEV),
	1	' TAPE_ID:', TAPE_ID
	  IF (DEV.KERR(KDEV) .GE. PR.MAXERR) THEN
	    KBAD = KBAD + 1
	    IF (KBAD .GE. DEV.KNT) THEN         !all devices bad, bail
	      CMESS = '  All specified devices are out-of-service.' 
	      GOTO 910                          ! error EXIT
	    END IF
	  END IF
	  KDEV = KDEV + 1			!inc. device and continue
	  IF (KDEV .GT. DEV.KNT) KDEV = 1	! wrapped, return to 1st device
	  MOUNT_FLG = .FALSE.
	  GOTO 55				! try mounting new device
	END IF

c ... good mount, 
	MOUNT_FLG = .TRUE.
	DEV.KERR(KDEV) = 0			!reset device error counter

	IF (DEV.NAME(KDEV)(LCDEV:LCDEV) .EQ. ':') THEN
	  IEND = LCDEV - 1
	ELSE
	  IEND = LCDEV
	END IF

	WRITE (IUNIT, *) 
	CALL TIME_STAMP ('**New tape at:', IUNIT)

	WRITE (IUNIT, 6000) DEV.NAME(KDEV)(:LCDEV), KTAPE, TAPE_ID
6000	FORMAT (' Device name is ',A<LCDEV>,'  Tape # ',I4, ' =>',I6/)

c......................................................................
c ..	TOP OF THE FILE LOOP

100	CONTINUE
	IF (TOTAL_GB_WRITTEN .GE. PR.MAXGB) GOTO 850	! end of tape
	LID = 0
	CALL TASKC('EVTTAP', LID, IRES)	! get next scheduled id
	IF (IRES .GT. 0) THEN		! got one
	  CONTINUE
	ELSE IF (IRES .EQ. 0) THEN	! no more ids scheduled
	  T_START = SECNDS(0.)
	  T_ELAPSED = 0.
	  T_LAST_CHK = 0.
	  DO WHILE (T_ELAPSED .LT. PR.WAIT)
	    CALL LIB$WAIT(60.)
	    T_ELAPSED = SECNDS(T_START)
	    IF (.NOT. PR.DELETE_FLAG) THEN
	      IF ((T_ELAPSED - T_LAST_CHK) .GT. PR.DELETE_CHKSEC) THEN
		T_LAST_CHK = T_ELAPSED
		CALL EVT_DELETE(LIST_LUN, EVT_LUN, PR.DELETE_DELAY, IRES)
		IF (IRES .LT. 0) THEN
		  WRITE(LIST_LUN, *) 'ERROR DELETING .EVT FILES. IRES:', IRES
		END IF
	      END IF
	    END IF
	    CALL TRANSLATE_STRING('PAR$PACKRAT', 'LNM$GROUP', JOB_FLG, IRES)
	    IF (JOB_FLG .EQ. GO_FLG) THEN			! process next id
	      CONTINUE
	    ELSE IF (JOB_FLG .EQ. STOP_FLG) THEN		! shutdown
	      IF (TOTAL_GB_WRITTEN .GT. 0.) THEN
		CALL MTEOF_1 (PR.KCHAN(KDEV), IUNIT, IRES)
	      END IF
	      CMESS = 'PAR$PACKRAT STOP ORDERED.'
	      GOTO 920
	    ELSE IF (JOB_FLG .EQ. INIT_FLG) THEN		!take no action now
	      CALL TIME_STAMP ('*PACKRAT_INIT ordered at:', LIST_LUN)
	      REREAD_INIT_FLG = .TRUE.
	      JOB_FLG = GO_FLG
	      IRES = LIB$SET_LOGICAL('PAR$PACKRAT', GO_FLG, 'LNM$GROUP')
	    ELSE IF (JOB_FLG .EQ. SWITCH_FLG) THEN	!switch tapes
	      CALL TIME_STAMP ('*PACKRAT_SWITCH ordered at:', LIST_LUN)
	      JOB_FLG = GO_FLG
	      REREAD_INIT_FLG = .TRUE.
	      IRES = LIB$SET_LOGICAL('PAR$PACKRAT', GO_FLG, 'LNM$GROUP')
	      GOTO 850				!close tape, start new one
	    ELSE
	      CALL TIME_STAMP ('*PACKRAT unknown JOB_FLG at:', LIST_LUN)
	      JOB_FLG = GO_FLG
	    END IF
	  ENDDO
	   WRITE(LIST_LUN,*) 'LOOK FOR MORE FILES TO WRITE; T_ELAPSED:', 
	1	 T_ELAPSED
	  GOTO 100
	ELSE IF (IRES .LT. 0) THEN
	  IER = 50
	  CMESS = 'TASK CANNOT GET NEXT ID FROM CUSP.KIN.'
	  GOTO 910
	END IF


	FILE_BYTES_OUT = 0.
	KBUF = 0			!reset 'buffers output' counter

C .. Construct input .EVT filename
	FILE_STR = 'CUSP$IN:T' // CHAR(0)
	CALL CONINTC(FILE_STR, LID, IRES)
	NC_ID = IRES - 9
	FILE_STR = FILE_STR(:IRES)  // '.EVT'
	NC_FILE = IRES+4

C .. Open .EVT input file
	LBLOCKS = 0
	LFLAG = 1
	OPEN_ERR_FLG = .FALSE.
110	CONTINUE
	CALL RMS_OPENC(LFLAG, EVT_LUN, FILE_STR, LBLOCKS, IRES)	! open input
	IER = 60
	IF(IRES .LT. 1) THEN
	  WRITE(UNIT= CMESS, FMT='(A,A)') 'CANNOT OPEN EVT FILE:',
	1	 FILE_STR(:NC_FILE)
	  CALL LIB$WAIT(180.)
	  IF (OPEN_ERR_FLG) THEN
	    GOTO 910
	  ELSE
	    OPEN_ERR_FLG = .TRUE.
	    GOTO 110	  
	  END IF
	END IF

	IF (LBLOCKS .EQ. 0) THEN
	   IER = 70
	   CMESS =  'ERROR .EVT INPUT FILE HAS NO DATA.'
	   WRITE(LIST_LUN, *) CMESS, LID
	   CLOSE(UNIT= EVT_LUN)
	   CALL RESULTC('EVTTAP', LID, -IER, IRES)
	   IF (IRES .LT. 1) THEN
	     WRITE(UNIT= CMESS, FMT='(A,I)') 'UNABLE TO RESULT ID:', LID
	     GOTO 910
	   END IF
	   GOTO 100	! done with current input file
	END IF

C .. Determine .evt file size in words
	IF (FFB .EQ. 0) THEN		! RMS common data, first free byte
	  IN_BLOCKS = EOF_BLOCK - 1	! Last block of data
	  TOTAL_WORDS = IN_BLOCKS * 256	! Words in grm file
	ELSE
	  IN_BLOCKS = EOF_BLOCK
	  TOTAL_WORDS = IN_BLOCKS * 256 + (FFB + 1)/256
	END IF

C .. read web
	LBASE_IN = 0			! base word of next block read
	CALL RMS_GET(EVT_LUN, NWORDS_WEB, W, LBASE_IN, IRES)	! get input data
	IER = 80
	IF (IRES .NE. NWORDS_WEB) THEN
	  CMESS = 'RMS_GET WRDS .NE. WORDS IN WEB.'
	  GOTO 910
	END IF	
	IF(W.WEB_ID .NE. VERSION) THEN	! check version number of web
	  WRITE(LIST_LUN, 6050) VERSION, W.WEB_ID
6050	  FORMAT(1X, '*ERROR: WEB VERSION MISMATCH.',/,
	1		 ' COMPILED VERSION= ', F7.2,
	1		 ', EVT W.WEB_ID= ', F7.2)
	  NWORDS_WEB =  ((W.NWPAR + 255) / 256) * 256
	  ERR_FLG = .TRUE.
	ENDIF

	LBASE_IN = LBASE_IN + NWORDS_WEB

	CALL SET_TIME (IRES)			!set/reset time base
	IER = 90
	IF (IRES .LT. 0) THEN
	  CMESS = 'UNABLE TO SET_TIME BASE.'
	  GOTO 910
	END IF

C .. read 1st data buffer
	NWORDS_DIO = ((W.NWDIO + 255) / 256) * 256
	CALL RMS_GET(EVT_LUN, NWORDS_DIO, IO.D, LBASE_IN, IRES)
	IF (IRES .NE. NWORDS_DIO) THEN
	  CMESS = 'RMS_GET WRDS .NE. WORDS/DIO FOR 1st DATA BUFFER.'
	  GOTO 910
	END IF	
	
	LBON = IO.D(1).H.LBUF
	LRTC_FIRST1 = ((LBON - 1) * W.KSPB)	! + 1
	LRTC_FIRST2 = IO.D(1).H.LRTC
	LRTC_FIRST = LRTC_FIRST2

	DATA_WORDS = (TOTAL_WORDS - NWORDS_WEB)
	DATA_BUFFERS = DATA_WORDS / NWORDS_DIO 
	LDIFF = MOD(DATA_WORDS, NWORDS_DIO)
	SAMPLES = DATA_BUFFERS * W.KSPB
	LRTC_END1 = SAMPLES + LRTC_FIRST - 1
	LRTC_END2 = W.LSLI_END
	LBOFF = LBON + DATA_BUFFERS - 1
	LRTC_END = LRTC_END1

	DT_FILE = DT_OF_RTC(LRTC_FIRST) 
	CALL DATE22 (DT_FILE, %REF(C22))
	KFILE = KFILE + 1		!increment file counter
	IF (KFILE .EQ. 1) THEN
	  WRITE (IUNIT, 6100) TAPE_ID, DEV.NAME(KDEV)(:LCDEV), C22,
	1	 TIME.CTYPE
6100	  FORMAT ('>>Begin Tape: ', I, ' on ', A<LCDEV>,
	1	 ' at ', A22, 1X, A6)
	END IF

	IF (TIME_TEAR_FLG) THEN
	  IF (LRTC_FIRST .NE. LRTC_LAST+1) THEN
	    WRITE(IUNIT, *) '*Error RTC mismatch between files;',
	1	' time tear.'
	    ERR_FLG = .TRUE.
	  END IF
	ENDIF

	WRITE (IUNIT, 6200) KFILE, LID, C22, TIME.CTYPE, LBON
6200	FORMAT (/'>File #', I4.4, ' (', I<NC_ID>, ') ', A22, 1X, A6, 
	1	 ' LBON =', I12)

	IF (LRTC_FIRST1 .NE. LRTC_FIRST2) THEN
	  WRITE(IUNIT, *) '*Error 1st RTC mismatch;',
	1	 ' CALC:', LRTC_FIRST1, ' FOUND:', LRTC_FIRST2
	  ERR_FLG = .TRUE.
	ENDIF
	IF (LDIFF .NE. 0) THEN
	  WRITE(IUNIT, *) '*Error words/DIO buffer mismatch.'
	  WRITE(IUNIT, *) ' BUFFERS:', DATA_BUFFERS,
	1	 ' RESID_WORDS:', LDIFF,
	1	'W.KSPB:', W.KSPB
	  ERR_FLG = .TRUE.
	END IF	
	IF (LRTC_END1 .NE. LRTC_END2) THEN
	  WRITE(IUNIT, *) '*Error end RTC mismatch;',
	1	 ' CALC:', LRTC_END1, ' EXPECT:', LRTC_END2
	  ERR_FLG = .TRUE.
	ENDIF

c ..  write the WEB region out to the tape
	W.LSLI_END = LRTC_END		! fix for idle condition in sqrl2disk

	CALL MVC(12, %REF(CNODE), W.C_T_DUB)				! PACKRAT CPU HOST
	CALL MVC(4, %REF(DEV.NAME(KDEV)(IEND-3:IEND)), W.C_T_DEV)	! DEVICE USED BY PACKRAT
	WRITE(UNIT=CTAPE, FMT='(I10.10)') TAPE_ID
	CALL MVC(10, %REF(CTAPE), W.C_T_TAPE)				! PACKRAT TAPE NUMBER
	CALL SYSTIME(W.D_T_T0, IRES)					! SYSTEM TIME AT FIRST TAPE WRITE

	CALL MTWR (PR.KCHAN(KDEV), NWORDS_WEB-1, W, IUNIT, IRES) ! have to subtract 1 to fit into block limit
	IER = 100
	IF (IRES .LT. 0) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFTAPE .OR.
	1	 IRES .EQ. SS$_CTRLERR) THEN
		CMESS = 'PHYSICAL ENDOFTAPE ... TERMINATING TAPE'
	  ELSE
		CMESS = 'TERMINATING TAPE ONE FILE BACK.'
	  END IF
	  GOTO 800
	END IF

c .. write 1st data buffer out to tape as one record
	CALL MTWR (PR.KCHAN(KDEV), NWORDS_DIO, IO.D, IUNIT, IRES)
	IER = 110
	IF (IRES .LT. 0) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFTAPE .OR.
	1   IRES .EQ. SS$_CTRLERR) THEN
	    CMESS = 'ENDOFTAPE OR CONTROLLER ERROR...TERMINATING TAPE.'
	  ELSE
	    CMESS = 'TERMINATING TAPE ONE FILE BACK.'
	  END IF
	  GOTO 800
	END IF

	KBUF = KBUF + 1			!count buffers output
	LB = LBON + 1			!set buffer index to 2nd buffer

c ...... Top of buffer write loop
	DO WHILE (LB .LE. LBOFF) 
	  LBASE_IN = LBASE_IN + NWORDS_DIO
	  CALL RMS_GET(EVT_LUN, NWORDS_DIO, IO.D, LBASE_IN, IRES)
	  IER = 115
	  IF (IRES .NE. NWORDS_DIO) THEN
	    WRITE(IUNIT, *) '*ERROR RMS_GET LB, LBOFF:', LB, LBOFF
	    WRITE(IUNIT, FMT='(A48, I6,1X, I6, A)')
	1	'RMS_GET WORDS IRES .NE. WORDS/DIO FOR DATA BUFFER:',
	1	 IRES, NWORDS_DIO, '; EOF .EVT ON DISK???'
	    GOTO 550
	  END IF	
	  LBUF = IO.D(1).H.LBUF
	  IF (LBUF .NE. LB) THEN
	    WRITE(IUNIT, *) '*ERROR RMS_GET LBUF .NE. LB:', LBUF, LB
	    ERR_FLG = .TRUE.
	  END IF

c .. write the buffer out as one record
	  CALL MTWR (PR.KCHAN(KDEV), NWORDS_DIO, IO.D(1), 
	1	IUNIT, IRES)
	  IER = 120
	  IF (IRES .LT. 0) THEN
	    IRES = PR.KCHAN(KDEV).IOSB(1)
	    IF (IRES .EQ. SS$_ENDOFTAPE .OR.
	1	 IRES .EQ. SS$_CTRLERR) THEN
		CMESS = 'ENDOFTAPE OR CONTROLLER ERROR...TERMINATING TAPE.'
	    ELSE
		CMESS = 'TERMINATING TAPE ONE FILE BACK.'
	    END IF
	    GOTO 800
	  END IF

	  KBUF = KBUF + 1			!count buffers output
	  LB = LB + 1				!increment long buffer

	END DO

c ...... Bottom of buffer loop

550	CONTINUE
	CALL MTEOF_1 (PR.KCHAN(KDEV), IUNIT, IRES)
	IER = 130
	IF (IRES .LT. 1) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFTAPE .OR.
	1	 IRES .EQ. SS$_CTRLERR) THEN
		CMESS = 'ENDOFTAPE OR CONTROLLER ERROR...TERMINATING TAPE.'
		GOTO 800
	  ELSE
		CMESS = 'TERMINATING TAPE ONE FILE BACK.'
		GOTO 800
	  END IF
	END IF

	FILE_BYTES_OUT = FLOAT(LBASE_IN + NWORDS_DIO) * 2.
	TOTAL_GB_WRITTEN = TOTAL_GB_WRITTEN + FILE_BYTES_OUT/ 1.E9

	LRTC_LAST = IO.D(1).H.LRTC + W.KSPB - 1
	IF (LRTC_LAST .NE. LRTC_END) THEN
	  WRITE(IUNIT, *) '*Error LBOFF RTC mismatch;',
	1	 ' FOUND:', LRTC_LAST, ' EXPECT:', LRTC_END
	  ERR_FLG = .TRUE.
	END IF

	LB_END = IO.D(1).H.LBUF
	IF (LB_END .NE. LBOFF) THEN
	  WRITE(IUNIT, *) '*Error LBOFF BUFFER mismatch;',
	1	 ' FOUND:', LB_END, ' EXPECT:', LBOFF
	  ERR_FLG = .TRUE.
	END IF

	DT_FILE = DT_OF_RTC(LRTC_LAST)			!stop sec of file
	CALL DATE22 (DT_FILE, %REF(C22))
	WRITE (IUNIT, 6300) KFILE, LID, C22, TIME.CTYPE, LB_END, KBUF
6300	FORMAT ('>File #', I4.4, ' (', I<NC_ID>, ') ', A22, 1X, A6,
	1	 ' LBEND=', I12, ' Buffers:', I5)

	CALL RESULTC('EVTTAP', LID, 1, IRES)
	IF (IRES .NE. 1) THEN
	  IER = 140
	  WRITE(UNIT=CMESS, FMT='(A,I)') 'UNABLE TO RESULT ID:',
	1	 LID
	  GOTO 910
	END IF

	IF (PR.DELETE_FLAG) THEN
	  CLOSE(UNIT=EVT_LUN, STATUS='DELETE', IOSTAT=IRES)
	ELSE
	  CLOSE(UNIT=EVT_LUN, STATUS='KEEP', IOSTAT=IRES)
	END IF

	IF (IRES .NE. 0) THEN
	  WRITE(UNIT=LIST_LUN, FMT='(A,I)')
	1	 '*Error CLOSING EVT; BAD IOSTAT:', IRES, ' LID:', LID
	  ERR_FLG = .TRUE.
	END  IF

C ... Check process control flags

	CALL TRANSLATE_STRING('PAR$PACKRAT', 'LNM$GROUP', JOB_FLG, IRES)
	IF (IRES .GT. 0) THEN
	  IF (JOB_FLG .EQ. GO_FLG) THEN			! process next id
	    CONTINUE
	  ELSE IF (JOB_FLG .EQ. STOP_FLG) THEN		! shutdown
	    CALL MTEOF_1 (PR.KCHAN(KDEV), IUNIT, IRES)
	    CMESS = 'PAR$PACKRAT STOP ORDERED.'
	    GOTO 920
	  ELSE IF (JOB_FLG .EQ. INIT_FLG) THEN		!take no action now
	    CALL TIME_STAMP ('*PACKRAT_INIT ordered at:', LIST_LUN)
	    REREAD_INIT_FLG = .TRUE.
	    JOB_FLG = GO_FLG
	    IRES = LIB$SET_LOGICAL('PAR$PACKRAT', GO_FLG, 'LNM$GROUP')
	  ELSE IF (JOB_FLG .EQ. SWITCH_FLG) THEN	!switch tapes
	    CALL TIME_STAMP ('*PACKRAT_SWITCH ordered at:', LIST_LUN)
	    JOB_FLG = GO_FLG
	    REREAD_INIT_FLG = .TRUE.
	    IRES = LIB$SET_LOGICAL('PAR$PACKRAT', GO_FLG, 'LNM$GROUP')
	    GOTO 850				!close tape, start new one
	  ELSE
	    CALL TIME_STAMP ('*PACKRAT unknown JOB_FLG at:', LIST_LUN)
	    JOB_FLG = GO_FLG
	  END IF
	END IF

	IF (ERR_FLG) THEN
	  ERR_FLG = .FALSE.
	  WRITE(UNIT=CMESS, FMT='(A, I, A, I)') 
	1	 'DATA ERRORS; SEE .TYP FILE; TAPE#:', TAPE_ID,
	1	 ' FILE#:', KFILE
	  CALL SEND_MAIL(LIST_LUN, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
	END IF

	TIME_TEAR_FLG = .TRUE.
	GOTO 100

c ------------------------------------------------------------------------
c ... Error, backup one file and end tape, switch to new device
800	CONTINUE

	CLOSE(UNIT=EVT_LUN, STATUS='KEEP', IOSTAT=IRES)
	IF (IRES .NE. 0) THEN
	  WRITE(LIST_LUN, *) '*Error on .EVT close; IOSTAT:', IRES, ' ID:', LID
	END  IF
	CALL WRITE_ERR(IUNIT, 'PACKRAT', CMESS, IER, IRES)
	WRITE (IUNIT, *) ' Data I/O error, EOT at end of previous file.'

	IF (KFILE .LE. 1) GOTO 850	! just write single EOF (diagnostic)

c ... Reverse skip leaves us positioned AT END of previous file
	CALL MTSPF (PR.KCHAN(KDEV), -1, IUNIT, IRES)	
	IER = 160			
	IF (IRES .NE. 1) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFFILE) THEN
	    CONTINUE
	  ELSE
	    CMESS = 'MTSPF BACKSPACE ERROR.'
	    CALL WRITE_ERR(IUNIT, 'PACKRAT', CMESS, IER, IRES)
	  END IF
	END IF

	CALL MTEOF_1 (PR.KCHAN(KDEV), IUNIT, IRES)
	IER = 170
	IF (IRES .LT. 0) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFTAPE) THEN
	    CMESS = 'ENDOFTAPE ERROR'
	  ELSE IF (IRES .EQ. SS$_ENDOFVOLUME) THEN
	    CMESS = 'ENDOFVOLUME ERROR'
	  ELSE
	    CMESS = 'MTEOF_1'
	  END IF
	  CALL WRITE_ERR(IUNIT, 'PACKRAT', CMESS, IER, IRES)
	END IF
	SUBTRACT_FILE_FLG = .TRUE.

C ... write EOT
 850	CONTINUE

	CALL MTEOF_1 (PR.KCHAN(KDEV), IUNIT, IRES)	!write 2nd EOF for EOV
	IER = 180
	IF (IRES .LT. 0) THEN
	  IRES = PR.KCHAN(KDEV).IOSB(1)
	  IF (IRES .EQ. SS$_ENDOFTAPE) THEN
	    CMESS = 'ENDOFTAPE ERROR'
	  ELSE IF (IRES .EQ. SS$_ENDOFVOLUME) THEN
	    CMESS = 'ENDOFVOLUME ERROR'
	  ELSE
	    CMESS = 'MTEOF_1'
	  END IF
	  CALL WRITE_ERR(IUNIT, 'PACKRAT', CMESS, IER, IRES)
	END IF

c ... rewind, tape without waiting, deassign channel, check unload flag
	CALL DISMOUNT (KDEV, IUNIT, IRES)
	IER = 190			
	IF (IRES .LT. 0) THEN
	  CMESS = 'DISMOUNT FAILURE.'
	  CALL WRITE_ERR(IUNIT, 'PACKRAT', CMESS, IER, IRES)
	END IF

	IF (ERR_FLG) THEN
	  ERR_FLG = .FALSE.
	  WRITE(UNIT=CMESS, FMT='(A, I, A, I)')
	1	 'DATA ERRORS; SEE .TYP FILE; TAPE#:', TAPE_ID,
	1	 ' FILE#:', KFILE
	  CALL SEND_MAIL(LIST_LUN, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
	END IF
	IF (SUBTRACT_FILE_FLG) THEN
	  SUBTRACT_FILE_FLG = .FALSE.
	  KFILE = KFILE - 1	! decrement file counter
	  WRITE(IUNIT, *)
	1	' Last file bad .. subtracting one from file count.'
	END IF

c .. figure stop time of tape
	WRITE (IUNIT, 6400) TAPE_ID, DEV.NAME(KDEV)(:LCDEV), C22,
	1	TIME.CTYPE, KFILE, TOTAL_GB_WRITTEN
6400	FORMAT (/,'>>End Tape  : ', I6, ' on ', A<LCDEV>, ' at ', A22,
	1	 1X, A6, ' with ', I5, ' files;', F5.2, ' Gigabytes.')

	CALL TIME_STAMP ('**Tape complete at:', IUNIT)

c .. increment device and continue
	KDEV = KDEV + 1			
	KTAPE = KTAPE + 1			!bump count of tapes 
	IF (KDEV .GT. DEV.KNT) KDEV = 1		!wrapped, return to 1st device
 
C	SUBTRACT_FILE_FLG = .FALSE.
	IF (REREAD_INIT_FLG) THEN
	  REREAD_INIT_FLG  = .FALSE.
	  GOTO 10
        ELSE
	  GOTO 50
        END IF
 
c ... ERROR path, notify and quit
910	CONTINUE

	CALL TIME_STAMP ('*PACKRAT FATAL ERROR', LIST_LUN)
	CALL WRITE_ERR(LIST_LUN, 'PACKRAT', CMESS, IER, IRES)

	IF (TOTAL_GB_WRITTEN .GT. 0.) THEN
	  CALL MTEOF_1 (PR.KCHAN(KDEV), LIST_LUN, JRES)
	END IF

	CLOSE(UNIT=EVT_LUN, STATUS='KEEP')

	IF (PR.KCHAN(KDEV).CHNL .GT. 0) THEN		!tape file open
	  WRITE (LIST_LUN, *) 
	1     'Tape file closed by error: device= ',dev.name(kdev)
	  WRITE (LIST_LUN, *) 
	1	'  PR.KCHAN(KDEV)=', PR.KCHAN(KDEV).CHNL, 
	1	' KFILE=', KFILE, ' KBUF=', KBUF
	  WRITE (LIST_LUN, *) 
	1	'  LBON=', LBON,' LBOFF=', LBOFF, ' W.LBUF=', W.LBUF,
	1	' LB=', LB
	END IF

c ... EXIT path
 920	CONTINUE

c ... rewind, tape without waiting, deassign channel, check unload flag 
	CALL DISMOUNT (KDEV, NULL_LUN, IRES)

c .. close .typ output; check .typ file for text
	IF (TYP_OPEN_FLG) THEN
	  REWIND(IUNIT, IOSTAT=IRES, ERR=930)
	  READ(IUNIT, END=930, ERR=930, FMT=*, IOSTAT= IRES) IER
930	  IF (IRES .LT. 0) THEN		! empty file
	    CLOSE(IUNIT, STATUS='DELETE')
	    OPEN(UNIT=SEQ_LUN, FILE='SEQ$SQRLTAP', STATUS='OLD',
	1	IOSTAT=IRES, ERR=935)	
935	    IF (IRES .EQ. 0) THEN 
		READ(SEQ_LUN, *) TAPE_ID
		TAPE_ID = TAPE_ID - 1
		REWIND(SEQ_LUN)
		WRITE(SEQ_LUN, *) TAPE_ID
		CLOSE(SEQ_LUN)
		WRITE(LIST_LUN, *) '	SEQ$SQRLTAP  reset to:', TAPE_ID
	    ELSE
		WRITE(LIST_LUN, *) 'SEQ$SQRLTAP open error; cannot reset id.'
	    END IF
	    OPEN(UNIT=SEQ_LUN, FILE='SEQ$SQRLTAP2', STATUS='OLD',
	1	IOSTAT=IRES, ERR=940)	
940	    IF (IRES .EQ. 0) THEN 
		READ(SEQ_LUN, *) TAPE_ID
		TAPE_ID = TAPE_ID - 1
		REWIND(SEQ_LUN)
		WRITE(SEQ_LUN, *) TAPE_ID
		CLOSE(SEQ_LUN)
		WRITE(LIST_LUN, *) '	SEQ$SQRLTAP2 reset to:', TAPE_ID
	    ELSE
		WRITE(LIST_LUN, *) 'SEQ$SQRLTAP2 open error; cannot reset id.'
	    END IF
	  ELSE
	    IF (IRES .GT. 0) WRITE(LIST_LUN, *)
	1	 'BAD IOSTAT FOR CHECK OF TAPE_*.TYP:', IRES
	    CLOSE(IUNIT, STATUS='KEEP')
	    OPEN(UNIT=IUNIT, FILE=FILENAME, STATUS='OLD',
	1	ACCESS= 'APPEND', ERR=950)
	    WRITE (IUNIT, 6400) TAPE_ID, DEV.NAME(KDEV)(:LCDEV), C22,
	1	TIME.CTYPE, KFILE, TOTAL_GB_WRITTEN
	    CALL TIME_STAMP ('**Tape complete at:', IUNIT)
	  END IF
	END IF

950	IF (ERR_FLG) THEN
	  WRITE(UNIT=LIST_LUN, FMT='(A, I, A, I)') 
	1	 ' DATA ERRORS; SEE .TYP FILE; TAPE#:', TAPE_ID,
	1	 ' FILE#:', KFILE
	END IF

	CALL SEND_MAIL(LIST_LUN, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
C	CALL SEND_PAGE(LIST_LUN, TERM_LUN, 'SQRL$PORT', 'RTEXAM',
C	1	CMESS, IRES)

c .. report stop time of tape to log file
C	DT_FILE = DT_OF_RTC(LBOFF * W.KSPB)
C	CALL DATE22 (DT_FILE, %REF(C22))

	WRITE (LIST_LUN, 6400) TAPE_ID, DEV.NAME(KDEV)(:LCDEV), C22,
	1	TIME.CTYPE, KFILE, TOTAL_GB_WRITTEN
	CALL TIME_STAMP ('**PACKRAT stopped at (systime):', LIST_LUN)

	CALL EXIT

	END

C ----------------------------------------------------------------------
	SUBROUTINE READ_INIT_PACKRAT (IUNIT, IRES)
c .... read the initalization file (logical PACKRAT$DCK or PACKRAT.DCK  if no 
c	logical is defined))
c	Call only AFTER LINKNLOCK, we need the WEB values here
c	The values are stored and passed in the 'PACKRAT.INC' common
	IMPLICIT NONE
	INCLUDE 'WEB$INCLUDE'
	INCLUDE 'PACKRAT.INC'
	CHARACTER*80 CSTR		!KOM subroutine work space
	CHARACTER*20 CTMP
	INTEGER*4 IRES, IER, I, L
	INTEGER*4 JUNIT, IUNIT
	LOGICAL	IT_IS
	INTEGER*4 NC_TYP, NC_DIR

c NOTE: the units used for some of these parameters internal to the program
c	may NOT be the same as those used to specify them in the .DCK
c	variable	default value	internal units		units
C			(inter/exter)
C	--------	-------------	--------------		----------
c .. define defaults
	DEV.NAME(1)	= ' '
	DEV.KNT		= 0		! total devices available
	PR.DIRECT	= ' '		! working directory
	PR.TYP_FILE	= ' '		! log file pathname prefix
	PR.MAXGB	= 1.		! maximum number of gigabytes on tape
	PR.MAXERR	= 1		! maxerr/device
	PR.WAIT		= 600.		! seconds to wait if no evt posted
	PR.UNLOAD_FLAG  = .FALSE.	! do not unload on dismount
	PR.STACKER_FLAG = .FALSE.	! not a stacker device
	PR.STACK_WAIT   = 120.		! wait this time before next tape mount
	PR.DELETE_FLAG  = .TRUE.
	PR.DELETE_DELAY = 3600.0
	PR.DELETE_CHKSEC= 600.0
	DEV.NAME(1)	= ' '		! none
	DEV.KNT		= 0		! total devices available

c .. open the file, try logical PACKRAT$DCK 1st then local file PACKRAT.DCK
	IER = 10
	JUNIT = 20
	OPEN(UNIT=JUNIT,
	1  FILE='PACKRAT$DCK',		!logical name of initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=40)			!no definition, try PACKRAT.DCK

	GOTO 50

  40	CONTINUE

	WRITE (IUNIT, *) 
	1	'PACKRAT$DCK not defined trying file []PACKRAT.DCK'

	IER = 20
	OPEN(UNIT=JUNIT,
	1  FILE='PACKRAT.DCK',	   !try literal name for local initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=910)

c .. read in the initializer file
   50	CONTINUE

	CALL KOMRDC(JUNIT, IRES)			!get a line
	IF(IRES .EQ. -10) GOTO 60		!end of file
	IF(IRES .EQ. 0) GOTO 50			!blank or comment line, skip it
	IER = 30
	IF(IRES .LT. 0) GOTO 910

	CALL KOMSTRC(20, CSTR, IRES)	!interpret 1st token
	IER = 40
	IF(IRES .LT. 1) GOTO 910

c .. command interpretation
c.. <DEVICES> - list of devices to write out to
C    Max allowable device name length is 20 characters, logical names are OK

	IF (IT_IS ('DEV!')) then		!Tape
	  DEV.KNT = 0
 610	  CALL KOMSTRC(20, CTMP, IRES)	!get device name(s)
	  IER = 50
	  IF (IRES .LT. 0) THEN
	    GOTO 910			!error
	  ELSE IF (IRES .GT. 0) THEN
	    IF (dev.knt .EQ. MAXDEV) THEN	!too many devices defined
	      WRITE (IUNIT, *) 
	1	'*Error maximum device count of ', MAXDEV, ' exceeded.'
	      WRITE (IUNIT, *) 
	1	' 	=> Subsequent device definitions ignored.'
	    ELSE
	      DEV.KNT = DEV.KNT + 1		!inc. device count 
	      L = IRES

c	... must have ":" at end for SYS$ASSIGN to work properly
	      IF (CTMP(L:L) .NE. ':') THEN
	        L = L + 1
	        CTMP(L:L) = ':' 		!append ":" if not present
	      END IF
	      DEV.NAME(DEV.KNT) = CTMP(:L)
	      DEV.KERR(DEV.KNT) = 0		! clear error counter ?
	      GOTO 610				!get another device?
	    END IF
	  END IF				!else, no more devices in list

	ELSE IF (IT_IS ('TYP!')) THEN
	  CALL KOMSTRC(80, PR.TYP_FILE, IRES)
	  IER = 60
	  IF (IRES .LE. 0) GOTO 910
	  NC_TYP = IRES
	ELSE IF (IT_IS ('DIRECT!')) THEN		! device:[direct]
	  CALL KOMSTRC(80, PR.DIRECT, IRES)
	  IER = 70
	  IF (IRES .LE. 0) GOTO 910
	  NC_DIR = IRES
	ELSE IF (IT_IS ('MAXG!')) THEN
	  CALL KOMVALC(PR.MAXGB, IRES)
	  IER = 80
	  IF (IRES .LT. 0) GOTO 910

	ELSE IF (IT_IS ('WAIT')) THEN
	  CALL KOMVALC(PR.WAIT, IRES)
	  IER = 90
	  IF (IRES .LT. 0) GOTO 910

	ELSE IF (IT_IS ('UNLOAD')) THEN
	  PR.UNLOAD_FLAG = .TRUE.

	ELSE IF (IT_IS ('NODEL')) THEN
	  PR.DELETE_FLAG = .FALSE.
	  CALL KOMVALC(PR.DELETE_DELAY, IRES)
	  IER = 100
	  IF (IRES .LT. 0) GOTO 910
	  CALL KOMVALC(PR.DELETE_CHKSEC, IRES)
	  IER = 110
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('STACKER')) THEN
	  PR.UNLOAD_FLAG = .TRUE.
	  PR.STACKER_FLAG = .TRUE.
	  CALL KOMVALC(PR.STACK_WAIT, IRES)
	  IER = 120
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('MAXE!')) THEN
	  CALL KOMINTC(PR.MAXERR, IRES)
	  IER = 160
	  IF (IRES .LT. 0) GOTO 910

c .. bad input
	ELSE
	  WRITE (IUNIT, *) '*Error READ_INIT input line /', CSTR(:IRES), '/'
	END IF

	GOTO 50			!MORE, MORE AND STILL NOT SATIFIED...

c .. end of the init file

60	CLOSE (JUNIT)

c .. regurg results
	  WRITE (IUNIT, *) ' PR.DIRECT       = ', PR.DIRECT(:NC_DIR),
	1	 ' (DEV:[DIR])' 
	  WRITE (IUNIT, *) ' PR.TYP_FILE     = ', PR.TYP_FILE(:NC_TYP),
	1 ' (PREFIX)' 
	  WRITE (IUNIT, *) ' PR.MAXGB        = ', PR.MAXGB, ' (GigaBytes)'
	  WRITE (IUNIT, *) ' PR.MAXERR       = ', PR.MAXERR
	  WRITE (IUNIT, *) ' PR.WAIT         = ', PR.WAIT
	  WRITE (IUNIT, *) ' PR.UNLOAD_FLAG  = ', PR.UNLOAD_FLAG
	  WRITE (IUNIT, *) ' PR.DELETE_FLAG  = ', PR.DELETE_FLAG
	  WRITE (IUNIT, *) ' PR.DELETE_DELAY = ', PR.DELETE_DELAY
	  WRITE (IUNIT, *) ' PR.DELETE_CHKSEC= ', PR.DELETE_CHKSEC
	  WRITE (IUNIT, *) ' PR.STACKER_FLAG = ', PR.STACKER_FLAG
	  WRITE (IUNIT, *) ' PR.STACK_WAIT   = ', PR.STACK_WAIT

	  IF (DEV.KNT .EQ. 0) THEN
	    WRITE (IUNIT, *) '*Error READ_INIT no output device defined.'
	    IER = 170
	    GOTO 910
	  ELSE
	    WRITE (IUNIT, *) 
	1	'The following', DEV.KNT, 
	1	' output device(s) have been defined:'
	    DO I = 1, DEV.KNT
	      WRITE (IUNIT, *) I, '  ', DEV.NAME(I)
	    END DO
	  END IF

	IRES = 1

	RETURN
	
C ... ERROR PATH

910	CONTINUE

	IRES = - IER

	RETURN
	END

C ----------------------------------------------------------------------
	SUBROUTINE DISMOUNT 
	1		(KDEV, 		!index of device in PACKRAT struct.
	1		 IUNIT, 	!unit # for error messages
	1		 IRES)		!status return

c	Rewind, dismount, check unload flag for tape defined by KDEV in the 
c	PACKRAT.INC structure. Don't want to wait for this to complete so issue
c	an AST to dismount and deassign channel after rewind is done. Main 
c	program can continue during rewind
	IMPLICIT NONE
	INCLUDE 'PACKRAT.INC'
	INCLUDE '($IODEF)'
	INCLUDE '($SSDEF)'
	EXTERNAL DISMOU_AST		!AST name
	INTEGER*4 SYS$QIO, SYS$QIOW
	INTEGER*4 IRES, IER, LRES
	INTEGER*4 IUNIT
	INTEGER*4 KDEV
	INTEGER*4 I
	INTEGER*4 IO_FUNC

c .. clear the IOSB
	DO I=1, 4
	  PR.KCHAN(KDEV).IOSB(I) = 0
	END DO

c .. define QIO function flag
C	IO_FUNC = io$_rewind .OR. io$m_nowait
	IO_FUNC = io$_rewind 		!cause QIO completion to wait for rewind

c .. set parameters for use in AST, passed in COMMON
	AST.CDEV  = DEV.NAME(KDEV)
	AST.KCHAN = PR.KCHAN(KDEV).CHNL
	AST.IRES  = 0
	AST.LRES  = 0
	AST.UNLOAD = PR.UNLOAD_FLAG

	IRES = 0

c .. issue the QIO , AST will be called at completion
	IF (PR.STACKER_FLAG) THEN

	  IER = 100
	  LRES = SYS$QIOW(
	1  %VAL(0)		,	!event flag
	1  %VAL(PR.KCHAN(KDEV).CHNL),	!channel number
	1  %VAL(IO_FUNC)	,	!function
	1  PR.KCHAN(KDEV).IOSB			,	
	1  			,	!AST address (name)
	1  			,	!AST parameter 
	1  ,,,,,)

	  IF (.NOT. LRES) GOTO 50
	  IRES = 1

	  CALL DISMOU_AST()
	  IER = 150
	  IF (AST.IRES .NE. 1) THEN
	    IF (IUNIT .GT. 0) THEN 
		WRITE(IUNIT, *) 'DISMOU_AST ERROR IRES:', AST.IRES
		CALL GETMSG(IUNIT, AST.LRES)
	    END IF
	    IRES = -IER
	  END IF

	ELSE
	  IER = 200
	  LRES = SYS$QIO(
	1  %VAL(0)		,	!event flag
	1  %VAL(PR.KCHAN(KDEV).CHNL),	!channel number
	1  %VAL(IO_FUNC)	,	!function
	1  PR.KCHAN(KDEV).IOSB			,	
	1  DISMOU_AST		,	!AST address (name)
	1  			,	!AST parameter 
	1  ,,,,,)

	  IF (.NOT. LRES) GOTO 50
	  IRES = 1

	END IF

	RETURN

50	CONTINUE

	IF (IUNIT .GT. 0) THEN
	  WRITE(IUNIT, *) '*DISMOUNT error on QIO submit!'
	  CALL GETMSG (IUNIT, LRES)
	ENDIF

	IRES = -IER

	END

	SUBROUTINE EVT_DELETE(LIST_LUN, EVT_LUN, DELAY, IRES)
	IMPLICIT NONE
	INTEGER*4 LIST_LUN
	INTEGER*4 EVT_LUN
	REAL*4 DELAY
	INTEGER*4 IRES, IER
	INTEGER*4 LID
	INTEGER*4 NC_FILE
	INTEGER*4 RMS_FLAG /1/	! must be 1
	INTEGER*4 LBLKS
	INTEGER*4 NDEL
	CHARACTER*32 CFILE
	CHARACTER*80 CMESS
	
	LID = 0
	NDEL = 0

10	CONTINUE
	CALL TASKC('EVTDEL', LID, IRES)	! get next scheduled id
	IF (IRES .GT. 0) THEN		! got one
	  CONTINUE
	ELSE IF (IRES .EQ. 0) THEN	! no more ids scheduled
	  IRES = NDEL
	  RETURN
	ELSE
	  IER = 5
	  CMESS = 'BAD TASK CALL FOR STATE EVTDEL'
	  GOTO 910
	END IF

c .. build  filename
	CFILE = 'CUSP$IN:T' // CHAR(0)
	CALL CONINTC(CFILE, LID, IRES)
	CFILE = CFILE(:IRES) // '.EVT' // CHAR(0) 
	NC_FILE = IRES + 4

C .. start processing
	CALL RMS_OPENC(RMS_FLAG, EVT_LUN, CFILE(:NC_FILE), LBLKS, IRES)
	IF (IRES .GT. 1) THEN
	  CALL FILE_DT_TIME(DELAY, LID, IRES)
	  CMESS = 'CLOSE ERROR FOR EVT FILE'
	  IF (IRES .GE. 1) THEN
	    IER = 10
	    CLOSE(EVT_LUN, STATUS='DELETE', ERR = 900)
	    NDEL = NDEL + 1
	    CALL RESULTC('EVTDEL', LID, 1, IRES)
	    IER = 40
	    IF (IRES .LT. 0) THEN
	      CMESS = 'ERROR RESULTING EVTDEL STATE'
	      GOTO 900
	    END IF
	  ELSE IF (IRES .EQ. 0) THEN
	    IER = 20
	    CLOSE(EVT_LUN, STATUS='KEEP', ERR = 900)
	  ELSE
	    CMESS = 'BAD FILE_DT_TIME'
	    IER = 30
	    CLOSE(EVT_LUN, STATUS='KEEP', ERR = 900)
	    GOTO 900
	  END IF
	ELSE IF ( IRES .LT. 1) THEN
	  WRITE(UNIT=CMESS,FMT='(2A)') 'BAD RMS_OPEN FOR FILE:',CFILE(:NC_FILE)
	  IER = 50
	  GOTO 900
	END IF

	GOTO 10

900	CONTINUE
	CALL WRITE_ERR(LIST_LUN, 'EVT_DELETE ERROR', CMESS, IER, IRES)
	CALL RESULTC('EVTDEL', LID, -IER, IRES)

	GOTO 10

910	CONTINUE
	CALL WRITE_ERR(LIST_LUN, 'EVT_DELETE ERROR', CMESS, IER, IRES)
	IRES = - IER
		
	END

	SUBROUTINE FILE_DT_TIME(DELAY, LID, IRES)
	IMPLICIT NONE

	REAL*4 DELAY
	INTEGER*4 IRES
	INTEGER*4 LID
	INTEGER*4 LRES
C	INTEGER*4 I
C	INTEGER*4 SYS$GETTIM
	INTEGER*4 SYS$NUMTIM
	INTEGER*4 LIST_LUN /6/
	INTEGER*2 I2TIME(7)
C	BYTE QUADWORDTIME(8)
	INTEGER*4 LMIN

	REAL*8 T0, T0_SYS, DT0

	INTEGER*4 IYR,IMO,IDY,IHR,IMN,ISC,IHUNS
	COMMON /TMPTIME/ IYR,IMO,IDY,IHR,IMN

	BYTE RMS_CDATETIME, RMS_RDATETIME
	COMMON /RMS_DATES/	RMS_CDATETIME(8),
	1			RMS_RDATETIME(8)

	CHARACTER*24 CSYS, CEVT

	IF (DELAY .LE. 0) THEN
	  IRES = 1
	  RETURN
	END IF

C	LRES = SYS$GETTIM(QUADWORDTIME)
C	LRES = SYS$NUMTIM(I2TIME, QUADWORDTIME)

	LRES = SYS$NUMTIM(I2TIME, RMS_CDATETIME)
	IF (.NOT. LRES) THEN
	  CALL GETMSG(LIST_LUN, LRES)
	  GOTO 900
	END IF

	IYR = I2TIME(1)
	IMO = I2TIME(2)
	IDY = I2TIME(3)
	IHR = I2TIME(4)
	IMN = I2TIME(5)

	ISC = I2TIME(6)
	IHUNS = I2TIME(7)
C	WRITE(LIST_LUN,*) (I2TIME(I), I=1,7)

	CALL GRGMIN(IYR, LMIN)
	T0 = LMIN * 60.d0 + DFLOAT(ISC) + DFLOAT(IHUNS) / DBLE(100.)

	CALL SYSTIME(T0_SYS,LRES)
	DT0 = T0_SYS - T0

	CALL VMSTIME(T0_SYS, CSYS)
	CALL VMSTIME(T0, CEVT)

	IF (DT0 .GE. DELAY) THEN
	  IRES = 1
	ELSE
	  IRES = 0
	END IF

	WRITE(LIST_LUN, 100) LID, DELAY, CSYS, CEVT, DT0, IRES
100	FORMAT(1X,'ID, DELAY, T_SYS, T_EVT, DT, IRES:',
	1	I12, 1X, F7.2, 1X, A24, 1X, A24, 1X, F16.2, 1X, I2)

	RETURN

900	CONTINUE
	WRITE(LIST_LUN, *) 'FILE_DT_TIME ERROR LRES:', LRES
	IRES = -1

	END
