#
#                    CONFIGURATION FILE FOR ADSENDXS
#                    -------------------------------
# Earthworm digitizer using National Instruments X-series DAQ modules
# and Trimble Thunderbolt GPS units.  A 1-PPS pulse from the GPS triggers
# the collection of N samples, using NI Retrigerable Analog Input mode.
# Data from adsendxs are scaled to match data from the older adsend program.
# An input range of +-2.5 V produces -2048 to 2047 digital counts.
#
ModuleId         MOD_ADSEND_WH  # Earthworm module id of this instance of adsendxs
OutRing          SCNL_RING      # Transport ring to write waveforms to
HeartbeatInt     15             # Seconds between heartbeat messages to statmgr
Debug            0              # If 0, no debug messages.
                                # If 1, log partial GPS status.
                                # If 2, log complete GPS status.
#
#
#                         TIMING INFORMATION
ComPort          2              # The PC com port where time is obtained from
                                #    the Trimble GPS.
BaudRate         38400          # Must be a standard baud rate supported by
                                #    the PC and the GPS, eg 19200, 38400, 57600, 115200
ReadFileTimeout  200            # ReadFile times out in this many milliseconds if no data
                                #    are available from the GPS via the com port.
                                #    Recommended value is 200.
TriggerChan      /Dev1/PFI1     # The NI physical channel where the external
                                #    1-PPS trigger is found.  Program tested and works
                                #    correctly with TriggerChan set to /Dev1/PFI1 and
                                #    pin PFI0 jumpered to pin PFI1.
GetGpsDelay      200            # Delay this many milliseconds before the callback
                                #    routine requests GPS time.  Recommended value is 200.
UpdatePcClock    1              # If 1, the PC clock is synched to GPS.
                                # If 0, the PC clock is not synched to GPS.
PcClockUpdInt    86400          # Seconds between PC clock updates from GPS.

# SampRate: For every 1-pps trigger pulse provided by the GPS, SampRate
# samples are collected and written to one tracebuf message.
SampRate         100
#
#
#                         SEISNET-WATCH OUTPUT
SnwReportInterval  3600        # In seconds
StaName            PWHRY       # Station name (5 chars max)
NetCode            NC          # Network code (2 chars max)
#
#
#                        CHANNEL CONFIGURATION
# Logical channels listed below are mapped to physical pins on
# an NI PCIe X-series DAQ module.  The "NI X-Series User Manual"
# contains channel mapping details for each X-Series module.
# We use NRSE analog input mode, with AISENSE jumpered to ADGND.
# For an NI PCIe-6343 module pin 29 = AIGND, pin 62 = AISENSE.
#
# Connector 0:
#       Pin    Sta/Comp/Net/Loc   DaqChan
#       ---    ----------------   -------
  Chan    0     BAP   EHZ NC --   Dev1/ai0
  Chan    1     BPO   EHZ NC --   Dev1/ai1
  Chan    2     PSA   EHZ NC --   Dev1/ai2
  Chan    3     PAN   EHZ NC --   Dev1/ai3
  Chan    4     PCC   EHZ NC --   Dev1/ai4
  Chan    5     PHR   EHZ NC --   Dev1/ai5
  Chan    6     PBW   EHZ NC --   Dev1/ai6
  Chan    7     PLO   EHZ NC --   Dev1/ai7
  Chan    8     PHP   EHZ NC --   Dev1/ai8
  Chan    9     PAP   EHZ NC 02   Dev1/ai9
  Chan   10     PPT   EHZ NC --   Dev1/ai10
  Chan   11     PPO   EHZ NC --   Dev1/ai11
  Chan   12     BPO   ELE NC --   Dev1/ai12   # will be converted to hi-gain EH* sometime
  Chan   13     BPO   ELN NC --   Dev1/ai13   # will be converted to hi-gain EH* sometime
  Chan   14     PCC   ELE NC --   Dev1/ai14   # will be converted to hi-gain EH* sometime
  Chan   15     PCC   ELN NC --   Dev1/ai15   # will be converted to hi-gain EH* sometime

# Connector 1:
#       Pin    Sta/Comp/Net/Loc   DaqChan
#       ---    ----------------   -------
# Chan   16     CH16  EHZ NC --   Dev1/ai16
# Chan   17     CH17  EHZ NC --   Dev1/ai17
# Chan   18     CH18  EHZ NC --   Dev1/ai18
# Chan   19     CH19  EHZ NC --   Dev1/ai19
# Chan   20     CH20  EHZ NC --   Dev1/ai20
# Chan   21     CH21  EHZ NC --   Dev1/ai21
# Chan   22     CH22  EHZ NC --   Dev1/ai22
# Chan   23     CH23  EHZ NC --   Dev1/ai23
# Chan   24     CH24  EHZ NC --   Dev1/ai24
# Chan   25     CH25  EHZ NC --   Dev1/ai25
# Chan   26     CH26  EHZ NC --   Dev1/ai26
# Chan   27     CH27  EHZ NC --   Dev1/ai27
# Chan   28     CH28  EHZ NC --   Dev1/ai28
# Chan   29     CH29  EHZ NC --   Dev1/ai29
# Chan   30     CH30  EHZ NC --   Dev1/ai30
# Chan   31     CH31  EHZ NC --   Dev1/ai31
