/***********************************************************************
Demo.Cpp - Code to demo tts.

Speaker.cpp (name at WC&ATWC)

This code was adapted by the WC&ATWC to provide text-to-speech 
capabilities for the seismic processing system.  This is a separate program
and object file from the rest of the software and must be linked with
any code which wants TTS. (PW - 10/97)


Copyright (c) 1995-1997 by Microsoft Corporation

THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
FOREGOING LIMITATION MAY NOT APPLY.

This Software may be copied and distributed royalty-free subject to
the following conditions:

1. You must copy all Software without modification and must include
   all pages, if the Software is distributed without inclusion in your
   software product. If you are incorporating the Software in
   conjunction with and as a part of your software product which adds
   substantial value, you may modify and include portions of the
   Software.

2. You must place all copyright notices and other protective
   disclaimers and notices contained on the Software on all copies of
   the Software and your software product.

3. Unless the Software is incorporated in your software product which
   adds substantial value, you may not distribute this Software for
   profit.

4. You may not use Microsoft's name, logo, or trademarks to market
   your software product.

5. You agree to indemnify, hold harmless, and defend Microsoft and its
   suppliers from and against any claims or lawsuits, including
   attorneys' fees, that arise or result from the use or distribution
   of your software product and any modifications to the Software.
*/


#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <mmsystem.h>
#include <initguid.h>
#include <objbase.h>
#include <objerror.h>
#include <ole2ver.h>
#include "myspeech.h"

/*************************************************************************
Globals */

HINSTANCE         ghInstance;                // instance handle
PITTSCENTRALW     gpITTSCentral = NULL;

/*************************************************************************
FindAndSelect - This finds and selects according to the specific TTSMODEINFOW.

inputs
   PTTSMODEINFOW     pTTSInfo - desired mode
returns
   PITTSCENTRAL - ISRCentral interface to TTS engine
sets:

*/

PITTSCENTRALW FindAndSelect (PTTSMODEINFOW pTTSInfo)
{
   HRESULT        hRes;
   TTSMODEINFOW        ttsResult;        // final result
   WCHAR          Zero = 0;
   PITTSFINDW      pITTSFind;             // find interface
   PIAUDIOMULTIMEDIADEVICE    pIAMM;      // multimedia device interface for audio-dest
   PITTSCENTRALW  pITTSCentral;           // central interface


   hRes = CoCreateInstance(CLSID_TTSEnumerator, NULL, CLSCTX_ALL, IID_ITTSFindW,
                                                   (void**)&pITTSFind);
   if (FAILED(hRes)) return NULL;

   hRes = pITTSFind->Find(pTTSInfo, NULL, &ttsResult);

   if (hRes)
      {
      pITTSFind->Release();
      return NULL;     // error
      }


// Get the audio dest
   hRes = CoCreateInstance(CLSID_MMAudioDest, NULL, CLSCTX_ALL, IID_IAudioMultiMediaDevice,
                                                   (void**)&pIAMM);
   if (hRes)
      {
      pITTSFind->Release();
      return NULL;     // error
      }
	pIAMM->DeviceNumSet (WAVE_MAPPER);

	// Pass off the multi-media-device interface as an IUnknown (since it is one)

// Should do select now

   hRes = pITTSFind->Select(ttsResult.gModeID, &pITTSCentral, (LPUNKNOWN) pIAMM);

   if (hRes) {
      pITTSFind->Release();
      return NULL;
      };

// free random stuff up

   pITTSFind->Release();

   return pITTSCentral;
}




/*************************************************************************
BeginOLE - This begins the OLE.

inputs
   none
returns
   BOOL - TRUE if is succedes
*/

BOOL BeginOLE (void)
{
   DWORD    dwVer;

// Initialize OLE

//   SetMessageQueue(96);
   dwVer = CoBuildVersion();

   if (rmm != HIWORD(dwVer)) return FALSE;         // error

   if (FAILED(CoInitialize(NULL))) return FALSE;

   return TRUE;
}


/*************************************************************************
EndOLE - This closes up the OLE.

inputs
   none
returns
   BOOL - TRUE if succede
*/

BOOL EndOLE (void)
{
// Free up all of OLE

   CoUninitialize ();

   return TRUE;
}

/*************************************************************************
Send text to TTS engine for an application. 
NOTE: iSpkBuffSz must be defined in calling program
*/

bool SendToTTS (PSZ pszSpeak)
{
WCHAR wszSpeak[MAX_TTS_BUFFER];
SDATA data;

               // Speak
data.dwSize = (DWORD) MultiByteToWideChar(CP_ACP, 0, pszSpeak, -1, wszSpeak,
              sizeof(wszSpeak) / sizeof(WCHAR)) * sizeof(WCHAR);
data.pData = wszSpeak;
gpITTSCentral->TextData (CHARSET_TEXT, 0, data, NULL,
               IID_ITTSBufNotifySinkW);
return TRUE;
}

/*************************************************************************
Initialize TTS engine for an application. 
NOTE: file logname2 must have been created in calling program.
*/

bool InitializeTTS ()
{
TTSMODEINFOW   ModeInfo;

// try to begin ole

if (!BeginOLE()) return FALSE;

// find the right object
memset (&ModeInfo, 0, sizeof(ModeInfo));
gpITTSCentral = FindAndSelect (&ModeInfo);
if (!gpITTSCentral) return FALSE;
return TRUE;
}

/*************************************************************************
Close up TTS engine for an application. 
NOTE: file logname2 must have been created in calling program.
*/

bool EndTTS ()
{
// try to close ole
gpITTSCentral->Release();

if (!EndOLE()) return FALSE;
return TRUE;
}
