/****************************************************************************
 IASPEI91.H

This is an include file which was created by the program ptable.c.  Ptable.c
utilizes the NEIC Tau/P software to create a P-wave travel time file.

This file fills a 1-d array with P-wave travel times in seconds similar
to qkldpees.h.  Qkldpees.h fills an array with the Jeffereys-
Bullen 1940 travel time table.  
  
Times listed for distances less than 115.1 degrees are for the first 
arriving P wave (usually P, could be Pn, Pg, Pb, Pdiff).  After 115.1, the
first branch of the PKP is taken.  This is usually the PKPdf (which is the
PKIKP through the inner core).

The file is organized by depth, then distance.  That is, the first value
is the P-time for 0km depth, 0 degrees.  Second is 0km depth, 0.5 degrees.
And so on until 0km, 180.0 degrees.  Then the next is for 25km, 0.0 degrees.
The distance increment is 0.5 degrees from 0 to 180 degree epicentral 
distance.  The depth increments are 0-750km in 25km increments throughout.
This gives 31 "rows" of P-time values.  This depth increment corresponds
to a value for DEPTH_LEVELS_IASP of 31 in utils.h.

        Function: 	    iaspei91.h	
        Author:             Whitmore
        Written:            April, 1999
        OS:                 Windows Nt v4.0
        Compiler:           Microsoft Visual C/C++ v6.0
---------------------------------------------------------------------------*/
#ifndef IASPEI91_H
#define IASPEI91_H

float fPP[11191] = {			// 0km
   0.00f,    9.59f,   19.17f,   28.15f,   35.03f,   41.90f,   48.78f,   55.65f, 
  62.53f,   69.40f,   76.27f,   83.14f,   90.01f,   96.88f,  103.75f,  110.61f, 
 117.47f,  124.33f,  131.19f,  138.04f,  144.90f,  151.74f,  158.59f,  165.43f, 
 172.27f,  179.11f,  185.94f,  192.77f,  199.59f,  206.41f,  213.23f,  219.88f, 
 226.38f,  232.80f,  239.13f,  245.38f,  251.58f,  257.66f,  263.16f,  268.64f, 
 274.10f,  279.54f,  284.95f,  290.34f,  295.71f,  301.04f,  306.34f,  311.61f, 
 316.31f,  320.87f,  325.43f,  329.97f,  334.51f,  339.03f,  343.54f,  348.03f, 
 352.50f,  356.96f,  361.41f,  365.85f,  370.27f,  374.69f,  379.10f,  383.50f, 
 387.89f,  392.27f,  396.64f,  400.99f,  405.34f,  409.66f,  413.98f,  418.28f, 
 422.57f,  426.84f,  431.09f,  435.34f,  439.56f,  443.77f,  447.96f,  452.14f, 
 456.30f,  460.45f,  464.57f,  468.68f,  472.78f,  476.85f,  480.91f,  484.95f, 
 488.98f,  492.98f,  496.97f,  500.95f,  504.90f,  508.84f,  512.75f,  516.65f, 
 520.54f,  524.40f,  528.25f,  532.08f,  535.89f,  539.68f,  543.45f,  547.21f, 
 550.95f,  554.67f,  558.37f,  562.05f,  565.72f,  569.37f,  572.99f,  576.61f, 
 580.20f,  583.77f,  587.33f,  590.87f,  594.39f,  597.89f,  601.38f,  604.84f, 
 608.29f,  611.72f,  615.13f,  618.53f,  621.90f,  625.26f,  628.60f,  631.92f, 
 635.22f,  638.51f,  641.77f,  645.02f,  648.25f,  651.46f,  654.66f,  657.83f, 
 660.99f,  664.13f,  667.25f,  670.35f,  673.43f,  676.50f,  679.55f,  682.58f, 
 685.59f,  688.58f,  691.55f,  694.51f,  697.45f,  700.36f,  703.26f,  706.14f, 
 709.01f,  711.85f,  714.68f,  717.48f,  720.27f,  723.04f,  725.79f,  728.52f, 
 731.23f,  733.92f,  736.60f,  739.25f,  741.88f,  744.50f,  747.10f,  749.67f, 
 752.23f,  754.77f,  757.28f,  759.78f,  762.26f,  764.72f,  767.16f,  769.58f, 
 771.96f,  774.32f,  776.67f,  779.01f,  781.35f,  783.68f,  786.00f,  788.31f, 
 790.62f,  792.93f,  795.23f,  797.52f,  799.81f,  802.10f,  804.38f,  806.65f, 
 808.91f,  811.17f,  813.41f,  815.65f,  817.89f,  820.11f,  822.33f,  824.55f, 
 826.77f,  828.99f,  831.20f,  833.42f,  835.64f,  837.86f,  840.08f,  842.30f, 
 844.52f,  846.74f,  848.96f,  851.18f,  853.40f,  855.62f,  857.84f,  860.06f, 
 862.28f,  864.50f,  866.72f,  868.94f,  871.16f,  873.37f,  875.59f,  877.81f, 
 880.03f,  882.25f,  884.47f,  886.69f,  888.91f,  891.13f,  893.35f, 1123.71f, 
1124.67f, 1125.63f, 1126.58f, 1127.54f, 1128.50f, 1129.45f, 1130.41f, 1131.37f, 
1132.32f, 1133.28f, 1134.23f, 1135.19f, 1136.14f, 1137.10f, 1138.05f, 1139.00f, 
1139.96f, 1140.91f, 1141.86f, 1142.81f, 1143.76f, 1144.71f, 1145.66f, 1146.61f, 
1147.55f, 1148.50f, 1149.44f, 1150.39f, 1151.33f, 1152.27f, 1153.21f, 1154.15f, 
1155.09f, 1156.02f, 1156.96f, 1157.89f, 1158.82f, 1159.75f, 1160.68f, 1161.60f, 
1162.52f, 1163.44f, 1164.36f, 1165.27f, 1166.19f, 1167.09f, 1168.00f, 1168.90f, 
1169.80f, 1170.70f, 1171.59f, 1172.48f, 1173.36f, 1174.24f, 1175.12f, 1175.99f, 
1176.85f, 1177.71f, 1177.62f, 1179.23f, 1180.26f, 1181.10f, 1181.93f, 1182.75f, 
1183.57f, 1184.38f, 1185.18f, 1185.98f, 1186.77f, 1187.54f, 1188.31f, 1189.07f, 
1189.83f, 1190.57f, 1191.30f, 1192.03f, 1192.74f, 1193.44f, 1194.13f, 1194.82f, 
1195.49f, 1196.15f, 1196.79f, 1197.43f, 1198.06f, 1198.67f, 1199.27f, 1199.86f, 
1200.43f, 1201.00f, 1201.55f, 1202.09f, 1202.61f, 1203.12f, 1203.62f, 1204.10f, 
1204.58f, 1205.03f, 1205.48f, 1205.91f, 1206.32f, 1206.73f, 1207.11f, 1207.49f, 
1207.85f, 1208.19f, 1208.53f, 1208.84f, 1209.15f, 1209.43f, 1209.71f, 1209.97f, 
1210.21f, 1210.44f, 1210.66f, 1210.86f, 1211.04f, 1211.21f, 1211.37f, 1211.51f, 
1211.64f, 1211.75f, 1211.85f, 1211.93f, 1212.00f, 1212.05f, 1212.09f, 1212.11f, 
1212.12f, 			// 25km
   4.22f,   10.20f,   18.42f,   25.30f,   32.17f,   39.05f,   45.93f,   52.80f, 
  59.67f,   66.55f,   73.42f,   80.29f,   87.16f,   94.02f,  100.89f,  107.75f, 
 114.61f,  121.47f,  128.33f,  135.18f,  142.03f,  148.88f,  155.72f,  162.56f, 
 169.40f,  176.23f,  183.06f,  189.89f,  196.71f,  203.53f,  210.32f,  216.86f, 
 223.33f,  229.71f,  236.00f,  242.23f,  248.40f,  254.25f,  259.74f,  265.22f, 
 270.67f,  276.10f,  281.51f,  286.89f,  292.25f,  297.57f,  302.86f,  308.06f, 
 312.63f,  317.19f,  321.74f,  326.29f,  330.82f,  335.34f,  339.84f,  344.33f, 
 348.80f,  353.25f,  357.70f,  362.13f,  366.56f,  370.97f,  375.38f,  379.78f, 
 384.17f,  388.54f,  392.91f,  397.26f,  401.60f,  405.92f,  410.24f,  414.53f, 
 418.82f,  423.08f,  427.34f,  431.57f,  435.80f,  440.00f,  444.19f,  448.37f, 
 452.52f,  456.66f,  460.79f,  464.89f,  468.98f,  473.06f,  477.11f,  481.15f, 
 485.17f,  489.17f,  493.16f,  497.13f,  501.08f,  505.01f,  508.92f,  512.82f, 
 516.70f,  520.56f,  524.40f,  528.23f,  532.03f,  535.82f,  539.59f,  543.34f, 
 547.08f,  550.79f,  554.49f,  558.17f,  561.84f,  565.48f,  569.11f,  572.71f, 
 576.30f,  579.88f,  583.43f,  586.96f,  590.48f,  593.98f,  597.46f,  600.92f, 
 604.37f,  607.80f,  611.20f,  614.59f,  617.97f,  621.32f,  624.66f,  627.97f, 
 631.27f,  634.56f,  637.82f,  641.06f,  644.29f,  647.50f,  650.69f,  653.86f, 
 657.02f,  660.15f,  663.27f,  666.37f,  669.45f,  672.51f,  675.56f,  678.58f, 
 681.59f,  684.58f,  687.55f,  690.51f,  693.44f,  696.36f,  699.25f,  702.13f, 
 704.99f,  707.83f,  710.65f,  713.46f,  716.24f,  719.01f,  721.75f,  724.48f, 
 727.19f,  729.88f,  732.55f,  735.20f,  737.84f,  740.45f,  743.04f,  745.62f, 
 748.17f,  750.70f,  753.22f,  755.71f,  758.19f,  760.65f,  763.09f,  765.50f, 
 767.88f,  770.24f,  772.59f,  774.93f,  777.26f,  779.59f,  781.91f,  784.23f, 
 786.54f,  788.84f,  791.14f,  793.43f,  795.72f,  798.01f,  800.29f,  802.56f, 
 804.82f,  807.07f,  809.32f,  811.56f,  813.79f,  816.01f,  818.23f,  820.45f, 
 822.67f,  824.89f,  827.11f,  829.33f,  831.55f,  833.77f,  835.99f,  838.21f, 
 840.42f,  842.64f,  844.86f,  847.08f,  849.30f,  851.52f,  853.74f,  855.96f, 
 858.18f,  860.40f,  862.62f,  864.84f,  867.06f,  869.28f,  871.50f,  873.72f, 
 875.94f,  878.16f,  880.37f,  882.59f,  884.81f,  887.03f,  889.25f, 1119.52f, 
1120.47f, 1121.43f, 1122.39f, 1123.34f, 1124.30f, 1125.26f, 1126.21f, 1127.17f, 
1128.13f, 1129.08f, 1130.04f, 1130.99f, 1131.95f, 1132.90f, 1133.86f, 1134.81f, 
1135.76f, 1136.71f, 1137.66f, 1138.62f, 1139.57f, 1140.51f, 1141.46f, 1142.41f, 
1143.36f, 1144.30f, 1145.25f, 1146.19f, 1147.13f, 1148.08f, 1149.02f, 1149.95f, 
1150.89f, 1151.83f, 1152.76f, 1153.69f, 1154.62f, 1155.55f, 1156.48f, 1157.40f, 
1158.32f, 1159.24f, 1160.16f, 1161.08f, 1161.99f, 1162.90f, 1163.80f, 1164.71f, 
1165.61f, 1166.50f, 1167.39f, 1168.28f, 1169.16f, 1170.04f, 1170.92f, 1171.79f, 
1172.65f, 1173.52f, 1173.47f, 1175.07f, 1176.06f, 1176.90f, 1177.73f, 1178.55f, 
1179.37f, 1180.18f, 1180.98f, 1181.78f, 1182.56f, 1183.34f, 1184.11f, 1184.87f, 
1185.62f, 1186.36f, 1187.10f, 1187.82f, 1188.53f, 1189.24f, 1189.93f, 1190.61f, 
1191.28f, 1191.94f, 1192.59f, 1193.22f, 1193.85f, 1194.46f, 1195.06f, 1195.65f, 
1196.22f, 1196.79f, 1197.34f, 1197.87f, 1198.40f, 1198.91f, 1199.41f, 1199.89f, 
1200.36f, 1200.82f, 1201.26f, 1201.69f, 1202.11f, 1202.51f, 1202.90f, 1203.27f, 
1203.63f, 1203.98f, 1204.31f, 1204.63f, 1204.93f, 1205.22f, 1205.49f, 1205.75f, 
1206.00f, 1206.23f, 1206.44f, 1206.64f, 1206.83f, 1207.00f, 1207.15f, 1207.29f, 
1207.42f, 1207.53f, 1207.63f, 1207.71f, 1207.78f, 1207.83f, 1207.87f, 1207.89f, 
1207.90f,  			// 50km
   7.62f,   11.24f,   17.70f,   24.48f,   31.32f,   38.16f,   45.02f,   51.88f, 
  58.74f,   65.60f,   72.45f,   79.31f,   86.17f,   93.03f,   99.88f,  106.73f, 
 113.58f,  120.43f,  127.27f,  134.12f,  140.96f,  147.79f,  154.63f,  161.46f, 
 168.29f,  175.11f,  181.93f,  188.75f,  195.56f,  202.23f,  208.77f,  215.23f, 
 221.62f,  227.93f,  234.18f,  240.36f,  246.46f,  251.96f,  257.44f,  262.91f, 
 268.35f,  273.77f,  279.16f,  284.53f,  289.87f,  295.18f,  300.46f,  305.37f, 
 309.94f,  314.50f,  319.04f,  323.58f,  328.11f,  332.62f,  337.12f,  341.60f, 
 346.07f,  350.52f,  354.96f,  359.39f,  363.82f,  368.23f,  372.63f,  377.03f, 
 381.41f,  385.78f,  390.15f,  394.49f,  398.83f,  403.15f,  407.45f,  411.75f, 
 416.03f,  420.29f,  424.54f,  428.77f,  432.99f,  437.19f,  441.37f,  445.54f, 
 449.69f,  453.83f,  457.95f,  462.05f,  466.13f,  470.20f,  474.25f,  478.28f, 
 482.30f,  486.30f,  490.28f,  494.24f,  498.18f,  502.11f,  506.02f,  509.91f, 
 513.79f,  517.64f,  521.48f,  525.30f,  529.10f,  532.88f,  536.65f,  540.40f, 
 544.13f,  547.84f,  551.53f,  555.21f,  558.87f,  562.51f,  566.13f,  569.73f, 
 573.32f,  576.88f,  580.43f,  583.96f,  587.48f,  590.97f,  594.45f,  597.91f, 
 601.35f,  604.77f,  608.17f,  611.56f,  614.93f,  618.28f,  621.61f,  624.92f, 
 628.22f,  631.50f,  634.75f,  638.00f,  641.22f,  644.42f,  647.61f,  650.78f, 
 653.93f,  657.06f,  660.17f,  663.27f,  666.35f,  669.41f,  672.45f,  675.47f, 
 678.47f,  681.46f,  684.43f,  687.38f,  690.31f,  693.22f,  696.11f,  698.99f, 
 701.84f,  704.68f,  707.50f,  710.30f,  713.08f,  715.84f,  718.59f,  721.31f, 
 724.02f,  726.70f,  729.37f,  732.02f,  734.65f,  737.26f,  739.85f,  742.42f, 
 744.97f,  747.50f,  750.01f,  752.50f,  754.98f,  757.43f,  759.87f,  762.27f, 
 764.65f,  767.01f,  769.36f,  771.70f,  774.03f,  776.35f,  778.67f,  780.99f, 
 783.30f,  785.60f,  787.90f,  790.19f,  792.48f,  794.77f,  797.04f,  799.31f, 
 801.57f,  803.83f,  806.07f,  808.31f,  810.54f,  812.76f,  814.98f,  817.20f, 
 819.42f,  821.64f,  823.86f,  826.08f,  828.30f,  830.52f,  832.74f,  834.95f, 
 837.17f,  839.39f,  841.61f,  843.83f,  846.05f,  848.27f,  850.49f,  852.71f, 
 854.93f,  857.15f,  859.37f,  861.59f,  863.81f,  866.03f,  868.25f,  870.47f, 
 872.69f,  874.90f,  877.12f,  879.34f,  881.56f,  883.78f,  886.00f, 1116.14f, 
1117.10f, 1118.05f, 1119.01f, 1119.97f, 1120.93f, 1121.88f, 1122.84f, 1123.80f, 
1124.75f, 1125.71f, 1126.66f, 1127.62f, 1128.57f, 1129.53f, 1130.48f, 1131.43f, 
1132.39f, 1133.34f, 1134.29f, 1135.24f, 1136.19f, 1137.14f, 1138.09f, 1139.03f, 
1139.98f, 1140.93f, 1141.87f, 1142.82f, 1143.76f, 1144.70f, 1145.64f, 1146.58f, 
1147.51f, 1148.45f, 1149.38f, 1150.32f, 1151.25f, 1152.17f, 1153.10f, 1154.02f, 
1154.95f, 1155.87f, 1156.78f, 1157.70f, 1158.61f, 1159.52f, 1160.42f, 1161.33f, 
1162.23f, 1163.12f, 1164.01f, 1164.90f, 1165.78f, 1166.66f, 1167.54f, 1168.41f, 
1169.27f, 1168.47f, 1170.15f, 1171.75f, 1172.68f, 1173.52f, 1174.35f, 1175.17f, 
1175.99f, 1176.80f, 1177.60f, 1178.39f, 1179.18f, 1179.95f, 1180.72f, 1181.48f, 
1182.24f, 1182.98f, 1183.71f, 1184.43f, 1185.14f, 1185.85f, 1186.54f, 1187.22f, 
1187.89f, 1188.55f, 1189.20f, 1189.83f, 1190.46f, 1191.07f, 1191.67f, 1192.25f, 
1192.83f, 1193.39f, 1193.94f, 1194.48f, 1195.00f, 1195.51f, 1196.01f, 1196.50f, 
1196.97f, 1197.42f, 1197.87f, 1198.30f, 1198.71f, 1199.11f, 1199.50f, 1199.88f, 
1200.23f, 1200.58f, 1200.91f, 1201.23f, 1201.53f, 1201.82f, 1202.09f, 1202.35f, 
1202.59f, 1202.82f, 1203.04f, 1203.24f, 1203.42f, 1203.59f, 1203.75f, 1203.89f, 
1204.02f, 1204.13f, 1204.23f, 1204.31f, 1204.37f, 1204.43f, 1204.46f, 1204.49f, 
1204.49f,  			// 75km
  10.73f,   13.25f,   18.73f,   25.10f,   31.73f,   38.46f,   45.23f,   52.03f, 
  58.84f,   65.66f,   72.48f,   79.31f,   86.14f,   92.97f,   99.80f,  106.63f, 
 113.46f,  120.28f,  127.11f,  133.93f,  140.75f,  147.57f,  154.39f,  161.20f, 
 168.01f,  174.81f,  181.59f,  188.21f,  194.78f,  201.29f,  207.74f,  214.11f, 
 220.42f,  226.66f,  232.84f,  238.98f,  244.61f,  250.10f,  255.57f,  261.02f, 
 266.45f,  271.86f,  277.24f,  282.59f,  287.91f,  293.21f,  298.46f,  303.06f, 
 307.62f,  312.17f,  316.72f,  321.25f,  325.77f,  330.28f,  334.78f,  339.25f, 
 343.71f,  348.16f,  352.59f,  357.02f,  361.44f,  365.85f,  370.25f,  374.64f, 
 379.02f,  383.39f,  387.75f,  392.09f,  396.42f,  400.73f,  405.04f,  409.32f, 
 413.60f,  417.85f,  422.10f,  426.32f,  430.53f,  434.73f,  438.91f,  443.07f, 
 447.22f,  451.35f,  455.46f,  459.55f,  463.63f,  467.70f,  471.74f,  475.77f, 
 479.78f,  483.77f,  487.74f,  491.70f,  495.64f,  499.56f,  503.47f,  507.35f, 
 511.22f,  515.07f,  518.90f,  522.72f,  526.51f,  530.29f,  534.05f,  537.79f, 
 541.52f,  545.22f,  548.91f,  552.58f,  556.24f,  559.87f,  563.49f,  567.08f, 
 570.66f,  574.23f,  577.77f,  581.30f,  584.80f,  588.29f,  591.77f,  595.22f, 
 598.66f,  602.07f,  605.47f,  608.85f,  612.22f,  615.56f,  618.89f,  622.20f, 
 625.49f,  628.76f,  632.02f,  635.26f,  638.47f,  641.67f,  644.86f,  648.02f, 
 651.17f,  654.29f,  657.40f,  660.50f,  663.57f,  666.62f,  669.66f,  672.68f, 
 675.68f,  678.66f,  681.62f,  684.57f,  687.50f,  690.40f,  693.29f,  696.16f, 
 699.02f,  701.85f,  704.66f,  707.46f,  710.24f,  713.00f,  715.74f,  718.46f, 
 721.16f,  723.84f,  726.51f,  729.15f,  731.78f,  734.38f,  736.97f,  739.54f, 
 742.08f,  744.61f,  747.12f,  749.61f,  752.08f,  754.53f,  756.96f,  759.36f, 
 761.73f,  764.09f,  766.44f,  768.77f,  771.11f,  773.43f,  775.75f,  778.06f, 
 780.37f,  782.67f,  784.97f,  787.27f,  789.55f,  791.84f,  794.11f,  796.38f, 
 798.64f,  800.89f,  803.14f,  805.37f,  807.60f,  809.82f,  812.04f,  814.26f, 
 816.48f,  818.70f,  820.92f,  823.14f,  825.36f,  827.58f,  829.79f,  832.01f, 
 834.23f,  836.45f,  838.67f,  840.89f,  843.11f,  845.33f,  847.55f,  849.77f, 
 851.99f,  854.21f,  856.43f,  858.65f,  860.87f,  863.09f,  865.31f,  867.53f, 
 869.75f,  871.96f,  874.18f,  876.40f,  878.62f,  880.84f,  883.06f, 1113.06f, 
1114.02f, 1114.98f, 1115.93f, 1116.89f, 1117.85f, 1118.80f, 1119.76f, 1120.72f, 
1121.67f, 1122.63f, 1123.58f, 1124.54f, 1125.49f, 1126.45f, 1127.40f, 1128.35f, 
1129.31f, 1130.26f, 1131.21f, 1132.16f, 1133.11f, 1134.06f, 1135.01f, 1135.96f, 
1136.90f, 1137.85f, 1138.79f, 1139.74f, 1140.68f, 1141.62f, 1142.56f, 1143.50f, 
1144.43f, 1145.37f, 1146.30f, 1147.24f, 1148.17f, 1149.09f, 1150.02f, 1150.94f, 
1151.87f, 1152.79f, 1153.70f, 1154.62f, 1155.53f, 1156.44f, 1157.34f, 1158.25f, 
1159.14f, 1160.04f, 1160.93f, 1161.82f, 1162.70f, 1163.58f, 1164.46f, 1165.33f, 
1166.19f, 1165.47f, 1167.13f, 1168.72f, 1169.59f, 1170.43f, 1171.26f, 1172.08f, 
1172.90f, 1173.71f, 1174.51f, 1175.30f, 1176.09f, 1176.87f, 1177.64f, 1178.39f, 
1179.15f, 1179.89f, 1180.62f, 1181.34f, 1182.05f, 1182.75f, 1183.45f, 1184.13f, 
1184.80f, 1185.45f, 1186.10f, 1186.74f, 1187.36f, 1187.97f, 1188.57f, 1189.16f, 
1189.73f, 1190.29f, 1190.84f, 1191.38f, 1191.90f, 1192.41f, 1192.91f, 1193.39f, 
1193.87f, 1194.32f, 1194.76f, 1195.19f, 1195.61f, 1196.01f, 1196.40f, 1196.77f, 
1197.13f, 1197.48f, 1197.81f, 1198.12f, 1198.42f, 1198.71f, 1198.98f, 1199.24f, 
1199.49f, 1199.72f, 1199.93f, 1200.13f, 1200.32f, 1200.49f, 1200.64f, 1200.78f, 
1200.91f, 1201.02f, 1201.12f, 1201.20f, 1201.27f, 1201.32f, 1201.36f, 1201.38f, 
1201.39f,  			// 100km
  13.84f,   15.76f,   20.39f,   26.22f,   32.54f,   39.07f,   45.71f,   52.40f, 
  59.14f,   65.89f,   72.67f,   79.45f,   86.24f,   93.03f,   99.83f,  106.62f, 
 113.42f,  120.22f,  127.02f,  133.82f,  140.62f,  147.42f,  154.21f,  160.95f, 
 167.61f,  174.23f,  180.82f,  187.36f,  193.84f,  200.27f,  206.63f,  212.93f, 
 219.17f,  225.36f,  231.49f,  237.28f,  242.77f,  248.25f,  253.71f,  259.15f, 
 264.56f,  269.96f,  275.32f,  280.66f,  285.96f,  291.23f,  296.18f,  300.75f, 
 305.31f,  309.86f,  314.40f,  318.93f,  323.45f,  327.95f,  332.43f,  336.90f, 
 341.36f,  345.80f,  350.23f,  354.66f,  359.07f,  363.48f,  367.88f,  372.26f, 
 376.64f,  381.00f,  385.35f,  389.69f,  394.01f,  398.33f,  402.62f,  406.90f, 
 411.17f,  415.42f,  419.66f,  423.88f,  428.09f,  432.28f,  436.45f,  440.61f, 
 444.75f,  448.87f,  452.98f,  457.07f,  461.14f,  465.20f,  469.23f,  473.26f, 
 477.26f,  481.25f,  485.22f,  489.17f,  493.10f,  497.02f,  500.91f,  504.80f, 
 508.66f,  512.50f,  516.33f,  520.14f,  523.93f,  527.70f,  531.46f,  535.19f, 
 538.91f,  542.61f,  546.30f,  549.96f,  553.61f,  557.24f,  560.85f,  564.44f, 
 568.02f,  571.57f,  575.11f,  578.63f,  582.14f,  585.62f,  589.09f,  592.54f, 
 595.97f,  599.38f,  602.78f,  606.15f,  609.51f,  612.85f,  616.18f,  619.48f, 
 622.77f,  626.04f,  629.29f,  632.52f,  635.73f,  638.93f,  642.11f,  645.27f, 
 648.41f,  651.53f,  654.64f,  657.72f,  660.79f,  663.84f,  666.88f,  669.89f, 
 672.89f,  675.86f,  678.82f,  681.76f,  684.69f,  687.59f,  690.48f,  693.34f, 
 696.19f,  699.02f,  701.83f,  704.63f,  707.40f,  710.15f,  712.89f,  715.61f, 
 718.31f,  720.98f,  723.64f,  726.29f,  728.91f,  731.51f,  734.09f,  736.66f, 
 739.20f,  741.72f,  744.23f,  746.71f,  749.18f,  751.63f,  754.06f,  756.45f, 
 758.82f,  761.17f,  763.52f,  765.86f,  768.19f,  770.51f,  772.83f,  775.14f, 
 777.45f,  779.75f,  782.05f,  784.34f,  786.63f,  788.91f,  791.18f,  793.45f, 
 795.71f,  797.96f,  800.20f,  802.44f,  804.66f,  806.88f,  809.10f,  811.32f, 
 813.54f,  815.76f,  817.98f,  820.20f,  822.42f,  824.64f,  826.86f,  829.08f, 
 831.30f,  833.52f,  835.73f,  837.95f,  840.17f,  842.39f,  844.61f,  846.83f, 
 849.05f,  851.27f,  853.49f,  855.71f,  857.93f,  860.15f,  862.37f,  864.59f, 
 866.81f,  869.03f,  871.25f,  873.47f,  875.69f,  877.90f,  880.12f, 1109.99f, 
1110.94f, 1111.90f, 1112.86f, 1113.81f, 1114.77f, 1115.73f, 1116.68f, 1117.64f, 
1118.60f, 1119.55f, 1120.51f, 1121.46f, 1122.42f, 1123.37f, 1124.32f, 1125.28f, 
1126.23f, 1127.18f, 1128.13f, 1129.08f, 1130.03f, 1130.98f, 1131.93f, 1132.88f, 
1133.83f, 1134.77f, 1135.72f, 1136.66f, 1137.60f, 1138.54f, 1139.48f, 1140.42f, 
1141.36f, 1142.29f, 1143.23f, 1144.16f, 1145.09f, 1146.02f, 1146.94f, 1147.87f, 
1148.79f, 1149.71f, 1150.62f, 1151.54f, 1152.45f, 1153.36f, 1154.26f, 1155.17f, 
1156.06f, 1156.96f, 1157.85f, 1158.74f, 1159.62f, 1160.50f, 1161.37f, 1162.24f, 
1163.11f, 1162.46f, 1164.11f, 1165.67f, 1166.51f, 1167.35f, 1168.18f, 1169.00f, 
1169.81f, 1170.62f, 1171.42f, 1172.22f, 1173.00f, 1173.78f, 1174.55f, 1175.31f, 
1176.06f, 1176.80f, 1177.53f, 1178.25f, 1178.96f, 1179.66f, 1180.35f, 1181.03f, 
1181.70f, 1182.36f, 1183.01f, 1183.64f, 1184.27f, 1184.88f, 1185.48f, 1186.06f, 
1186.64f, 1187.20f, 1187.75f, 1188.28f, 1188.81f, 1189.32f, 1189.81f, 1190.30f, 
1190.77f, 1191.22f, 1191.66f, 1192.09f, 1192.51f, 1192.91f, 1193.30f, 1193.67f, 
1194.03f, 1194.37f, 1194.70f, 1195.02f, 1195.32f, 1195.61f, 1195.88f, 1196.14f, 
1196.38f, 1196.61f, 1196.83f, 1197.03f, 1197.21f, 1197.38f, 1197.54f, 1197.68f, 
1197.80f, 1197.91f, 1198.01f, 1198.09f, 1198.16f, 1198.21f, 1198.25f, 1198.27f, 
1198.28f,  			// 125km
  16.94f,   18.48f,   22.44f,   27.73f,   33.68f,   39.96f,   46.42f,   52.99f, 
  59.62f,   66.29f,   72.99f,   79.71f,   86.45f,   93.19f,   99.95f,  106.71f, 
 113.46f,  120.21f,  126.95f,  133.67f,  140.37f,  147.05f,  153.70f,  160.32f, 
 166.91f,  173.46f,  179.97f,  186.43f,  192.83f,  199.18f,  205.47f,  211.71f, 
 217.89f,  224.03f,  229.96f,  235.46f,  240.94f,  246.41f,  251.86f,  257.28f, 
 262.68f,  268.06f,  273.41f,  278.72f,  284.01f,  289.26f,  293.89f,  298.45f, 
 303.01f,  307.55f,  312.09f,  316.61f,  321.13f,  325.62f,  330.10f,  334.56f, 
 339.01f,  343.45f,  347.88f,  352.30f,  356.71f,  361.12f,  365.51f,  369.89f, 
 374.26f,  378.62f,  382.97f,  387.30f,  391.62f,  395.92f,  400.21f,  404.49f, 
 408.75f,  413.00f,  417.23f,  421.45f,  425.65f,  429.83f,  434.00f,  438.15f, 
 442.28f,  446.40f,  450.50f,  454.59f,  458.65f,  462.70f,  466.74f,  470.75f, 
 474.75f,  478.73f,  482.69f,  486.64f,  490.57f,  494.48f,  498.37f,  502.24f, 
 506.10f,  509.94f,  513.76f,  517.56f,  521.35f,  525.12f,  528.87f,  532.60f, 
 536.31f,  540.01f,  543.69f,  547.34f,  550.99f,  554.61f,  558.22f,  561.80f, 
 565.37f,  568.93f,  572.46f,  575.98f,  579.47f,  582.95f,  586.42f,  589.86f, 
 593.29f,  596.70f,  600.09f,  603.46f,  606.81f,  610.15f,  613.47f,  616.77f, 
 620.05f,  623.31f,  626.56f,  629.78f,  632.99f,  636.19f,  639.36f,  642.52f, 
 645.65f,  648.77f,  651.87f,  654.96f,  658.02f,  661.07f,  664.10f,  667.11f, 
 670.10f,  673.07f,  676.03f,  678.96f,  681.88f,  684.78f,  687.66f,  690.53f, 
 693.37f,  696.20f,  699.00f,  701.79f,  704.56f,  707.31f,  710.05f,  712.76f, 
 715.45f,  718.13f,  720.79f,  723.42f,  726.04f,  728.64f,  731.22f,  733.78f, 
 736.32f,  738.84f,  741.34f,  743.82f,  746.29f,  748.73f,  751.15f,  753.54f, 
 755.90f,  758.26f,  760.60f,  762.94f,  765.27f,  767.59f,  769.91f,  772.22f, 
 774.53f,  776.83f,  779.12f,  781.42f,  783.70f,  785.98f,  788.26f,  790.52f, 
 792.78f,  795.03f,  797.27f,  799.50f,  801.73f,  803.95f,  806.17f,  808.39f, 
 810.61f,  812.83f,  815.04f,  817.26f,  819.48f,  821.70f,  823.92f,  826.14f, 
 828.36f,  830.58f,  832.80f,  835.02f,  837.24f,  839.46f,  841.68f,  843.90f, 
 846.12f,  848.34f,  850.56f,  852.78f,  855.00f,  857.21f,  859.43f,  861.65f, 
 863.87f,  866.09f,  868.31f,  870.53f,  872.75f,  874.97f,  877.19f, 1106.91f, 
1107.87f, 1108.83f, 1109.78f, 1110.74f, 1111.70f, 1112.65f, 1113.61f, 1114.57f, 
1115.52f, 1116.48f, 1117.43f, 1118.39f, 1119.34f, 1120.30f, 1121.25f, 1122.20f, 
1123.16f, 1124.11f, 1125.06f, 1126.01f, 1126.96f, 1127.91f, 1128.86f, 1129.80f, 
1130.75f, 1131.70f, 1132.64f, 1133.58f, 1134.53f, 1135.47f, 1136.41f, 1137.34f, 
1138.28f, 1139.22f, 1140.15f, 1141.08f, 1142.01f, 1142.94f, 1143.87f, 1144.79f, 
1145.71f, 1146.63f, 1147.55f, 1148.46f, 1149.37f, 1150.28f, 1151.19f, 1152.09f, 
1152.99f, 1153.88f, 1154.77f, 1155.66f, 1156.54f, 1157.42f, 1158.29f, 1159.16f, 
1160.03f, 1159.45f, 1161.09f, 1162.59f, 1163.43f, 1164.27f, 1165.09f, 1165.92f, 
1166.73f, 1167.54f, 1168.34f, 1169.13f, 1169.92f, 1170.69f, 1171.46f, 1172.22f, 
1172.97f, 1173.71f, 1174.44f, 1175.16f, 1175.87f, 1176.57f, 1177.27f, 1177.94f, 
1178.61f, 1179.27f, 1179.92f, 1180.55f, 1181.17f, 1181.78f, 1182.38f, 1182.97f, 
1183.54f, 1184.10f, 1184.65f, 1185.19f, 1185.71f, 1186.22f, 1186.71f, 1187.20f, 
1187.67f, 1188.12f, 1188.56f, 1188.99f, 1189.41f, 1189.81f, 1190.20f, 1190.57f, 
1190.93f, 1191.27f, 1191.60f, 1191.92f, 1192.22f, 1192.50f, 1192.78f, 1193.03f, 
1193.28f, 1193.51f, 1193.72f, 1193.92f, 1194.11f, 1194.28f, 1194.43f, 1194.57f, 
1194.70f, 1194.81f, 1194.91f, 1194.99f, 1195.05f, 1195.11f, 1195.14f, 1195.17f, 
1195.17f,  			// 150km
  20.03f,   21.31f,   24.73f,   29.52f,   35.08f,   41.07f,   47.32f,   53.71f, 
  60.20f,   66.76f,   73.36f,   79.99f,   86.65f,   93.31f,   99.99f,  106.66f, 
 113.33f,  120.00f,  126.66f,  133.30f,  139.93f,  146.54f,  153.12f,  159.67f, 
 166.19f,  172.67f,  179.10f,  185.48f,  191.81f,  198.09f,  204.32f,  210.50f, 
 216.64f,  222.68f,  228.19f,  233.68f,  239.15f,  244.61f,  250.04f,  255.45f, 
 260.83f,  266.19f,  271.52f,  276.82f,  282.09f,  287.05f,  291.62f,  296.19f, 
 300.74f,  305.28f,  309.81f,  314.33f,  318.83f,  323.32f,  327.79f,  332.25f, 
 336.70f,  341.13f,  345.56f,  349.97f,  354.38f,  358.78f,  363.17f,  367.55f, 
 371.92f,  376.27f,  380.61f,  384.94f,  389.25f,  393.55f,  397.84f,  402.11f, 
 406.36f,  410.60f,  414.83f,  419.04f,  423.23f,  427.41f,  431.57f,  435.72f, 
 439.85f,  443.96f,  448.05f,  452.13f,  456.19f,  460.24f,  464.26f,  468.27f, 
 472.26f,  476.24f,  480.20f,  484.14f,  488.06f,  491.96f,  495.85f,  499.72f, 
 503.57f,  507.40f,  511.22f,  515.02f,  518.80f,  522.56f,  526.30f,  530.03f, 
 533.74f,  537.43f,  541.10f,  544.75f,  548.39f,  552.01f,  555.61f,  559.19f, 
 562.76f,  566.30f,  569.83f,  573.34f,  576.84f,  580.31f,  583.77f,  587.21f, 
 590.63f,  594.03f,  597.42f,  600.78f,  604.13f,  607.47f,  610.78f,  614.07f, 
 617.35f,  620.61f,  623.85f,  627.07f,  630.28f,  633.47f,  636.64f,  639.79f, 
 642.92f,  646.04f,  649.13f,  652.21f,  655.27f,  658.31f,  661.34f,  664.34f, 
 667.33f,  670.30f,  673.25f,  676.18f,  679.10f,  682.00f,  684.87f,  687.73f, 
 690.57f,  693.39f,  696.20f,  698.98f,  701.75f,  704.50f,  707.22f,  709.93f, 
 712.62f,  715.29f,  717.95f,  720.58f,  723.20f,  725.79f,  728.37f,  730.92f, 
 733.46f,  735.97f,  738.47f,  740.95f,  743.41f,  745.85f,  748.27f,  750.65f, 
 753.01f,  755.37f,  757.71f,  760.04f,  762.37f,  764.69f,  767.01f,  769.32f, 
 771.63f,  773.93f,  776.22f,  778.51f,  780.80f,  783.08f,  785.35f,  787.61f, 
 789.87f,  792.12f,  794.36f,  796.59f,  798.81f,  801.03f,  803.25f,  805.47f, 
 807.69f,  809.91f,  812.13f,  814.35f,  816.57f,  818.79f,  821.01f,  823.23f, 
 825.45f,  827.67f,  829.89f,  832.11f,  834.33f,  836.55f,  838.76f,  840.98f, 
 843.20f,  845.42f,  847.64f,  849.86f,  852.08f,  854.30f,  856.52f,  858.74f, 
 860.96f,  863.18f,  865.40f,  867.62f,  869.84f,  872.06f,  874.28f, 1103.86f, 
1104.81f, 1105.77f, 1106.73f, 1107.69f, 1108.64f, 1109.60f, 1110.55f, 1111.51f, 
1112.47f, 1113.42f, 1114.38f, 1115.33f, 1116.29f, 1117.24f, 1118.19f, 1119.15f, 
1120.10f, 1121.05f, 1122.00f, 1122.95f, 1123.90f, 1124.85f, 1125.80f, 1126.75f, 
1127.69f, 1128.64f, 1129.58f, 1130.53f, 1131.47f, 1132.41f, 1133.35f, 1134.29f, 
1135.22f, 1136.16f, 1137.09f, 1138.02f, 1138.95f, 1139.88f, 1140.81f, 1141.73f, 
1142.65f, 1143.57f, 1144.49f, 1145.40f, 1146.31f, 1147.22f, 1148.13f, 1149.03f, 
1149.93f, 1150.82f, 1151.71f, 1152.60f, 1153.48f, 1154.36f, 1155.23f, 1156.10f, 
1156.97f, 1156.46f, 1158.10f, 1159.53f, 1160.37f, 1161.20f, 1162.03f, 1162.85f, 
1163.67f, 1164.48f, 1165.28f, 1166.07f, 1166.85f, 1167.63f, 1168.39f, 1169.15f, 
1169.90f, 1170.64f, 1171.37f, 1172.09f, 1172.80f, 1173.50f, 1174.19f, 1174.87f, 
1175.54f, 1176.20f, 1176.84f, 1177.48f, 1178.10f, 1178.71f, 1179.31f, 1179.89f, 
1180.47f, 1181.03f, 1181.57f, 1182.11f, 1182.63f, 1183.14f, 1183.64f, 1184.12f, 
1184.59f, 1185.04f, 1185.48f, 1185.91f, 1186.33f, 1186.73f, 1187.11f, 1187.49f, 
1187.84f, 1188.19f, 1188.52f, 1188.83f, 1189.13f, 1189.42f, 1189.69f, 1189.95f, 
1190.19f, 1190.42f, 1190.64f, 1190.84f, 1191.02f, 1191.19f, 1191.35f, 1191.49f, 
1191.61f, 1191.72f, 1191.82f, 1191.90f, 1191.97f, 1192.02f, 1192.06f, 1192.08f, 
1192.09f,  			// 175km
  23.09f,   24.18f,   27.18f,   31.51f,   36.69f,   42.37f,   48.37f,   54.57f, 
  60.91f,   67.33f,   73.81f,   80.33f,   86.88f,   93.46f,  100.04f,  106.63f, 
 113.23f,  119.81f,  126.39f,  132.96f,  139.52f,  146.05f,  152.56f,  159.05f, 
 165.49f,  171.89f,  178.25f,  184.56f,  190.82f,  197.03f,  203.21f,  209.34f, 
 215.42f,  220.98f,  226.47f,  231.95f,  237.41f,  242.85f,  248.27f,  253.67f, 
 259.03f,  264.37f,  269.69f,  274.97f,  280.22f,  284.84f,  289.40f,  293.96f, 
 298.51f,  303.04f,  307.57f,  312.08f,  316.58f,  321.06f,  325.53f,  329.98f, 
 334.42f,  338.85f,  343.27f,  347.69f,  352.09f,  356.49f,  360.87f,  365.25f, 
 369.61f,  373.96f,  378.29f,  382.61f,  386.92f,  391.22f,  395.50f,  399.76f, 
 404.01f,  408.25f,  412.47f,  416.67f,  420.86f,  425.03f,  429.19f,  433.32f, 
 437.45f,  441.55f,  445.64f,  449.71f,  453.77f,  457.81f,  461.83f,  465.83f, 
 469.82f,  473.79f,  477.74f,  481.67f,  485.59f,  489.48f,  493.37f,  497.23f, 
 501.07f,  504.90f,  508.71f,  512.50f,  516.28f,  520.03f,  523.77f,  527.49f, 
 531.19f,  534.88f,  538.55f,  542.20f,  545.83f,  549.44f,  553.03f,  556.61f, 
 560.17f,  563.71f,  567.24f,  570.74f,  574.23f,  577.70f,  581.15f,  584.59f, 
 588.00f,  591.40f,  594.78f,  598.14f,  601.49f,  604.82f,  608.12f,  611.41f, 
 614.69f,  617.94f,  621.18f,  624.40f,  627.60f,  630.78f,  633.94f,  637.09f, 
 640.22f,  643.33f,  646.42f,  649.50f,  652.55f,  655.59f,  658.61f,  661.61f, 
 664.60f,  667.56f,  670.51f,  673.44f,  676.35f,  679.24f,  682.11f,  684.97f, 
 687.80f,  690.62f,  693.42f,  696.20f,  698.96f,  701.71f,  704.43f,  707.14f, 
 709.82f,  712.49f,  715.14f,  717.77f,  720.38f,  722.97f,  725.54f,  728.10f, 
 730.63f,  733.14f,  735.63f,  738.11f,  740.57f,  743.01f,  745.41f,  747.79f, 
 750.15f,  752.50f,  754.84f,  757.18f,  759.51f,  761.83f,  764.14f,  766.45f, 
 768.76f,  771.06f,  773.35f,  775.64f,  777.93f,  780.20f,  782.47f,  784.74f, 
 786.99f,  789.24f,  791.48f,  793.71f,  795.93f,  798.15f,  800.37f,  802.59f, 
 804.81f,  807.03f,  809.25f,  811.47f,  813.69f,  815.91f,  818.12f,  820.34f, 
 822.56f,  824.78f,  827.00f,  829.22f,  831.44f,  833.66f,  835.88f,  838.10f, 
 840.32f,  842.54f,  844.76f,  846.98f,  849.20f,  851.42f,  853.64f,  855.86f, 
 858.07f,  860.29f,  862.51f,  864.73f,  866.95f,  869.17f,  871.39f, 1100.83f, 
1101.78f, 1102.74f, 1103.70f, 1104.66f, 1105.61f, 1106.57f, 1107.53f, 1108.48f, 
1109.44f, 1110.39f, 1111.35f, 1112.30f, 1113.26f, 1114.21f, 1115.17f, 1116.12f, 
1117.07f, 1118.02f, 1118.97f, 1119.92f, 1120.87f, 1121.82f, 1122.77f, 1123.72f, 
1124.66f, 1125.61f, 1126.55f, 1127.50f, 1128.44f, 1129.38f, 1130.32f, 1131.26f, 
1132.19f, 1133.13f, 1134.06f, 1134.99f, 1135.92f, 1136.85f, 1137.78f, 1138.70f, 
1139.62f, 1140.54f, 1141.46f, 1142.37f, 1143.28f, 1144.19f, 1145.09f, 1146.00f, 
1146.89f, 1147.79f, 1148.68f, 1149.57f, 1150.45f, 1151.33f, 1152.20f, 1153.07f, 
1153.93f, 1153.50f, 1155.12f, 1156.49f, 1157.33f, 1158.17f, 1158.99f, 1159.82f, 
1160.63f, 1161.44f, 1162.24f, 1163.03f, 1163.81f, 1164.59f, 1165.35f, 1166.11f, 
1166.86f, 1167.60f, 1168.33f, 1169.05f, 1169.76f, 1170.46f, 1171.15f, 1171.83f, 
1172.50f, 1173.15f, 1173.80f, 1174.43f, 1175.05f, 1175.66f, 1176.26f, 1176.84f, 
1177.42f, 1177.98f, 1178.52f, 1179.06f, 1179.58f, 1180.09f, 1180.58f, 1181.07f, 
1181.53f, 1181.99f, 1182.43f, 1182.86f, 1183.27f, 1183.67f, 1184.06f, 1184.43f, 
1184.79f, 1185.13f, 1185.46f, 1185.77f, 1186.08f, 1186.36f, 1186.63f, 1186.89f, 
1187.13f, 1187.36f, 1187.58f, 1187.78f, 1187.96f, 1188.13f, 1188.29f, 1188.43f, 
1188.55f, 1188.66f, 1188.76f, 1188.84f, 1188.91f, 1188.96f, 1189.00f, 1189.02f, 
1189.03f,  			// 200km
  26.12f,   27.07f,   29.72f,   33.66f,   38.47f,   43.85f,   49.59f,   55.58f, 
  61.73f,   68.00f,   74.35f,   80.76f,   87.20f,   93.68f,  100.17f,  106.68f, 
 113.19f,  119.70f,  126.20f,  132.69f,  139.17f,  145.62f,  152.05f,  158.45f, 
 164.80f,  171.13f,  177.41f,  183.65f,  189.85f,  196.01f,  202.13f,  208.21f, 
 213.83f,  219.33f,  224.81f,  230.28f,  235.72f,  241.15f,  246.55f,  251.93f, 
 257.28f,  262.60f,  267.89f,  273.15f,  278.09f,  282.66f,  287.22f,  291.78f, 
 296.32f,  300.85f,  305.37f,  309.88f,  314.37f,  318.84f,  323.30f,  327.75f, 
 332.19f,  336.61f,  341.03f,  345.44f,  349.84f,  354.23f,  358.61f,  362.98f, 
 367.34f,  371.68f,  376.01f,  380.33f,  384.63f,  388.92f,  393.19f,  397.45f, 
 401.70f,  405.93f,  410.14f,  414.34f,  418.52f,  422.69f,  426.83f,  430.97f, 
 435.08f,  439.18f,  443.27f,  447.33f,  451.38f,  455.41f,  459.43f,  463.42f, 
 467.40f,  471.37f,  475.31f,  479.24f,  483.15f,  487.04f,  490.92f,  494.77f, 
 498.61f,  502.43f,  506.24f,  510.02f,  513.79f,  517.54f,  521.28f,  524.99f, 
 528.69f,  532.37f,  536.03f,  539.67f,  543.30f,  546.90f,  550.49f,  554.07f, 
 557.62f,  561.16f,  564.68f,  568.18f,  571.66f,  575.12f,  578.57f,  582.00f, 
 585.41f,  588.80f,  592.18f,  595.54f,  598.88f,  602.20f,  605.50f,  608.79f, 
 612.05f,  615.30f,  618.54f,  621.75f,  624.95f,  628.12f,  631.28f,  634.43f, 
 637.55f,  640.66f,  643.74f,  646.81f,  649.87f,  652.90f,  655.91f,  658.91f, 
 661.89f,  664.85f,  667.80f,  670.72f,  673.63f,  676.51f,  679.38f,  682.23f, 
 685.07f,  687.88f,  690.67f,  693.45f,  696.21f,  698.95f,  701.67f,  704.37f, 
 707.05f,  709.72f,  712.36f,  714.99f,  717.59f,  720.18f,  722.75f,  725.30f, 
 727.83f,  730.33f,  732.82f,  735.30f,  737.75f,  740.19f,  742.59f,  744.96f, 
 747.32f,  749.67f,  752.01f,  754.34f,  756.67f,  758.99f,  761.30f,  763.61f, 
 765.91f,  768.21f,  770.51f,  772.80f,  775.08f,  777.36f,  779.63f,  781.89f, 
 784.14f,  786.39f,  788.62f,  790.85f,  793.07f,  795.29f,  797.51f,  799.73f, 
 801.95f,  804.17f,  806.39f,  808.61f,  810.83f,  813.05f,  815.27f,  817.49f, 
 819.71f,  821.93f,  824.15f,  826.37f,  828.59f,  830.81f,  833.02f,  835.24f, 
 837.46f,  839.68f,  841.90f,  844.12f,  846.34f,  848.56f,  850.78f,  853.00f, 
 855.22f,  857.44f,  859.66f,  861.88f,  864.10f,  866.32f,  868.54f, 1097.82f, 
1098.78f, 1099.74f, 1100.70f, 1101.65f, 1102.61f, 1103.57f, 1104.52f, 1105.48f, 
1106.44f, 1107.39f, 1108.35f, 1109.30f, 1110.26f, 1111.21f, 1112.16f, 1113.12f, 
1114.07f, 1115.02f, 1115.97f, 1116.92f, 1117.87f, 1118.82f, 1119.77f, 1120.72f, 
1121.66f, 1122.61f, 1123.55f, 1124.49f, 1125.44f, 1126.38f, 1127.32f, 1128.25f, 
1129.19f, 1130.13f, 1131.06f, 1131.99f, 1132.92f, 1133.85f, 1134.77f, 1135.70f, 
1136.62f, 1137.54f, 1138.45f, 1139.37f, 1140.28f, 1141.18f, 1142.09f, 1142.99f, 
1143.89f, 1144.78f, 1145.67f, 1146.56f, 1147.44f, 1148.32f, 1149.19f, 1150.06f, 
1150.92f, 1150.56f, 1152.18f, 1153.48f, 1154.32f, 1155.15f, 1155.98f, 1156.80f, 
1157.62f, 1158.42f, 1159.22f, 1160.02f, 1160.80f, 1161.57f, 1162.34f, 1163.10f, 
1163.85f, 1164.58f, 1165.31f, 1166.03f, 1166.74f, 1167.44f, 1168.13f, 1168.81f, 
1169.48f, 1170.13f, 1170.78f, 1171.41f, 1172.03f, 1172.64f, 1173.24f, 1173.82f, 
1174.39f, 1174.95f, 1175.50f, 1176.03f, 1176.55f, 1177.06f, 1177.56f, 1178.04f, 
1178.51f, 1178.96f, 1179.40f, 1179.83f, 1180.24f, 1180.64f, 1181.03f, 1181.40f, 
1181.76f, 1182.10f, 1182.43f, 1182.74f, 1183.04f, 1183.33f, 1183.60f, 1183.86f, 
1184.10f, 1184.33f, 1184.54f, 1184.74f, 1184.93f, 1185.10f, 1185.25f, 1185.39f, 
1185.52f, 1185.63f, 1185.72f, 1185.81f, 1185.87f, 1185.92f, 1185.96f, 1185.98f, 
1185.99f,  			// 225km
  29.13f,   29.97f,   32.34f,   35.92f,   40.39f,   45.47f,   50.95f,   56.72f, 
  62.69f,   68.80f,   75.00f,   81.28f,   87.61f,   93.98f,  100.37f,  106.78f, 
 113.20f,  119.62f,  126.03f,  132.43f,  138.82f,  145.19f,  151.53f,  157.84f, 
 164.13f,  170.38f,  176.60f,  182.78f,  188.93f,  195.03f,  201.10f,  206.74f, 
 212.25f,  217.73f,  223.20f,  228.66f,  234.09f,  239.50f,  244.88f,  250.24f, 
 255.57f,  260.88f,  266.15f,  271.39f,  275.96f,  280.53f,  285.09f,  289.64f, 
 294.18f,  298.70f,  303.22f,  307.72f,  312.20f,  316.67f,  321.12f,  325.56f, 
 330.00f,  334.42f,  338.83f,  343.24f,  347.64f,  352.02f,  356.40f,  360.76f, 
 365.11f,  369.45f,  373.77f,  378.08f,  382.38f,  386.66f,  390.93f,  395.19f, 
 399.42f,  403.65f,  407.85f,  412.05f,  416.22f,  420.38f,  424.52f,  428.65f, 
 432.76f,  436.85f,  440.93f,  444.99f,  449.03f,  453.06f,  457.06f,  461.05f, 
 465.03f,  468.98f,  472.92f,  476.84f,  480.75f,  484.64f,  488.50f,  492.35f, 
 496.19f,  500.00f,  503.80f,  507.58f,  511.34f,  515.09f,  518.81f,  522.52f, 
 526.21f,  529.89f,  533.54f,  537.18f,  540.80f,  544.40f,  547.99f,  551.56f, 
 555.10f,  558.63f,  562.15f,  565.64f,  569.12f,  572.58f,  576.02f,  579.45f, 
 582.85f,  586.24f,  589.61f,  592.96f,  596.30f,  599.61f,  602.91f,  606.19f, 
 609.46f,  612.70f,  615.93f,  619.14f,  622.33f,  625.50f,  628.66f,  631.79f, 
 634.91f,  638.01f,  641.10f,  644.16f,  647.21f,  650.24f,  653.25f,  656.24f, 
 659.22f,  662.18f,  665.11f,  668.03f,  670.94f,  673.82f,  676.68f,  679.53f, 
 682.36f,  685.17f,  687.96f,  690.73f,  693.49f,  696.22f,  698.94f,  701.63f, 
 704.31f,  706.97f,  709.61f,  712.24f,  714.84f,  717.42f,  719.99f,  722.53f, 
 725.05f,  727.56f,  730.05f,  732.52f,  734.97f,  737.40f,  739.79f,  742.16f, 
 744.52f,  746.87f,  749.20f,  751.54f,  753.86f,  756.18f,  758.49f,  760.80f, 
 763.10f,  765.40f,  767.69f,  769.98f,  772.26f,  774.54f,  776.81f,  779.07f, 
 781.32f,  783.57f,  785.80f,  788.03f,  790.25f,  792.47f,  794.69f,  796.91f, 
 799.13f,  801.35f,  803.57f,  805.79f,  808.00f,  810.22f,  812.44f,  814.66f, 
 816.88f,  819.10f,  821.32f,  823.54f,  825.76f,  827.98f,  830.20f,  832.42f, 
 834.64f,  836.86f,  839.08f,  841.30f,  843.52f,  845.74f,  847.95f,  850.17f, 
 852.39f,  854.61f,  856.83f,  859.05f,  861.27f,  863.49f,  865.71f, 1094.85f, 
1095.81f, 1096.76f, 1097.72f, 1098.68f, 1099.64f, 1100.59f, 1101.55f, 1102.50f, 
1103.46f, 1104.42f, 1105.37f, 1106.33f, 1107.28f, 1108.23f, 1109.19f, 1110.14f, 
1111.09f, 1112.04f, 1113.00f, 1113.95f, 1114.90f, 1115.84f, 1116.79f, 1117.74f, 
1118.69f, 1119.63f, 1120.58f, 1121.52f, 1122.46f, 1123.40f, 1124.34f, 1125.28f, 
1126.21f, 1127.15f, 1128.08f, 1129.01f, 1129.94f, 1130.87f, 1131.80f, 1132.72f, 
1133.64f, 1134.56f, 1135.47f, 1136.39f, 1137.30f, 1138.21f, 1139.11f, 1140.01f, 
1140.91f, 1141.80f, 1142.69f, 1143.58f, 1144.46f, 1145.34f, 1146.21f, 1147.08f, 
1147.94f, 1147.65f, 1149.26f, 1150.50f, 1151.34f, 1152.17f, 1153.00f, 1153.82f, 
1154.63f, 1155.44f, 1156.24f, 1157.03f, 1157.81f, 1158.59f, 1159.35f, 1160.11f, 
1160.86f, 1161.60f, 1162.33f, 1163.04f, 1163.75f, 1164.45f, 1165.14f, 1165.82f, 
1166.48f, 1167.14f, 1167.78f, 1168.41f, 1169.03f, 1169.64f, 1170.24f, 1170.82f, 
1171.40f, 1171.95f, 1172.50f, 1173.03f, 1173.56f, 1174.06f, 1174.56f, 1175.04f, 
1175.51f, 1175.96f, 1176.40f, 1176.83f, 1177.24f, 1177.64f, 1178.02f, 1178.40f, 
1178.75f, 1179.10f, 1179.42f, 1179.74f, 1180.04f, 1180.32f, 1180.60f, 1180.85f, 
1181.10f, 1181.32f, 1181.54f, 1181.74f, 1181.92f, 1182.09f, 1182.24f, 1182.38f, 
1182.51f, 1182.62f, 1182.72f, 1182.80f, 1182.86f, 1182.92f, 1182.95f, 1182.97f, 
1182.98f,  			// 250km
  32.11f,   32.86f,   34.99f,   38.27f,   42.42f,   47.21f,   52.44f,   57.98f, 
  63.75f,   69.68f,   75.74f,   81.88f,   88.08f,   94.33f,  100.62f,  106.92f, 
 113.24f,  119.57f,  125.89f,  132.20f,  138.51f,  144.79f,  151.06f,  157.30f, 
 163.52f,  169.70f,  175.85f,  181.98f,  188.06f,  194.11f,  199.74f,  205.24f, 
 210.73f,  216.21f,  221.67f,  227.10f,  232.52f,  237.91f,  243.28f,  248.62f, 
 253.93f,  259.21f,  264.46f,  269.32f,  273.89f,  278.45f,  283.01f,  287.55f, 
 292.08f,  296.60f,  301.11f,  305.60f,  310.08f,  314.54f,  318.99f,  323.43f, 
 327.85f,  332.27f,  336.68f,  341.09f,  345.48f,  349.86f,  354.23f,  358.59f, 
 362.93f,  367.26f,  371.58f,  375.89f,  380.18f,  384.46f,  388.72f,  392.97f, 
 397.20f,  401.41f,  405.61f,  409.80f,  413.97f,  418.12f,  422.26f,  426.38f, 
 430.48f,  434.57f,  438.64f,  442.69f,  446.73f,  450.74f,  454.75f,  458.73f, 
 462.70f,  466.65f,  470.58f,  474.49f,  478.39f,  482.27f,  486.13f,  489.98f, 
 493.81f,  497.62f,  501.41f,  505.18f,  508.94f,  512.68f,  516.40f,  520.10f, 
 523.78f,  527.45f,  531.10f,  534.73f,  538.35f,  541.95f,  545.52f,  549.09f, 
 552.63f,  556.15f,  559.66f,  563.15f,  566.62f,  570.08f,  573.51f,  576.93f, 
 580.33f,  583.72f,  587.08f,  590.43f,  593.76f,  597.07f,  600.36f,  603.64f, 
 606.90f,  610.14f,  613.36f,  616.56f,  619.75f,  622.92f,  626.07f,  629.20f, 
 632.32f,  635.41f,  638.49f,  641.55f,  644.59f,  647.62f,  650.63f,  653.61f, 
 656.58f,  659.54f,  662.47f,  665.39f,  668.28f,  671.16f,  674.02f,  676.86f, 
 679.69f,  682.49f,  685.28f,  688.05f,  690.80f,  693.53f,  696.24f,  698.94f, 
 701.61f,  704.27f,  706.90f,  709.52f,  712.12f,  714.70f,  717.26f,  719.80f, 
 722.32f,  724.82f,  727.30f,  729.77f,  732.22f,  734.64f,  737.03f,  739.40f, 
 741.75f,  744.10f,  746.44f,  748.77f,  751.09f,  753.41f,  755.72f,  758.03f, 
 760.33f,  762.62f,  764.92f,  767.20f,  769.49f,  771.76f,  774.03f,  776.28f, 
 778.54f,  780.78f,  783.01f,  785.24f,  787.46f,  789.68f,  791.90f,  794.12f, 
 796.34f,  798.56f,  800.78f,  803.00f,  805.21f,  807.43f,  809.65f,  811.87f, 
 814.09f,  816.31f,  818.53f,  820.75f,  822.97f,  825.19f,  827.41f,  829.63f, 
 831.85f,  834.07f,  836.29f,  838.51f,  840.73f,  842.95f,  845.17f,  847.38f, 
 849.60f,  851.82f,  854.04f,  856.26f,  858.48f,  860.70f,  862.92f, 1091.91f, 
1092.86f, 1093.82f, 1094.78f, 1095.74f, 1096.69f, 1097.65f, 1098.61f, 1099.56f, 
1100.52f, 1101.47f, 1102.43f, 1103.38f, 1104.34f, 1105.29f, 1106.24f, 1107.20f, 
1108.15f, 1109.10f, 1110.05f, 1111.00f, 1111.95f, 1112.90f, 1113.85f, 1114.80f, 
1115.74f, 1116.69f, 1117.63f, 1118.57f, 1119.52f, 1120.46f, 1121.40f, 1122.33f, 
1123.27f, 1124.20f, 1125.14f, 1126.07f, 1127.00f, 1127.93f, 1128.85f, 1129.77f, 
1130.69f, 1131.61f, 1132.53f, 1133.44f, 1134.35f, 1135.26f, 1136.16f, 1137.06f, 
1137.96f, 1138.86f, 1139.75f, 1140.63f, 1141.51f, 1142.39f, 1143.26f, 1144.13f, 
1143.10f, 1144.78f, 1146.38f, 1147.55f, 1148.39f, 1149.22f, 1150.05f, 1150.87f, 
1151.68f, 1152.49f, 1153.29f, 1154.08f, 1154.86f, 1155.63f, 1156.40f, 1157.15f, 
1157.90f, 1158.64f, 1159.37f, 1160.09f, 1160.80f, 1161.49f, 1162.18f, 1162.86f, 
1163.52f, 1164.18f, 1164.82f, 1165.45f, 1166.07f, 1166.68f, 1167.28f, 1167.86f, 
1168.43f, 1168.99f, 1169.54f, 1170.07f, 1170.59f, 1171.10f, 1171.59f, 1172.07f, 
1172.54f, 1172.99f, 1173.43f, 1173.86f, 1174.27f, 1174.67f, 1175.05f, 1175.42f, 
1175.78f, 1176.12f, 1176.45f, 1176.77f, 1177.07f, 1177.35f, 1177.62f, 1177.88f, 
1178.12f, 1178.35f, 1178.56f, 1178.76f, 1178.94f, 1179.11f, 1179.27f, 1179.41f, 
1179.53f, 1179.64f, 1179.74f, 1179.82f, 1179.89f, 1179.94f, 1179.98f, 1180.00f, 
1180.01f,  			// 275km
  35.05f,   35.73f,   37.66f,   40.68f,   44.54f,   49.05f,   54.02f,   59.34f, 
  64.91f,   70.67f,   76.56f,   82.56f,   88.63f,   94.76f,  100.93f,  107.13f, 
 113.35f,  119.58f,  125.81f,  132.03f,  138.25f,  144.46f,  150.65f,  156.82f, 
 162.96f,  169.08f,  175.17f,  181.23f,  187.25f,  192.82f,  198.32f,  203.82f, 
 209.30f,  214.76f,  220.20f,  225.62f,  231.01f,  236.38f,  241.73f,  247.05f, 
 252.34f,  257.60f,  262.72f,  267.30f,  271.87f,  276.43f,  280.98f,  285.51f, 
 290.04f,  294.56f,  299.06f,  303.54f,  308.01f,  312.46f,  316.91f,  321.34f, 
 325.76f,  330.18f,  334.59f,  338.98f,  343.37f,  347.75f,  352.11f,  356.46f, 
 360.80f,  365.13f,  369.44f,  373.74f,  378.03f,  382.30f,  386.55f,  390.79f, 
 395.02f,  399.23f,  403.42f,  407.60f,  411.76f,  415.91f,  420.04f,  424.15f, 
 428.25f,  432.33f,  436.39f,  440.44f,  444.47f,  448.48f,  452.47f,  456.45f, 
 460.41f,  464.35f,  468.28f,  472.19f,  476.08f,  479.95f,  483.81f,  487.65f, 
 491.47f,  495.27f,  499.06f,  502.82f,  506.57f,  510.31f,  514.02f,  517.72f, 
 521.40f,  525.06f,  528.70f,  532.33f,  535.94f,  539.53f,  543.10f,  546.66f, 
 550.19f,  553.71f,  557.22f,  560.70f,  564.17f,  567.62f,  571.05f,  574.46f, 
 577.85f,  581.23f,  584.59f,  587.93f,  591.26f,  594.56f,  597.85f,  601.12f, 
 604.38f,  607.61f,  610.83f,  614.03f,  617.21f,  620.37f,  623.52f,  626.65f, 
 629.76f,  632.85f,  635.92f,  638.98f,  642.02f,  645.04f,  648.04f,  651.02f, 
 653.99f,  656.94f,  659.86f,  662.78f,  665.67f,  668.54f,  671.40f,  674.24f, 
 677.06f,  679.86f,  682.64f,  685.40f,  688.15f,  690.88f,  693.58f,  696.27f, 
 698.94f,  701.60f,  704.23f,  706.84f,  709.44f,  712.01f,  714.57f,  717.10f, 
 719.62f,  722.12f,  724.60f,  727.06f,  729.50f,  731.92f,  734.30f,  736.67f, 
 739.02f,  741.37f,  743.70f,  746.03f,  748.35f,  750.67f,  752.98f,  755.29f, 
 757.59f,  759.88f,  762.18f,  764.46f,  766.74f,  769.01f,  771.28f,  773.54f, 
 775.79f,  778.03f,  780.26f,  782.49f,  784.71f,  786.92f,  789.14f,  791.36f, 
 793.58f,  795.80f,  798.02f,  800.24f,  802.46f,  804.68f,  806.90f,  809.12f, 
 811.34f,  813.56f,  815.78f,  818.00f,  820.22f,  822.44f,  824.66f,  826.87f, 
 829.09f,  831.31f,  833.53f,  835.75f,  837.97f,  840.19f,  842.41f,  844.63f, 
 846.85f,  849.07f,  851.29f,  853.51f,  855.73f,  857.95f,  860.17f, 1089.00f, 
1089.96f, 1090.91f, 1091.87f, 1092.83f, 1093.78f, 1094.74f, 1095.70f, 1096.65f, 
1097.61f, 1098.56f, 1099.52f, 1100.47f, 1101.43f, 1102.38f, 1103.33f, 1104.29f, 
1105.24f, 1106.19f, 1107.14f, 1108.09f, 1109.04f, 1109.99f, 1110.94f, 1111.89f, 
1112.83f, 1113.78f, 1114.72f, 1115.66f, 1116.61f, 1117.55f, 1118.49f, 1119.42f, 
1120.36f, 1121.29f, 1122.23f, 1123.16f, 1124.09f, 1125.01f, 1125.94f, 1126.86f, 
1127.78f, 1128.70f, 1129.62f, 1130.53f, 1131.44f, 1132.35f, 1133.25f, 1134.15f, 
1135.05f, 1135.94f, 1136.83f, 1137.72f, 1138.60f, 1139.47f, 1140.35f, 1141.21f, 
1140.27f, 1141.93f, 1143.53f, 1144.63f, 1145.47f, 1146.30f, 1147.13f, 1147.95f, 
1148.76f, 1149.57f, 1150.36f, 1151.15f, 1151.94f, 1152.71f, 1153.48f, 1154.23f, 
1154.98f, 1155.72f, 1156.44f, 1157.16f, 1157.87f, 1158.57f, 1159.25f, 1159.93f, 
1160.60f, 1161.25f, 1161.89f, 1162.52f, 1163.14f, 1163.75f, 1164.35f, 1164.93f, 
1165.50f, 1166.06f, 1166.60f, 1167.14f, 1167.65f, 1168.16f, 1168.65f, 1169.13f, 
1169.60f, 1170.05f, 1170.49f, 1170.92f, 1171.33f, 1171.73f, 1172.11f, 1172.48f, 
1172.84f, 1173.18f, 1173.51f, 1173.83f, 1174.12f, 1174.41f, 1174.68f, 1174.94f, 
1175.18f, 1175.41f, 1175.62f, 1175.82f, 1176.00f, 1176.17f, 1176.32f, 1176.46f, 
1176.59f, 1176.70f, 1176.80f, 1176.88f, 1176.94f, 1177.00f, 1177.03f, 1177.05f, 
1177.06f,  			// 300km
  37.97f,   38.58f,   40.34f,   43.13f,   46.73f,   50.98f,   55.71f,   60.80f, 
  66.17f,   71.75f,   77.48f,   83.33f,   89.26f,   95.26f,  101.32f,  107.41f, 
 113.52f,  119.65f,  125.79f,  131.93f,  138.07f,  144.19f,  150.30f,  156.40f, 
 162.47f,  168.52f,  174.55f,  180.46f,  185.98f,  191.49f,  196.99f,  202.47f, 
 207.93f,  213.37f,  218.79f,  224.19f,  229.57f,  234.92f,  240.25f,  245.54f, 
 250.81f,  256.04f,  260.76f,  265.34f,  269.90f,  274.45f,  279.00f,  283.53f, 
 288.05f,  292.56f,  297.05f,  301.53f,  305.99f,  310.44f,  314.88f,  319.31f, 
 323.73f,  328.14f,  332.54f,  336.93f,  341.31f,  345.69f,  350.04f,  354.39f, 
 358.72f,  363.04f,  367.35f,  371.64f,  375.92f,  380.18f,  384.43f,  388.67f, 
 392.89f,  397.09f,  401.28f,  405.45f,  409.60f,  413.74f,  417.86f,  421.97f, 
 426.06f,  430.13f,  434.19f,  438.23f,  442.25f,  446.26f,  450.24f,  454.22f, 
 458.17f,  462.11f,  466.02f,  469.93f,  473.81f,  477.68f,  481.53f,  485.36f, 
 489.17f,  492.97f,  496.75f,  500.51f,  504.25f,  507.98f,  511.69f,  515.38f, 
 519.05f,  522.71f,  526.35f,  529.97f,  533.57f,  537.15f,  540.72f,  544.27f, 
 547.80f,  551.31f,  554.81f,  558.29f,  561.75f,  565.19f,  568.62f,  572.03f, 
 575.42f,  578.79f,  582.14f,  585.48f,  588.80f,  592.10f,  595.38f,  598.65f, 
 601.90f,  605.13f,  608.34f,  611.53f,  614.71f,  617.87f,  621.01f,  624.13f, 
 627.23f,  630.32f,  633.39f,  636.44f,  639.48f,  642.49f,  645.49f,  648.47f, 
 651.43f,  654.37f,  657.30f,  660.20f,  663.09f,  665.96f,  668.81f,  671.65f, 
 674.46f,  677.26f,  680.04f,  682.80f,  685.54f,  688.26f,  690.96f,  693.65f, 
 696.31f,  698.96f,  701.59f,  704.20f,  706.79f,  709.36f,  711.91f,  714.44f, 
 716.96f,  719.45f,  721.93f,  724.39f,  726.82f,  729.24f,  731.61f,  733.98f, 
 736.33f,  738.67f,  741.00f,  743.33f,  745.65f,  747.97f,  750.28f,  752.58f, 
 754.88f,  757.18f,  759.47f,  761.75f,  764.03f,  766.30f,  768.57f,  770.82f, 
 773.07f,  775.31f,  777.54f,  779.77f,  781.99f,  784.21f,  786.43f,  788.64f, 
 790.86f,  793.08f,  795.30f,  797.52f,  799.74f,  801.96f,  804.18f,  806.40f, 
 808.62f,  810.84f,  813.06f,  815.28f,  817.50f,  819.72f,  821.94f,  824.16f, 
 826.38f,  828.59f,  830.81f,  833.03f,  835.25f,  837.47f,  839.69f,  841.91f, 
 844.13f,  846.35f,  848.57f,  850.79f,  853.01f,  855.23f,  857.45f, 1086.12f, 
1087.08f, 1088.03f, 1088.99f, 1089.95f, 1090.91f, 1091.86f, 1092.82f, 1093.77f, 
1094.73f, 1095.69f, 1096.64f, 1097.60f, 1098.55f, 1099.50f, 1100.46f, 1101.41f, 
1102.36f, 1103.31f, 1104.26f, 1105.21f, 1106.16f, 1107.11f, 1108.06f, 1109.01f, 
1109.95f, 1110.90f, 1111.84f, 1112.79f, 1113.73f, 1114.67f, 1115.61f, 1116.54f, 
1117.48f, 1118.41f, 1119.35f, 1120.28f, 1121.21f, 1122.13f, 1123.06f, 1123.98f, 
1124.90f, 1125.82f, 1126.74f, 1127.65f, 1128.56f, 1129.46f, 1130.37f, 1131.27f, 
1132.17f, 1133.06f, 1133.95f, 1134.83f, 1135.71f, 1136.59f, 1137.46f, 1138.33f, 
1137.47f, 1139.12f, 1140.71f, 1141.74f, 1142.58f, 1143.42f, 1144.24f, 1145.06f, 
1145.87f, 1146.68f, 1147.48f, 1148.27f, 1149.05f, 1149.82f, 1150.58f, 1151.34f, 
1152.09f, 1152.82f, 1153.55f, 1154.27f, 1154.98f, 1155.67f, 1156.36f, 1157.03f, 
1157.70f, 1158.35f, 1158.99f, 1159.63f, 1160.24f, 1160.85f, 1161.45f, 1162.03f, 
1162.60f, 1163.16f, 1163.70f, 1164.23f, 1164.75f, 1165.26f, 1165.75f, 1166.23f, 
1166.70f, 1167.15f, 1167.59f, 1168.01f, 1168.43f, 1168.82f, 1169.21f, 1169.58f, 
1169.93f, 1170.27f, 1170.60f, 1170.92f, 1171.21f, 1171.50f, 1171.77f, 1172.03f, 
1172.27f, 1172.50f, 1172.71f, 1172.91f, 1173.09f, 1173.26f, 1173.41f, 1173.55f, 
1173.68f, 1173.79f, 1173.88f, 1173.96f, 1174.03f, 1174.08f, 1174.12f, 1174.14f, 
1174.15f,  			// 325km
  40.85f,   41.41f,   43.03f,   45.60f,   48.97f,   52.98f,   57.47f,   62.35f, 
  67.52f,   72.92f,   78.48f,   84.18f,   89.97f,   95.85f,  101.78f,  107.76f, 
 113.77f,  119.80f,  125.84f,  131.89f,  137.94f,  143.99f,  150.02f,  156.04f, 
 162.04f,  168.03f,  173.72f,  179.24f,  184.75f,  190.24f,  195.72f,  201.19f, 
 206.63f,  212.06f,  217.46f,  222.84f,  228.19f,  233.52f,  238.82f,  244.09f, 
 249.33f,  254.28f,  258.86f,  263.43f,  267.99f,  272.53f,  277.07f,  281.60f, 
 286.11f,  290.62f,  295.10f,  299.57f,  304.02f,  308.46f,  312.90f,  317.32f, 
 321.74f,  326.14f,  330.54f,  334.93f,  339.31f,  343.67f,  348.02f,  352.36f, 
 356.69f,  361.01f,  365.31f,  369.59f,  373.86f,  378.12f,  382.36f,  386.59f, 
 390.80f,  395.00f,  399.18f,  403.34f,  407.49f,  411.62f,  415.74f,  419.83f, 
 423.92f,  427.98f,  432.03f,  436.06f,  440.08f,  444.08f,  448.06f,  452.02f, 
 455.97f,  459.90f,  463.81f,  467.71f,  471.59f,  475.45f,  479.29f,  483.11f, 
 486.92f,  490.71f,  494.48f,  498.24f,  501.97f,  505.69f,  509.40f,  513.08f, 
 516.75f,  520.40f,  524.03f,  527.64f,  531.24f,  534.82f,  538.38f,  541.92f, 
 545.45f,  548.96f,  552.45f,  555.92f,  559.37f,  562.81f,  566.23f,  569.63f, 
 573.02f,  576.38f,  579.73f,  583.06f,  586.38f,  589.67f,  592.95f,  596.21f, 
 599.45f,  602.68f,  605.88f,  609.07f,  612.24f,  615.40f,  618.53f,  621.65f, 
 624.75f,  627.83f,  630.90f,  633.94f,  636.97f,  639.98f,  642.98f,  645.95f, 
 648.91f,  651.84f,  654.76f,  657.67f,  660.55f,  663.42f,  666.26f,  669.09f, 
 671.90f,  674.69f,  677.47f,  680.22f,  682.96f,  685.68f,  688.38f,  691.06f, 
 693.72f,  696.36f,  698.99f,  701.59f,  704.18f,  706.75f,  709.29f,  711.82f, 
 714.33f,  716.82f,  719.29f,  721.75f,  724.18f,  726.58f,  728.96f,  731.32f, 
 733.67f,  736.01f,  738.34f,  740.67f,  742.99f,  745.30f,  747.61f,  749.91f, 
 752.21f,  754.51f,  756.80f,  759.08f,  761.36f,  763.63f,  765.89f,  768.15f, 
 770.39f,  772.63f,  774.86f,  777.08f,  779.30f,  781.52f,  783.74f,  785.96f, 
 788.18f,  790.40f,  792.62f,  794.84f,  797.06f,  799.28f,  801.50f,  803.72f, 
 805.94f,  808.15f,  810.37f,  812.59f,  814.81f,  817.03f,  819.25f,  821.47f, 
 823.69f,  825.91f,  828.13f,  830.35f,  832.57f,  834.79f,  837.01f,  839.23f, 
 841.45f,  843.67f,  845.89f,  848.11f,  850.32f,  852.54f,  854.76f, 1083.27f, 
1084.23f, 1085.19f, 1086.15f, 1087.10f, 1088.06f, 1089.02f, 1089.97f, 1090.93f, 
1091.88f, 1092.84f, 1093.79f, 1094.75f, 1095.70f, 1096.66f, 1097.61f, 1098.56f, 
1099.51f, 1100.47f, 1101.42f, 1102.37f, 1103.32f, 1104.27f, 1105.21f, 1106.16f, 
1107.11f, 1108.05f, 1108.99f, 1109.94f, 1110.88f, 1111.82f, 1112.76f, 1113.70f, 
1114.63f, 1115.57f, 1116.50f, 1117.43f, 1118.36f, 1119.28f, 1120.21f, 1121.13f, 
1122.05f, 1122.97f, 1123.89f, 1124.80f, 1125.71f, 1126.61f, 1127.52f, 1128.42f, 
1129.31f, 1130.21f, 1131.10f, 1131.98f, 1132.86f, 1133.74f, 1134.61f, 1135.48f, 
1134.70f, 1136.34f, 1137.93f, 1138.89f, 1139.73f, 1140.56f, 1141.39f, 1142.21f, 
1143.02f, 1143.82f, 1144.62f, 1145.41f, 1146.19f, 1146.96f, 1147.72f, 1148.48f, 
1149.23f, 1149.96f, 1150.69f, 1151.41f, 1152.11f, 1152.81f, 1153.49f, 1154.17f, 
1154.83f, 1155.49f, 1156.13f, 1156.76f, 1157.38f, 1157.98f, 1158.58f, 1159.16f, 
1159.73f, 1160.29f, 1160.83f, 1161.36f, 1161.88f, 1162.39f, 1162.88f, 1163.36f, 
1163.82f, 1164.27f, 1164.71f, 1165.14f, 1165.55f, 1165.95f, 1166.33f, 1166.70f, 
1167.06f, 1167.40f, 1167.72f, 1168.04f, 1168.34f, 1168.62f, 1168.89f, 1169.15f, 
1169.39f, 1169.61f, 1169.83f, 1170.03f, 1170.21f, 1170.38f, 1170.53f, 1170.67f, 
1170.80f, 1170.91f, 1171.00f, 1171.08f, 1171.15f, 1171.20f, 1171.24f, 1171.26f, 
1171.27f,  			// 350km
  43.70f,   44.22f,   45.71f,   48.10f,   51.26f,   55.03f,   59.31f,   63.98f, 
  68.95f,   74.16f,   79.56f,   85.11f,   90.76f,   96.51f,  102.32f,  108.18f, 
 114.09f,  120.02f,  125.96f,  131.92f,  137.89f,  143.85f,  149.80f,  155.75f, 
 161.55f,  167.08f,  172.60f,  178.10f,  183.60f,  189.08f,  194.54f,  199.98f, 
 205.41f,  210.81f,  216.19f,  221.55f,  226.88f,  232.18f,  237.46f,  242.70f, 
 247.86f,  252.44f,  257.01f,  261.57f,  266.12f,  270.67f,  275.20f,  279.72f, 
 284.23f,  288.72f,  293.19f,  297.65f,  302.10f,  306.54f,  310.97f,  315.39f, 
 319.80f,  324.20f,  328.60f,  332.98f,  337.35f,  341.71f,  346.05f,  350.39f, 
 354.71f,  359.02f,  363.31f,  367.59f,  371.85f,  376.10f,  380.34f,  384.56f, 
 388.76f,  392.95f,  397.12f,  401.28f,  405.42f,  409.54f,  413.65f,  417.74f, 
 421.82f,  425.88f,  429.92f,  433.95f,  437.95f,  441.94f,  445.92f,  449.88f, 
 453.82f,  457.74f,  461.64f,  465.53f,  469.40f,  473.26f,  477.09f,  480.91f, 
 484.71f,  488.49f,  492.26f,  496.01f,  499.74f,  503.45f,  507.15f,  510.82f, 
 514.48f,  518.13f,  521.75f,  525.36f,  528.95f,  532.52f,  536.08f,  539.61f, 
 543.13f,  546.64f,  550.12f,  553.59f,  557.04f,  560.47f,  563.88f,  567.28f, 
 570.66f,  574.02f,  577.36f,  580.69f,  583.99f,  587.28f,  590.56f,  593.81f, 
 597.05f,  600.27f,  603.47f,  606.65f,  609.82f,  612.97f,  616.10f,  619.21f, 
 622.31f,  625.38f,  628.44f,  631.48f,  634.51f,  637.51f,  640.50f,  643.47f, 
 646.42f,  649.35f,  652.27f,  655.17f,  658.04f,  660.91f,  663.75f,  666.57f, 
 669.38f,  672.17f,  674.93f,  677.69f,  680.42f,  683.13f,  685.83f,  688.50f, 
 691.16f,  693.80f,  696.42f,  699.02f,  701.60f,  704.16f,  706.71f,  709.23f, 
 711.73f,  714.22f,  716.69f,  719.14f,  721.57f,  723.96f,  726.34f,  728.69f, 
 731.04f,  733.38f,  735.71f,  738.04f,  740.36f,  742.67f,  744.98f,  747.28f, 
 749.58f,  751.87f,  754.16f,  756.44f,  758.72f,  760.99f,  763.25f,  765.50f, 
 767.75f,  769.98f,  772.21f,  774.43f,  776.65f,  778.87f,  781.09f,  783.31f, 
 785.53f,  787.75f,  789.97f,  792.19f,  794.41f,  796.63f,  798.85f,  801.07f, 
 803.28f,  805.50f,  807.72f,  809.94f,  812.16f,  814.38f,  816.60f,  818.82f, 
 821.04f,  823.26f,  825.48f,  827.70f,  829.92f,  832.14f,  834.36f,  836.58f, 
 838.80f,  841.02f,  843.24f,  845.45f,  847.67f,  849.89f,  852.11f, 1080.46f, 
1081.41f, 1082.37f, 1083.33f, 1084.29f, 1085.24f, 1086.20f, 1087.16f, 1088.11f, 
1089.07f, 1090.02f, 1090.98f, 1091.93f, 1092.89f, 1093.84f, 1094.79f, 1095.75f, 
1096.70f, 1097.65f, 1098.60f, 1099.55f, 1100.50f, 1101.45f, 1102.40f, 1103.34f, 
1104.29f, 1105.23f, 1106.18f, 1107.12f, 1108.06f, 1109.00f, 1109.94f, 1110.88f, 
1111.81f, 1112.75f, 1113.68f, 1114.61f, 1115.54f, 1116.47f, 1117.39f, 1118.31f, 
1119.23f, 1120.15f, 1121.07f, 1121.98f, 1122.89f, 1123.79f, 1124.70f, 1125.60f, 
1126.49f, 1127.39f, 1128.28f, 1129.16f, 1130.04f, 1130.92f, 1131.79f, 1132.65f, 
1131.96f, 1133.59f, 1135.17f, 1136.07f, 1136.90f, 1137.74f, 1138.56f, 1139.38f, 
1140.19f, 1140.99f, 1141.79f, 1142.58f, 1143.36f, 1144.13f, 1144.90f, 1145.65f, 
1146.40f, 1147.13f, 1147.86f, 1148.57f, 1149.28f, 1149.98f, 1150.66f, 1151.34f, 
1152.00f, 1152.65f, 1153.29f, 1153.92f, 1154.54f, 1155.14f, 1155.74f, 1156.32f, 
1156.89f, 1157.45f, 1157.99f, 1158.52f, 1159.04f, 1159.54f, 1160.03f, 1160.51f, 
1160.98f, 1161.43f, 1161.87f, 1162.29f, 1162.70f, 1163.10f, 1163.48f, 1163.85f, 
1164.21f, 1164.55f, 1164.88f, 1165.19f, 1165.49f, 1165.77f, 1166.04f, 1166.30f, 
1166.54f, 1166.76f, 1166.98f, 1167.17f, 1167.36f, 1167.53f, 1167.68f, 1167.82f, 
1167.94f, 1168.05f, 1168.15f, 1168.23f, 1168.30f, 1168.35f, 1168.38f, 1168.41f, 
1168.41f,  			// 375km
  46.52f,   47.00f,   48.39f,   50.62f,   53.57f,   57.14f,   61.21f,   65.67f, 
  70.46f,   75.49f,   80.72f,   86.11f,   91.63f,   97.24f,  102.93f,  108.68f, 
 114.47f,  120.30f,  126.15f,  132.02f,  137.89f,  143.77f,  149.48f,  155.01f, 
 160.54f,  166.05f,  171.56f,  177.05f,  182.53f,  187.99f,  193.43f,  198.85f, 
 204.25f,  209.63f,  214.99f,  220.32f,  225.62f,  230.90f,  236.15f,  241.37f, 
 246.07f,  250.64f,  255.21f,  259.77f,  264.31f,  268.85f,  273.38f,  277.89f, 
 282.39f,  286.87f,  291.34f,  295.79f,  300.24f,  304.67f,  309.09f,  313.51f, 
 317.91f,  322.31f,  326.70f,  331.08f,  335.44f,  339.79f,  344.13f,  348.46f, 
 352.77f,  357.07f,  361.36f,  365.63f,  369.89f,  374.13f,  378.36f,  382.57f, 
 386.77f,  390.95f,  395.11f,  399.26f,  403.40f,  407.51f,  411.61f,  415.70f, 
 419.77f,  423.82f,  427.85f,  431.87f,  435.87f,  439.85f,  443.82f,  447.77f, 
 451.70f,  455.62f,  459.52f,  463.40f,  467.26f,  471.11f,  474.94f,  478.75f, 
 482.54f,  486.32f,  490.08f,  493.82f,  497.54f,  501.25f,  504.94f,  508.61f, 
 512.26f,  515.90f,  519.52f,  523.12f,  526.70f,  530.27f,  533.82f,  537.35f, 
 540.86f,  544.36f,  547.83f,  551.29f,  554.74f,  558.16f,  561.57f,  564.96f, 
 568.33f,  571.69f,  575.03f,  578.35f,  581.65f,  584.93f,  588.20f,  591.45f, 
 594.68f,  597.89f,  601.09f,  604.27f,  607.43f,  610.57f,  613.70f,  616.81f, 
 619.90f,  622.97f,  626.02f,  629.06f,  632.08f,  635.08f,  638.06f,  641.02f, 
 643.97f,  646.90f,  649.81f,  652.70f,  655.58f,  658.43f,  661.27f,  664.09f, 
 666.89f,  669.67f,  672.44f,  675.18f,  677.91f,  680.62f,  683.31f,  685.98f, 
 688.63f,  691.27f,  693.88f,  696.48f,  699.06f,  701.62f,  704.16f,  706.67f, 
 709.17f,  711.66f,  714.12f,  716.57f,  718.99f,  721.38f,  723.75f,  726.10f, 
 728.45f,  730.79f,  733.12f,  735.44f,  737.76f,  740.07f,  742.38f,  744.68f, 
 746.98f,  749.27f,  751.56f,  753.84f,  756.11f,  758.38f,  760.64f,  762.89f, 
 765.13f,  767.37f,  769.59f,  771.81f,  774.03f,  776.25f,  778.47f,  780.69f, 
 782.91f,  785.13f,  787.35f,  789.57f,  791.79f,  794.01f,  796.23f,  798.45f, 
 800.67f,  802.89f,  805.11f,  807.33f,  809.55f,  811.77f,  813.98f,  816.20f, 
 818.42f,  820.64f,  822.86f,  825.08f,  827.30f,  829.52f,  831.74f,  833.96f, 
 836.18f,  838.40f,  840.62f,  842.84f,  845.06f,  847.28f,  849.50f, 1077.67f, 
1078.63f, 1079.59f, 1080.54f, 1081.50f, 1082.46f, 1083.41f, 1084.37f, 1085.33f, 
1086.28f, 1087.24f, 1088.19f, 1089.15f, 1090.10f, 1091.05f, 1092.01f, 1092.96f, 
1093.91f, 1094.86f, 1095.81f, 1096.76f, 1097.71f, 1098.66f, 1099.61f, 1100.56f, 
1101.50f, 1102.45f, 1103.39f, 1104.33f, 1105.27f, 1106.21f, 1107.15f, 1108.09f, 
1109.03f, 1109.96f, 1110.89f, 1111.82f, 1112.75f, 1113.68f, 1114.60f, 1115.53f, 
1116.45f, 1117.36f, 1118.28f, 1119.19f, 1120.10f, 1121.00f, 1121.91f, 1122.81f, 
1123.70f, 1124.60f, 1125.48f, 1126.37f, 1127.25f, 1128.12f, 1129.00f, 1129.86f, 
1129.25f, 1130.88f, 1132.43f, 1133.27f, 1134.11f, 1134.94f, 1135.77f, 1136.58f, 
1137.39f, 1138.20f, 1138.99f, 1139.78f, 1140.56f, 1141.33f, 1142.10f, 1142.85f, 
1143.59f, 1144.33f, 1145.06f, 1145.77f, 1146.48f, 1147.17f, 1147.86f, 1148.53f, 
1149.19f, 1149.84f, 1150.49f, 1151.11f, 1151.73f, 1152.34f, 1152.93f, 1153.51f, 
1154.08f, 1154.63f, 1155.18f, 1155.71f, 1156.23f, 1156.73f, 1157.22f, 1157.70f, 
1158.16f, 1158.62f, 1159.05f, 1159.48f, 1159.89f, 1160.28f, 1160.67f, 1161.04f, 
1161.39f, 1161.73f, 1162.06f, 1162.37f, 1162.67f, 1162.95f, 1163.22f, 1163.48f, 
1163.72f, 1163.94f, 1164.16f, 1164.35f, 1164.54f, 1164.70f, 1164.86f, 1165.00f, 
1165.12f, 1165.23f, 1165.33f, 1165.41f, 1165.47f, 1165.53f, 1165.56f, 1165.58f, 
1165.59f,  			// 400km
  49.32f,   49.76f,   51.05f,   53.13f,   55.91f,   59.29f,   63.16f,   67.43f, 
  72.03f,   76.88f,   81.95f,   87.19f,   92.56f,   98.04f,  103.61f,  109.24f, 
 114.92f,  120.65f,  126.40f,  131.97f,  137.52f,  143.06f,  148.59f,  154.11f, 
 159.62f,  165.12f,  170.61f,  176.08f,  181.54f,  186.97f,  192.39f,  197.79f, 
 203.17f,  208.52f,  213.85f,  219.15f,  224.43f,  229.68f,  234.90f,  239.76f, 
 244.34f,  248.91f,  253.47f,  258.02f,  262.56f,  267.09f,  271.61f,  276.11f, 
 280.60f,  285.08f,  289.53f,  293.98f,  298.42f,  302.85f,  307.27f,  311.68f, 
 316.08f,  320.47f,  324.85f,  329.22f,  333.58f,  337.93f,  342.26f,  346.58f, 
 350.89f,  355.18f,  359.46f,  363.72f,  367.97f,  372.21f,  376.43f,  380.63f, 
 384.82f,  388.99f,  393.15f,  397.29f,  401.42f,  405.53f,  409.62f,  413.70f, 
 417.76f,  421.80f,  425.83f,  429.84f,  433.83f,  437.81f,  441.77f,  445.71f, 
 449.63f,  453.54f,  457.43f,  461.31f,  465.16f,  469.00f,  472.82f,  476.63f, 
 480.41f,  484.18f,  487.93f,  491.67f,  495.38f,  499.08f,  502.77f,  506.43f, 
 510.08f,  513.71f,  517.32f,  520.91f,  524.49f,  528.05f,  531.59f,  535.12f, 
 538.62f,  542.11f,  545.59f,  549.04f,  552.48f,  555.90f,  559.30f,  562.68f, 
 566.05f,  569.40f,  572.73f,  576.05f,  579.34f,  582.62f,  585.88f,  589.13f, 
 592.35f,  595.56f,  598.75f,  601.92f,  605.08f,  608.22f,  611.33f,  614.44f, 
 617.52f,  620.59f,  623.64f,  626.67f,  629.68f,  632.68f,  635.65f,  638.61f, 
 641.55f,  644.48f,  647.38f,  650.27f,  653.14f,  655.99f,  658.82f,  661.64f, 
 664.44f,  667.21f,  669.97f,  672.71f,  675.44f,  678.14f,  680.83f,  683.49f, 
 686.14f,  688.77f,  691.38f,  693.98f,  696.55f,  699.10f,  701.64f,  704.15f, 
 706.65f,  709.13f,  711.59f,  714.03f,  716.44f,  718.83f,  721.19f,  723.54f, 
 725.89f,  728.22f,  730.55f,  732.88f,  735.19f,  737.50f,  739.81f,  742.11f, 
 744.41f,  746.70f,  748.98f,  751.27f,  753.54f,  755.80f,  758.06f,  760.31f, 
 762.55f,  764.79f,  767.01f,  769.23f,  771.45f,  773.67f,  775.89f,  778.11f, 
 780.33f,  782.55f,  784.77f,  786.99f,  789.21f,  791.43f,  793.64f,  795.86f, 
 798.08f,  800.30f,  802.52f,  804.74f,  806.96f,  809.18f,  811.40f,  813.62f, 
 815.84f,  818.06f,  820.28f,  822.50f,  824.72f,  826.94f,  829.16f,  831.38f, 
 833.60f,  835.81f,  838.03f,  840.25f,  842.47f,  844.69f,  846.91f, 1074.92f, 
1075.87f, 1076.83f, 1077.79f, 1078.74f, 1079.70f, 1080.66f, 1081.61f, 1082.57f, 
1083.53f, 1084.48f, 1085.44f, 1086.39f, 1087.34f, 1088.30f, 1089.25f, 1090.20f, 
1091.16f, 1092.11f, 1093.06f, 1094.01f, 1094.96f, 1095.91f, 1096.85f, 1097.80f, 
1098.75f, 1099.69f, 1100.63f, 1101.58f, 1102.52f, 1103.46f, 1104.40f, 1105.33f, 
1106.27f, 1107.20f, 1108.13f, 1109.06f, 1109.99f, 1110.92f, 1111.84f, 1112.77f, 
1113.69f, 1114.60f, 1115.52f, 1116.43f, 1117.34f, 1118.24f, 1119.15f, 1120.05f, 
1120.94f, 1121.83f, 1122.72f, 1123.61f, 1124.49f, 1125.36f, 1126.23f, 1127.10f, 
1126.57f, 1128.19f, 1129.66f, 1130.51f, 1131.34f, 1132.17f, 1133.00f, 1133.82f, 
1134.63f, 1135.43f, 1136.23f, 1137.01f, 1137.79f, 1138.56f, 1139.33f, 1140.08f, 
1140.82f, 1141.56f, 1142.28f, 1143.00f, 1143.70f, 1144.40f, 1145.08f, 1145.75f, 
1146.42f, 1147.07f, 1147.71f, 1148.34f, 1148.95f, 1149.56f, 1150.15f, 1150.73f, 
1151.30f, 1151.85f, 1152.40f, 1152.93f, 1153.44f, 1153.95f, 1154.44f, 1154.91f, 
1155.38f, 1155.83f, 1156.27f, 1156.69f, 1157.10f, 1157.50f, 1157.88f, 1158.25f, 
1158.60f, 1158.94f, 1159.27f, 1159.58f, 1159.88f, 1160.16f, 1160.43f, 1160.68f, 
1160.93f, 1161.15f, 1161.36f, 1161.56f, 1161.74f, 1161.91f, 1162.06f, 1162.20f, 
1162.33f, 1162.44f, 1162.53f, 1162.61f, 1162.68f, 1162.73f, 1162.77f, 1162.79f, 
1162.80f,  			// 425km
  52.03f,   52.44f,   53.65f,   55.59f,   58.20f,   61.39f,   65.07f,   69.15f, 
  73.55f,   78.23f,   83.13f,   88.19f,   93.40f,   98.72f,  104.12f,  109.57f, 
 115.06f,  120.56f,  126.08f,  131.59f,  137.10f,  142.61f,  148.10f,  153.59f, 
 159.07f,  164.54f,  169.99f,  175.42f,  180.84f,  186.25f,  191.63f,  196.99f, 
 202.33f,  207.65f,  212.94f,  218.21f,  223.45f,  228.67f,  233.60f,  238.18f, 
 242.76f,  247.32f,  251.87f,  256.42f,  260.95f,  265.48f,  269.99f,  274.48f, 
 278.96f,  283.42f,  287.88f,  292.32f,  296.75f,  301.17f,  305.58f,  309.99f, 
 314.39f,  318.77f,  323.15f,  327.51f,  331.86f,  336.20f,  340.52f,  344.84f, 
 349.14f,  353.42f,  357.69f,  361.95f,  366.19f,  370.42f,  374.63f,  378.82f, 
 383.01f,  387.17f,  391.32f,  395.45f,  399.57f,  403.67f,  407.75f,  411.82f, 
 415.88f,  419.91f,  423.93f,  427.93f,  431.92f,  435.88f,  439.83f,  443.77f, 
 447.69f,  451.59f,  455.47f,  459.33f,  463.18f,  467.01f,  470.83f,  474.62f, 
 478.40f,  482.16f,  485.91f,  489.64f,  493.34f,  497.04f,  500.71f,  504.37f, 
 508.01f,  511.63f,  515.24f,  518.82f,  522.40f,  525.95f,  529.48f,  533.00f, 
 536.50f,  539.98f,  543.45f,  546.90f,  550.33f,  553.74f,  557.14f,  560.52f, 
 563.88f,  567.22f,  570.54f,  573.85f,  577.14f,  580.41f,  583.67f,  586.91f, 
 590.13f,  593.33f,  596.51f,  599.68f,  602.83f,  605.96f,  609.08f,  612.17f, 
 615.25f,  618.31f,  621.36f,  624.38f,  627.39f,  630.38f,  633.35f,  636.31f, 
 639.24f,  642.16f,  645.06f,  647.94f,  650.81f,  653.65f,  656.48f,  659.29f, 
 662.08f,  664.85f,  667.61f,  670.35f,  673.06f,  675.76f,  678.44f,  681.11f, 
 683.75f,  686.38f,  688.98f,  691.57f,  694.14f,  696.69f,  699.21f,  701.72f, 
 704.22f,  706.69f,  709.15f,  711.59f,  713.99f,  716.37f,  718.73f,  721.08f, 
 723.43f,  725.76f,  728.09f,  730.41f,  732.72f,  735.03f,  737.34f,  739.64f, 
 741.93f,  744.22f,  746.51f,  748.79f,  751.06f,  753.32f,  755.58f,  757.83f, 
 760.07f,  762.30f,  764.52f,  766.74f,  768.96f,  771.18f,  773.40f,  775.62f, 
 777.84f,  780.06f,  782.28f,  784.50f,  786.72f,  788.94f,  791.16f,  793.38f, 
 795.59f,  797.81f,  800.03f,  802.25f,  804.47f,  806.69f,  808.91f,  811.13f, 
 813.35f,  815.57f,  817.79f,  820.01f,  822.23f,  824.45f,  826.67f,  828.89f, 
 831.11f,  833.33f,  835.55f,  837.76f,  839.98f,  842.20f,  844.42f, 1072.25f, 
1073.20f, 1074.16f, 1075.12f, 1076.08f, 1077.03f, 1077.99f, 1078.94f, 1079.90f, 
1080.86f, 1081.81f, 1082.77f, 1083.72f, 1084.68f, 1085.63f, 1086.58f, 1087.53f, 
1088.49f, 1089.44f, 1090.39f, 1091.34f, 1092.29f, 1093.24f, 1094.18f, 1095.13f, 
1096.08f, 1097.02f, 1097.96f, 1098.91f, 1099.85f, 1100.79f, 1101.73f, 1102.66f, 
1103.60f, 1104.53f, 1105.46f, 1106.39f, 1107.32f, 1108.25f, 1109.17f, 1110.09f, 
1111.01f, 1111.93f, 1112.85f, 1113.76f, 1114.67f, 1115.57f, 1116.47f, 1117.37f, 
1118.27f, 1119.16f, 1120.05f, 1120.93f, 1121.81f, 1122.69f, 1123.56f, 1122.30f, 
1123.98f, 1125.59f, 1126.99f, 1127.83f, 1128.67f, 1129.50f, 1130.32f, 1131.14f, 
1131.95f, 1132.75f, 1133.54f, 1134.33f, 1135.11f, 1135.88f, 1136.64f, 1137.39f, 
1138.14f, 1138.87f, 1139.60f, 1140.31f, 1141.02f, 1141.71f, 1142.39f, 1143.07f, 
1143.73f, 1144.38f, 1145.02f, 1145.64f, 1146.26f, 1146.86f, 1147.46f, 1148.04f, 
1148.60f, 1149.16f, 1149.70f, 1150.23f, 1150.75f, 1151.25f, 1151.74f, 1152.22f, 
1152.68f, 1153.13f, 1153.57f, 1153.99f, 1154.40f, 1154.79f, 1155.18f, 1155.54f, 
1155.90f, 1156.24f, 1156.56f, 1156.88f, 1157.17f, 1157.46f, 1157.72f, 1157.98f, 
1158.22f, 1158.45f, 1158.66f, 1158.85f, 1159.04f, 1159.20f, 1159.36f, 1159.50f, 
1159.62f, 1159.73f, 1159.83f, 1159.91f, 1159.97f, 1160.02f, 1160.06f, 1160.08f, 
1160.09f,  			// 450km
  54.67f,   55.06f,   56.19f,   58.01f,   60.47f,   63.48f,   66.98f,   70.87f, 
  75.09f,   79.59f,   84.31f,   89.21f,   94.25f,   99.41f,  104.66f,  109.98f, 
 115.35f,  120.75f,  126.17f,  131.61f,  137.05f,  142.49f,  147.93f,  153.36f, 
 158.79f,  164.20f,  169.61f,  175.00f,  180.37f,  185.73f,  191.06f,  196.38f, 
 201.68f,  206.95f,  212.21f,  217.43f,  222.63f,  227.57f,  232.15f,  236.73f, 
 241.29f,  245.85f,  250.40f,  254.94f,  259.46f,  263.98f,  268.48f,  272.96f, 
 277.43f,  281.88f,  286.33f,  290.76f,  295.19f,  299.61f,  304.01f,  308.41f, 
 312.80f,  317.18f,  321.55f,  325.90f,  330.25f,  334.58f,  338.90f,  343.20f, 
 347.49f,  351.77f,  356.03f,  360.28f,  364.51f,  368.73f,  372.93f,  377.12f, 
 381.29f,  385.45f,  389.59f,  393.71f,  397.82f,  401.91f,  405.99f,  410.05f, 
 414.09f,  418.12f,  422.12f,  426.12f,  430.09f,  434.05f,  438.00f,  441.92f, 
 445.83f,  449.72f,  453.60f,  457.45f,  461.29f,  465.12f,  468.92f,  472.71f, 
 476.48f,  480.24f,  483.97f,  487.69f,  491.39f,  495.08f,  498.74f,  502.39f, 
 506.03f,  509.64f,  513.24f,  516.82f,  520.38f,  523.93f,  527.46f,  530.97f, 
 534.46f,  537.94f,  541.40f,  544.84f,  548.26f,  551.67f,  555.06f,  558.43f, 
 561.78f,  565.12f,  568.44f,  571.74f,  575.02f,  578.29f,  581.54f,  584.77f, 
 587.98f,  591.18f,  594.36f,  597.52f,  600.66f,  603.79f,  606.90f,  609.99f, 
 613.06f,  616.12f,  619.15f,  622.17f,  625.18f,  628.16f,  631.13f,  634.08f, 
 637.01f,  639.92f,  642.81f,  645.69f,  648.55f,  651.39f,  654.21f,  657.02f, 
 659.80f,  662.57f,  665.32f,  668.05f,  670.76f,  673.46f,  676.13f,  678.79f, 
 681.43f,  684.05f,  686.65f,  689.24f,  691.80f,  694.34f,  696.87f,  699.37f, 
 701.86f,  704.33f,  706.78f,  709.21f,  711.61f,  713.98f,  716.34f,  718.69f, 
 721.03f,  723.37f,  725.69f,  728.01f,  730.33f,  732.63f,  734.94f,  737.24f, 
 739.53f,  741.82f,  744.10f,  746.38f,  748.65f,  750.91f,  753.17f,  755.41f, 
 757.65f,  759.88f,  762.10f,  764.32f,  766.54f,  768.76f,  770.98f,  773.20f, 
 775.42f,  777.64f,  779.86f,  782.08f,  784.30f,  786.52f,  788.74f,  790.96f, 
 793.18f,  795.40f,  797.62f,  799.84f,  802.05f,  804.27f,  806.49f,  808.71f, 
 810.93f,  813.15f,  815.37f,  817.59f,  819.81f,  822.03f,  824.25f,  826.47f, 
 828.69f,  830.91f,  833.13f,  835.35f,  837.57f,  839.79f,  842.00f, 1069.64f, 
1070.60f, 1071.56f, 1072.51f, 1073.47f, 1074.43f, 1075.38f, 1076.34f, 1077.30f, 
1078.25f, 1079.21f, 1080.16f, 1081.12f, 1082.07f, 1083.02f, 1083.98f, 1084.93f, 
1085.88f, 1086.83f, 1087.78f, 1088.73f, 1089.68f, 1090.63f, 1091.58f, 1092.53f, 
1093.47f, 1094.42f, 1095.36f, 1096.30f, 1097.24f, 1098.18f, 1099.12f, 1100.06f, 
1100.99f, 1101.93f, 1102.86f, 1103.79f, 1104.72f, 1105.64f, 1106.57f, 1107.49f, 
1108.41f, 1109.32f, 1110.24f, 1111.15f, 1112.06f, 1112.96f, 1113.87f, 1114.76f, 
1115.66f, 1116.55f, 1117.44f, 1118.32f, 1119.20f, 1120.08f, 1120.94f, 1119.79f, 
1121.46f, 1123.06f, 1124.37f, 1125.21f, 1126.05f, 1126.88f, 1127.70f, 1128.52f, 
1129.33f, 1130.13f, 1130.93f, 1131.71f, 1132.49f, 1133.26f, 1134.02f, 1134.77f, 
1135.52f, 1136.25f, 1136.97f, 1137.69f, 1138.39f, 1139.09f, 1139.77f, 1140.44f, 
1141.10f, 1141.75f, 1142.39f, 1143.02f, 1143.63f, 1144.24f, 1144.83f, 1145.41f, 
1145.97f, 1146.53f, 1147.07f, 1147.60f, 1148.11f, 1148.61f, 1149.10f, 1149.58f, 
1150.04f, 1150.49f, 1150.93f, 1151.35f, 1151.76f, 1152.16f, 1152.54f, 1152.90f, 
1153.26f, 1153.60f, 1153.92f, 1154.23f, 1154.53f, 1154.81f, 1155.08f, 1155.34f, 
1155.58f, 1155.80f, 1156.01f, 1156.21f, 1156.39f, 1156.56f, 1156.71f, 1156.85f, 
1156.98f, 1157.09f, 1157.18f, 1157.26f, 1157.33f, 1157.38f, 1157.42f, 1157.44f, 
1157.44f,  			// 475km
  57.29f,   57.65f,   58.71f,   60.43f,   62.74f,   65.60f,   68.92f,   72.64f, 
  76.69f,   81.02f,   85.57f,   90.31f,   95.21f,  100.23f,  105.34f,  110.53f, 
 115.79f,  121.08f,  126.41f,  131.76f,  137.12f,  142.49f,  147.86f,  153.23f, 
 158.59f,  163.95f,  169.30f,  174.64f,  179.96f,  185.27f,  190.56f,  195.83f, 
 201.08f,  206.31f,  211.52f,  216.70f,  221.60f,  226.18f,  230.76f,  235.32f, 
 239.88f,  244.43f,  248.97f,  253.50f,  258.02f,  262.53f,  267.01f,  271.49f, 
 275.94f,  280.39f,  284.83f,  289.26f,  293.68f,  298.09f,  302.49f,  306.88f, 
 311.27f,  315.64f,  320.00f,  324.34f,  328.68f,  333.00f,  337.31f,  341.61f, 
 345.89f,  350.15f,  354.41f,  358.65f,  362.87f,  367.08f,  371.27f,  375.45f, 
 379.61f,  383.76f,  387.89f,  392.01f,  396.11f,  400.19f,  404.26f,  408.31f, 
 412.34f,  416.36f,  420.36f,  424.34f,  428.31f,  432.26f,  436.20f,  440.11f, 
 444.01f,  447.90f,  451.76f,  455.61f,  459.44f,  463.26f,  467.05f,  470.83f, 
 474.60f,  478.34f,  482.07f,  485.78f,  489.48f,  493.15f,  496.81f,  500.46f, 
 504.08f,  507.69f,  511.28f,  514.85f,  518.41f,  521.95f,  525.47f,  528.97f, 
 532.46f,  535.93f,  539.38f,  542.81f,  546.23f,  549.63f,  553.01f,  556.37f, 
 559.72f,  563.05f,  566.36f,  569.66f,  572.94f,  576.20f,  579.44f,  582.66f, 
 585.87f,  589.06f,  592.23f,  595.39f,  598.53f,  601.65f,  604.75f,  607.83f, 
 610.90f,  613.95f,  616.98f,  620.00f,  622.99f,  625.97f,  628.93f,  631.87f, 
 634.80f,  637.71f,  640.60f,  643.47f,  646.32f,  649.16f,  651.97f,  654.77f, 
 657.55f,  660.32f,  663.06f,  665.79f,  668.49f,  671.18f,  673.85f,  676.51f, 
 679.14f,  681.75f,  684.35f,  686.93f,  689.49f,  692.03f,  694.54f,  697.05f, 
 699.53f,  701.99f,  704.44f,  706.87f,  709.26f,  711.63f,  713.98f,  716.33f, 
 718.67f,  721.00f,  723.32f,  725.64f,  727.96f,  730.26f,  732.57f,  734.86f, 
 737.16f,  739.45f,  741.73f,  744.00f,  746.27f,  748.53f,  750.78f,  753.03f, 
 755.27f,  757.49f,  759.71f,  761.93f,  764.15f,  766.37f,  768.59f,  770.81f, 
 773.03f,  775.25f,  777.47f,  779.69f,  781.91f,  784.13f,  786.35f,  788.57f, 
 790.79f,  793.01f,  795.23f,  797.44f,  799.66f,  801.88f,  804.10f,  806.32f, 
 808.54f,  810.76f,  812.98f,  815.20f,  817.42f,  819.64f,  821.86f,  824.08f, 
 826.30f,  828.52f,  830.74f,  832.96f,  835.18f,  837.39f,  839.61f, 1067.06f, 
1068.02f, 1068.98f, 1069.93f, 1070.89f, 1071.85f, 1072.80f, 1073.76f, 1074.72f, 
1075.67f, 1076.63f, 1077.58f, 1078.54f, 1079.49f, 1080.44f, 1081.40f, 1082.35f, 
1083.30f, 1084.25f, 1085.20f, 1086.15f, 1087.10f, 1088.05f, 1089.00f, 1089.94f, 
1090.89f, 1091.83f, 1092.78f, 1093.72f, 1094.66f, 1095.60f, 1096.54f, 1097.47f, 
1098.41f, 1099.34f, 1100.27f, 1101.20f, 1102.13f, 1103.06f, 1103.98f, 1104.90f, 
1105.82f, 1106.74f, 1107.65f, 1108.56f, 1109.47f, 1110.38f, 1111.28f, 1112.18f, 
1113.07f, 1113.96f, 1114.85f, 1115.73f, 1116.61f, 1117.49f, 1118.36f, 1117.31f, 
1118.96f, 1120.55f, 1121.78f, 1122.62f, 1123.46f, 1124.29f, 1125.11f, 1125.93f, 
1126.74f, 1127.54f, 1128.33f, 1129.12f, 1129.90f, 1130.67f, 1131.43f, 1132.18f, 
1132.92f, 1133.65f, 1134.38f, 1135.09f, 1135.79f, 1136.49f, 1137.17f, 1137.84f, 
1138.50f, 1139.15f, 1139.79f, 1140.41f, 1141.03f, 1141.63f, 1142.22f, 1142.80f, 
1143.36f, 1143.92f, 1144.46f, 1144.99f, 1145.50f, 1146.00f, 1146.49f, 1146.97f, 
1147.43f, 1147.88f, 1148.32f, 1148.74f, 1149.15f, 1149.54f, 1149.92f, 1150.29f, 
1150.64f, 1150.98f, 1151.31f, 1151.62f, 1151.91f, 1152.20f, 1152.46f, 1152.72f, 
1152.96f, 1153.18f, 1153.39f, 1153.59f, 1153.77f, 1153.94f, 1154.09f, 1154.23f, 
1154.36f, 1154.47f, 1154.56f, 1154.64f, 1154.71f, 1154.76f, 1154.79f, 1154.82f, 
1154.82f,  			// 500km
  59.89f,   60.23f,   61.23f,   62.84f,   65.03f,   67.74f,   70.91f,   74.46f, 
  78.35f,   82.51f,   86.91f,   91.50f,   96.25f,  101.13f,  106.12f,  111.19f, 
 116.33f,  121.52f,  126.74f,  132.00f,  137.28f,  142.57f,  147.87f,  153.17f, 
 158.48f,  163.77f,  169.06f,  174.34f,  179.61f,  184.87f,  190.11f,  195.33f, 
 200.53f,  205.72f,  210.88f,  215.68f,  220.27f,  224.84f,  229.41f,  233.97f, 
 238.53f,  243.07f,  247.60f,  252.12f,  256.63f,  261.12f,  265.60f,  270.06f, 
 274.51f,  278.95f,  283.38f,  287.80f,  292.22f,  296.62f,  301.02f,  305.40f, 
 309.78f,  314.14f,  318.49f,  322.83f,  327.16f,  331.47f,  335.77f,  340.06f, 
 344.33f,  348.59f,  352.83f,  357.06f,  361.27f,  365.47f,  369.66f,  373.83f, 
 377.98f,  382.12f,  386.24f,  390.34f,  394.43f,  398.51f,  402.57f,  406.61f, 
 410.63f,  414.64f,  418.63f,  422.61f,  426.57f,  430.51f,  434.43f,  438.34f, 
 442.23f,  446.11f,  449.96f,  453.80f,  457.63f,  461.43f,  465.22f,  468.99f, 
 472.75f,  476.49f,  480.21f,  483.91f,  487.59f,  491.26f,  494.92f,  498.55f, 
 502.17f,  505.77f,  509.35f,  512.92f,  516.46f,  519.99f,  523.51f,  527.00f, 
 530.48f,  533.95f,  537.39f,  540.82f,  544.23f,  547.62f,  550.99f,  554.35f, 
 557.69f,  561.02f,  564.32f,  567.61f,  570.88f,  574.13f,  577.37f,  580.59f, 
 583.79f,  586.97f,  590.14f,  593.29f,  596.42f,  599.53f,  602.63f,  605.71f, 
 608.77f,  611.81f,  614.84f,  617.85f,  620.84f,  623.81f,  626.76f,  629.70f, 
 632.62f,  635.52f,  638.41f,  641.27f,  644.12f,  646.95f,  649.76f,  652.56f, 
 655.33f,  658.09f,  660.83f,  663.55f,  666.25f,  668.93f,  671.60f,  674.25f, 
 676.88f,  679.49f,  682.08f,  684.65f,  687.20f,  689.74f,  692.25f,  694.75f, 
 697.23f,  699.69f,  702.13f,  704.55f,  706.93f,  709.30f,  711.65f,  713.99f, 
 716.33f,  718.66f,  720.98f,  723.30f,  725.61f,  727.92f,  730.22f,  732.52f, 
 734.81f,  737.10f,  739.38f,  741.65f,  743.92f,  746.18f,  748.43f,  750.67f, 
 752.90f,  755.13f,  757.35f,  759.57f,  761.79f,  764.01f,  766.23f,  768.45f, 
 770.67f,  772.89f,  775.11f,  777.33f,  779.55f,  781.76f,  783.98f,  786.20f, 
 788.42f,  790.64f,  792.86f,  795.08f,  797.30f,  799.52f,  801.74f,  803.96f, 
 806.18f,  808.40f,  810.62f,  812.84f,  815.06f,  817.28f,  819.50f,  821.71f, 
 823.93f,  826.15f,  828.37f,  830.59f,  832.81f,  835.03f,  837.25f, 1064.51f, 
1065.46f, 1066.42f, 1067.38f, 1068.33f, 1069.29f, 1070.25f, 1071.20f, 1072.16f, 
1073.11f, 1074.07f, 1075.02f, 1075.98f, 1076.93f, 1077.89f, 1078.84f, 1079.79f, 
1080.74f, 1081.70f, 1082.65f, 1083.60f, 1084.54f, 1085.49f, 1086.44f, 1087.39f, 
1088.33f, 1089.28f, 1090.22f, 1091.16f, 1092.10f, 1093.04f, 1093.98f, 1094.92f, 
1095.85f, 1096.78f, 1097.72f, 1098.65f, 1099.57f, 1100.50f, 1101.42f, 1102.34f, 
1103.26f, 1104.18f, 1105.09f, 1106.00f, 1106.91f, 1107.82f, 1108.72f, 1109.62f, 
1110.51f, 1111.40f, 1112.29f, 1113.17f, 1114.05f, 1114.92f, 1115.79f, 1114.84f, 
1116.48f, 1118.06f, 1119.22f, 1120.06f, 1120.89f, 1121.72f, 1122.55f, 1123.36f, 
1124.17f, 1124.97f, 1125.76f, 1126.55f, 1127.33f, 1128.09f, 1128.85f, 1129.60f, 
1130.35f, 1131.08f, 1131.80f, 1132.51f, 1133.22f, 1133.91f, 1134.59f, 1135.26f, 
1135.92f, 1136.57f, 1137.21f, 1137.83f, 1138.45f, 1139.05f, 1139.64f, 1140.21f, 
1140.78f, 1141.33f, 1141.87f, 1142.40f, 1142.91f, 1143.42f, 1143.90f, 1144.38f, 
1144.84f, 1145.29f, 1145.73f, 1146.15f, 1146.56f, 1146.95f, 1147.33f, 1147.70f, 
1148.05f, 1148.39f, 1148.71f, 1149.02f, 1149.32f, 1149.60f, 1149.87f, 1150.12f, 
1150.36f, 1150.59f, 1150.80f, 1150.99f, 1151.18f, 1151.34f, 1151.50f, 1151.63f, 
1151.76f, 1151.87f, 1151.96f, 1152.04f, 1152.11f, 1152.16f, 1152.19f, 1152.22f, 
1152.22f,  			// 525km
  62.47f,   62.79f,   63.73f,   65.25f,   67.33f,   69.90f,   72.92f,   76.32f, 
  80.05f,   84.06f,   88.31f,   92.75f,   97.36f,  102.11f,  106.97f,  111.92f, 
 116.95f,  122.03f,  127.17f,  132.33f,  137.52f,  142.74f,  147.96f,  153.19f, 
 158.43f,  163.66f,  168.89f,  174.11f,  179.32f,  184.53f,  189.71f,  194.88f, 
 200.04f,  205.17f,  209.83f,  214.41f,  218.99f,  223.56f,  228.12f,  232.68f, 
 237.22f,  241.75f,  246.28f,  250.79f,  255.28f,  259.76f,  264.23f,  268.68f, 
 273.12f,  277.56f,  281.98f,  286.40f,  290.80f,  295.20f,  299.59f,  303.97f, 
 308.33f,  312.69f,  317.03f,  321.36f,  325.68f,  329.98f,  334.27f,  338.55f, 
 342.81f,  347.06f,  351.30f,  355.52f,  359.72f,  363.91f,  368.09f,  372.24f, 
 376.39f,  380.51f,  384.63f,  388.72f,  392.80f,  396.87f,  400.92f,  404.95f, 
 408.96f,  412.96f,  416.94f,  420.91f,  424.86f,  428.79f,  432.71f,  436.61f, 
 440.49f,  444.35f,  448.20f,  452.03f,  455.85f,  459.65f,  463.43f,  467.19f, 
 470.93f,  474.66f,  478.38f,  482.07f,  485.75f,  489.41f,  493.05f,  496.68f, 
 500.29f,  503.88f,  507.46f,  511.01f,  514.55f,  518.08f,  521.58f,  525.07f, 
 528.54f,  532.00f,  535.44f,  538.86f,  542.26f,  545.64f,  549.01f,  552.36f, 
 555.70f,  559.01f,  562.31f,  565.59f,  568.86f,  572.10f,  575.33f,  578.54f, 
 581.74f,  584.92f,  588.08f,  591.22f,  594.34f,  597.45f,  600.54f,  603.61f, 
 606.67f,  609.71f,  612.73f,  615.73f,  618.71f,  621.68f,  624.63f,  627.56f, 
 630.47f,  633.37f,  636.25f,  639.11f,  641.95f,  644.77f,  647.58f,  650.37f, 
 653.14f,  655.89f,  658.62f,  661.34f,  664.04f,  666.71f,  669.37f,  672.02f, 
 674.64f,  677.25f,  679.83f,  682.40f,  684.95f,  687.47f,  689.98f,  692.47f, 
 694.95f,  697.41f,  699.84f,  702.25f,  704.63f,  706.99f,  709.34f,  711.69f, 
 714.02f,  716.35f,  718.67f,  720.99f,  723.30f,  725.60f,  727.90f,  730.20f, 
 732.49f,  734.77f,  737.05f,  739.33f,  741.59f,  743.85f,  746.10f,  748.34f, 
 750.57f,  752.79f,  755.01f,  757.23f,  759.45f,  761.67f,  763.89f,  766.11f, 
 768.33f,  770.55f,  772.77f,  774.99f,  777.21f,  779.43f,  781.65f,  783.87f, 
 786.09f,  788.31f,  790.53f,  792.74f,  794.96f,  797.18f,  799.40f,  801.62f, 
 803.84f,  806.06f,  808.28f,  810.50f,  812.72f,  814.94f,  817.16f,  819.38f, 
 821.60f,  823.82f,  826.04f,  828.26f,  830.48f,  832.69f,  834.91f, 1061.97f, 
1062.93f, 1063.89f, 1064.84f, 1065.80f, 1066.76f, 1067.71f, 1068.67f, 1069.63f, 
1070.58f, 1071.54f, 1072.49f, 1073.45f, 1074.40f, 1075.35f, 1076.31f, 1077.26f, 
1078.21f, 1079.16f, 1080.11f, 1081.06f, 1082.01f, 1082.96f, 1083.91f, 1084.85f, 
1085.80f, 1086.74f, 1087.68f, 1088.63f, 1089.57f, 1090.51f, 1091.44f, 1092.38f, 
1093.32f, 1094.25f, 1095.18f, 1096.11f, 1097.04f, 1097.96f, 1098.89f, 1099.81f, 
1100.73f, 1101.64f, 1102.56f, 1103.47f, 1104.37f, 1105.28f, 1106.18f, 1107.08f, 
1107.97f, 1108.86f, 1109.75f, 1110.63f, 1111.51f, 1112.38f, 1113.25f, 1112.40f, 
1114.03f, 1115.60f, 1116.67f, 1117.51f, 1118.35f, 1119.18f, 1120.00f, 1120.82f, 
1121.62f, 1122.42f, 1123.22f, 1124.00f, 1124.78f, 1125.55f, 1126.30f, 1127.05f, 
1127.80f, 1128.53f, 1129.25f, 1129.96f, 1130.66f, 1131.35f, 1132.03f, 1132.70f, 
1133.36f, 1134.01f, 1134.65f, 1135.27f, 1135.89f, 1136.49f, 1137.08f, 1137.65f, 
1138.22f, 1138.77f, 1139.31f, 1139.84f, 1140.35f, 1140.85f, 1141.34f, 1141.81f, 
1142.28f, 1142.72f, 1143.16f, 1143.58f, 1143.99f, 1144.38f, 1144.76f, 1145.13f, 
1145.48f, 1145.82f, 1146.14f, 1146.45f, 1146.75f, 1147.03f, 1147.30f, 1147.55f, 
1147.79f, 1148.01f, 1148.22f, 1148.42f, 1148.60f, 1148.77f, 1148.92f, 1149.06f, 
1149.18f, 1149.29f, 1149.39f, 1149.47f, 1149.53f, 1149.58f, 1149.62f, 1149.64f, 
1149.65f,  			// 550km
  65.02f,   65.32f,   66.21f,   67.66f,   69.62f,   72.07f,   74.95f,   78.21f, 
  81.79f,   85.65f,   89.76f,   94.06f,   98.54f,  103.16f,  107.89f,  112.73f, 
 117.65f,  122.63f,  127.66f,  132.73f,  137.84f,  142.97f,  148.12f,  153.27f, 
 158.44f,  163.61f,  168.77f,  173.93f,  179.09f,  184.23f,  189.37f,  194.49f, 
 199.44f,  204.03f,  208.62f,  213.20f,  217.77f,  222.34f,  226.89f,  231.44f, 
 235.97f,  240.49f,  245.01f,  249.51f,  253.99f,  258.45f,  262.91f,  267.35f, 
 271.79f,  276.21f,  280.63f,  285.04f,  289.44f,  293.83f,  298.21f,  302.58f, 
 306.94f,  311.28f,  315.62f,  319.94f,  324.25f,  328.54f,  332.82f,  337.09f, 
 341.34f,  345.58f,  349.80f,  354.01f,  358.21f,  362.39f,  366.55f,  370.70f, 
 374.83f,  378.95f,  383.05f,  387.14f,  391.21f,  395.27f,  399.30f,  403.33f, 
 407.33f,  411.32f,  415.29f,  419.25f,  423.19f,  427.11f,  431.02f,  434.91f, 
 438.78f,  442.64f,  446.48f,  450.30f,  454.10f,  457.89f,  461.66f,  465.42f, 
 469.16f,  472.88f,  476.58f,  480.27f,  483.94f,  487.59f,  491.22f,  494.84f, 
 498.44f,  502.03f,  505.59f,  509.14f,  512.68f,  516.19f,  519.69f,  523.17f, 
 526.64f,  530.08f,  533.51f,  536.93f,  540.32f,  543.70f,  547.06f,  550.40f, 
 553.73f,  557.04f,  560.33f,  563.61f,  566.86f,  570.10f,  573.33f,  576.53f, 
 579.72f,  582.89f,  586.04f,  589.18f,  592.30f,  595.40f,  598.48f,  601.55f, 
 604.60f,  607.63f,  610.64f,  613.64f,  616.62f,  619.58f,  622.52f,  625.45f, 
 628.35f,  631.24f,  634.12f,  636.97f,  639.81f,  642.62f,  645.43f,  648.21f, 
 650.97f,  653.72f,  656.45f,  659.16f,  661.85f,  664.52f,  667.18f,  669.81f, 
 672.43f,  675.03f,  677.61f,  680.17f,  682.72f,  685.24f,  687.74f,  690.23f, 
 692.70f,  695.15f,  697.58f,  699.98f,  702.36f,  704.71f,  707.06f,  709.40f, 
 711.74f,  714.06f,  716.38f,  718.70f,  721.01f,  723.31f,  725.61f,  727.91f, 
 730.20f,  732.48f,  734.76f,  737.03f,  739.29f,  741.55f,  743.79f,  746.03f, 
 748.26f,  750.48f,  752.70f,  754.92f,  757.14f,  759.36f,  761.58f,  763.80f, 
 766.02f,  768.24f,  770.46f,  772.68f,  774.90f,  777.12f,  779.34f,  781.56f, 
 783.78f,  786.00f,  788.22f,  790.43f,  792.65f,  794.87f,  797.09f,  799.31f, 
 801.53f,  803.75f,  805.97f,  808.19f,  810.41f,  812.63f,  814.85f,  817.07f, 
 819.29f,  821.51f,  823.73f,  825.95f,  828.17f,  830.38f,  832.60f, 1059.46f, 
1060.42f, 1061.38f, 1062.33f, 1063.29f, 1064.25f, 1065.20f, 1066.16f, 1067.12f, 
1068.07f, 1069.03f, 1069.98f, 1070.93f, 1071.89f, 1072.84f, 1073.79f, 1074.75f, 
1075.70f, 1076.65f, 1077.60f, 1078.55f, 1079.50f, 1080.45f, 1081.39f, 1082.34f, 
1083.29f, 1084.23f, 1085.17f, 1086.11f, 1087.05f, 1087.99f, 1088.93f, 1089.87f, 
1090.80f, 1091.74f, 1092.67f, 1093.60f, 1094.52f, 1095.45f, 1096.37f, 1097.29f, 
1098.21f, 1099.13f, 1100.04f, 1100.95f, 1101.86f, 1102.76f, 1103.66f, 1104.56f, 
1105.46f, 1106.35f, 1107.23f, 1108.11f, 1108.99f, 1109.86f, 1110.73f, 1109.97f, 
1111.60f, 1113.17f, 1114.15f, 1114.99f, 1115.83f, 1116.66f, 1117.48f, 1118.29f, 
1119.10f, 1119.90f, 1120.69f, 1121.48f, 1122.25f, 1123.02f, 1123.78f, 1124.53f, 
1125.27f, 1126.00f, 1126.72f, 1127.43f, 1128.13f, 1128.82f, 1129.50f, 1130.17f, 
1130.83f, 1131.48f, 1132.11f, 1132.74f, 1133.35f, 1133.95f, 1134.54f, 1135.11f, 
1135.68f, 1136.23f, 1136.77f, 1137.30f, 1137.81f, 1138.31f, 1138.80f, 1139.27f, 
1139.73f, 1140.18f, 1140.61f, 1141.03f, 1141.44f, 1141.83f, 1142.21f, 1142.58f, 
1142.93f, 1143.27f, 1143.59f, 1143.90f, 1144.20f, 1144.48f, 1144.74f, 1145.00f, 
1145.24f, 1145.46f, 1145.67f, 1145.87f, 1146.05f, 1146.21f, 1146.37f, 1146.50f, 
1146.63f, 1146.74f, 1146.83f, 1146.91f, 1146.98f, 1147.03f, 1147.06f, 1147.09f, 
1147.09f,  			// 575km
  67.55f,   67.84f,   68.68f,   70.05f,   71.92f,   74.25f,   77.01f,   80.13f, 
  83.57f,   87.29f,   91.25f,   95.42f,   99.77f,  104.26f,  108.88f,  113.60f, 
 118.41f,  123.28f,  128.22f,  133.20f,  138.22f,  143.27f,  148.33f,  153.42f, 
 158.51f,  163.61f,  168.72f,  173.82f,  178.91f,  184.00f,  189.08f,  193.72f, 
 198.31f,  202.90f,  207.48f,  212.05f,  216.61f,  221.17f,  225.71f,  230.25f, 
 234.77f,  239.29f,  243.79f,  248.27f,  252.74f,  257.20f,  261.64f,  266.08f, 
 270.51f,  274.92f,  279.33f,  283.74f,  288.13f,  292.51f,  296.88f,  301.24f, 
 305.59f,  309.93f,  314.25f,  318.56f,  322.86f,  327.14f,  331.41f,  335.67f, 
 339.91f,  344.14f,  348.36f,  352.56f,  356.74f,  360.91f,  365.06f,  369.20f, 
 373.32f,  377.43f,  381.52f,  385.60f,  389.66f,  393.70f,  397.73f,  401.74f, 
 405.74f,  409.72f,  413.68f,  417.63f,  421.56f,  425.47f,  429.37f,  433.25f, 
 437.11f,  440.96f,  444.79f,  448.60f,  452.40f,  456.18f,  459.94f,  463.68f, 
 467.41f,  471.12f,  474.82f,  478.50f,  482.16f,  485.80f,  489.43f,  493.04f, 
 496.63f,  500.21f,  503.77f,  507.31f,  510.83f,  514.34f,  517.83f,  521.30f, 
 524.76f,  528.20f,  531.62f,  535.03f,  538.42f,  541.79f,  545.14f,  548.48f, 
 551.80f,  555.10f,  558.38f,  561.65f,  564.90f,  568.13f,  571.35f,  574.55f, 
 577.73f,  580.89f,  584.04f,  587.17f,  590.28f,  593.37f,  596.45f,  599.51f, 
 602.55f,  605.58f,  608.59f,  611.58f,  614.55f,  617.50f,  620.44f,  623.36f, 
 626.26f,  629.15f,  632.01f,  634.86f,  637.69f,  640.50f,  643.30f,  646.08f, 
 648.83f,  651.57f,  654.30f,  657.00f,  659.69f,  662.36f,  665.01f,  667.64f, 
 670.25f,  672.84f,  675.42f,  677.97f,  680.51f,  683.03f,  685.53f,  688.01f, 
 690.48f,  692.92f,  695.35f,  697.74f,  700.11f,  702.46f,  704.81f,  707.15f, 
 709.48f,  711.81f,  714.12f,  716.44f,  718.74f,  721.05f,  723.35f,  725.64f, 
 727.93f,  730.21f,  732.49f,  734.75f,  737.02f,  739.27f,  741.51f,  743.75f, 
 745.98f,  748.20f,  750.42f,  752.64f,  754.86f,  757.08f,  759.30f,  761.52f, 
 763.74f,  765.96f,  768.18f,  770.40f,  772.61f,  774.83f,  777.05f,  779.27f, 
 781.49f,  783.71f,  785.93f,  788.15f,  790.37f,  792.59f,  794.81f,  797.03f, 
 799.25f,  801.47f,  803.69f,  805.91f,  808.13f,  810.35f,  812.57f,  814.78f, 
 817.00f,  819.22f,  821.44f,  823.66f,  825.88f,  828.10f,  830.32f, 1056.97f, 
1057.93f, 1058.89f, 1059.85f, 1060.80f, 1061.76f, 1062.71f, 1063.67f, 1064.63f, 
1065.58f, 1066.54f, 1067.49f, 1068.45f, 1069.40f, 1070.35f, 1071.31f, 1072.26f, 
1073.21f, 1074.16f, 1075.11f, 1076.06f, 1077.01f, 1077.96f, 1078.90f, 1079.85f, 
1080.80f, 1081.74f, 1082.68f, 1083.62f, 1084.56f, 1085.50f, 1086.44f, 1087.38f, 
1088.31f, 1089.25f, 1090.18f, 1091.11f, 1092.03f, 1092.96f, 1093.88f, 1094.80f, 
1095.72f, 1096.64f, 1097.55f, 1098.46f, 1099.37f, 1100.27f, 1101.17f, 1102.07f, 
1102.96f, 1103.85f, 1104.74f, 1105.62f, 1106.50f, 1107.37f, 1105.90f, 1107.58f, 
1109.19f, 1110.75f, 1111.66f, 1112.50f, 1113.33f, 1114.16f, 1114.98f, 1115.79f, 
1116.60f, 1117.40f, 1118.19f, 1118.97f, 1119.75f, 1120.51f, 1121.27f, 1122.02f, 
1122.76f, 1123.49f, 1124.21f, 1124.92f, 1125.62f, 1126.31f, 1126.99f, 1127.66f, 
1128.32f, 1128.96f, 1129.60f, 1130.22f, 1130.83f, 1131.43f, 1132.02f, 1132.60f, 
1133.16f, 1133.71f, 1134.25f, 1134.78f, 1135.29f, 1135.79f, 1136.27f, 1136.75f, 
1137.21f, 1137.66f, 1138.09f, 1138.51f, 1138.91f, 1139.31f, 1139.69f, 1140.05f, 
1140.40f, 1140.74f, 1141.06f, 1141.37f, 1141.67f, 1141.95f, 1142.22f, 1142.47f, 
1142.71f, 1142.93f, 1143.14f, 1143.34f, 1143.52f, 1143.68f, 1143.84f, 1143.97f, 
1144.10f, 1144.21f, 1144.30f, 1144.38f, 1144.44f, 1144.50f, 1144.53f, 1144.55f, 
1144.56f,  			// 600km
  70.07f,   70.34f,   71.14f,   72.44f,   74.22f,   76.44f,   79.07f,   82.06f, 
  85.37f,   88.96f,   92.79f,   96.83f,  101.05f,  105.42f,  109.92f,  114.53f, 
 119.23f,  124.00f,  128.84f,  133.73f,  138.66f,  143.62f,  148.61f,  153.62f, 
 158.64f,  163.67f,  168.71f,  173.75f,  178.78f,  183.46f,  188.06f,  192.65f, 
 197.24f,  201.82f,  206.39f,  210.95f,  215.51f,  220.05f,  224.59f,  229.12f, 
 233.63f,  238.13f,  242.62f,  247.08f,  251.54f,  255.99f,  260.43f,  264.85f, 
 269.27f,  273.69f,  278.09f,  282.48f,  286.87f,  291.24f,  295.60f,  299.95f, 
 304.29f,  308.62f,  312.93f,  317.23f,  321.52f,  325.79f,  330.05f,  334.30f, 
 338.53f,  342.75f,  346.95f,  351.14f,  355.31f,  359.47f,  363.61f,  367.74f, 
 371.85f,  375.95f,  380.03f,  384.10f,  388.15f,  392.18f,  396.20f,  400.20f, 
 404.18f,  408.15f,  412.11f,  416.04f,  419.96f,  423.87f,  427.75f,  431.62f, 
 435.48f,  439.31f,  443.14f,  446.94f,  450.73f,  454.50f,  458.25f,  461.98f, 
 465.70f,  469.41f,  473.09f,  476.76f,  480.41f,  484.05f,  487.67f,  491.27f, 
 494.85f,  498.42f,  501.97f,  505.51f,  509.02f,  512.52f,  516.00f,  519.47f, 
 522.92f,  526.35f,  529.76f,  533.16f,  536.54f,  539.91f,  543.25f,  546.58f, 
 549.89f,  553.19f,  556.46f,  559.72f,  562.97f,  566.19f,  569.40f,  572.59f, 
 575.77f,  578.93f,  582.07f,  585.19f,  588.29f,  591.38f,  594.45f,  597.51f, 
 600.54f,  603.56f,  606.56f,  609.54f,  612.51f,  615.46f,  618.39f,  621.30f, 
 624.20f,  627.08f,  629.94f,  632.78f,  635.60f,  638.41f,  641.20f,  643.97f, 
 646.72f,  649.46f,  652.18f,  654.87f,  657.55f,  660.22f,  662.86f,  665.49f, 
 668.09f,  670.68f,  673.25f,  675.80f,  678.33f,  680.85f,  683.34f,  685.82f, 
 688.28f,  690.72f,  693.14f,  695.52f,  697.89f,  700.24f,  702.58f,  704.92f, 
 707.25f,  709.57f,  711.89f,  714.20f,  716.51f,  718.81f,  721.11f,  723.40f, 
 725.69f,  727.97f,  730.24f,  732.51f,  734.77f,  737.02f,  739.26f,  741.50f, 
 743.72f,  745.94f,  748.16f,  750.38f,  752.60f,  754.82f,  757.04f,  759.26f, 
 761.48f,  763.70f,  765.92f,  768.14f,  770.36f,  772.58f,  774.80f,  777.02f, 
 779.23f,  781.45f,  783.67f,  785.89f,  788.11f,  790.33f,  792.55f,  794.77f, 
 796.99f,  799.21f,  801.43f,  803.65f,  805.87f,  808.09f,  810.31f,  812.53f, 
 814.75f,  816.97f,  819.19f,  821.40f,  823.62f,  825.84f,  828.06f, 1054.51f, 
1055.47f, 1056.42f, 1057.38f, 1058.34f, 1059.29f, 1060.25f, 1061.20f, 1062.16f, 
1063.12f, 1064.07f, 1065.03f, 1065.98f, 1066.93f, 1067.89f, 1068.84f, 1069.79f, 
1070.74f, 1071.69f, 1072.64f, 1073.59f, 1074.54f, 1075.49f, 1076.44f, 1077.38f, 
1078.33f, 1079.27f, 1080.22f, 1081.16f, 1082.10f, 1083.04f, 1083.97f, 1084.91f, 
1085.84f, 1086.78f, 1087.71f, 1088.64f, 1089.56f, 1090.49f, 1091.41f, 1092.33f, 
1093.25f, 1094.17f, 1095.08f, 1095.99f, 1096.90f, 1097.80f, 1098.70f, 1099.60f, 
1100.49f, 1101.38f, 1102.26f, 1103.15f, 1104.02f, 1104.90f, 1103.53f, 1105.20f, 
1106.80f, 1108.33f, 1109.18f, 1110.02f, 1110.85f, 1111.68f, 1112.50f, 1113.31f, 
1114.12f, 1114.92f, 1115.71f, 1116.49f, 1117.27f, 1118.03f, 1118.79f, 1119.54f, 
1120.28f, 1121.01f, 1121.73f, 1122.43f, 1123.13f, 1123.82f, 1124.50f, 1125.17f, 
1125.83f, 1126.47f, 1127.11f, 1127.73f, 1128.34f, 1128.94f, 1129.53f, 1130.10f, 
1130.67f, 1131.22f, 1131.75f, 1132.28f, 1132.79f, 1133.29f, 1133.77f, 1134.25f, 
1134.71f, 1135.15f, 1135.59f, 1136.01f, 1136.41f, 1136.80f, 1137.18f, 1137.55f, 
1137.90f, 1138.23f, 1138.56f, 1138.87f, 1139.16f, 1139.44f, 1139.71f, 1139.96f, 
1140.20f, 1140.42f, 1140.63f, 1140.83f, 1141.01f, 1141.17f, 1141.33f, 1141.46f, 
1141.59f, 1141.69f, 1141.79f, 1141.87f, 1141.93f, 1141.98f, 1142.02f, 1142.04f, 
1142.05f,  			// 625km
  72.56f,   72.81f,   73.58f,   74.82f,   76.51f,   78.63f,   81.15f,   84.02f, 
  87.21f,   90.67f,   94.37f,   98.28f,  102.38f,  106.63f,  111.01f,  115.51f, 
 120.10f,  124.77f,  129.51f,  134.31f,  139.15f,  144.03f,  148.94f,  153.88f, 
 158.82f,  163.79f,  168.67f,  173.28f,  177.88f,  182.48f,  187.07f,  191.66f, 
 196.23f,  200.81f,  205.37f,  209.92f,  214.47f,  219.00f,  223.53f,  228.04f, 
 232.54f,  237.02f,  241.49f,  245.95f,  250.40f,  254.84f,  259.27f,  263.69f, 
 268.10f,  272.50f,  276.90f,  281.28f,  285.66f,  290.02f,  294.37f,  298.71f, 
 303.04f,  307.35f,  311.66f,  315.95f,  320.22f,  324.48f,  328.73f,  332.97f, 
 337.19f,  341.40f,  345.59f,  349.77f,  353.93f,  358.07f,  362.21f,  366.32f, 
 370.42f,  374.51f,  378.58f,  382.63f,  386.67f,  390.70f,  394.70f,  398.69f, 
 402.67f,  406.63f,  410.57f,  414.50f,  418.41f,  422.30f,  426.18f,  430.04f, 
 433.88f,  437.71f,  441.52f,  445.31f,  449.09f,  452.85f,  456.59f,  460.32f, 
 464.03f,  467.72f,  471.40f,  475.06f,  478.70f,  482.33f,  485.94f,  489.53f, 
 493.11f,  496.67f,  500.21f,  503.74f,  507.24f,  510.74f,  514.21f,  517.67f, 
 521.11f,  524.53f,  527.94f,  531.33f,  534.70f,  538.06f,  541.39f,  544.72f, 
 548.02f,  551.31f,  554.58f,  557.83f,  561.07f,  564.28f,  567.49f,  570.67f, 
 573.84f,  576.99f,  580.12f,  583.24f,  586.34f,  589.42f,  592.48f,  595.53f, 
 598.56f,  601.57f,  604.56f,  607.54f,  610.50f,  613.44f,  616.37f,  619.27f, 
 622.16f,  625.04f,  627.89f,  630.73f,  633.54f,  636.34f,  639.13f,  641.89f, 
 644.64f,  647.37f,  650.08f,  652.77f,  655.45f,  658.10f,  660.74f,  663.36f, 
 665.96f,  668.55f,  671.11f,  673.66f,  676.18f,  678.69f,  681.18f,  683.65f, 
 686.11f,  688.54f,  690.95f,  693.33f,  695.69f,  698.04f,  700.38f,  702.72f, 
 705.04f,  707.37f,  709.68f,  711.99f,  714.30f,  716.60f,  718.89f,  721.18f, 
 723.47f,  725.75f,  728.02f,  730.29f,  732.54f,  734.79f,  737.03f,  739.27f, 
 741.49f,  743.71f,  745.93f,  748.15f,  750.37f,  752.59f,  754.81f,  757.03f, 
 759.25f,  761.47f,  763.69f,  765.91f,  768.13f,  770.34f,  772.56f,  774.78f, 
 777.00f,  779.22f,  781.44f,  783.66f,  785.88f,  788.10f,  790.32f,  792.54f, 
 794.76f,  796.98f,  799.20f,  801.42f,  803.64f,  805.86f,  808.08f,  810.29f, 
 812.51f,  814.73f,  816.95f,  819.17f,  821.39f,  823.61f,  825.83f, 1052.06f, 
1053.02f, 1053.98f, 1054.94f, 1055.89f, 1056.85f, 1057.80f, 1058.76f, 1059.72f, 
1060.67f, 1061.63f, 1062.58f, 1063.54f, 1064.49f, 1065.44f, 1066.40f, 1067.35f, 
1068.30f, 1069.25f, 1070.20f, 1071.15f, 1072.10f, 1073.05f, 1073.99f, 1074.94f, 
1075.88f, 1076.83f, 1077.77f, 1078.71f, 1079.65f, 1080.59f, 1081.53f, 1082.46f, 
1083.40f, 1084.33f, 1085.26f, 1086.19f, 1087.12f, 1088.04f, 1088.96f, 1089.88f, 
1090.80f, 1091.72f, 1092.63f, 1093.54f, 1094.45f, 1095.35f, 1096.25f, 1097.15f, 
1098.04f, 1098.93f, 1099.81f, 1100.69f, 1101.57f, 1102.44f, 1101.19f, 1102.84f, 
1104.44f, 1105.88f, 1106.72f, 1107.56f, 1108.40f, 1109.22f, 1110.04f, 1110.86f, 
1111.66f, 1112.46f, 1113.25f, 1114.03f, 1114.80f, 1115.57f, 1116.33f, 1117.07f, 
1117.81f, 1118.54f, 1119.26f, 1119.97f, 1120.67f, 1121.36f, 1122.03f, 1122.70f, 
1123.36f, 1124.00f, 1124.64f, 1125.26f, 1125.87f, 1126.47f, 1127.05f, 1127.63f, 
1128.19f, 1128.74f, 1129.28f, 1129.80f, 1130.31f, 1130.81f, 1131.30f, 1131.77f, 
1132.23f, 1132.67f, 1133.11f, 1133.52f, 1133.93f, 1134.32f, 1134.70f, 1135.06f, 
1135.41f, 1135.75f, 1136.07f, 1136.38f, 1136.67f, 1136.95f, 1137.22f, 1137.47f, 
1137.71f, 1137.93f, 1138.14f, 1138.34f, 1138.52f, 1138.68f, 1138.84f, 1138.97f, 
1139.10f, 1139.20f, 1139.30f, 1139.38f, 1139.44f, 1139.49f, 1139.53f, 1139.55f, 
1139.56f,  			// 650km
  75.03f,   75.27f,   76.00f,   77.18f,   78.80f,   80.82f,   83.24f,   85.99f, 
  89.06f,   92.40f,   95.98f,   99.77f,  103.74f,  107.88f,  112.15f,  116.53f, 
 121.02f,  125.60f,  130.24f,  134.95f,  139.70f,  144.50f,  149.33f,  153.95f, 
 158.57f,  163.17f,  167.78f,  172.38f,  176.97f,  181.56f,  186.15f,  190.72f, 
 195.29f,  199.85f,  204.41f,  208.95f,  213.48f,  218.01f,  222.52f,  227.02f, 
 231.50f,  235.97f,  240.43f,  244.87f,  249.31f,  253.74f,  258.16f,  262.57f, 
 266.98f,  271.37f,  275.76f,  280.13f,  284.50f,  288.85f,  293.19f,  297.52f, 
 301.83f,  306.14f,  310.43f,  314.71f,  318.97f,  323.22f,  327.46f,  331.69f, 
 335.89f,  340.09f,  344.27f,  348.44f,  352.59f,  356.72f,  360.84f,  364.95f, 
 369.04f,  373.11f,  377.17f,  381.21f,  385.24f,  389.25f,  393.25f,  397.23f, 
 401.19f,  405.14f,  409.07f,  412.99f,  416.89f,  420.77f,  424.64f,  428.49f, 
 432.32f,  436.14f,  439.94f,  443.72f,  447.49f,  451.24f,  454.97f,  458.69f, 
 462.39f,  466.08f,  469.74f,  473.39f,  477.03f,  480.65f,  484.25f,  487.83f, 
 491.40f,  494.95f,  498.48f,  502.00f,  505.50f,  508.98f,  512.45f,  515.90f, 
 519.33f,  522.74f,  526.14f,  529.52f,  532.89f,  536.24f,  539.57f,  542.88f, 
 546.18f,  549.46f,  552.72f,  555.97f,  559.19f,  562.41f,  565.60f,  568.78f, 
 571.94f,  575.08f,  578.21f,  581.32f,  584.41f,  587.48f,  590.54f,  593.58f, 
 596.60f,  599.61f,  602.59f,  605.56f,  608.52f,  611.45f,  614.37f,  617.27f, 
 620.16f,  623.02f,  625.87f,  628.70f,  631.51f,  634.31f,  637.08f,  639.84f, 
 642.58f,  645.31f,  648.01f,  650.70f,  653.37f,  656.02f,  658.65f,  661.26f, 
 663.86f,  666.44f,  669.00f,  671.54f,  674.06f,  676.56f,  679.04f,  681.51f, 
 683.96f,  686.39f,  688.79f,  691.16f,  693.52f,  695.87f,  698.21f,  700.54f, 
 702.86f,  705.18f,  707.50f,  709.81f,  712.11f,  714.41f,  716.71f,  719.00f, 
 721.28f,  723.56f,  725.83f,  728.09f,  730.35f,  732.59f,  734.83f,  737.06f, 
 739.28f,  741.50f,  743.72f,  745.94f,  748.16f,  750.38f,  752.60f,  754.82f, 
 757.04f,  759.26f,  761.48f,  763.70f,  765.92f,  768.14f,  770.36f,  772.58f, 
 774.80f,  777.02f,  779.24f,  781.45f,  783.67f,  785.89f,  788.11f,  790.33f, 
 792.55f,  794.77f,  796.99f,  799.21f,  801.43f,  803.65f,  805.87f,  808.09f, 
 810.31f,  812.53f,  814.75f,  816.97f,  819.19f,  821.40f,  823.62f, 1049.64f, 
1050.60f, 1051.56f, 1052.51f, 1053.47f, 1054.43f, 1055.38f, 1056.34f, 1057.29f, 
1058.25f, 1059.20f, 1060.16f, 1061.11f, 1062.07f, 1063.02f, 1063.97f, 1064.92f, 
1065.88f, 1066.83f, 1067.78f, 1068.73f, 1069.67f, 1070.62f, 1071.57f, 1072.51f, 
1073.46f, 1074.40f, 1075.35f, 1076.29f, 1077.23f, 1078.17f, 1079.10f, 1080.04f, 
1080.97f, 1081.90f, 1082.84f, 1083.76f, 1084.69f, 1085.62f, 1086.54f, 1087.46f, 
1088.38f, 1089.29f, 1090.20f, 1091.11f, 1092.02f, 1092.92f, 1093.82f, 1094.72f, 
1095.61f, 1096.50f, 1097.38f, 1098.26f, 1099.14f, 1100.01f, 1098.87f, 1100.51f, 
1102.10f, 1103.45f, 1104.29f, 1105.13f, 1105.96f, 1106.79f, 1107.61f, 1108.42f, 
1109.22f, 1110.02f, 1110.81f, 1111.59f, 1112.37f, 1113.13f, 1113.89f, 1114.63f, 
1115.37f, 1116.10f, 1116.82f, 1117.53f, 1118.22f, 1118.91f, 1119.59f, 1120.25f, 
1120.91f, 1121.55f, 1122.19f, 1122.81f, 1123.42f, 1124.02f, 1124.60f, 1125.18f, 
1125.74f, 1126.29f, 1126.82f, 1127.34f, 1127.86f, 1128.35f, 1128.84f, 1129.31f, 
1129.77f, 1130.21f, 1130.64f, 1131.06f, 1131.47f, 1131.86f, 1132.24f, 1132.60f, 
1132.95f, 1133.29f, 1133.61f, 1133.91f, 1134.21f, 1134.49f, 1134.75f, 1135.01f, 
1135.24f, 1135.47f, 1135.68f, 1135.87f, 1136.05f, 1136.22f, 1136.37f, 1136.50f, 
1136.63f, 1136.74f, 1136.83f, 1136.91f, 1136.97f, 1137.02f, 1137.06f, 1137.08f, 
1137.09f,  			// 675km
  77.39f,   77.63f,   78.32f,   79.45f,   80.99f,   82.93f,   85.23f,   87.88f, 
  90.82f,   94.04f,   97.49f,  101.15f,  105.00f,  109.01f,  113.15f,  117.41f, 
 121.77f,  126.20f,  130.70f,  135.25f,  139.82f,  144.40f,  148.99f,  153.58f, 
 158.17f,  162.76f,  167.34f,  171.92f,  176.49f,  181.06f,  185.63f,  190.18f, 
 194.73f,  199.27f,  203.80f,  208.32f,  212.84f,  217.34f,  221.82f,  226.30f, 
 230.76f,  235.21f,  239.65f,  244.09f,  248.51f,  252.93f,  257.34f,  261.74f, 
 266.13f,  270.51f,  274.88f,  279.24f,  283.59f,  287.93f,  292.26f,  296.57f, 
 300.87f,  305.16f,  309.44f,  313.70f,  317.95f,  322.19f,  326.41f,  330.62f, 
 334.82f,  339.00f,  343.16f,  347.31f,  351.45f,  355.57f,  359.68f,  363.77f, 
 367.85f,  371.91f,  375.95f,  379.98f,  384.00f,  388.00f,  391.98f,  395.95f, 
 399.90f,  403.83f,  407.75f,  411.66f,  415.54f,  419.41f,  423.27f,  427.11f, 
 430.93f,  434.74f,  438.53f,  442.30f,  446.05f,  449.79f,  453.52f,  457.22f, 
 460.91f,  464.59f,  468.25f,  471.89f,  475.51f,  479.12f,  482.71f,  486.28f, 
 489.84f,  493.38f,  496.90f,  500.41f,  503.90f,  507.38f,  510.83f,  514.27f, 
 517.70f,  521.10f,  524.49f,  527.87f,  531.22f,  534.56f,  537.88f,  541.19f, 
 544.48f,  547.75f,  551.00f,  554.24f,  557.46f,  560.66f,  563.85f,  567.02f, 
 570.17f,  573.31f,  576.43f,  579.53f,  582.61f,  585.68f,  588.73f,  591.76f, 
 594.78f,  597.77f,  600.76f,  603.72f,  606.66f,  609.59f,  612.50f,  615.40f, 
 618.27f,  621.13f,  623.97f,  626.80f,  629.60f,  632.39f,  635.16f,  637.92f, 
 640.65f,  643.37f,  646.07f,  648.75f,  651.41f,  654.05f,  656.68f,  659.29f, 
 661.88f,  664.45f,  667.00f,  669.53f,  672.05f,  674.54f,  677.02f,  679.49f, 
 681.93f,  684.35f,  686.74f,  689.11f,  691.46f,  693.81f,  696.15f,  698.48f, 
 700.80f,  703.12f,  705.43f,  707.74f,  710.04f,  712.34f,  714.63f,  716.92f, 
 719.20f,  721.48f,  723.75f,  726.01f,  728.26f,  730.51f,  732.74f,  734.97f, 
 737.19f,  739.41f,  741.63f,  743.85f,  746.07f,  748.29f,  750.51f,  752.73f, 
 754.95f,  757.17f,  759.39f,  761.61f,  763.83f,  766.05f,  768.27f,  770.49f, 
 772.71f,  774.92f,  777.14f,  779.36f,  781.58f,  783.80f,  786.02f,  788.24f, 
 790.46f,  792.68f,  794.90f,  797.12f,  799.34f,  801.56f,  803.78f,  806.00f, 
 808.22f,  810.44f,  812.66f,  814.87f,  817.09f,  819.31f,  821.53f, 1047.32f, 
1048.28f, 1049.23f, 1050.19f, 1051.15f, 1052.10f, 1053.06f, 1054.02f, 1054.97f, 
1055.93f, 1056.88f, 1057.84f, 1058.79f, 1059.75f, 1060.70f, 1061.65f, 1062.60f, 
1063.55f, 1064.51f, 1065.46f, 1066.40f, 1067.35f, 1068.30f, 1069.25f, 1070.19f, 
1071.14f, 1072.08f, 1073.02f, 1073.96f, 1074.90f, 1075.84f, 1076.78f, 1077.72f, 
1078.65f, 1079.58f, 1080.51f, 1081.44f, 1082.37f, 1083.29f, 1084.21f, 1085.13f, 
1086.05f, 1086.97f, 1087.88f, 1088.79f, 1089.69f, 1090.60f, 1091.49f, 1092.39f, 
1093.28f, 1094.17f, 1095.06f, 1095.94f, 1096.81f, 1097.68f, 1096.65f, 1098.28f, 
1099.86f, 1101.11f, 1101.96f, 1102.80f, 1103.63f, 1104.45f, 1105.27f, 1106.08f, 
1106.89f, 1107.69f, 1108.47f, 1109.25f, 1110.03f, 1110.79f, 1111.55f, 1112.29f, 
1113.03f, 1113.76f, 1114.47f, 1115.18f, 1115.88f, 1116.57f, 1117.24f, 1117.91f, 
1118.56f, 1119.21f, 1119.84f, 1120.46f, 1121.07f, 1121.66f, 1122.25f, 1122.82f, 
1123.38f, 1123.93f, 1124.47f, 1124.99f, 1125.50f, 1126.00f, 1126.48f, 1126.95f, 
1127.41f, 1127.85f, 1128.28f, 1128.70f, 1129.11f, 1129.50f, 1129.87f, 1130.24f, 
1130.59f, 1130.92f, 1131.24f, 1131.55f, 1131.84f, 1132.12f, 1132.39f, 1132.64f, 
1132.88f, 1133.10f, 1133.31f, 1133.50f, 1133.68f, 1133.85f, 1134.00f, 1134.14f, 
1134.26f, 1134.37f, 1134.46f, 1134.54f, 1134.60f, 1134.66f, 1134.69f, 1134.71f, 
1134.72f,  			// 700km
  79.70f,   79.92f,   80.58f,   81.65f,   83.13f,   84.98f,   87.18f,   89.72f, 
  92.55f,   95.64f,   98.97f,  102.51f,  106.23f,  110.10f,  114.12f,  118.25f, 
 122.49f,  126.80f,  131.18f,  135.62f,  140.09f,  144.59f,  149.11f,  153.64f, 
 158.18f,  162.72f,  167.26f,  171.80f,  176.34f,  180.87f,  185.40f,  189.92f, 
 194.44f,  198.95f,  203.45f,  207.94f,  212.42f,  216.89f,  221.35f,  225.80f, 
 230.24f,  234.67f,  239.09f,  243.51f,  247.92f,  252.32f,  256.72f,  261.10f, 
 265.48f,  269.84f,  274.19f,  278.54f,  282.87f,  287.19f,  291.50f,  295.80f, 
 300.08f,  304.35f,  308.61f,  312.86f,  317.09f,  321.31f,  325.52f,  329.71f, 
 333.89f,  338.05f,  342.20f,  346.34f,  350.46f,  354.56f,  358.66f,  362.73f, 
 366.79f,  370.84f,  374.87f,  378.89f,  382.89f,  386.87f,  390.84f,  394.79f, 
 398.73f,  402.65f,  406.56f,  410.45f,  414.32f,  418.18f,  422.03f,  425.85f, 
 429.66f,  433.45f,  437.23f,  440.99f,  444.74f,  448.46f,  452.18f,  455.87f, 
 459.55f,  463.21f,  466.86f,  470.49f,  474.10f,  477.70f,  481.28f,  484.84f, 
 488.39f,  491.92f,  495.43f,  498.93f,  502.41f,  505.87f,  509.32f,  512.75f, 
 516.17f,  519.56f,  522.94f,  526.31f,  529.65f,  532.98f,  536.30f,  539.59f, 
 542.87f,  546.14f,  549.38f,  552.61f,  555.82f,  559.02f,  562.20f,  565.36f, 
 568.50f,  571.63f,  574.74f,  577.83f,  580.91f,  583.97f,  587.01f,  590.03f, 
 593.04f,  596.03f,  599.01f,  601.96f,  604.90f,  607.82f,  610.73f,  613.61f, 
 616.48f,  619.33f,  622.17f,  624.98f,  627.78f,  630.56f,  633.33f,  636.07f, 
 638.80f,  641.51f,  644.20f,  646.88f,  649.53f,  652.17f,  654.79f,  657.39f, 
 659.98f,  662.54f,  665.09f,  667.62f,  670.12f,  672.61f,  675.09f,  677.55f, 
 679.98f,  682.39f,  684.77f,  687.14f,  689.49f,  691.83f,  694.17f,  696.50f, 
 698.82f,  701.14f,  703.45f,  705.75f,  708.05f,  710.35f,  712.64f,  714.93f, 
 717.21f,  719.48f,  721.75f,  724.01f,  726.26f,  728.50f,  730.74f,  732.96f, 
 735.18f,  737.40f,  739.62f,  741.84f,  744.06f,  746.28f,  748.50f,  750.72f, 
 752.94f,  755.16f,  757.38f,  759.60f,  761.82f,  764.04f,  766.25f,  768.47f, 
 770.69f,  772.91f,  775.13f,  777.35f,  779.57f,  781.79f,  784.01f,  786.23f, 
 788.45f,  790.67f,  792.89f,  795.11f,  797.33f,  799.55f,  801.77f,  803.99f, 
 806.21f,  808.42f,  810.64f,  812.86f,  815.08f,  817.30f,  819.52f, 1045.07f, 
1046.03f, 1046.98f, 1047.94f, 1048.90f, 1049.85f, 1050.81f, 1051.77f, 1052.72f, 
1053.68f, 1054.63f, 1055.59f, 1056.54f, 1057.49f, 1058.45f, 1059.40f, 1060.35f, 
1061.30f, 1062.25f, 1063.20f, 1064.15f, 1065.10f, 1066.05f, 1067.00f, 1067.94f, 
1068.89f, 1069.83f, 1070.77f, 1071.71f, 1072.65f, 1073.59f, 1074.53f, 1075.46f, 
1076.40f, 1077.33f, 1078.26f, 1079.19f, 1080.11f, 1081.04f, 1081.96f, 1082.88f, 
1083.80f, 1084.71f, 1085.62f, 1086.53f, 1087.44f, 1088.34f, 1089.24f, 1090.13f, 
1091.03f, 1091.91f, 1092.80f, 1093.68f, 1094.55f, 1092.82f, 1094.51f, 1096.12f, 
1097.69f, 1098.85f, 1099.70f, 1100.53f, 1101.37f, 1102.19f, 1103.01f, 1103.82f, 
1104.62f, 1105.42f, 1106.21f, 1106.99f, 1107.76f, 1108.52f, 1109.28f, 1110.02f, 
1110.76f, 1111.48f, 1112.20f, 1112.91f, 1113.60f, 1114.29f, 1114.97f, 1115.63f, 
1116.28f, 1116.93f, 1117.56f, 1118.18f, 1118.79f, 1119.38f, 1119.97f, 1120.54f, 
1121.10f, 1121.65f, 1122.18f, 1122.70f, 1123.21f, 1123.71f, 1124.19f, 1124.66f, 
1125.12f, 1125.56f, 1125.99f, 1126.41f, 1126.81f, 1127.20f, 1127.58f, 1127.94f, 
1128.29f, 1128.63f, 1128.95f, 1129.25f, 1129.55f, 1129.83f, 1130.09f, 1130.34f, 
1130.58f, 1130.80f, 1131.01f, 1131.20f, 1131.38f, 1131.55f, 1131.70f, 1131.84f, 
1131.96f, 1132.07f, 1132.16f, 1132.24f, 1132.30f, 1132.35f, 1132.39f, 1132.41f, 
1132.42f,  			// 725km
  81.98f,   82.20f,   82.83f,   83.85f,   85.26f,   87.03f,   89.14f,   91.58f, 
  94.30f,   97.28f,  100.49f,  103.91f,  107.51f,  111.27f,  115.17f,  119.18f, 
 123.30f,  127.51f,  131.78f,  136.12f,  140.50f,  144.92f,  149.36f,  153.82f, 
 158.30f,  162.78f,  167.27f,  171.77f,  176.26f,  180.76f,  185.25f,  189.73f, 
 194.21f,  198.68f,  203.14f,  207.60f,  212.05f,  216.49f,  220.93f,  225.36f, 
 229.78f,  234.20f,  238.60f,  243.00f,  247.40f,  251.78f,  256.15f,  260.52f, 
 264.88f,  269.22f,  273.56f,  277.88f,  282.19f,  286.50f,  290.79f,  295.07f, 
 299.33f,  303.59f,  307.83f,  312.06f,  316.27f,  320.47f,  324.66f,  328.84f, 
 333.00f,  337.15f,  341.28f,  345.40f,  349.50f,  353.59f,  357.67f,  361.73f, 
 365.78f,  369.81f,  373.82f,  377.82f,  381.81f,  385.78f,  389.73f,  393.67f, 
 397.60f,  401.51f,  405.40f,  409.27f,  413.14f,  416.98f,  420.81f,  424.62f, 
 428.42f,  432.20f,  435.96f,  439.71f,  443.44f,  447.16f,  450.86f,  454.54f, 
 458.21f,  461.86f,  465.50f,  469.12f,  472.72f,  476.30f,  479.87f,  483.43f, 
 486.96f,  490.48f,  493.99f,  497.47f,  500.94f,  504.40f,  507.84f,  511.26f, 
 514.66f,  518.05f,  521.42f,  524.77f,  528.11f,  531.43f,  534.74f,  538.02f, 
 541.29f,  544.55f,  547.78f,  551.00f,  554.21f,  557.39f,  560.56f,  563.72f, 
 566.85f,  569.97f,  573.07f,  576.16f,  579.23f,  582.28f,  585.31f,  588.33f, 
 591.33f,  594.31f,  597.28f,  600.23f,  603.16f,  606.07f,  608.97f,  611.85f, 
 614.71f,  617.55f,  620.38f,  623.19f,  625.98f,  628.76f,  631.51f,  634.25f, 
 636.97f,  639.68f,  642.36f,  645.03f,  647.68f,  650.31f,  652.92f,  655.52f, 
 658.10f,  660.66f,  663.19f,  665.71f,  668.22f,  670.70f,  673.17f,  675.62f, 
 678.05f,  680.45f,  682.83f,  685.18f,  687.53f,  689.88f,  692.21f,  694.54f, 
 696.86f,  699.17f,  701.48f,  703.79f,  706.09f,  708.38f,  710.67f,  712.96f, 
 715.23f,  717.51f,  719.77f,  722.03f,  724.27f,  726.51f,  728.75f,  730.97f, 
 733.19f,  735.41f,  737.63f,  739.85f,  742.07f,  744.29f,  746.51f,  748.73f, 
 750.95f,  753.17f,  755.38f,  757.60f,  759.82f,  762.04f,  764.26f,  766.48f, 
 768.70f,  770.92f,  773.14f,  775.36f,  777.58f,  779.80f,  782.02f,  784.24f, 
 786.46f,  788.68f,  790.90f,  793.12f,  795.34f,  797.55f,  799.77f,  801.99f, 
 804.21f,  806.43f,  808.65f,  810.87f,  813.09f,  815.31f,  817.53f, 1042.83f, 
1043.79f, 1044.75f, 1045.71f, 1046.66f, 1047.62f, 1048.58f, 1049.53f, 1050.49f, 
1051.44f, 1052.40f, 1053.35f, 1054.31f, 1055.26f, 1056.21f, 1057.16f, 1058.12f, 
1059.07f, 1060.02f, 1060.97f, 1061.92f, 1062.87f, 1063.81f, 1064.76f, 1065.70f, 
1066.65f, 1067.59f, 1068.53f, 1069.48f, 1070.41f, 1071.35f, 1072.29f, 1073.23f, 
1074.16f, 1075.09f, 1076.02f, 1076.95f, 1077.87f, 1078.80f, 1079.72f, 1080.64f, 
1081.56f, 1082.47f, 1083.38f, 1084.29f, 1085.20f, 1086.10f, 1087.00f, 1087.89f, 
1088.78f, 1089.67f, 1090.55f, 1091.43f, 1092.31f, 1090.71f, 1092.38f, 1093.98f, 
1095.55f, 1096.61f, 1097.45f, 1098.29f, 1099.12f, 1099.94f, 1100.76f, 1101.57f, 
1102.37f, 1103.17f, 1103.95f, 1104.73f, 1105.50f, 1106.27f, 1107.02f, 1107.77f, 
1108.50f, 1109.23f, 1109.94f, 1110.65f, 1111.34f, 1112.03f, 1112.70f, 1113.37f, 
1114.02f, 1114.66f, 1115.29f, 1115.91f, 1116.52f, 1117.11f, 1117.70f, 1118.27f, 
1118.83f, 1119.38f, 1119.91f, 1120.43f, 1120.94f, 1121.43f, 1121.92f, 1122.39f, 
1122.84f, 1123.29f, 1123.72f, 1124.13f, 1124.54f, 1124.92f, 1125.30f, 1125.66f, 
1126.01f, 1126.34f, 1126.66f, 1126.97f, 1127.26f, 1127.54f, 1127.81f, 1128.06f, 
1128.29f, 1128.52f, 1128.72f, 1128.92f, 1129.10f, 1129.26f, 1129.41f, 1129.55f, 
1129.67f, 1129.78f, 1129.87f, 1129.95f, 1130.02f, 1130.07f, 1130.10f, 1130.12f, 
1130.13f,  			// 750km
  84.26f,   84.46f,   85.06f,   86.05f,   87.39f,   89.09f,   91.11f,   93.45f, 
  96.07f,   98.94f,  102.04f,  105.35f,  108.84f,  112.48f,  116.27f,  120.18f, 
 124.20f,  128.30f,  132.48f,  136.72f,  141.01f,  145.34f,  149.71f,  154.10f, 
 158.51f,  162.94f,  167.37f,  171.82f,  176.26f,  180.71f,  185.16f,  189.60f, 
 194.04f,  198.48f,  202.91f,  207.34f,  211.76f,  216.18f,  220.59f,  225.00f, 
 229.40f,  233.80f,  238.18f,  242.56f,  246.94f,  251.30f,  255.65f,  260.00f, 
 264.33f,  268.66f,  272.97f,  277.28f,  281.57f,  285.85f,  290.12f,  294.38f, 
 298.63f,  302.86f,  307.09f,  311.30f,  315.49f,  319.68f,  323.85f,  328.01f, 
 332.15f,  336.28f,  340.39f,  344.50f,  348.58f,  352.66f,  356.72f,  360.76f, 
 364.79f,  368.81f,  372.81f,  376.79f,  380.76f,  384.72f,  388.66f,  392.58f, 
 396.49f,  400.39f,  404.27f,  408.13f,  411.98f,  415.81f,  419.62f,  423.42f, 
 427.21f,  430.97f,  434.73f,  438.46f,  442.18f,  445.89f,  449.57f,  453.25f, 
 456.90f,  460.54f,  464.16f,  467.77f,  471.36f,  474.94f,  478.50f,  482.04f, 
 485.56f,  489.07f,  492.57f,  496.04f,  499.50f,  502.95f,  506.37f,  509.78f, 
 513.18f,  516.56f,  519.92f,  523.26f,  526.59f,  529.90f,  533.20f,  536.47f, 
 539.74f,  542.98f,  546.21f,  549.42f,  552.61f,  555.79f,  558.95f,  562.10f, 
 565.23f,  568.34f,  571.43f,  574.51f,  577.57f,  580.61f,  583.64f,  586.65f, 
 589.64f,  592.61f,  595.57f,  598.51f,  601.44f,  604.34f,  607.23f,  610.10f, 
 612.96f,  615.80f,  618.62f,  621.42f,  624.20f,  626.97f,  629.72f,  632.45f, 
 635.17f,  637.86f,  640.54f,  643.20f,  645.84f,  648.47f,  651.08f,  653.66f, 
 656.23f,  658.79f,  661.32f,  663.83f,  666.33f,  668.81f,  671.27f,  673.72f, 
 676.14f,  678.53f,  680.90f,  683.25f,  685.60f,  687.94f,  690.27f,  692.59f, 
 694.91f,  697.23f,  699.53f,  701.84f,  704.13f,  706.43f,  708.72f,  711.00f, 
 713.28f,  715.55f,  717.81f,  720.06f,  722.31f,  724.55f,  726.78f,  729.00f, 
 731.22f,  733.44f,  735.66f,  737.87f,  740.09f,  742.31f,  744.53f,  746.75f, 
 748.97f,  751.19f,  753.41f,  755.63f,  757.85f,  760.07f,  762.29f,  764.51f, 
 766.73f,  768.95f,  771.17f,  773.39f,  775.61f,  777.83f,  780.04f,  782.26f, 
 784.48f,  786.70f,  788.92f,  791.14f,  793.36f,  795.58f,  797.80f,  800.02f, 
 802.24f,  804.46f,  806.68f,  808.90f,  811.12f,  813.34f,  815.56f, 1040.61f, 
1041.57f, 1042.53f, 1043.48f, 1044.44f, 1045.40f, 1046.35f, 1047.31f, 1048.27f, 
1049.22f, 1050.18f, 1051.13f, 1052.08f, 1053.04f, 1053.99f, 1054.94f, 1055.89f, 
1056.85f, 1057.80f, 1058.75f, 1059.70f, 1060.64f, 1061.59f, 1062.54f, 1063.48f, 
1064.43f, 1065.37f, 1066.31f, 1067.25f, 1068.19f, 1069.13f, 1070.07f, 1071.00f, 
1071.94f, 1072.87f, 1073.80f, 1074.72f, 1075.65f, 1076.57f, 1077.50f, 1078.41f, 
1079.33f, 1080.24f, 1081.16f, 1082.06f, 1082.97f, 1083.87f, 1084.77f, 1085.66f, 
1086.56f, 1087.44f, 1088.33f, 1089.20f, 1090.08f, 1088.60f, 1090.26f, 1091.86f, 
1093.41f, 1094.37f, 1095.22f, 1096.05f, 1096.88f, 1097.71f, 1098.52f, 1099.33f, 
1100.13f, 1100.93f, 1101.72f, 1102.49f, 1103.26f, 1104.03f, 1104.78f, 1105.52f, 
1106.26f, 1106.98f, 1107.70f, 1108.40f, 1109.10f, 1109.78f, 1110.46f, 1111.12f, 
1111.77f, 1112.41f, 1113.04f, 1113.66f, 1114.27f, 1114.86f, 1115.44f, 1116.01f, 
1116.57f, 1117.12f, 1117.65f, 1118.17f, 1118.68f, 1119.17f, 1119.66f, 1120.13f, 
1120.58f, 1121.02f, 1121.45f, 1121.87f, 1122.27f, 1122.66f, 1123.03f, 1123.40f, 
1123.74f, 1124.08f, 1124.40f, 1124.70f, 1124.99f, 1125.27f, 1125.54f, 1125.79f, 
1126.02f, 1126.24f, 1126.45f, 1126.65f, 1126.82f, 1126.99f, 1127.14f, 1127.28f, 
1127.40f, 1127.51f, 1127.60f, 1127.68f, 1127.74f, 1127.79f, 1127.83f, 1127.85f, 
1127.86f};
#endif
