
   /********************************************************************
    *                           remux_tbuf.c                           *
    *                                                                  *
    *      Reads a file of demultiplexed TYPE_TRACEBUF2 msgs -         *
    *  one that contains all msgs for a given SCNL, followed by all    * 
    *  msgs for the next SCNL, etc, as could be built from multiple    * 
    *  binary requests to wave_serverV.                                *
    *      Writes a new file containing all of the TRACEBUF2 messages  *
    *  arranged in chronological order. This new file can then be used *
    *  as input to tankplayer, allowing the QA of earthworm with data  *
    *  from wave_serverV. The data may not be in exactly the same      *
    *  order as it was originally, but it'll be close.                 *
    *                                                                  *  
    *  Command line arguments:                                         *
    *     arvg[1] = name of input file  (arranged by SCNL)             *
    *     argv[2] = name of output file (chronological)                *
    *                                                                  *
    *  Lynn Dietz  April 7, 1999                                       *
    ********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <trace_buf.h>
#include <earthworm.h>
#include <kom.h>
#include <swap.h>
#include <time_ew.h>

#include "remux.h"

main( int argc, char *argv[] )
{
  int           rc;

  logit_init("remux_tbuf", 0, 1024, 1);

  /* Check arguments
  *****************/
  if ( argc != 3 )
  {
    logit("et", "Usage: remux_tbuf <demuxed_file> <outputfile>\n" );
    return( 0 );
  }

  rc = remux_tracebufs(argv[1], argv[2], 0.0, 0.0);

  return( rc );
}
