/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import pickewanalysis.TracePanelMouseListener;
import pickewanalysis.VisiblePick;
import pickewanalysis.ewmessages.CodaSCNL;
import pickewanalysis.ewmessages.EWMessage;
import pickewanalysis.ewmessages.EWMessageGroup;
import pickewanalysis.ewmessages.PickSCNL;
import pickewanalysis.ewpicker.PickEWDebugMsg;
import pickewanalysis.ewpicker.PickEWStation;
import pickewanalysis.waveform.WaveForm;
import pickewanalysis.waveform.WaveFormGroup;

public class TracePanel
extends JPanel {
    BufferedImage traceImage = null;
    boolean requiresUpdate = true;
    private List<VisiblePick> visiblePicks;
    public long starttime;
    public long endtime;
    private WaveFormGroup[] groups;
    private EWMessageGroup msg;
    private PickEWStation station;
    private final double RAW_HEIGHT_RATIO = 0.15;
    private final double RDAT_HEIGHT_RATIO = 0.45;
    private final double STA_HEIGHT_RATIO = 0.15;
    private final double THRES_HEIGHT_RATIO = 0.25;

    public TracePanel() {
        this.initComponents();
        TracePanelMouseListener listener = new TracePanelMouseListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void setActiveWaveforms(WaveFormGroup waveGroup, WaveFormGroup rdatGroup, WaveFormGroup charGroup, WaveFormGroup ltaGroup, WaveFormGroup staGroup, WaveFormGroup staltaGroup) {
        this.groups[0] = waveGroup;
        this.groups[1] = rdatGroup;
        this.groups[2] = charGroup;
        this.groups[3] = ltaGroup;
        this.groups[4] = staGroup;
        this.groups[5] = staltaGroup;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.traceImage == null || this.getWidth() != this.traceImage.getWidth() || this.getHeight() != this.traceImage.getHeight() || this.requiresUpdate) {
            this.traceImage = this.produceTraceImage();
        }
        if (this.traceImage != null) {
            g.drawImage(this.traceImage, 0, 0, null);
        }
        this.requiresUpdate = false;
        ((TracePanelMouseListener)this.getMouseListeners()[0]).drawBox((Graphics2D)g);
    }

    private BufferedImage produceTraceImage() {
        int ymax;
        int ymin;
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int xmin = 0;
        int xmax = this.getWidth();
        g.setFont(new Font("Tahoma", 0, 10));
        if (this.groups != null) {
            String fmt;
            this.visiblePicks = new ArrayList<VisiblePick>();
            ymin = 0;
            double d = this.getHeight();
            this.getClass();
            ymax = (int)(d * 0.15);
            this.plotTrace(g, this.groups[0], xmin, xmax, ymin, ymax, Color.BLACK, true);
            ymin = ymax;
            ymax = ymin + (int)((double)this.getHeight() * this.RDAT_HEIGHT_RATIO);
            this.plotTrace(g, this.groups[2], xmin, xmax, ymin, ymax, Color.LIGHT_GRAY, false);
            double[] plotParams = this.plotTrace(g, this.groups[1], xmin, xmax, ymin, ymax, Color.BLUE, true);
            int[] mpsPos = this.getPos(new double[]{0.0, this.station.MinPeakSize, 0.0, -this.station.MinPeakSize}, plotParams);
            g.setColor(Color.RED);
            g.drawLine(xmin, mpsPos[1] > ymin ? mpsPos[1] : ymin, xmax, mpsPos[1] > ymin ? mpsPos[1] : ymin);
            g.drawLine(xmin, mpsPos[3] < ymax ? mpsPos[3] : ymax, xmax, mpsPos[3] < ymax ? mpsPos[3] : ymax);
            PickSCNL last = null;
            for (EWMessage ewm : this.msg) {
                if (ewm.getType() <= 0) continue;
                if (ewm.getType() == 8) {
                    PickSCNL pick = (PickSCNL)ewm;
                    int[] pickPos = this.getPos(new double[]{pick.arrivalTime, 0.0}, plotParams);
                    g.setColor(Color.RED);
                    g.drawLine(pickPos[0], ymin, pickPos[0], ymax);
                    char motion = pick.FirstMotion != ' ' ? (char)pick.FirstMotion : (char)'?';
                    fmt = String.format(Locale.UK, "%c%1d", Character.valueOf(motion), pick.Weight);
                    g.drawString(fmt, pickPos[0] + 1, ymin + 12);
                    this.addToVisiblePicks(new VisiblePick(pick, new int[]{pickPos[0], ymin, ymax}));
                    last = pick;
                    continue;
                }
                if (ewm.getType() != 9) continue;
                CodaSCNL coda = (CodaSCNL)ewm;
                if (last == null) continue;
                double codaTime = last.arrivalTime + (double)Math.abs(coda.duration);
                int[] codaPos = this.getPos(new double[]{codaTime, 0.0}, plotParams);
                g.setColor(Color.GREEN);
                g.drawLine(codaPos[0], ymin, codaPos[0], ymax);
                this.addToVisiblePicks(new VisiblePick(coda, new int[]{codaPos[0], ymin, ymax}));
                int[] pickPos = this.getPos(new double[]{last.arrivalTime, 0.0}, plotParams);
                Rectangle rect = new Rectangle(pickPos[0] + 1, ymin, codaPos[0] - pickPos[0] - 1, ymax - ymin - 1);
                Composite originalComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g.setPaint(Color.GREEN);
                g.fill(rect);
                g.setComposite(originalComposite);
                String fmt2 = String.format(Locale.UK, "%3ds", coda.duration);
                g.setColor(new Color(0, 128, 0));
                g.drawString(fmt2, codaPos[0] + 1, ymin + 12);
                last = null;
            }
            ymin = ymax;
            double d2 = this.getHeight();
            this.getClass();
            ymax = ymin + (int)(d2 * 0.15);
            this.plotTrace(g, this.groups[3], xmin, xmax, ymin, ymax, Color.LIGHT_GRAY, false);
            this.plotTrace(g, this.groups[4], xmin, xmax, ymin, ymax, Color.DARK_GRAY, false);
            ymin = ymax;
            ymax = ymin + (int)((double)this.getHeight() * this.THRES_HEIGHT_RATIO);
            plotParams = this.plotTrace(g, this.groups[5], xmin, xmax, ymin, ymax, Color.LIGHT_GRAY, false);
            int[] thPos = this.getPos(new double[]{0.0, this.station.EventThresh}, plotParams);
            g.setColor(Color.RED);
            g.drawLine(xmin, thPos[1] > ymin ? thPos[1] : ymin, xmax, thPos[1] > ymin ? thPos[1] : ymin);
            for (EWMessage ewm : this.msg) {
                if (ewm.getType() >= 0) continue;
                PickEWDebugMsg fp = (PickEWDebugMsg)ewm;
                int[] pos = this.getPos(new double[]{(double)fp.getTime() / 1000.0, 0.0}, plotParams);
                g.setColor(new Color(128, 0, 0));
                g.drawLine(pos[0], ymin, pos[0], thPos[1]);
                this.addToVisiblePicks(new VisiblePick(fp, new int[]{pos[0], ymin, thPos[1]}));
                fmt = String.format(Locale.UK, "%d", -fp.getType());
                g.drawString(fmt, pos[0] + 1, ymin + 12);
            }
        }
        ymin = 0;
        double d = this.getHeight();
        this.getClass();
        ymax = (int)(d * 0.15);
        g.setColor(Color.BLACK);
        g.drawRect(xmin, ymin, xmax - xmin - 1, ymax - ymin);
        g.setColor(Color.BLACK);
        g.drawString("Raw Trace", xmin + 2, ymin + 10);
        ymin = ymax;
        ymax = ymin + (int)((double)this.getHeight() * this.RDAT_HEIGHT_RATIO);
        g.setColor(Color.BLACK);
        g.drawRect(xmin, ymin, xmax - xmin - 1, ymax - ymin);
        g.setColor(Color.BLUE);
        g.drawString("High-Pass Filtered Trace", xmin + 2, ymin + 10);
        g.setColor(Color.LIGHT_GRAY);
        g.drawString("Characteristic Function", xmin + 2, ymin + 20);
        g.setColor(Color.RED);
        g.drawString("MinPeakSize", xmin + 2, ymin + 30);
        ymin = ymax;
        double d3 = this.getHeight();
        this.getClass();
        ymax = ymin + (int)(d3 * 0.15);
        g.setColor(Color.BLACK);
        g.drawRect(xmin, ymin, xmax - xmin - 1, ymax - ymin);
        g.setColor(Color.BLACK);
        g.drawString("Long-Term Average", xmin + 2, ymin + 10);
        g.setColor(Color.LIGHT_GRAY);
        g.drawString("Short-Term Average", xmin + 2, ymin + 20);
        ymin = ymax;
        ymax = ymin + (int)((double)this.getHeight() * this.THRES_HEIGHT_RATIO);
        g.setColor(Color.BLACK);
        g.drawRect(xmin, ymin, xmax - xmin - 1, ymax - ymin);
        g.setColor(Color.LIGHT_GRAY);
        g.drawString("Threshold Function", xmin + 2, ymin + 10);
        g.setColor(Color.RED);
        g.drawString("Threshold", xmin + 2, ymin + 20);
        return image;
    }

    private int[] getPos(double[] p, double[] plotParams) {
        int np = p.length;
        int[] output = new int[p.length];
        for (int i = 0; i < np; i += 2) {
            output[i] = (int)plotParams[0] + (int)((p[i] - plotParams[1]) * plotParams[2] + 0.5);
            output[i + 1] = (int)plotParams[3] - (int)((p[i + 1] - plotParams[4]) * plotParams[5]);
        }
        return output;
    }

    private double[] plotTrace(Graphics2D gr, WaveFormGroup group, int xmin, int xmax, int ymin, int ymax, Color color, boolean centerVerticaly) {
        double yAverage = 0.0;
        double yMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        int nsamp = 0;
        for (WaveForm wave : group) {
            double[] samples = wave.getSamples();
            for (int i = 0; i < samples.length; ++i) {
                long t = (long)((double)wave.getStartTime() + (double)i * 1000.0 / wave.getSamplingRate());
                if (t < this.starttime || t > this.endtime) continue;
                yAverage += samples[i];
                ++nsamp;
            }
        }
        double yAvg = centerVerticaly ? (yAverage /= (double)nsamp) : 0.0;
        int yZero = centerVerticaly ? (int)((double)((ymax + ymin) / 2) + 0.5) : ymax;
        for (WaveForm wave : group) {
            double[] samples = wave.getSamples();
            for (int i = 0; i < samples.length; ++i) {
                long t = (long)((double)wave.getStartTime() + (double)i * 1000.0 / wave.getSamplingRate());
                if (t < this.starttime || t > this.endtime) continue;
                if (samples[i] - yAvg > yMax) {
                    yMax = samples[i];
                }
                if (!(samples[i] - yAvg < yMin)) continue;
                yMin = samples[i];
            }
        }
        double yScale = centerVerticaly ? (double)(ymax - ymin) / 2.0 / Math.max(Math.abs(yMax), Math.abs(yMin)) : (double)(ymax - ymin) / Math.abs(yMax);
        double xScale = (double)(xmax - xmin) / (double)(this.endtime - this.starttime) * 1000.0;
        int xZero = xmin;
        gr.setColor(color);
        int lastX = 0;
        int lastY = 0;
        boolean firstwave = true;
        for (WaveForm wave : group) {
            double samprate = wave.getSamplingRate();
            double[] samples = wave.getSamples();
            int[] xPos = new int[wave.getSampleCount()];
            int[] yPos = new int[wave.getSampleCount()];
            for (int i = 0; i < wave.getSampleCount(); ++i) {
                xPos[i] = xZero + (int)(((double)(wave.getStartTime() - this.starttime) / 1000.0 + (double)i / samprate) * xScale);
                yPos[i] = yZero - (int)((samples[i] - yAvg) * yScale);
            }
            gr.drawPolyline(xPos, yPos, xPos.length);
            if (!firstwave) {
                gr.drawLine(lastX, lastY, xPos[0], yPos[0]);
            } else {
                firstwave = false;
            }
            lastX = xPos[wave.getSampleCount() - 1];
            lastY = yPos[wave.getSampleCount() - 1];
        }
        return new double[]{xZero, (double)this.starttime / 1000.0, xScale, yZero, yAvg, yScale};
    }

    private void addToVisiblePicks(VisiblePick x) {
        if (x.pos[0] < 0 || x.pos[0] > this.getWidth()) {
            return;
        }
        this.visiblePicks.add(x);
    }

    public String isPick(int x, int y) {
        if (this.visiblePicks == null) {
            return null;
        }
        int d = Integer.MAX_VALUE;
        String output = null;
        block4: for (VisiblePick pick : this.visiblePicks) {
            int newd;
            if (y < pick.pos[1] || y > pick.pos[2] || (newd = Math.abs(pick.pos[0] - x)) >= d || newd >= 5) continue;
            d = newd;
            switch (pick.ewm.getType()) {
                case 8: {
                    output = ((PickSCNL)pick.ewm).toString();
                    continue block4;
                }
                case 9: {
                    output = ((CodaSCNL)pick.ewm).toString();
                    continue block4;
                }
            }
            output = ((PickEWDebugMsg)pick.ewm).toString();
        }
        return output;
    }

    public void update(long starttime, long endtime, PickEWStation station, WaveFormGroup[] groups, EWMessageGroup mg) {
        this.starttime = starttime;
        this.endtime = endtime;
        this.groups = groups;
        this.msg = mg;
        this.station = station;
        this.requiresUpdate = true;
        this.repaint();
    }
}

