/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import javax.swing.table.AbstractTableModel;
import pickewanalysis.Configuration;
import pickewanalysis.ewpicker.PickEWStation;
import pickewanalysis.ewpicker.PickEWStationGroup;
import pickewanalysis.wavesources.WaveSource;

public class StationsListTableModel
extends AbstractTableModel {
    private PickEWStationGroup stations;
    private boolean[] availableData;
    private String[] columnNames = new String[]{"Station", "Ava"};

    public StationsListTableModel(String stationsFile, Configuration config) {
        try {
            this.stations = new PickEWStationGroup(stationsFile);
        }
        catch (Exception e) {
            this.stations = new PickEWStationGroup();
        }
        this.availableData = new boolean[this.stations.size()];
        block2: for (int i = 0; i < this.availableData.length; ++i) {
            this.availableData[i] = false;
            for (WaveSource source : config.sources) {
                if (!source.isSCNL(((PickEWStation)this.stations.get((int)i)).stat, ((PickEWStation)this.stations.get((int)i)).chan, ((PickEWStation)this.stations.get((int)i)).net, ((PickEWStation)this.stations.get((int)i)).loc, config.starttime.getTime(), config.endtime.getTime())) continue;
                this.availableData[i] = true;
                continue block2;
            }
        }
    }

    public PickEWStationGroup getStations() {
        return this.stations;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.stations.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.stations.isEmpty()) {
            return null;
        }
        if (col == 0) {
            return this.stations.get(row);
        }
        return this.availableData[row];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return PickEWStation.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

