/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pickewanalysis.AboutDialog;
import pickewanalysis.Configuration;
import pickewanalysis.ErrorDialog;
import pickewanalysis.PreferencesTableModel;
import pickewanalysis.StationParametersTableModel;
import pickewanalysis.StationsListTableModel;
import pickewanalysis.TracePanel;
import pickewanalysis.ewmessages.EWMessageGroup;
import pickewanalysis.ewpicker.EWPicker;
import pickewanalysis.ewpicker.EWPickerParameters;
import pickewanalysis.ewpicker.PickEWStation;
import pickewanalysis.ewpicker.PickEWStationGroup;
import pickewanalysis.waveform.WaveFormGroup;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.WaveSourceStation;

public class PickEWAnalysis
extends JFrame {
    private JTable PreferencesTable;
    private JTable StationParametersTable;
    private JTable StationsList;
    private JMenuItem aboutMenuItem;
    private JButton centerButton;
    private JMenu editMenu;
    private JTextField endtimeField;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton leftButton;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JButton rightButtom;
    private JMenuItem saveAsMenuItem;
    private JButton setTimeButton;
    private JMenuItem settingsMenuItem;
    private JTextField starttimeField;
    private TracePanel tracePanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    static String configFileName;
    Configuration config;
    PickEWStation curStation;
    WaveSource curSource;
    WaveFormGroup curGroup;
    long viewStart;
    long viewEnd;
    public static final String DEFAULT_CONFIG_FILENAME = "PickEWAnalysisConfig.xml";
    public static final SimpleDateFormat df;
    public static final long MAXTIME = 3600000L;
    public static final long MARGIN = 15000L;

    public PickEWAnalysis() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.StationsList = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.StationParametersTable = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.PreferencesTable = new JTable();
        this.jLabel1 = new JLabel();
        this.starttimeField = new JTextField();
        this.jLabel2 = new JLabel();
        this.endtimeField = new JTextField();
        this.setTimeButton = new JButton();
        this.leftButton = new JButton();
        this.rightButtom = new JButton();
        this.zoomOutButton = new JButton();
        this.zoomInButton = new JButton();
        this.centerButton = new JButton();
        this.tracePanel = new TracePanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.settingsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("PickEWAnalysis");
        this.StationsList.setAutoCreateRowSorter(true);
        this.StationsList.setFont(new Font("Tahoma", 0, 10));
        this.StationsList.setModel(new StationsListTableModel("", null));
        this.StationsList.setAutoResizeMode(0);
        this.StationsList.setSelectionMode(0);
        this.StationsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PickEWAnalysis.this.stationSelected();
            }
        });
        this.jScrollPane1.setViewportView(this.StationsList);
        this.StationParametersTable.setFont(new Font("Tahoma", 0, 10));
        this.StationParametersTable.setModel(new StationParametersTableModel(null, null));
        this.jScrollPane2.setViewportView(this.StationParametersTable);
        this.PreferencesTable.setFont(new Font("Tahoma", 0, 10));
        this.PreferencesTable.setModel(new PreferencesTableModel(this.config, this));
        this.jScrollPane3.setViewportView(this.PreferencesTable);
        this.jLabel1.setFont(new Font("Tahoma", 0, 10));
        this.jLabel1.setText("Start Time");
        this.starttimeField.setFont(new Font("Tahoma", 0, 10));
        this.starttimeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PickEWAnalysis.this.starttimeFieldKeyReleased(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 0, 10));
        this.jLabel2.setText("End Time");
        this.endtimeField.setFont(new Font("Tahoma", 0, 10));
        this.endtimeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PickEWAnalysis.this.endtimeFieldKeyReleased(evt);
            }
        });
        this.setTimeButton.setFont(new Font("Tahoma", 0, 10));
        this.setTimeButton.setText("Set From Source");
        this.setTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.setTimeButtonActionPerformed(evt);
            }
        });
        this.leftButton.setFont(new Font("Tahoma", 0, 8));
        this.leftButton.setText("<");
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.leftButtonActionPerformed(evt);
            }
        });
        this.rightButtom.setFont(new Font("Tahoma", 0, 8));
        this.rightButtom.setText(">");
        this.rightButtom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.rightButtomActionPerformed(evt);
            }
        });
        this.zoomOutButton.setFont(new Font("Tahoma", 0, 8));
        this.zoomOutButton.setText("<>");
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.zoomInButton.setFont(new Font("Tahoma", 0, 8));
        this.zoomInButton.setText("><");
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.zoomInButtonActionPerformed(evt);
            }
        });
        this.centerButton.setFont(new Font("Tahoma", 0, 8));
        this.centerButton.setText("O");
        this.centerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.centerButtonActionPerformed(evt);
            }
        });
        this.tracePanel.setBackground(new Color(255, 255, 255));
        GroupLayout tracePanelLayout = new GroupLayout(this.tracePanel);
        this.tracePanel.setLayout(tracePanelLayout);
        tracePanelLayout.setHorizontalGroup(tracePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 508, Short.MAX_VALUE));
        tracePanelLayout.setVerticalGroup(tracePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 495, Short.MAX_VALUE));
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open Stations File ...");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAsMenuItem.setMnemonic('a');
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.setDisplayedMnemonicIndex(5);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.settingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.settingsMenuItem.setMnemonic('t');
        this.settingsMenuItem.setText("Settings");
        this.settingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.settingsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.settingsMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickEWAnalysis.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.setTimeButton, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 129, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.starttimeField).addComponent(this.jLabel2).addComponent(this.endtimeField)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.leftButton, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightButtom, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomOutButton, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomInButton, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerButton, -2, 50, -2)).addComponent(this.tracePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.leftButton, -2, 20, -2).addComponent(this.rightButtom, -2, 20, -2).addComponent(this.zoomOutButton, -2, 20, -2).addComponent(this.zoomInButton, -2, 20, -2).addComponent(this.centerButton, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tracePanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 521, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 309, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane3, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.starttimeField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endtimeField, -2, -1, -2).addGap(14, 14, 14).addComponent(this.setTimeButton))).addContainerGap()));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void settingsMenuItemActionPerformed(ActionEvent evt) {
        this.config.setLocationRelativeTo(this);
        this.config.setVisible(true);
        this.update();
    }

    private void starttimeFieldKeyReleased(KeyEvent evt) {
        try {
            this.config.starttime = df.parse(this.starttimeField.getText().trim());
            this.viewStart = this.config.starttime.getTime();
            this.starttimeField.setForeground(Color.BLACK);
            if (this.checkTimeConsistency()) {
                this.updateWaveData();
            }
        }
        catch (Exception e) {
            this.starttimeField.setForeground(Color.RED);
        }
    }

    private void endtimeFieldKeyReleased(KeyEvent evt) {
        try {
            this.config.endtime = df.parse(this.endtimeField.getText().trim());
            this.viewEnd = this.config.endtime.getTime();
            this.endtimeField.setForeground(Color.BLACK);
            if (this.checkTimeConsistency()) {
                this.updateWaveData();
            }
        }
        catch (Exception e) {
            this.endtimeField.setForeground(Color.RED);
        }
    }

    private void setTimeButtonActionPerformed(ActionEvent evt) {
        this.config.endtime = new Date(System.currentTimeMillis() / 1000L * 1000L);
        this.config.starttime = new Date(this.config.endtime.getTime() - 60000L);
        if (this.curStation == null) {
            this.update();
            return;
        }
        for (WaveSource source : this.config.sources) {
            WaveSourceStation station = source.findStation(this.curStation.stat, this.curStation.chan, this.curStation.net, this.curStation.loc);
            if (station == null) continue;
            long st = station.getStartTime();
            long et = station.getEndTime();
            long delta = et - st;
            if (delta < 0L) continue;
            if (delta > 3600000L) {
                st = et - 3600000L;
            }
            this.config.starttime = new Date(st);
            this.config.endtime = new Date(et);
            this.viewStart = st;
            this.viewEnd = et;
            this.update();
        }
    }

    private void leftButtonActionPerformed(ActionEvent evt) {
        if (this.viewStart <= this.config.starttime.getTime()) {
            return;
        }
        long shiftSpan = (long)((double)(this.viewEnd - this.viewStart) * 0.2 + 0.5);
        long newStart = this.viewStart - shiftSpan;
        if (newStart < this.config.starttime.getTime()) {
            newStart = this.config.starttime.getTime();
        }
        long delta = this.viewStart - newStart;
        this.viewStart = newStart;
        this.viewEnd -= delta;
        this.updateTracePanel();
    }

    private void rightButtomActionPerformed(ActionEvent evt) {
        if (this.viewEnd >= this.config.endtime.getTime()) {
            return;
        }
        long shiftSpan = (long)((double)(this.viewEnd - this.viewStart) * 0.2 + 0.5);
        long newEnd = this.viewEnd + shiftSpan;
        if (newEnd > this.config.endtime.getTime()) {
            newEnd = this.config.endtime.getTime();
        }
        long delta = this.viewEnd - newEnd;
        this.viewEnd = newEnd;
        this.viewStart -= delta;
        this.updateTracePanel();
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        this.zoom(1.2);
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        this.zoom(0.8333333333333334);
    }

    private void centerButtonActionPerformed(ActionEvent evt) {
        this.viewStart = this.config.starttime.getTime();
        this.viewEnd = this.config.endtime.getTime();
        this.updateTracePanel();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        File selectedfile;
        PickEWStationGroup stations = ((StationsListTableModel)this.StationsList.getModel()).getStations();
        if (stations == null || stations.isEmpty()) {
            System.err.println("No stations available for saving.");
        }
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showSaveDialog(null);
        if (aux == 0 && (selectedfile = filechooser.getSelectedFile()) != null) {
            try {
                BufferedWriter Foutput = new BufferedWriter(new FileWriter(selectedfile));
                Foutput.write("#####################################################");
                Foutput.newLine();
                Foutput.write("#  Pick_EW Stations File created automaticaly.      #");
                Foutput.newLine();
                Foutput.write("#  Date: " + new Date().toString() + "             #");
                Foutput.newLine();
                Foutput.write("#####################################################");
                Foutput.newLine();
                for (PickEWStation station : stations) {
                    System.out.println(station.toStationLine());
                    Foutput.write(station.toStationLine());
                    Foutput.newLine();
                }
                Foutput.flush();
                Foutput.close();
            }
            catch (Exception e) {
                System.err.println("Unable to save stations file.");
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == 0) {
            File selectedfile = filechooser.getSelectedFile();
            if (selectedfile != null) {
                this.config.StationsFile = selectedfile.getAbsolutePath();
                try {
                    this.config.save(this.config.configFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.update();
        }
    }

    public static void main(final String[] args) {
        System.setProperty("user.timezone", "Etc/Universal");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PickEWAnalysis mainWindow = new PickEWAnalysis();
                configFileName = PickEWAnalysis.DEFAULT_CONFIG_FILENAME;
                if (args.length > 0) {
                    configFileName = args[0];
                }
                try {
                    mainWindow.config = Configuration.load(configFileName);
                }
                catch (Exception e) {
                    System.err.println("Unable to open configuration file");
                    e.printStackTrace();
                    System.err.println("Starting default configuration.");
                    mainWindow.config = new Configuration();
                    try {
                        mainWindow.config.save(configFileName);
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to save new configuration file.");
                        System.err.println("Settings will not be saved");
                    }
                }
                mainWindow.update();
                mainWindow.setLocationRelativeTo(null);
                mainWindow.setVisible(true);
            }
        });
    }

    private void update() {
        int rowIndex = this.StationsList.getSelectedRow();
        this.updateStationsList();
        this.updateParametersTable();
        this.updatePreferencesTable();
        this.updateTimeFields();
        if (rowIndex != -1) {
            this.StationsList.setRowSelectionInterval(rowIndex, rowIndex);
        }
        this.StationsList.getColumnModel().getColumn(0).setPreferredWidth(110);
        this.StationsList.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.updateWaveData();
    }

    private boolean updateStationsList() {
        this.StationsList.setModel(new StationsListTableModel(this.config.StationsFile, this.config));
        return true;
    }

    private boolean updateParametersTable() {
        this.StationParametersTable.setModel(new StationParametersTableModel(this.curStation, this));
        return true;
    }

    private boolean updatePreferencesTable() {
        this.PreferencesTable.setModel(new PreferencesTableModel(this.config, this));
        return true;
    }

    private boolean updateTimeFields() {
        this.starttimeField.setText(df.format(this.config.starttime));
        this.endtimeField.setText(df.format(this.config.endtime));
        this.checkTimeConsistency();
        return true;
    }

    private boolean updateWaveData() {
        if (this.curStation == null) {
            return false;
        }
        this.curGroup = null;
        for (WaveSource source : this.config.sources) {
            block5: {
                if (!source.isSCNL(this.curStation.stat, this.curStation.chan, this.curStation.net, this.curStation.loc, this.config.starttime.getTime(), this.config.endtime.getTime())) continue;
                try {
                    this.curGroup = source.read(this.curStation.stat, this.curStation.chan, this.curStation.net, this.curStation.loc, this.config.starttime.getTime(), this.config.endtime.getTime());
                    if (this.curGroup == null) {
                    }
                    break block5;
                }
                catch (Exception e) {
                    new ErrorDialog("Error reading data: " + e.getMessage(), "Error", this, true).setVisible(true);
                }
                continue;
            }
            if (this.curGroup != null) continue;
            new ErrorDialog("Unable to load data.", "Error", this, true).setVisible(true);
        }
        return this.updateTracePanel();
    }

    public boolean updateTracePanel() {
        if (this.curGroup == null) {
            this.tracePanel.update(this.viewStart, this.viewEnd, this.curStation, null, null);
            return false;
        }
        EWPickerParameters pickerParams = new EWPickerParameters(this.config.RestartLength, this.config.MaxGap, this.config.NoCoda);
        EWPicker picker = new EWPicker(this.curStation, pickerParams);
        EWMessageGroup mg = picker.analyze(this.curGroup);
        WaveFormGroup[] groups = new WaveFormGroup[]{this.curGroup, picker.rdatGroup, picker.charGroup, picker.staGroup, picker.ltaGroup, picker.staltaGroup};
        this.tracePanel.update(this.viewStart, this.viewEnd, this.curStation, groups, mg);
        return false;
    }

    private boolean checkTimeConsistency() {
        long delta = this.config.endtime.getTime() - this.config.starttime.getTime();
        boolean output = true;
        if (delta <= 0L) {
            output = false;
        }
        if (delta > 3600000L) {
            output = false;
        }
        if (output) {
            this.starttimeField.setForeground(Color.BLACK);
            this.endtimeField.setForeground(Color.BLACK);
        } else {
            this.starttimeField.setForeground(Color.RED);
            this.endtimeField.setForeground(Color.RED);
        }
        return output;
    }

    public void zoom(double k) {
        long curSpan = this.viewEnd - this.viewStart;
        double newSpan = (double)curSpan * k;
        double center = (this.viewEnd + this.viewStart) / 2L;
        double newViewStart = center - newSpan / 2.0;
        double newViewEnd = center + newSpan / 2.0;
        this.viewStart = newViewStart <= (double)this.config.starttime.getTime() ? this.config.starttime.getTime() : (long)(newViewStart + 0.5);
        this.viewEnd = newViewEnd >= (double)this.config.endtime.getTime() ? this.config.endtime.getTime() : (long)(newViewEnd + 0.5);
        this.updateTracePanel();
    }

    public void zoom(long startT, long endT) {
        this.viewStart = startT < this.config.starttime.getTime() ? this.config.starttime.getTime() : startT;
        this.viewEnd = endT > this.config.endtime.getTime() ? this.config.endtime.getTime() : endT;
        this.updateTracePanel();
    }

    private void stationSelected() {
        int selectedRow = this.StationsList.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int rowIndex = this.StationsList.convertRowIndexToModel(selectedRow);
        this.curStation = (PickEWStation)((StationsListTableModel)this.StationsList.getModel()).getValueAt(rowIndex, 0);
        if (this.viewStart == 0L || this.viewEnd == 0L) {
            this.viewStart = this.config.starttime.getTime();
            this.viewEnd = this.config.endtime.getTime();
        }
        this.updateParametersTable();
        this.updateWaveData();
    }

    static {
        df = new SimpleDateFormat("yyyyMMddHHmmss");
    }
}

