/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pickewanalysis.ErrorDialog;
import pickewanalysis.wavesources.TankFile;
import pickewanalysis.wavesources.WaveServer;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.miniSEEDFile;

public class AddSourceDialog
extends JDialog {
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton mseedFileBrowseButton;
    private JTextField mseedFileField;
    private JButton okButton;
    private JTabbedPane sourcesTabbedPane;
    private JButton tankFileBrowseButton;
    private JTextField tankFileField;
    private JTextField wsIPField;
    private JTextField wsPortField;
    private WaveSource source;
    private TankFile tankSource;
    private miniSEEDFile mseedSource;
    private WaveServer waveServerSource;

    public AddSourceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.sourcesTabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.wsIPField = new JTextField();
        this.jLabel4 = new JLabel();
        this.wsPortField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tankFileField = new JTextField();
        this.tankFileBrowseButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.mseedFileField = new JTextField();
        this.mseedFileBrowseButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add New Wave Source");
        this.jLabel3.setText("WaveServer IP");
        this.wsIPField.setText(" ");
        this.wsIPField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddSourceDialog.this.wsIPFieldKeyReleased(evt);
            }
        });
        this.jLabel4.setText("WaveServer Port");
        this.wsPortField.setText(" ");
        this.wsPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddSourceDialog.this.wsPortFieldKeyReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(29, 29, 29).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.wsPortField).addComponent(this.wsIPField, -1, 125, Short.MAX_VALUE)).addContainerGap(148, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.wsIPField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.wsPortField, -2, -1, -2)).addContainerGap(155, Short.MAX_VALUE)));
        this.sourcesTabbedPane.addTab("WaveServer", this.jPanel1);
        this.jLabel1.setText("Tank File");
        this.tankFileField.setText(" ");
        this.tankFileBrowseButton.setText("Browse");
        this.tankFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.tankFileBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tankFileField, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tankFileBrowseButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tankFileField, -2, -1, -2).addComponent(this.tankFileBrowseButton)).addContainerGap(178, Short.MAX_VALUE)));
        this.sourcesTabbedPane.addTab("Tank File", this.jPanel2);
        this.jLabel2.setText("miniSEED File");
        this.mseedFileField.setText(" ");
        this.mseedFileBrowseButton.setText("Browse");
        this.mseedFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.mseedFileBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mseedFileField, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mseedFileBrowseButton).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.mseedFileField, -2, -1, -2).addComponent(this.mseedFileBrowseButton)).addContainerGap(178, Short.MAX_VALUE)));
        this.sourcesTabbedPane.addTab("miniSEED File", this.jPanel3);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourcesTabbedPane, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(224, Short.MAX_VALUE).addComponent(this.okButton, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 80, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourcesTabbedPane, -2, 240, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.source = null;
        this.dispose();
    }

    private void tankFileBrowseButtonActionPerformed(ActionEvent evt) {
        File selectedfile;
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == 0 && (selectedfile = filechooser.getSelectedFile()) != null) {
            try {
                TankFile newsource = new TankFile();
                newsource.setName(selectedfile.getAbsolutePath());
                this.tankFileField.setText(selectedfile.getAbsolutePath());
                this.tankSource = newsource;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int selectedSource = this.sourcesTabbedPane.getSelectedIndex();
        WaveSource tempSource = null;
        switch (selectedSource) {
            case 0: {
                tempSource = this.waveServerSource;
                break;
            }
            case 1: {
                tempSource = this.tankSource;
                break;
            }
            case 2: {
                tempSource = this.mseedSource;
            }
        }
        try {
            ((WaveSource)tempSource).update();
            this.source = tempSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            new ErrorDialog("Unable to contact source: " + e.getMessage(), "Error", null, true).setVisible(true);
        }
        this.dispose();
    }

    private void mseedFileBrowseButtonActionPerformed(ActionEvent evt) {
        File selectedfile;
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == 0 && (selectedfile = filechooser.getSelectedFile()) != null) {
            try {
                miniSEEDFile newsource = new miniSEEDFile();
                newsource.setName(selectedfile.getAbsolutePath());
                this.mseedFileField.setText(selectedfile.getAbsolutePath());
                this.mseedSource = newsource;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void wsPortFieldKeyReleased(KeyEvent evt) {
        this.setWaveServer(evt.getComponent());
    }

    private void wsIPFieldKeyReleased(KeyEvent evt) {
        this.setWaveServer(evt.getComponent());
    }

    public WaveSource getSource() {
        return this.source;
    }

    private void setWaveServer(Component c) {
        if (this.checkValidServerAddress(this.wsIPField.getText().trim(), this.wsPortField.getText().trim())) {
            this.waveServerSource = new WaveServer();
            String name = this.wsIPField.getText().trim() + ":" + this.wsPortField.getText().trim();
            this.waveServerSource.setName(name);
            this.wsIPField.setForeground(Color.BLACK);
            this.wsPortField.setForeground(Color.BLACK);
        } else {
            c.setForeground(Color.RED);
        }
    }

    private boolean checkValidServerAddress(String ip, String port) {
        int a;
        if (ip.isEmpty()) {
            return false;
        }
        String[] parts = ip.split("[.]+");
        if (parts.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            try {
                a = Integer.valueOf(parts[i].trim());
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (port.isEmpty()) {
            return false;
        }
        try {
            a = Integer.valueOf(port.trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

