/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Collector
implements Criteria {
    private final Registry registry = new Registry();
    private final Context context;

    public Collector(Context context) {
        this.context = context;
    }

    @Override
    public Variable get(String name) {
        return (Variable)this.registry.get(name);
    }

    @Override
    public Variable remove(String name) {
        return (Variable)this.registry.remove(name);
    }

    @Override
    public Iterator<String> iterator() {
        return this.registry.iterator();
    }

    @Override
    public void set(Label label, Object value) throws Exception {
        String name;
        Variable variable = new Variable(label, value);
        if (label != null && !this.registry.containsKey(name = label.getName(this.context))) {
            this.registry.put(name, variable);
        }
    }

    @Override
    public void commit(Object source) throws Exception {
        Collection set = this.registry.values();
        for (Variable entry : set) {
            Contact contact = entry.getContact();
            Object value = entry.getValue();
            contact.set(source, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Registry
    extends LinkedHashMap<String, Variable> {
        private Registry() {
        }

        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }
    }
}

