/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

public class Complex {
    private double real;
    private double imaginary;

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public final double mag() {
        return Math.sqrt(this.getReal() * this.getReal() + this.getImaginary() * this.getImaginary());
    }

    public static final Complex add(double a, Complex b) {
        return Complex.add(new Complex(a, 0.0), b);
    }

    public static final Complex add(Complex a, double b) {
        return Complex.add(a, new Complex(b, 0.0));
    }

    public static final Complex add(Complex a, Complex b) {
        return new Complex(a.getReal() + b.getReal(), a.getImaginary() + b.getImaginary());
    }

    public static final Complex sub(double a, Complex b) {
        return Complex.sub(new Complex(a, 0.0), b);
    }

    public static final Complex sub(Complex a, double b) {
        return Complex.sub(a, new Complex(b, 0.0));
    }

    public static final Complex sub(Complex a, Complex b) {
        return new Complex(a.getReal() - b.getReal(), a.getImaginary() - b.getImaginary());
    }

    public static final Complex mul(double a, Complex b) {
        return Complex.mul(new Complex(a, 0.0), b);
    }

    public static final Complex mul(Complex a, double b) {
        return Complex.mul(a, new Complex(b, 0.0));
    }

    public static final Complex mul(Complex a, Complex b) {
        return new Complex(a.getReal() * b.getReal() - a.getImaginary() * b.getImaginary(), a.getImaginary() * b.getReal() + a.getReal() * b.getImaginary());
    }

    public static final Complex div(double a, Complex b) {
        return Complex.div(new Complex(a, 0.0), b);
    }

    public static final Complex div(Complex a, double b) {
        return Complex.div(a, new Complex(b, 0.0));
    }

    public static final Complex div(Complex a, Complex b) {
        if (Math.abs(b.getReal()) >= Math.abs(b.getImaginary())) {
            double r = b.getImaginary() / b.getReal();
            double den = b.getReal() + r * b.getImaginary();
            return new Complex((a.getReal() + r * a.getImaginary()) / den, (a.getImaginary() - r * a.getReal()) / den);
        }
        double r = b.getReal() / b.getImaginary();
        double den = b.getImaginary() + r * b.getReal();
        return new Complex((a.getReal() * r + a.getImaginary()) / den, (a.getImaginary() * r - a.getReal()) / den);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Complex) {
            Complex other = (Complex)obj;
            return this.getReal() == other.getReal() && this.getImaginary() == other.getImaginary();
        }
        return false;
    }

    public int hashCode() {
        int i = 17;
        long tmp = Double.doubleToLongBits(this.getImaginary());
        i = 31 * i + (int)(tmp ^ tmp >>> 32);
        tmp = Double.doubleToLongBits(this.getReal());
        i = 37 * i + (int)(tmp ^ tmp >>> 32);
        return i;
    }
}

