/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNDateTime;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNEventInfo {
    private DataInputStream dis;
    private byte[] fourBytes = new byte[4];
    private byte[] sixBytes = new byte[6];
    private PSNDateTime time;
    private double lat;
    private double lon;
    private double depthKM;
    private double[] magnitudes;
    private String otherMagType;
    private byte eventType;
    private byte locationQuality;
    private short flags;
    private String reportingAgency;

    public PSNEventInfo(DataInputStream data) throws IOException {
        this.dis = data;
        this.time = new PSNDateTime(this.dis);
        this.lat = Double.longBitsToDouble(SacTimeSeries.swapBytes(this.dis.readLong()));
        this.lon = Double.longBitsToDouble(SacTimeSeries.swapBytes(this.dis.readLong()));
        this.depthKM = Double.longBitsToDouble(SacTimeSeries.swapBytes(this.dis.readLong()));
        this.magnitudes = new double[6];
        for (int i = 0; i < this.magnitudes.length; ++i) {
            this.magnitudes[i] = (double)SacTimeSeries.swapBytes(this.dis.readShort()) / 100.0;
        }
        this.dis.readFully(this.fourBytes);
        this.otherMagType = new String(PSNDataFile.chopToLength(this.fourBytes));
        this.eventType = this.dis.readByte();
        this.locationQuality = this.dis.readByte();
        this.flags = SacTimeSeries.swapBytes((short)this.dis.readUnsignedShort());
        this.dis.readFully(this.sixBytes);
        this.reportingAgency = new String(PSNDataFile.chopToLength(this.sixBytes));
    }

    public PSNDateTime getTime() {
        return this.time;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getDepthKM() {
        return this.depthKM;
    }

    public double[] getMagnitudes() {
        return this.magnitudes;
    }

    public String getOtherMagType() {
        return this.otherMagType;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public byte getLocationQuality() {
        return this.locationQuality;
    }

    public short getFlags() {
        return this.flags;
    }

    public String getReportingAgency() {
        return this.reportingAgency;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Time: " + this.time.toString() + '\n');
        buf.append("Location: Lat " + this.lat + ", Lon " + this.lon + ", Depth " + this.depthKM + '\n');
        buf.append("Magnitudes: ");
        for (int i = 0; i < this.magnitudes.length; ++i) {
            buf.append(this.magnitudes[i] + " ");
        }
        buf.append('\n');
        buf.append("Other Mag type: " + this.otherMagType + '\n');
        buf.append("Event Type Code: " + this.eventType + '\n');
        buf.append("Event Location Quarlity: " + this.locationQuality + '\n');
        buf.append("Flags: " + this.flags + '\n');
        buf.append("Reporting Agency: " + this.reportingAgency + '\n');
        return buf.toString();
    }
}

