/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.dataSelectWS;

import edu.sc.seis.seisFile.dataSelectWS.DataSelectException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSelectReader {
    protected String urlBase;
    public static final String DEFAULT_WS_URL = "http://www.iris.edu/ws/dataselect/query";
    public static SimpleDateFormat longFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public DataSelectReader() {
        this(DEFAULT_WS_URL);
    }

    public DataSelectReader(String urlBase) {
        this.urlBase = urlBase;
    }

    protected String createQuery(String network, String station, String location, String channel) throws IOException, DataSelectException, SeedFormatException {
        String query = "net=" + network;
        query = query + "&sta=" + station;
        query = query + "&loc=" + location;
        query = query + "&cha=" + channel;
        return query;
    }

    public URL createQuery(String network, String station, String location, String channel, Date begin, float durationSeconds) throws IOException, DataSelectException, SeedFormatException {
        String query = this.createQuery(network, station, location, channel);
        query = query + "&start=" + longFormat.format(begin);
        query = query + "&dur=" + durationSeconds;
        URL requestURL = new URL(this.urlBase + "?" + query);
        return requestURL;
    }

    public List<DataRecord> read(URL requestURL) throws IOException, DataSelectException, SeedFormatException {
        HttpURLConnection conn = (HttpURLConnection)requestURL.openConnection();
        conn.connect();
        if (conn.getResponseCode() != 200) {
            if (conn.getResponseCode() == 404) {
                return new ArrayList<DataRecord>();
            }
            throw new DataSelectException("Did not get an OK repsonse code:" + conn.getResponseCode());
        }
        BufferedInputStream bif = new BufferedInputStream(conn.getInputStream());
        DataInputStream in = new DataInputStream(bif);
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        try {
            while (true) {
                SeedRecord sr;
                if ((sr = SeedRecord.read(in)) instanceof DataRecord) {
                    records.add((DataRecord)sr);
                    continue;
                }
                System.err.println("None data record found, skipping...");
            }
        }
        catch (EOFException e) {
            in.close();
            return records;
        }
    }
}

