/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import java.io.Serializable;

public class SamplingImpl
extends Sampling {
    protected SamplingImpl() {
    }

    public static Serializable createEmpty() {
        return new SamplingImpl();
    }

    public SamplingImpl(int numPoints, TimeInterval interval) {
        if (interval.value == Double.POSITIVE_INFINITY && numPoints == 1) {
            interval = new TimeInterval(1.0, UnitImpl.SECOND);
            numPoints = 0;
        }
        this.interval = interval;
        this.numPoints = numPoints;
    }

    public static SamplingImpl createSamplingImpl(Sampling samp) {
        if (samp instanceof SamplingImpl) {
            return (SamplingImpl)samp;
        }
        return new SamplingImpl(samp.numPoints, TimeInterval.createTimeInterval(samp.interval));
    }

    public TimeInterval getPeriod() {
        return (TimeInterval)this.getTimeInterval().divideBy(this.numPoints);
    }

    public QuantityImpl getFrequency() {
        return this.getTimeInterval().inverse().multiplyBy(this.numPoints);
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public TimeInterval getTimeInterval() {
        return TimeInterval.createTimeInterval(this.interval);
    }

    public String toString() {
        return this.numPoints + " in " + this.interval;
    }

    public int hashCode() {
        int result = 38;
        result += 37 * result + this.getTimeInterval().hashCode();
        result += 37 * result + this.getNumPoints();
        return result;
    }

    public boolean equals(Object o) {
        SamplingImpl sampImpl;
        if (super.equals(o)) {
            return true;
        }
        return o instanceof SamplingImpl && (sampImpl = (SamplingImpl)((Object)o)).getPeriod().equals((Object)this.getPeriod());
    }
}

