/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedBuilderFilter;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.director.ImportDirector;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class SeedImportDirector
extends ImportDirector {
    public SeedImportDirector() {
        this.maxRecordLength = 65536;
    }

    public SeedImportDirector(ObjectBuilder builder) {
        super(builder);
        this.maxRecordLength = 65536;
    }

    public int getRecLen() throws Exception {
        if (this.fixedRecordLength > 0) {
            return this.fixedRecordLength;
        }
        int recLen = 256;
        int bufferLength = this.readBuffer.length();
        while (recLen < bufferLength) {
            if (this.checkRecordBoundary(this.readBuffer.buffer, recLen)) break;
            recLen *= 2;
        }
        if (recLen > bufferLength || recLen > this.maxRecordLength) {
            throw new SeedInputException("unable to determine record length (recLen=" + recLen + ", maxRecordLength=" + this.maxRecordLength + ", bufferLength=" + bufferLength);
        }
        return recLen;
    }

    public int build() throws Exception {
        if (this.builder == null) {
            throw new BuilderException("Director has not been assigned a builder");
        }
        if (this.recordOffset == 0) {
            this.builder.setRecordBeginFlag(true);
            this.recordOffset = 8;
        }
        if (this.record == null) {
            throw new BuilderException("import record is null");
        }
        if (this.record.length <= this.recordOffset) {
            throw new BuilderException("insufficient import record length");
        }
        if (this.recordOffset < 0) {
            throw new BuilderException("record offset less than 0");
        }
        byte[] recordSection = new byte[this.record.length - this.recordOffset];
        System.arraycopy(this.record, this.recordOffset, recordSection, 0, recordSection.length);
        this.builder.setRecordType(this.record[6]);
        this.builder.setContinuationFlag(this.record[7] == 42);
        int i = 0;
        while (i < 5 && i < recordSection.length) {
            if (recordSection[i] != 32 && recordSection[i] != 0) break;
            ++i;
        }
        int numBytes = 0;
        if (i == 5 || i == recordSection.length) {
            numBytes = recordSection.length;
            this.builder.removeCurrent();
        } else {
            numBytes = this.builder.build(recordSection);
        }
        if (numBytes < 0) {
            throw new BuilderException("number of bytes is less than zero");
        }
        return numBytes;
    }

    private boolean checkRecordBoundary(byte[] buffer, int offset) throws Exception {
        char recordType = (char)buffer[offset + 6];
        char contFlag = (char)buffer[offset + 7];
        byte[] tempTime = new byte[10];
        int i = 0;
        while (i < 6 && (this.isDigit(buffer[offset + i]) || buffer[offset + i] == 0)) {
            ++i;
        }
        if (recordType == 'D' || recordType == 'R' || recordType == 'Q') {
            if (i == 6 && buffer[offset + 7] == 32) {
                int start = 8;
                if (new String(buffer, offset + 8, 5).compareTo("PFO_T") == 0) {
                    start = 13;
                }
                i = start;
                while (i < 20) {
                    if (buffer[offset + i] != 32 && (buffer[offset + i] < 48 || buffer[offset + i] > 90)) {
                        return false;
                    }
                    ++i;
                }
                System.arraycopy(buffer, offset + 20, tempTime, 0, 10);
                Btime timeVal = new Btime(tempTime);
                return timeVal.getError().length() <= 0;
            }
            return false;
        }
        if (recordType == 'V' || recordType == 'A' || recordType == 'S' || recordType == 'T') {
            if (contFlag == ' ' && (this.isDigit(buffer[offset + 8]) || buffer[offset + 8] == 32) && (this.isDigit(buffer[offset + 9]) || buffer[offset + 9] == 32) && this.isDigit(buffer[offset + 10]) && (this.isDigit(buffer[offset + 11]) || buffer[offset + 11] == 32) && (this.isDigit(buffer[offset + 12]) || buffer[offset + 12] == 32) && (this.isDigit(buffer[offset + 13]) || buffer[offset + 13] == 32) && this.isDigit(buffer[offset + 14]) || contFlag == '*' && this.isPrintable(buffer[offset + 8]) && this.isPrintable(buffer[offset + 9]) && this.isPrintable(buffer[offset + 10]) && this.isPrintable(buffer[offset + 11]) && this.isPrintable(buffer[offset + 12]) && this.isPrintable(buffer[offset + 13]) && this.isPrintable(buffer[offset + 14])) {
                return true;
            }
        } else if (recordType == ' ') {
            if (i < 6) {
                i = 0;
                while (i < 6 && buffer[offset + i] == 32) {
                    ++i;
                }
            }
            if (i == 6) {
                i = 7;
                while (i < 48 && buffer[offset + i] == 32) {
                    ++i;
                }
                if (i == 48) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDigit(byte ascii) {
        return ascii > 47 && ascii < 58;
    }

    private boolean isAlpha(byte ascii) {
        if (ascii > 64 && ascii < 91) {
            return true;
        }
        return ascii > 97 && ascii < 123;
    }

    private boolean isPrintable(byte c) {
        return c > 31 && c < 127;
    }

    public static void main(String[] args) {
        boolean runmode = false;
        try {
            Btime bTime;
            String fileName;
            if (args.length == 0) {
                System.err.println("usage: SeedImportDirector <input_file> [<output_file>] [STN] [CHN] [START] [END]");
                System.exit(1);
            }
            if ((fileName = new String(args[0])).length() == 0) {
                System.err.println("ERROR: empty first argument");
                System.exit(1);
            }
            String fileOut = new String("");
            if (args.length > 1) {
                runmode = true;
                fileOut = new String(args[1]);
                if (fileOut.length() == 0) {
                    System.err.println("ERROR: empty second argument");
                    System.exit(1);
                }
                if (fileOut.equals("object_store.ser")) {
                    runmode = false;
                }
            }
            SeedBuilderFilter buildFilter = null;
            if (args.length > 2) {
                System.out.println("instantiating builder filter...");
                buildFilter = new SeedBuilderFilter();
                buildFilter.addParameter("station", args[2]);
            }
            if (args.length > 3) {
                buildFilter.addParameter("channel", args[3]);
            }
            if (args.length > 4) {
                bTime = new Btime(args[4]);
                buildFilter.addParameter("start_time", bTime.toString());
            }
            if (args.length > 5) {
                bTime = new Btime(args[5]);
                buildFilter.addParameter("end_time", bTime.toString());
            }
            System.out.print("instantiating builder...");
            SeedObjectBuilder seedBuilder = null;
            if (fileOut.equals("object_store.ser")) {
                seedBuilder = new SeedObjectBuilder(fileOut);
                System.out.println("(disk mode)");
            } else {
                seedBuilder = new SeedObjectBuilder();
                System.out.println("(memory mode)");
            }
            if (buildFilter != null) {
                buildFilter.iterate();
                String[] keyAndValue = null;
                while ((keyAndValue = buildFilter.getNext()) != null) {
                    System.out.println("filter parameter: " + keyAndValue[0] + " = " + keyAndValue[1]);
                }
                System.out.println("registering filter with builder...");
                seedBuilder.registerFilter(buildFilter);
            }
            System.out.println("instantiating director and registering builder...");
            SeedImportDirector seedDirector = new SeedImportDirector(seedBuilder);
            System.out.println("opening SEED file " + fileName + " for reading...");
            DataInputStream seedIn = new DataInputStream(new FileInputStream(fileName));
            if (!runmode) {
                System.out.println("accessing SEED data for object generation...");
                seedDirector.construct(seedIn);
            } else {
                System.out.println("accessing SEED data for printing to output file " + fileOut + "...");
                System.out.println("opening output file...");
                DataOutputStream printOut = new DataOutputStream(new FileOutputStream(fileOut));
                System.out.println("printing SEED info...");
                seedDirector.construct(seedIn, printOut, false);
            }
            System.out.println("done.");
            if (runmode) {
                System.exit(0);
            }
            System.out.println("fetching object container...");
            SeedObjectContainer container = (SeedObjectContainer)seedBuilder.getContainer();
            System.out.println("going through object container to display everything we have there...");
            int i = 1;
            while (i < 6) {
                int numElem = container.iterate(1, i);
                if (numElem > 0) {
                    Blockette nextBlockette = null;
                    while ((nextBlockette = (Blockette)container.getNext()) != null) {
                        System.out.println(nextBlockette.toString());
                        int numChild1 = nextBlockette.numberofChildBlockettes();
                        if (numChild1 <= 0) continue;
                        int j = 0;
                        while (j < numChild1) {
                            int numChild2;
                            Blockette child1Blk = nextBlockette.getChildBlockette(j);
                            if (child1Blk == null) {
                                System.out.println("++++> null child blockette encountered");
                            } else {
                                System.out.println("++++> " + child1Blk.toString());
                            }
                            if (child1Blk.getType() == 52) {
                                Blockette blk52 = child1Blk;
                                int[] refFields = new int[]{5, 6, 8, 9, 16};
                                int r = 0;
                                while (r < refFields.length) {
                                    System.out.print("++++|++++> Dictionary lookup for field " + refFields[r] + "(" + blk52.getFieldName(refFields[r]) + "): ");
                                    int refVal = Integer.parseInt(blk52.toString(refFields[r]));
                                    int lookupId = blk52.getDictionaryLookup(refVal);
                                    if (lookupId > 0) {
                                        Blockette dictBlk = (Blockette)container.get(lookupId);
                                        if (dictBlk != null) {
                                            System.out.println(dictBlk.toString());
                                        } else {
                                            System.out.println("-- dictionary blockette not found --");
                                        }
                                    } else {
                                        System.out.println("-- lookupId == 0 --");
                                    }
                                    ++r;
                                }
                            }
                            if ((numChild2 = child1Blk.numberofChildBlockettes()) > 0) {
                                int k = 0;
                                while (k < numChild2) {
                                    Blockette child2Blk = child1Blk.getChildBlockette(k);
                                    if (child2Blk == null) {
                                        System.out.println("++++|++++> null child blockette encountered");
                                    } else {
                                        System.out.println("++++|++++> " + child2Blk.toString());
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    System.out.println("There are 0 type " + i + " elements.");
                }
                ++i;
            }
            System.out.println("done.");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            e.printStackTrace();
        }
    }
}

