/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.builder.ExportBuilder;
import edu.iris.Fissures.seed.container.ObjectContainer;
import edu.iris.Fissures.seed.director.ExportTemplate;
import edu.iris.Fissures.seed.exception.BuilderException;

public abstract class ExportDirector {
    protected ExportBuilder builder = null;
    protected ObjectContainer container = null;
    protected ExportTemplate expTemplate = null;

    public ExportDirector() {
    }

    public ExportDirector(ExportBuilder builder) {
        this.assignBuilder(builder);
    }

    public ExportDirector(ObjectContainer container, ExportBuilder builder) {
        this.assignContainer(container);
        this.assignBuilder(builder);
    }

    public ExportDirector(ObjectContainer container, ExportBuilder builder, ExportTemplate expTemplate) {
        this.assignContainer(container);
        this.assignBuilder(builder);
        this.assignTemplate(expTemplate);
    }

    public void assignBuilder(ExportBuilder builder) {
        this.builder = builder;
    }

    public void assignContainer(ObjectContainer container) {
        this.container = container;
    }

    public void assignTemplate(ExportTemplate expTemplate) {
        this.expTemplate = expTemplate;
    }

    public int construct() throws Exception {
        int objType;
        if (this.container == null) {
            throw new BuilderException("Container not assigned");
        }
        if (this.builder == null) {
            throw new BuilderException("Builder not assigned");
        }
        if (this.expTemplate == null) {
            throw new BuilderException("Template not assigned");
        }
        int recCount = 0;
        this.startVolume();
        this.builder.startVolume();
        int refNum = -1;
        while ((objType = this.builder.getNext()) != -1) {
            if (objType == -2) {
                this.expTemplate.reset();
                continue;
            }
            long newObjType = this.getContext(objType);
            refNum = this.expTemplate.getNext(newObjType);
            Object nextObject = null;
            try {
                if (refNum > 0) {
                    nextObject = this.getObject(refNum);
                }
            }
            catch (BuilderException e) {
                System.err.println("Exception: " + e);
                this.expTemplate.debugDump();
                throw new BuilderException("Called for object refNum " + refNum + " of type " + objType + " converted to new object type " + newObjType);
            }
            recCount += this.builder.build(nextObject);
        }
        this.builder.finish();
        return recCount++;
    }

    public abstract void fillTemplate(BuilderFilter var1) throws Exception;

    protected abstract void startVolume();

    protected abstract Object getObject(int var1) throws Exception;

    protected abstract long getContext(int var1) throws Exception;
}

