/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;

public class SeedEncodingResolver {
    private static final String[] encodingArray = new String[]{"0", "ASCIIText", "1", "16BitInt", "2", "24BitInt", "3", "32BitInt", "4", "Float", "5", "DoubleFloat", "10", "Steim1", "11", "Steim2", "12", "GMuxed24Bit", "13", "GMuxed16Bit3Exp", "14", "GMuxed16Bit4Exp", "15", "USNSN", "16", "CDSN", "17", "Graefenberg", "18", "IPG", "19", "Steim3", "30", "SRO", "31", "HGLP", "32", "DWWSSN", "33", "RSTN", "999", "UNKNOWN"};

    public static String resolve(Blockette dictBlk) {
        String encodeString;
        block25: {
            encodeString = "UNKNOWN";
            block0 : switch (Integer.parseInt(dictBlk.toString(5))) {
                case 0: {
                    String key1 = dictBlk.toString(7, 1);
                    if (key1 == null) break;
                    if (key1.equals("W2 D0-15 C2")) {
                        encodeString = "16BitInt";
                        break;
                    }
                    if (key1.equals("W3 D0-23 C2") || key1.equals("W3 D24 C2")) {
                        encodeString = "24BitInt";
                        break;
                    }
                    if (!key1.equals("W4 D0-31 C2")) break;
                    encodeString = "32BitInt";
                    break;
                }
                case 1: {
                    switch (Integer.parseInt(dictBlk.toString(6))) {
                        case 4: {
                            String key1 = dictBlk.toString(7, 1);
                            if (key1 == null) break;
                            if (key1.equals("W2 D0-11 A-2048")) {
                                String key2 = dictBlk.toString(7, 2);
                                if (key2 == null) break;
                                if (key2.equals("D12-14")) {
                                    encodeString = "GMuxed16Bit3Exp";
                                    break;
                                }
                                if (!key2.equals("D12-15")) break block0;
                                encodeString = "GMuxed16Bit4Exp";
                                break;
                            }
                            if (key1.equals("W2 D0-11 C2")) {
                                encodeString = "SRO";
                                break;
                            }
                            if (key1.equals("W2 D0-13 A-8191")) {
                                String key3 = dictBlk.toString(7, 3);
                                if (key3 == null) break;
                                if (key3.equals("P0:#0,1:#2,2:#4,3:#7")) {
                                    encodeString = "CDSN";
                                    break;
                                }
                                if (!key3.equals("P0:1,1:4,2:16,3:128")) break block0;
                                encodeString = "RSTN";
                                break;
                            }
                            if (key1.equals("W2 D4-15 C2")) {
                                encodeString = "GRAEF";
                                break;
                            }
                            if (key1.equals("W3,0,2,1 D0-15:1:0:-16384")) {
                                encodeString = "KNMI";
                                break;
                            }
                            if (key1.equals("W4 D0-22 S31") || key1.equals("W4, 1, 0, 3,2, D0-22 S31,0")) {
                                encodeString = "Float";
                                break;
                            }
                            break block25;
                        }
                        case 5: {
                            encodeString = "Float";
                        }
                    }
                    break;
                }
                case 50: {
                    switch (Integer.parseInt(dictBlk.toString(6))) {
                        case 6: {
                            encodeString = "Steim1";
                            break;
                        }
                        case 14: {
                            encodeString = "Steim2";
                            break;
                        }
                        case 19: {
                            encodeString = "USNSN";
                        }
                    }
                    break;
                }
                case 80: {
                    encodeString = "ASCIIText";
                    break;
                }
                default: {
                    encodeString = "UNKNOWN";
                }
            }
        }
        return encodeString;
    }

    public static String translate(String s) {
        if (s.length() == 0) {
            return new String("");
        }
        if (s.charAt(0) < 'A') {
            int i = 0;
            while (i < encodingArray.length) {
                if (s.equals(encodingArray[i])) {
                    return encodingArray[i + 1];
                }
                i += 2;
            }
            return "UNKNOWN";
        }
        int i = 1;
        while (i < encodingArray.length) {
            if (s.equals(encodingArray[i])) {
                return encodingArray[i - 1];
            }
            i += 2;
        }
        return "999";
    }
}

