/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedFormatException;
import edu.iris.Fissures.seed.util.Utility;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class BlocketteFactory {
    private static final float defaultSEEDVersion = 2.4f;
    private static final int[] blocketteTypes = new int[]{5, 8, 10, 11, 12, 30, 31, 32, 33, 34, 35, 41, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 70, 71, 72, 73, 74, 999, 100, 200, 201, 300, 310, 320, 390, 395, 400, 405, 500, 1000, 1001};
    private static final int highestBlocketteType = 1001;
    private static final int numberOfBlocketteTypes = blocketteTypes.length;
    private static boolean optimized = false;
    private static int[] blocketteTypeMap = new int[1002];
    private static String[][] arrayFieldName = new String[numberOfBlocketteTypes][];
    private static char[][] arrayFieldType = new char[numberOfBlocketteTypes][];
    private static String[][] arrayFieldLength = new String[numberOfBlocketteTypes][];
    private static String[][] arrayFieldMask = new String[numberOfBlocketteTypes][];
    private static int[][] arrayFieldRepeat = new int[numberOfBlocketteTypes][];
    private static String[] arrayBlkName = new String[numberOfBlocketteTypes];
    private static String[] arrayBlkCategory = new String[numberOfBlocketteTypes];
    private static String[] arrayNumFields = new String[numberOfBlocketteTypes];
    private static final byte[] tildeArray = new byte[]{126};

    public static Blockette createBlockette(byte[] blocketteStream, boolean swapFlag, boolean isData, float version) throws SeedException {
        return new Blockette(blocketteStream, swapFlag, isData, version);
    }

    public static Blockette createBlockette(byte[] blocketteStream, boolean swapFlag, boolean isData) throws SeedException {
        return new Blockette(blocketteStream, swapFlag, isData);
    }

    public static Blockette createBlockette(String inputString, String delimiter, String blank, float version) throws SeedException {
        return new Blockette(inputString, delimiter, blank, version);
    }

    public static Blockette createBlockette(String inputString, String delimiter, String blank) throws SeedException {
        return new Blockette(inputString, delimiter, blank);
    }

    public static Blockette createBlockette(String inputString) throws SeedException {
        return new Blockette(inputString);
    }

    public static Blockette createBlockette(String inputString, float version) throws SeedException {
        return new Blockette(inputString, version);
    }

    public static Blockette createBlockette(int blkType) throws SeedException {
        int numFields = BlocketteFactory.getNumFields(blkType, Blockette.getDefaultVersion());
        String delimiter = "|";
        String blank = "^";
        StringBuffer inputStringBuf = new StringBuffer(String.valueOf(blkType));
        int i = 1;
        while (i < numFields) {
            inputStringBuf.append(delimiter);
            inputStringBuf.append(blank);
            ++i;
        }
        return new Blockette(inputStringBuf.toString(), delimiter, blank);
    }

    public static String getName(int blkType) throws SeedException {
        if (optimized) {
            return arrayBlkName[blocketteTypeMap[blkType]];
        }
        try {
            return BlocketteFactory.getField(blkType, 0, 2);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get name description for blockette " + blkType + ": " + e);
        }
    }

    public static String getCategory(int blkType) throws SeedException {
        if (optimized) {
            return arrayBlkCategory[blocketteTypeMap[blkType]];
        }
        try {
            return BlocketteFactory.getField(blkType, 0, 3);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get category description for blockette " + blkType + ": " + e);
        }
    }

    public static float getVersion(int blkType) throws SeedException {
        StringTokenizer verTok = new StringTokenizer(BlocketteFactory.getNumFields(blkType), "=");
        String firstVer = null;
        if (!verTok.hasMoreTokens()) {
            throw new SeedFormatException("unable to parse NumFields description for blockette " + blkType);
        }
        firstVer = verTok.nextToken();
        return Float.parseFloat(firstVer);
    }

    public static float getDefaultVersion() {
        return 2.4f;
    }

    public static String getNumFields(int blkType) throws SeedException {
        if (optimized) {
            return arrayNumFields[blocketteTypeMap[blkType]];
        }
        try {
            return BlocketteFactory.getField(blkType, 0, 4);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get NumFields description for blockette " + blkType + ": " + e);
        }
    }

    public static int getNumFields(int blkType, float version) throws SeedException {
        int numFld = 0;
        String numFieldsStr = BlocketteFactory.getNumFields(blkType);
        int begin = 0;
        int end = 0;
        float sampVer = 0.0f;
        String groupStr = null;
        while (end > -1) {
            end = numFieldsStr.indexOf(",", begin);
            groupStr = end > -1 ? numFieldsStr.substring(begin, end) : numFieldsStr.substring(begin);
            int equalsIdx = groupStr.indexOf("=");
            if (equalsIdx <= -1) {
                throw new SeedFormatException("unable to get number of fields for version " + version + " of blockette " + blkType);
            }
            sampVer = Float.parseFloat(groupStr.substring(0, equalsIdx));
            if (version < sampVer) break;
            numFld = Integer.parseInt(groupStr.substring(equalsIdx + 1));
            begin = end + 1;
        }
        if (numFld == 0) {
            throw new SeedException("unable to get number of fields for blockette " + blkType + ", version " + version);
        }
        return numFld;
    }

    public static String getFieldName(int blkType, int fieldNum) throws SeedException {
        if (optimized) {
            return arrayFieldName[blocketteTypeMap[blkType]][fieldNum - 1];
        }
        try {
            return BlocketteFactory.getField(blkType, fieldNum, 2);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get field name for blockette " + blkType + ", field " + fieldNum + ": " + e);
        }
    }

    public static String getFieldType(int blkType, int fieldNum) throws SeedException {
        if (optimized) {
            return String.valueOf(arrayFieldType[blocketteTypeMap[blkType]][fieldNum - 1]);
        }
        try {
            return BlocketteFactory.getField(blkType, fieldNum, 3);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get field type for blockette " + blkType + ", field " + fieldNum + ": " + e);
        }
    }

    public static String getFieldLength(int blkType, int fieldNum) throws SeedException {
        if (optimized) {
            return arrayFieldLength[blocketteTypeMap[blkType]][fieldNum - 1];
        }
        try {
            return BlocketteFactory.getField(blkType, fieldNum, 4);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get field length for blockette " + blkType + ", field " + fieldNum + ": " + e);
        }
    }

    public static String getFieldMask(int blkType, int fieldNum) throws SeedException {
        if (optimized) {
            return arrayFieldMask[blocketteTypeMap[blkType]][fieldNum - 1];
        }
        try {
            return BlocketteFactory.getField(blkType, fieldNum, 5);
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get field mask for blockette " + blkType + ", field " + fieldNum + ": " + e);
        }
    }

    public static int getFieldRepeat(int blkType, int fieldNum) throws SeedException {
        if (optimized) {
            return arrayFieldRepeat[blocketteTypeMap[blkType]][fieldNum - 1];
        }
        try {
            return Integer.parseInt(BlocketteFactory.getField(blkType, fieldNum, 6));
        }
        catch (Exception e) {
            throw new SeedFormatException("unable to get field repeat for blockette " + blkType + ", field " + fieldNum + ": " + e);
        }
    }

    public static String formatDecimal(int blkType, int fieldNum, Object value) throws SeedException {
        if (value == null) {
            return "";
        }
        String fldMask = BlocketteFactory.getFieldMask(blkType, fieldNum);
        if (fldMask.indexOf("\"") == 0) {
            int end = fldMask.indexOf("\"", 1);
            String fmtString = fldMask.substring(1, end);
            DecimalFormat df = new DecimalFormat(fmtString);
            String fldLen = BlocketteFactory.getFieldLength(blkType, fieldNum);
            int intLen = Integer.parseInt(fldLen);
            if (fmtString.length() < intLen) {
                df.setPositivePrefix("+");
            }
            String fmtVal = null;
            try {
                fmtVal = df.format(value);
            }
            catch (Exception e) {
                throw new SeedException("DecimalFormat exception (" + e + "), blkType = " + blkType + ", fieldNum = " + fieldNum + ", value Object = " + value);
            }
            if (fmtVal.length() > intLen) {
                return fmtVal.substring(1);
            }
            return fmtVal;
        }
        return value.toString();
    }

    public static String formatDecimal(int blkType, int fieldNum, String stringVal) throws SeedException {
        if (stringVal == null) {
            return "";
        }
        String fldMask = BlocketteFactory.getFieldMask(blkType, fieldNum);
        if (fldMask.indexOf("\"") == 0) {
            int end = fldMask.indexOf("\"", 1);
            String fmtString = fldMask.substring(1, end);
            DecimalFormat df = new DecimalFormat(fmtString);
            String fldLen = BlocketteFactory.getFieldLength(blkType, fieldNum);
            int intLen = Integer.parseInt(fldLen);
            if (fmtString.length() < intLen) {
                df.setPositivePrefix("+");
            }
            String fmtVal = null;
            try {
                fmtVal = fmtString.indexOf(46) > 0 ? df.format(Double.parseDouble(stringVal)) : df.format(Long.parseLong(stringVal));
            }
            catch (Exception e) {
                throw new SeedException("DecimalFormat exception (" + e + "), blkType = " + blkType + ", fieldNum = " + fieldNum + ", value String = " + stringVal);
            }
            if (fmtVal.length() > intLen) {
                return fmtVal.substring(1);
            }
            return fmtVal;
        }
        return stringVal;
    }

    public static byte[] getBytes(int blkType, int fieldNum, String stringVal) throws SeedException {
        String fldType = BlocketteFactory.getFieldType(blkType, fieldNum);
        String fldLen = BlocketteFactory.getFieldLength(blkType, fieldNum);
        if (fldType.equals("L")) {
            if (stringVal.length() == 0) {
                return new byte[0];
            }
            StringTokenizer listTok = new StringTokenizer(stringVal, "[], ");
            String fldMask = BlocketteFactory.getFieldMask(blkType, fieldNum);
            StringTokenizer ft = new StringTokenizer(fldMask, "/");
            String fmtString = "\"" + ft.nextToken() + "\"";
            DecimalFormat df = new DecimalFormat(fmtString);
            int intLen = Integer.parseInt(fldLen);
            Vector<String> fmtVector = new Vector<String>(8, 8);
            while (listTok.hasMoreTokens()) {
                String nextVal = listTok.nextToken();
                String fmtVal = df.format(Long.parseLong(nextVal));
                fmtVector.add(fmtVal);
            }
            int vecSize = fmtVector.size();
            byte[] retArray = new byte[vecSize * intLen];
            int i = 0;
            while (i < vecSize) {
                System.arraycopy(((String)fmtVector.get(i)).getBytes(), 0, retArray, i * intLen, intLen);
                ++i;
            }
            return retArray;
        }
        if (fldType.equals("D") || fldType.equals("F")) {
            String trimVal = stringVal.trim();
            if (trimVal.length() == 0) {
                return new byte[0];
            }
            int intLen = Integer.parseInt(fldLen);
            String fmtVal = BlocketteFactory.formatDecimal(blkType, fieldNum, trimVal);
            byte[] tempArray = fmtVal.getBytes();
            int copyLen = tempArray.length;
            byte[] retArray = new byte[intLen];
            if (intLen < copyLen) {
                copyLen = intLen;
            }
            System.arraycopy(tempArray, 0, retArray, 0, copyLen);
            int i = copyLen;
            while (i < intLen) {
                retArray[i] = 32;
                ++i;
            }
            return retArray;
        }
        if (fldType.equals("A")) {
            if (stringVal.length() == 0) {
                return new byte[0];
            }
            byte[] tempArray = stringVal.getBytes();
            int copyLen = tempArray.length;
            int intLen = Integer.parseInt(fldLen);
            byte[] retArray = new byte[intLen];
            if (intLen < copyLen) {
                copyLen = intLen;
            }
            System.arraycopy(tempArray, 0, retArray, 0, copyLen);
            int i = copyLen;
            while (i < intLen) {
                retArray[i] = 32;
                ++i;
            }
            return retArray;
        }
        if (fldType.equals("V")) {
            if (stringVal.length() == 0) {
                return tildeArray;
            }
            byte[] tempArray = stringVal.getBytes();
            int begin = fldLen.indexOf("-");
            int maxLen = 0;
            int copyLen = tempArray.length;
            maxLen = begin == -1 ? Integer.parseInt(fldLen) : Integer.parseInt(fldLen.substring(begin + 1));
            if (copyLen > maxLen) {
                copyLen = maxLen;
            }
            byte[] retArray = new byte[copyLen + 1];
            System.arraycopy(tempArray, 0, retArray, 0, copyLen);
            retArray[copyLen] = 126;
            return retArray;
        }
        if (fldType.equals("B")) {
            if (stringVal.length() == 0) {
                return new byte[0];
            }
            String fldMask = BlocketteFactory.getFieldMask(blkType, fieldNum);
            int intLen = Integer.parseInt(fldLen);
            if (fldMask.equals("BTIME")) {
                Btime bTime = new Btime(stringVal);
                return bTime.getByteTime();
            }
            if (fldMask.equals("UBYTE") || fldMask.equals("BYTE")) {
                StringTokenizer strTok = new StringTokenizer(stringVal, " ");
                byte[] retArray = new byte[intLen];
                byte[] tmpArray = new byte[2];
                int i = 0;
                while (strTok.hasMoreTokens() && i < intLen) {
                    int intVal = Integer.parseInt(strTok.nextToken());
                    tmpArray = Utility.intToShortBytes(intVal);
                    retArray[i] = tmpArray[1];
                    ++i;
                }
                return retArray;
            }
            if (fldMask.equals("FLOAT")) {
                float fVal = Float.parseFloat(stringVal);
                int bInt = Float.floatToIntBits(fVal);
                return Utility.longToIntBytes(bInt);
            }
            if (fldMask.equals("UWORD") || fldMask.equals("WORD")) {
                int intVal = Integer.parseInt(stringVal);
                return Utility.intToShortBytes(intVal);
            }
            if (fldMask.equals("ULONG") || fldMask.equals("LONG")) {
                long lngVal = Long.parseLong(stringVal);
                return Utility.longToIntBytes(lngVal);
            }
            throw new SeedFormatException("unrecognized binary field type: " + fldMask);
        }
        throw new SeedFormatException("unrecognized field type: " + fldType);
    }

    public static String getListValue(String listStr, int listIndex) {
        if (listStr.indexOf(91) == 0) {
            int begin = 1;
            int end = 1;
            int a = 0;
            while (a < listIndex) {
                end = listStr.indexOf(44, begin);
                if (end == -1) break;
                begin = end + 1;
                ++a;
            }
            end = listStr.indexOf(44, begin);
            if (end <= begin) {
                end = listStr.indexOf(93);
            }
            listStr = end > begin ? listStr.substring(begin, end) : "";
        }
        return listStr;
    }

    public static String setListValue(String listStr, String value, int listIndex) {
        String returnStr = value;
        Vector<String> listVec = new Vector<String>();
        if (listStr.indexOf(91) == 0) {
            int begin;
            int end = begin = 1;
            while (begin < listStr.length()) {
                end = listStr.indexOf(44, begin);
                if (end == -1) {
                    end = listStr.length() - 1;
                }
                if (begin < end) {
                    listVec.add(listStr.substring(begin, end));
                }
                begin = end + 1;
            }
            if (listVec.size() <= listIndex) {
                listVec.setSize(listIndex + 1);
            }
            listVec.setElementAt(value, listIndex);
            returnStr = listVec.toString();
        }
        return returnStr;
    }

    public static String getBlocketteDefinition(int blkType) throws SeedException {
        switch (blkType) {
            case 5: {
                return "005\tField Volume Identifier Blockette\tVolume Index\t2.0=5\n1\tBlockette type - 005\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tBeginning of volume\t\tV\t1-22\tTIME\t\t\t0\n";
            }
            case 8: {
                return "008\tTelemetry Volume Identifier Blockette\tVolume Index\t2.1=11\n1\tBlockette type - 008\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n6\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n7\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n8\tBeginning of volume\t\tV\t1-22\tTIME\t\t\t0\n9\tEnd of volume\t\t\tV\t1-22\tTIME\t\t\t0\n10\tStation info effective date\tV\t1-22\tTIME\t\t\t0\n11\tChannel info effective date\tV\t1-22\tTIME\t\t\t0\n12\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 10: {
                return "010\tVolume Identifier Blockette\t\tVolume Index\t2.0=6,2.3=9\n1\tBlockette type - 010\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tVersion of format\t\tD\t4\t\"00.0\"\t\t0\n4\tLogical record length\t\tD\t2\t\"00\"\t\t\t0\n5\tBeginning time\t\t\tV\t1-22\tTIME\t\t\t0\n6\tEnd time\t\t\tV\t1-22\tTIME\t\t\t0\n7\tVolume Time\t\t\tV\t1-22\tTIME\t\t\t0\n8\tOriginating Organization\tV\t1-80\t[]\t\t\t0\n9\tLabel\t\t\t\tV\t1-80\t[]\t\t\t0\n";
            }
            case 11: {
                return "011\tVolume Station Header Index Blockette\tVolume Index\t2.0=5\n1\tBlockette type - 011\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of stations\t\tD\t3\t\"000\"\t\t\t0\n4\tStation identifier code\t\tA\t5\t[]\t\t\t3\n5\tSequence no. of station header\tD\t6\t\"000000\"\t\t3\n";
            }
            case 12: {
                return "012\tVolume Time Span Index Blockette\tVolume Index\t2.0=6\n1\tBlockette type - 012\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of spans in table\tD\t4\t\"0000\"\t\t0\n4\tBeginning of span\t\tV\t1-22\tTIME\t\t\t3\n5\tEnd of span\t\t\tV\t1-22\tTIME\t\t\t3\n6\tSequence no. of time span hdr.\tD\t6\t\"000000\"\t\t3\n";
            }
            case 30: {
                return "030\tData Format Dictionary Blockette\tAbbreviation Dictionary\t\t2.0=7\n1\tBlockette type - 030\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tShort descriptive name\t\tV\t1-50\t[UNLPS]\t\t\t0\n4\tData format identifier code\tD\t4\t\"0000\"\t\t0\n5\tData family type\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of decoder keys\t\tD\t2\t\"00\"\t\t\t0\n7\tDecoder keys\t\t\tV\t1-9999\t[UNLPS]\t\t\t6\n";
            }
            case 31: {
                return "031\tComment Description Blockette\t\tAbbreviation Dictionary\t\t2.0=6\n1\tBlockette type - 031\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tComment code key\t\tD\t4\t\"0000\"\t\t0\n4\tComment class code\t\tA\t1\t[U]\t\t\t0\n5\tDescription of comment\t\tV\t1-70\t[UNLPS]\t\t\t0\n6\tUnits of comment level\t\tD\t3\t\"000\"\t\t\t0\n";
            }
            case 32: {
                return "032\tCited Source Dictionary Blockette\tAbbreviation Dictionary\t\t2.0=6\n1\tBlockette type - 032\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tSource lookup code\t\tD\t2\t\"00\"\t\t\t0\n4\tName of publication/author\tV\t1-70\t[UNLPS]\t\t\t0\n5\tDate published/catalog\t\tV\t1-70\t[UNLPS]\t\t\t0\n6\tPublisher name\t\t\tV\t1-50\t[UNLPS]\t\t\t0\n";
            }
            case 33: {
                return "033\tGeneric Abbreviation Blockette\t\tAbbreviation Dictionary\t\t2.0=4\n1\tBlockette type - 033\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tAbbreviation lookup code\tD\t3\t\"000\"\t\t\t0\n4\tAbbreviation description\tV\t1-50\t[UNLPS]\t\t\t0\n";
            }
            case 34: {
                return "034\tUnits Abbreviations Blockette\t\tAbbreviation Dictionary\t\t2.0=5\n1\tBlockette type - 034\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tUnit lookup code\t\tD\t3\t\"000\"\t\t\t0\n4\tUnit name\t\t\tV\t1-20\t[UNP]\t\t\t0\n5\tUnit description\t\tV\t0-50\t[UNLPS]\t\t\t0\n";
            }
            case 35: {
                return "035\tBeam Configuration Blockette\t\tAbbreviation Dictionary\t\t2.0=9\n1\tBlockette type - 035\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tUnit lookup code\t\tD\t3\t\"000\"\t\t\t0\n4\tNumber of components\t\tD\t4\t\"0000\"\t\t0\n5\tStation identifier\t\tA\t5\t[UN]\t\t\t4\n6\tLocation identifier\t\tA\t2\t[UNS]\t\t\t4\n7\tChannel identifier\t\tA\t3\t[UN]\t\t\t4\n8\tSub-channel identifier\t\tD\t4\t\"0000\"\t\t4\n9\tComponent weight\t\tD\t5\t\"0.000\"\t\t4\n";
            }
            case 41: {
                return "041\tFIR Dictionary Blockette\t\tAbbreviation Dictionary\t\t2.2=9\n1\tBlockette type - 041\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse Lookup Key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse Name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSymmetry Code\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal In Units\t\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal Out Units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of Factors\t\tD\t4\t\"0000\"\t\t0\n9\tFIR Coefficient\t\t\tF\t14\t\"0.0000000E00\"\t8\n";
            }
            case 43: {
                return "043\tResponse (Poles & Zeros) Dictionary Blockette\tAbbreviation Dictionary\t2.1=19\n1\tBlockette type - 043\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n6\tStage signal input units\tD\t3\t\"000\"\t\t\t0\n7\tStage signal output units\tD\t3\t\"000\"\t\t\t0\n8\tAO normalization factor\t\tF\t12\t\"0.00000E00\"\t\t0\n9\tNormalization frequency (Hz)\tF\t12\t\"0.00000E00\"\t\t0\n10\tNumber of complex zeros\t\tD\t3\t\"000\"\t\t\t0\n11\tReal zero\t\t\tF\t12\t\"0.00000E00\"\t\t10\n12\tImaginary zero\t\t\tF\t12\t\"0.00000E00\"\t\t10\n13\tReal zero error\t\t\tF\t12\t\"0.00000E00\"\t\t10\n14\tImaginary zero error\t\tF\t12\t\"0.00000E00\"\t\t10\n15\tNumber of complex poles\t\tD\t3\t\"000\"\t\t\t0\n16\tReal pole\t\t\tF\t12\t\"0.00000E00\"\t\t15\n17\tImaginary pole\t\t\tF\t12\t\"0.00000E00\"\t\t15\n18\tReal pole error\t\t\tF\t12\t\"0.00000E00\"\t\t15\n19\tImaginary pole error\t\tF\t12\t\"0.00000E00\"\t\t15\n";
            }
            case 44: {
                return "044\tResponse (Coefficients) Dictionary Blockette\tAbbreviation Dictionary\t2.1=13\n1\tBlockette type - 044\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UN_]\t\t\t0\n5\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of numerators\t\tD\t4\t\"0000\"\t\t0\n9\tNumerator coefficient\t\tF\t12\t\"0.00000E00\"\t\t8\n10\tNumerator error\t\t\tF\t12\t\"0.00000E00\"\t\t8\n11\tNumber of denominators\t\tD\t4\t\"0000\"\t\t0\n12\tDenominator coefficient\t\tF\t12\t\"0.00000E00\"\t\t11\n13\tDenominator error\t\tF\t12\t\"0.00000E00\"\t\t11\n";
            }
            case 45: {
                return "045\tResponse List Dictionary Blockette\tAbbreviation Dictionary\t\t2.1=12\n1\tBlockette type - 045\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of responses listed\tD\t4\t\"0000\"\t\t0\n8\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tAmplitude\t\t\tF\t12\t\"0.00000E00\"\t\t7\n10\tAmplitude error\t\t\tF\t12\t\"0.00000E00\"\t\t7\n11\tPhase angle (degrees)\t\tF\t12\t\"0.00000E00\"\t\t7\n12\tPhase error (degrees)\t\tF\t12\t\"0.00000E00\"\t\t7\n";
            }
            case 46: {
                return "046\tGeneric Response Dictionary Blockette\tAbbreviation Dictionary\t\t2.1=9\n1\tBlockette type - 046\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of corners listed\tD\t4\t\"0000\"\t\t0\n8\tCorner frequency (Hz)\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tCorner slope (db/decade)\tF\t12\t\"0.00000E00\"\t\t7\n";
            }
            case 47: {
                return "047\tDecimation Dictionary Blockette\t\tAbbreviation Dictionary\t\t2.1=9\n1\tBlockette type - 047\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tInput sample rate\t\tF\t10\t\"0.0000E00\"\t\t0\n6\tDecimation factor\t\tD\t5\t\"00000\"\t\t0\n7\tDecimation offset\t\tD\t5\t\"00000\"\t\t0\n8\tEstimated delay (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n9\tCorrection applied (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n";
            }
            case 48: {
                return "048\tChannel Sensitivity/Gain Dictionary Blockette\tAbbreviation Dictionary\t2.1=10\n1\tBlockette type - 048\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse lookup key\t\tD\t4\t\"0000\"\t\t0\n4\tResponse name\t\t\tV\t1-25\t[UNL_]\t\t\t0\n5\tSensitivity/gain\t\tF\t12\t\"0.00000E00\"\t\t0\n6\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t0\n7\tNumber of history values\tD\t2\t\"00\"\t\t\t0\n8\tSensitivity for calibration\tF\t12\t\"0.00000E00\"\t\t7\n9\tFreq. of calib. sensitivity\tF\t12\t\"0.00000E00\"\t\t7\n10\tTime of above calibration\tV\t1-22\tTIME\t\t\t7\n";
            }
            case 50: {
                return "050\tStation Identifier Blockette\t\tStation\t\t2.0=15,2.3=16\n1\tBlockette type - 050\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation call letters\t\tA\t5\t[UN]\t\t\t0\n4\tLatitude (degrees)\t\tD\t10\t\"00.000000\"\t\t0\n5\tLongitude (degrees)\t\tD\t11\t\"000.000000\"\t\t0\n6\tElevation (m)\t\t\tD\t7\t\"0000.0\"\t\t0\n7\tNumber of channels\t\tD\t4\t\"0000\"\t\t0\n8\tNumber of station comments\tD\t3\t\"000\"\t\t\t0\n9\tSite name\t\t\tV\t1-60\t[UNLPS]\t\t\t0\n10\tNetwork identifier code\t\tD\t3\t\"000\"\t\t\t0\n11\t32 bit word order\t\tD\t4\t\"0000\"\t\t0\n12\t16 bit word order\t\tD\t2\t\"00\"\t\t\t0\n13\tStart effective date\t\tV\t1-22\tTIME\t\t\t0\n14\tEnd effective date\t\tV\t0-22\tTIME\t\t\t0\n15\tUpdate flag\t\t\tA\t1\t[]\t\t\t0\n16\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 51: {
                return "051\tStation Comment Blockette\t\tStation\t\t2.0=6\n1\tBlockette type - 051\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tBeginning effective time\tV\t1-22\tTIME\t\t\t0\n4\tEnd effective time\t\tV\t1-22\tTIME\t\t\t0\n5\tComment code key\t\tD\t4\t\"0000\"\t\t0\n6\tComment level\t\t\tD\t6\t\"000000\"\t\t0\n";
            }
            case 52: {
                return "052\tChannel Identifier Blockette\t\tStation\t\t2.0=24\n1\tBlockette type - 052\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n4\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n5\tSubchannel identifier\t\tD\t4\t\"0000\"\t\t0\n6\tInstrument identifier\t\tD\t3\t\"000\"\t\t\t0\n7\tOptional comment\t\tV\t0-30\t[UNLPS]\t\t\t0\n8\tUnits of signal response\tD\t3\t\"000\"\t\t\t0\n9\tUnits of calibration input\tD\t3\t\"000\"\t\t\t0\n10\tLatitude (degrees)\t\tD\t10\t\"00.000000\"\t\t0\n11\tLongitude (degrees)\t\tD\t11\t\"000.000000\"\t\t0\n12\tElevation (m)\t\t\tD\t7\t\"0000.0\"\t\t0\n13\tLocal depth (m)\t\t\tD\t5\t\"000.0\"\t\t0\n14\tAzimuth (degrees)\t\tD\t5\t\"000.0\"\t\t0\n15\tDip (degrees)\t\t\tD\t5\t\"00.0\"\t\t0\n16\tData format identifier code\tD\t4\t\"0000\"\t\t0\n17\tData record length\t\tD\t2\t\"00\"\t\t\t0\n18\tSample rate (Hz)\t\tF\t10\t\"0.0000E00\"\t\t0\n19\tMax clock drift (seconds)\tF\t10\t\"0.0000E00\"\t\t0\n20\tNumber of comments\t\tD\t4\t\"0000\"\t\t0\n21\tChannel flags\t\t\tV\t0-26\t[U]\t\t\t0\n22\tStart date\t\t\tV\t1-22\tTIME\t\t\t0\n23\tEnd date\t\t\tV\t0-22\tTIME\t\t\t0\n24\tUpdate flag\t\t\tA\t1\t[]\t\t\t0\n";
            }
            case 53: {
                return "053\tResponse (Poles & Zeros) Blockette\tStation\t\t2.0=18\n1\tBlockette type - 053\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tTransfer function type\t\tA\t1\t[U]\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n5\tStage signal input units\tD\t3\t\"000\"\t\t\t0\n6\tStage signal output units\tD\t3\t\"000\"\t\t\t0\n7\tAO normalization factor\t\tF\t12\t\"0.00000E00\"\t\t0\n8\tNormalization freq. f(n) (Hz)\tF\t12\t\"0.00000E00\"\t\t0\n9\tNumber of complex zeros\t\tD\t3\t\"000\"\t\t\t0\n10\tReal zero\t\t\tF\t12\t\"0.00000E00\"\t\t9\n11\tImaginary zero\t\t\tF\t12\t\"0.00000E00\"\t\t9\n12\tReal zero error\t\t\tF\t12\t\"0.00000E00\"\t\t9\n13\tImaginary zero error\t\tF\t12\t\"0.00000E00\"\t\t9\n14\tNumber of complex poles\t\tD\t3\t\"000\"\t\t\t0\n15\tReal pole\t\t\tF\t12\t\"0.00000E00\"\t\t14\n16\tImaginary pole\t\t\tF\t12\t\"0.00000E00\"\t\t14\n17\tReal pole error\t\t\tF\t12\t\"0.00000E00\"\t\t14\n18\tImaginary pole error\t\tF\t12\t\"0.00000E00\"\t\t14\n";
            }
            case 54: {
                return "054\tResponse (Coefficients) Blockette\tStation\t\t2.0=12\n1\tBlockette type - 054\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tResponse type\t\t\tA\t1\t[U]\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n5\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n6\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n7\tNumber of numerators\t\tD\t4\t\"0000\"\t\t0\n8\tNumerator coefficient\t\tF\t12\t\"0.00000E00\"\t\t7\n9\tNumerator error\t\t\tF\t12\t\"0.00000E00\"\t\t7\n10\tNumber of denominators\t\tD\t4\t\"0000\"\t\t0\n11\tDenominator coefficient\t\tF\t12\t\"0.00000E00\"\t\t10\n12\tDenominator error\t\tF\t12\t\"0.00000E00\"\t\t10\n";
            }
            case 55: {
                return "055\tResponse List Blockette\t\t\tStation\t\t2.0=11\n1\tBlockette type - 055\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n5\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of responses listed\tD\t4\t\"0000\"\t\t0\n7\tFrequency (Hz)\t\t\tF\t12\t\"0.00000E00\"\t\t6\n8\tAmplitude\t\t\tF\t12\t\"0.00000E00\"\t\t6\n9\tAmplitude error\t\t\tF\t12\t\"0.00000E00\"\t\t6\n10\tPhase angle (degrees)\t\tF\t12\t\"0.00000E00\"\t\t6\n11\tPhase error (degrees)\t\tF\t12\t\"0.00000E00\"\t\t6\n";
            }
            case 56: {
                return "056\tGeneric Response Blockette\t\tStation\t\t2.0=8\n1\tBlockette type - 056\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSignal input units\t\tD\t3\t\"000\"\t\t\t0\n5\tSignal output units\t\tD\t3\t\"000\"\t\t\t0\n6\tNumber of corners listed\tD\t4\t\"0000\"\t\t0\n7\tCorner frequency (Hz)\t\tF\t12\t\"0.00000E00\"\t\t6\n8\tCorner slope (db/decade)\tF\t12\t\"0.00000E00\"\t\t6\n";
            }
            case 57: {
                return "057\tDecimation Blockette\t\t\tStation\t\t2.1=8\n1\tBlockette type - 057\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tInput sample rate (Hz)\t\tF\t10\t\"0.0000E00\"\t\t0\n5\tDecimation factor\t\tD\t5\t\"00000\"\t\t0\n6\tDecimation offset\t\tD\t5\t\"00000\"\t\t0\n7\tEstimated delay (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n8\tCorrection applied (seconds)\tF\t11\t\"0.0000E00\"\t\t0\n";
            }
            case 58: {
                return "058\tChannel Sensitivity/Gain Blockette\tStation\t\t2.0=9\n1\tBlockette type - 058\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tSensitivity/gain S(d)\t\tF\t12\t\"0.00000E00\"\t\t0\n5\tFrequency (Hz) f(s)\t\tF\t12\t\"0.00000E00\"\t\t0\n6\tNumber of history values\tD\t2\t\"00\"\t\t\t0\n7\tSensitivity for calibration\tF\t12\t\"0.00000E00\"\t\t6\n8\tFrequency of calibration (Hz)\tF\t12\t\"0.00000E00\"\t\t6\n9\tTime of above calibration\tV\t1-22\tTIME\t\t\t6\n";
            }
            case 59: {
                return "059\tChannel Comment Blockette\t\tStation\t\t2.0=6\n1\tBlockette type - 059\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tBeginning effective time\tV\t1-22\tTIME\t\t\t0\n4\tEnd effective time\t\tV\t0-22\tTIME\t\t\t0\n5\tComment code key\t\tD\t4\t\"0000\"\t\t0\n6\tComment level\t\t\tD\t6\t\"000000\"\t\t0\n";
            }
            case 60: {
                return "060\tResponse Reference Blockette\t\tStation\t\t2.1=6\n1\tBlockette type - 060\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of stages\t\tD\t2\t\"00\"\t\t\t0\n4\tStage sequence number\t\tD\t2\t\"00\"\t\t\t3\n5\tNumber of responses\t\tD\t2\t\"00\"\t\t\t3\n6\tResponse lookup key\t\tL\t4\t/0000/\t\t\t5\n";
            }
            case 61: {
                return "061\tFIR Response Blockette\t\t\tStation\t\t2.2=9\n1\tBlockette type - 061\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStage sequence number\t\tD\t2\t\"00\"\t\t\t0\n4\tResponse Name\t\t\tV\t1-25\t[ULN_]\t\t\t0\n5\tSymmetry Code\t\t\tA\t1\t[U]\t\t\t0\n6\tSignal In Units\t\t\tD\t3\t\"000\"\t\t\t0\n7\tSignal Out Units\t\tD\t3\t\"000\"\t\t\t0\n8\tNumber of Coefficients\t\tD\t4\t\"0000\"\t\t0\n9\tFIR Coefficient\t\t\tF\t14\t\"0.0000000E00\"\t8\n";
            }
            case 70: {
                return "070\tTime Span Identifier Blockette\t\tTime Span\t2.0=5\n1\tBlockette type - 070\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tTime span flag\t\t\tA\t1\t[U]\t\t\t0\n4\tBeginning time of data span\tV\t1-22\tTIME\t\t\t0\n5\tEnd time of data span\t\tV\t1-22\tTIME\t\t\t0\n";
            }
            case 71: {
                return "071\tHypocenter Information Blockette\tTime Span\t2.0=11,2.3=14\n1\tBlockette type - 071\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tOrigin time of event\t\tV\t1-22\tTIME\t\t\t0\n4\tHypocenter source identifier\tD\t2\t\"00\"\t\t\t0\n5\tLatitude of event (degrees)\tD\t10\t\"00.000000\"\t\t0\n6\tLongitude of event (degrees)\tD\t11\t\"000.000000\"\t\t0\n7\tDepth (Km)\t\t\tD\t7\t\"0000.00\"\t\t0\n8\tNumber of magnitudes\t\tD\t2\t\"00\"\t\t\t0\n9\tMagnitude\t\t\tD\t5\t\"00.00\"\t\t8\n10\tMagnitude type\t\t\tV\t1-10\t[UNLPS]\t\t\t8\n11\tMagnitude source\t\tD\t2\t\"00\"\t\t\t8\n12\tSeismic region\t\t\tD\t3\t\"000\"\t\t\t0\n13\tSeismic Location\t\tD\t4\t\"0000\"\t\t0\n14\tRegion Name\t\t\tV\t1-40\t[UNLPS]\t\t\t0\n";
            }
            case 72: {
                return "072\tEvent Phases Blockette\t\t\tTime Span\t2.0=10,2.3=12\n1\tBlockette type - 072\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n4\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n5\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n6\tArrival time of phase\t\tV\t1-22\tTIME\t\t\t0\n7\tAmplitude of signal\t\tF\t10\t\"0.0000E00\"\t\t0\n8\tPeriod of signal (seconds)\tF\t10\t\"0.0000E00\"\t\t0\n9\tSignal-to-noise ratio\t\tF\t10\t\"0.0000E00\"\t\t0\n10\tName of phase\t\t\tV\t1-20\t[UNLP]\t\t\t0\n11\tSource\t\t\t\tD\t2\t\"00\"\t\t\t0\n12\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 73: {
                return "073\tTime Span Data Start Index Blockette\tTime Span\t2.0=9\n1\tBlockette type - 073\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tNumber of data pieces\t\tD\t4\t\"0000\"\t\t0\n4\tStation identifier\t\tA\t5\t[UN]\t\t\t3\n5\tLocation identifier\t\tA\t2\t[UNS]\t\t\t3\n6\tChannel identifier\t\tA\t3\t[UN]\t\t\t3\n7\tTime of record\t\t\tV\t1-22\tTIME\t\t\t3\n8\tSequence number of first record\tD\t6\t\"000000\"\t\t3\n9\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t3\n";
            }
            case 74: {
                return "074\tTime Series Index Blockette\t\tTime Span\t2.1=15,2.3=16\n1\tBlockette type - 074\t\tD\t3\t\"000\"\t\t\t0\n2\tLength of blockette\t\tD\t4\t\"0000\"\t\t0\n3\tStation identifier\t\tA\t5\t[UN]\t\t\t0\n4\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n5\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n6\tSeries start time\t\tV\t1-22\tTIME\t\t\t0\n7\tSequence number of first data\tD\t6\t\"000000\"\t\t0\n8\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t0\n9\tSeries end time\t\t\tV\t1-22\tTIME\t\t\t0\n10\tSequence number of last record\tD\t6\t\"000000\"\t\t0\n11\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t0\n12\tNumber of accelerator repeats\tD\t3\t\"000\"\t\t\t0\n13\tRecord start time\t\tV\t1-22\tTIME\t\t\t12\n14\tSequence number of record\tD\t6\t\"000000\"\t\t12\n15\tSub-sequence number\t\tD\t2\t\"00\"\t\t\t12\n16\tNetwork Code\t\t\tA\t2\t[UN]\t\t\t0\n";
            }
            case 999: {
                return "999\tFixed Section of Data Header\tData Record\t2.0=18\n1\tBlockette type - 999\t\tD\t2\tUWORD\t\t\t0\n2\tData Quality Flags\t\tA\t8\t[UNS]\t\t\t0\n3\tData Arrival Time Stamp\t\tB\t10\tBTIME\t\t\t0\n4\tStation identifier code\t\tA\t5\t[UN]\t\t\t0\n5\tLocation identifier\t\tA\t2\t[UNS]\t\t\t0\n6\tChannel identifier\t\tA\t3\t[UN]\t\t\t0\n7\tNetwork Code\t\t\tA\t2\t[]\t\t\t0\n8\tRecord start time\t\tB\t10\tBTIME\t\t\t0\n9\tNumber of samples\t\tB\t2\tUWORD\t\t\t0\n10\tSample rate factor\t\tB\t2\tWORD\t\t\t0\n11\tSample rate multiplier\t\tB\t2\tWORD\t\t\t0\n12\tActivity flags\t\t\tB\t1\tUBYTE\t\t\t0\n13\tI/O and clock flags\t\tB\t1\tUBYTE\t\t\t0\n14\tData quality flags\t\tB\t1\tUBYTE\t\t\t0\n15\tNo. of blockettes that follow\tB\t1\tUBYTE\t\t\t0\n16\tTime correction\t\t\tB\t4\tLONG\t\t\t0\n17\tBeginning of data\t\tB\t2\tUWORD\t\t\t0\n18\tFirst blockette\t\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 100: {
                return "100\tSample Rate Blockette\t\t\tData Record\t2.3=5\n1\tBlockette type - 100\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tActual Sample Rate\t\tB\t4\tFLOAT\t\t\t0\n4\tFlags (to be defined)\t\tB\t1\tBYTE\t\t\t0\n5\tReserved byte\t\t\tB\t3\tUBYTE\t\t\t0\n";
            }
            case 200: {
                return "200\tGeneric Event Detection Blockette\tData Record\t2.0=9\n1\tBlockette type - 200\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tSignal amplitude\t\tB\t4\tFLOAT\t\t\t0\n4\tSignal period\t\t\tB\t4\tFLOAT\t\t\t0\n5\tBackground estimate\t\tB\t4\tFLOAT\t\t\t0\n6\tEvent detection flags\t\tB\t1\tUBYTE\t\t\t0\n7\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n8\tSignal onset time\t\tB\t10\tBTIME\t\t\t0\n9\tDetector Name\t\t\tA\t24\t[]\t\t\t0\n";
            }
            case 201: {
                return "201\tMurdock Event Detection Blockette\tData Record\t2.0=12\n1\tBlockette type - 201\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tSignal amplitude\t\tB\t4\tFLOAT\t\t\t0\n4\tSignal period\t\t\tB\t4\tFLOAT\t\t\t0\n5\tBackground estimate\t\tB\t4\tFLOAT\t\t\t0\n6\tEvent detection flags\t\tB\t1\tUBYTE\t\t\t0\n7\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n8\tSignal onset time\t\tB\t10\tBTIME\t\t\t0\n9\tSignal-to-noise ratio values\tB\t6\tUBYTE\t\t\t0\n10\tLookback value\t\t\tB\t1\tUBYTE\t\t\t0\n11\tPick algorithm\t\t\tB\t1\tUBYTE\t\t\t0\n12\tDetector name\t\t\tA\t24\t[]\t\t\t0\n";
            }
            case 300: {
                return "300\tStep Calibration Blockette\t\tData Record\t2.0=13\n1\tBlockette type - 300\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tNumber of step calibrations\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tStep duration\t\t\tB\t4\tULONG\t\t\t0\n7\tInterval duration\t\tB\t4\tULONG\t\t\t0\n8\tCalibration signal amplitude\tB\t4\tFLOAT\t\t\t0\n9\tChannel with calibration input\tA\t3\t[]\t\t\t0\n10\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n11\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n12\tCoupling\t\t\tA\t12\t[]\t\t\t0\n13\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n";
            }
            case 310: {
                return "310\tSine Calibration Blockette\t\tData Record\t2.0=13\n1\tBlockette type - 310\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tPeriod of signal (seconds)\tB\t4\tFLOAT\t\t\t0\n8\tAmplitude of signal\t\tB\t4\tFLOAT\t\t\t0\n9\tChannel with calibration input\tA\t3\t[]\t\t\t0\n10\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n11\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n12\tCoupling\t\t\tA\t12\t[]\t\t\t0\n13\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n";
            }
            case 320: {
                return "320\tPseudo-random Calibration Blockette\tData Record\t2.0=13\n1\tBlockette type - 320\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tPeak-to-peak amplitude of steps\tB\t4\tFLOAT\t\t\t0\n8\tChannel with calibration output\tA\t3\t[]\t\t\t0\n9\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n10\tReference amplitude\t\tB\t4\tULONG\t\t\t0\n11\tCoupling\t\t\tA\t12\t[]\t\t\t0\n12\tRolloff\t\t\t\tA\t12\t[]\t\t\t0\n13\tNoise type\t\t\tA\t8\t[]\t\t\t0\n";
            }
            case 390: {
                return "390\tGeneric Calibration Blockette\t\tData Record\t2.0=9\n1\tBlockette type - 390\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeginning of calibration time\tB\t10\tBTIME\t\t\t0\n4\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n5\tCalibration flags\t\tB\t1\tUBYTE\t\t\t0\n6\tCalibration duration\t\tB\t4\tULONG\t\t\t0\n7\tCalibration signal amplitude\tB\t4\tFLOAT\t\t\t0\n8\tChannel with calibration input\tA\t3\t[]\t\t\t0\n9\tReserved byte\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
            case 395: {
                return "395\tCalibration Abort Blockette\t\tData Record\t2.0=4\n1\tBlockette type - 395\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tEnd of calibration time\t\tB\t10\tBTIME\t\t\t0\n4\tReserved bytes\t\t\tB\t2\tUBYTE\t\t\t0\n";
            }
            case 400: {
                return "400\tBeam Blockette\t\t\t\tData Record\t2.0=6\n1\tBlockette type - 400\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tBeam azimuth (degrees)\t\tB\t4\tFLOAT\t\t\t0\n4\tBeam slowness (sec/degree)\tB\t4\tFLOAT\t\t\t0\n5\tBeam configuration\t\tB\t2\tUWORD\t\t\t0\n6\tReserved bytes\t\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 405: {
                return "405\tBeam Delay Blockette\t\t\tData Record\t2.0=3\n1\tBlockette type - 405\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tArray of delay values\t\tB\t2\tUWORD\t\t\t0\n";
            }
            case 500: {
                return "500\tTiming Blockette\t\t\tData Record\t2.0=10\n1\tBlockette type - 500\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tVCO correction\t\t\tB\t4\tFLOAT\t\t\t0\n4\tTime of exception\t\tB\t10\tBTIME\t\t\t0\n5\tMicroseconds\t\t\tB\t1\tUBYTE\t\t\t0\n6\tReception Quality\t\tB\t1\tUBYTE\t\t\t0\n7\tException count\t\t\tB\t4\tULONG\t\t\t0\n8\tException type\t\t\tA\t16\t[]\t\t\t0\n9\tClock model\t\t\tA\t32\t[]\t\t\t0\n10\tClock status\t\t\tA\t128\t[]\t\t\t0\n";
            }
            case 1000: {
                return "1000\tData Only SEED Blockette\t\tData Record\t2.3=6\n1\tBlockette type - 1000\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tEncoding format\t\t\tB\t1\tBYTE\t\t\t0\n4\tWord order\t\t\tB\t1\tUBYTE\t\t\t0\n5\tData Record Length\t\tB\t1\tUBYTE\t\t\t0\n6\tReserved\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
            case 1001: {
                return "1001\tData Extension Blockette\t\tData Record\t2.0=6\n1\tBlockette type - 1001\t\tB\t2\tUWORD\t\t\t0\n2\tNext blockette's byte number\tB\t2\tUWORD\t\t\t0\n3\tTiming quality\t\t\tB\t1\tUBYTE\t\t\t0\n4\tMicroseconds\t\t\tB\t1\tUBYTE\t\t\t0\n5\tReserved\t\t\tB\t1\tUBYTE\t\t\t0\n6\tFrame Count\t\t\tB\t1\tUBYTE\t\t\t0\n";
            }
        }
        throw new SeedException("Blockette type " + blkType + " not defined");
    }

    public static String getTranslation(int blkType, int fieldNum, Object value) {
        switch (blkType) {
            case 30: {
                if (fieldNum != 5) break;
                int val = Integer.parseInt(value.toString());
                if (val == 0) {
                    return "Integer format fixed interval data";
                }
                if (val == 1) {
                    return "Gain ranged fixed interval data";
                }
                if (val == 50) {
                    return "Integer differences compression";
                }
                if (val == 80) {
                    return "ASCII text with line control (for console logs)";
                }
                if (val != 81) break;
                return "Non-ASCII text (for other language character sets)";
            }
            case 41: {
                String val;
                if (fieldNum == 5) {
                    val = value.toString();
                    if (val.equals("A")) {
                        return "No Symmetry - all Coefficients are specified";
                    }
                    if (val.equals("B")) {
                        return "Odd number Coefficients with symmetry";
                    }
                    if (val.equals("C")) {
                        return "Even number Coefficients with symmetry";
                    }
                }
                if (fieldNum != 8) break;
                val = value.toString();
                if (val.equals("A")) {
                    return "No Symmetry - All Coefficients specified";
                }
                if (val.equals("B")) {
                    return "Odd - First half of all coefficients and center coefficient specified";
                }
                if (!val.equals("C")) break;
                return "Even - First half of all coefficients specified";
            }
            case 43: {
                if (fieldNum != 5) break;
                String val = value.toString();
                if (val.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (val.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (val.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!val.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 44: {
                if (fieldNum != 5) break;
                String val = value.toString();
                if (val.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (val.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (val.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!val.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 50: {
                int val;
                if (fieldNum == 11) {
                    val = Integer.parseInt(value.toString());
                    if (val == 123) {
                        return "VAX, 8086 series";
                    }
                    if (val == 3210) {
                        return "68000 series";
                    }
                }
                if (fieldNum == 12) {
                    val = Integer.parseInt(value.toString());
                    if (val == 1) {
                        return "VAX, 8086 series";
                    }
                    if (val == 10) {
                        return "68000 series";
                    }
                }
                if (fieldNum != 15) break;
                String val2 = value.toString();
                if (val2.equals("N") || val2.equals("n")) {
                    return "Effective dates pertain to these data";
                }
                if (!val2.equals("U") && !val2.equals("u")) break;
                return "Control header updates information previously sent";
            }
            case 52: {
                if (fieldNum != 21) break;
                String val = value.toString();
                StringBuffer outVal = new StringBuffer();
                if (val.indexOf("T") >= 0) {
                    outVal.append("Channel is triggered\n");
                }
                if (val.indexOf("C") >= 0) {
                    outVal.append("Channel is recorded continuously\n");
                }
                if (val.indexOf("H") >= 0) {
                    outVal.append("State of health data\n");
                }
                if (val.indexOf("G") >= 0) {
                    outVal.append("Geophysical data\n");
                }
                if (val.indexOf("W") >= 0) {
                    outVal.append("Weather or environmental data\n");
                }
                if (val.indexOf("F") >= 0) {
                    outVal.append("Flag information (nominal, not ordinal)\n");
                }
                if (val.indexOf("S") >= 0) {
                    outVal.append("Synthesized data\n");
                }
                if (val.indexOf("I") >= 0) {
                    outVal.append("Channel is a calibration input\n");
                }
                if (val.indexOf("E") >= 0) {
                    outVal.append("Channel is experimental or temporary\n");
                }
                if (val.indexOf("M") >= 0) {
                    outVal.append("Maintenance tests are underway on channel; possible abnormal data\n");
                }
                if (val.indexOf("B") >= 0) {
                    outVal.append("Data are a beam synthesis\n");
                }
                return outVal.toString();
            }
            case 53: {
                if (fieldNum != 3) break;
                String val = value.toString();
                if (val.equals("A")) {
                    return "Laplace transform analog response, in rad/sec";
                }
                if (val.equals("B")) {
                    return "Analog response, in Hz";
                }
                if (val.equals("C")) {
                    return "Composite (currently undefined)";
                }
                if (!val.equals("D")) break;
                return "Digital (Z-transform)";
            }
            case 61: {
                String val;
                if (fieldNum == 5) {
                    val = value.toString();
                    if (val.equals("A")) {
                        return "No Symmetry - all Coefficients are specified";
                    }
                    if (val.equals("B")) {
                        return "Odd number Coefficients with symmetry";
                    }
                    if (val.equals("C")) {
                        return "Even number Coefficients with symmetry";
                    }
                }
                if (fieldNum != 8) break;
                val = value.toString();
                if (val.equals("A")) {
                    return "No Symmetry - All Coefficients specified";
                }
                if (val.equals("B")) {
                    return "Odd - First half of all coefficients and center coefficient specified";
                }
                if (!val.equals("C")) break;
                return "Even - First half of all coefficients specified";
            }
            case 70: {
                if (fieldNum != 3) break;
                String val = value.toString();
                if (val.equals("E")) {
                    return "Data are event oriented";
                }
                if (!val.equals("P")) break;
                return "Data are for a given period";
            }
            case 999: {
                if (fieldNum == 2) {
                    String val = value.toString();
                    StringBuffer outVal = new StringBuffer();
                    if (val.indexOf("D") >= 0) {
                        outVal.append("Default data (might be QC'd, might not be)\n");
                    }
                    if (val.indexOf("R") >= 0) {
                        outVal.append("Real-time data (un-QC'd)\n");
                    }
                    if (val.indexOf("Q") >= 0) {
                        outVal.append("Quality controlled data (QC'd)\n");
                    }
                    if (val.indexOf("P") >= 0) {
                        outVal.append("Primary data source\n");
                    }
                    if (val.indexOf("S") >= 0) {
                        outVal.append("Secondary data source\n");
                    }
                    return outVal.toString();
                }
                if (fieldNum == 12) {
                    int val = Integer.parseInt(value.toString());
                    StringBuffer outVal = new StringBuffer();
                    if (val > 127) {
                        outVal.append("Bit 7 set (undefined)\n");
                        val -= 128;
                    }
                    if (val > 63) {
                        outVal.append("Event in progress\n");
                        val -= 64;
                    }
                    if (val > 31) {
                        outVal.append("A negative leap second happened during this record (A 59 second minute)\n");
                        val -= 32;
                    }
                    if (val > 15) {
                        outVal.append("A positive leap second happened during this record (A 61 second minute)\n");
                        val -= 16;
                    }
                    if (val > 7) {
                        outVal.append("End of the event, station detriggers\n");
                        val -= 8;
                    }
                    if (val > 3) {
                        outVal.append("Beginning of an event, station trigger\n");
                        val -= 4;
                    }
                    if (val > 1) {
                        outVal.append("Time correction in field 16 applied to field 8\n");
                        val -= 2;
                    }
                    if (val > 0) {
                        outVal.append("Calibration signals present\n");
                    }
                    return outVal.toString();
                }
                if (fieldNum == 13) {
                    int val = Integer.parseInt(value.toString());
                    StringBuffer outVal = new StringBuffer();
                    if (val > 127) {
                        outVal.append("Bit 7 set (undefined)\n");
                        val -= 128;
                    }
                    if (val > 63) {
                        outVal.append("Bit 6 set (undefined)\n");
                        val -= 64;
                    }
                    if (val > 31) {
                        outVal.append("Clock locked\n");
                        val -= 32;
                    }
                    if (val > 15) {
                        outVal.append("End of time series\n");
                        val -= 16;
                    }
                    if (val > 7) {
                        outVal.append("Start of time series\n");
                        val -= 8;
                    }
                    if (val > 3) {
                        outVal.append("Short record read (record padded)\n");
                        val -= 4;
                    }
                    if (val > 1) {
                        outVal.append("Long record read (possibly no problem)\n");
                        val -= 2;
                    }
                    if (val > 0) {
                        outVal.append("Station volume parity error possibly present\n");
                    }
                    return outVal.toString();
                }
                if (fieldNum != 14) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Time tag is questionable\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("A digital filter may be charging\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("Telemetry synchronization error\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("Missing/padded data present\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("Glitches detected\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("Spikes detected\n");
                    val -= 4;
                }
                if (val > 1) {
                    outVal.append("Digitizer clipping detected\n");
                    val -= 2;
                }
                if (val > 0) {
                    outVal.append("Amplifier saturation detected (station dependent)\n");
                }
                return outVal.toString();
            }
            case 200: {
                if (fieldNum != 6) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Bit 7 set (undefined)\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("Bit 6 set (undefined)\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("Bit 5 set (undefined)\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("Bit 4 set (undefined)\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("Bit 3 set (undefined)\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("bit 0 is undetermined\n");
                    val -= 4;
                }
                if (val > 1) {
                    outVal.append("units above are after deconvolution\n");
                    val -= 2;
                } else {
                    outVal.append("digital counts\n");
                }
                if (val > 0) {
                    outVal.append("dilatation wave\n");
                } else {
                    outVal.append("compression\n");
                }
                return outVal.toString();
            }
            case 201: {
                if (fieldNum != 6) break;
                int val = Integer.parseInt(value.toString());
                if (val > 0) {
                    return "dilatation wave";
                }
                return "compression";
            }
            case 300: {
                if (fieldNum != 5) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Bit 7 set (undefined)\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("Bit 6 set (undefined)\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("Bit 5 set (undefined)\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("Bit 4 set (undefined)\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("calibration continued from previous record(s)\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("calibration was automatic\n");
                    val -= 4;
                } else {
                    outVal.append("calibration was manual\n");
                }
                if (val > 1) {
                    outVal.append("calibration's alternate sign\n");
                    val -= 2;
                }
                if (val > 0) {
                    outVal.append("first pulse is positive\n");
                }
                return outVal.toString();
            }
            case 310: {
                if (fieldNum != 5) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Bit 7 set (undefined)\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("RMS amplitude\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("zero-to-peak amplitude\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("peak-to-peak amplitude\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("calibration continued from previous record(s)\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("calibration was automatic\n");
                    val -= 4;
                } else {
                    outVal.append("calibration was manual\n");
                }
                if (val > 1) {
                    outVal.append("Bit 1 set (undefined)\n");
                    val -= 2;
                }
                if (val > 0) {
                    outVal.append("Bit 0 set (undefined)\n");
                }
                return outVal.toString();
            }
            case 320: {
                if (fieldNum != 5) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Bit 7 set (undefined)\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("Bit 6 set (undefined)\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("Bit 5 set (undefined)\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("random amplitudes\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("calibration continued from previous record(s)\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("calibration was automatic\n");
                    val -= 4;
                } else {
                    outVal.append("calibration was manual\n");
                }
                if (val > 1) {
                    outVal.append("Bit 1 set (undefined)\n");
                    val -= 2;
                }
                if (val > 0) {
                    outVal.append("Bit 0 set (undefined)\n");
                }
                return outVal.toString();
            }
            case 390: {
                if (fieldNum != 5) break;
                int val = Integer.parseInt(value.toString());
                StringBuffer outVal = new StringBuffer();
                if (val > 127) {
                    outVal.append("Bit 7 set (undefined)\n");
                    val -= 128;
                }
                if (val > 63) {
                    outVal.append("Bit 6 set (undefined)\n");
                    val -= 64;
                }
                if (val > 31) {
                    outVal.append("Bit 5 set (undefined)\n");
                    val -= 32;
                }
                if (val > 15) {
                    outVal.append("Bit 4 set (undefined)\n");
                    val -= 16;
                }
                if (val > 7) {
                    outVal.append("calibration continued from previous record(s)\n");
                    val -= 8;
                }
                if (val > 3) {
                    outVal.append("calibration was automatic\n");
                    val -= 4;
                } else {
                    outVal.append("calibration was manual\n");
                }
                if (val > 1) {
                    outVal.append("Bit 1 set (undefined)\n");
                    val -= 2;
                }
                if (val > 0) {
                    outVal.append("Bit 0 set (undefined)\n");
                }
                return outVal.toString();
            }
            case 1000: {
                if (fieldNum == 3) {
                    int val = Integer.parseInt(value.toString());
                    switch (val) {
                        case 0: {
                            return "ASCII text, byte order as specified in field 4";
                        }
                        case 1: {
                            return "16 bit integers";
                        }
                        case 2: {
                            return "24 bit integers";
                        }
                        case 3: {
                            return "32 bit integers";
                        }
                        case 4: {
                            return "IEEE floating point";
                        }
                        case 5: {
                            return "IEEE double precision floating point";
                        }
                        case 10: {
                            return "STEIM (1) Compression";
                        }
                        case 11: {
                            return "STEIM (2) Compression";
                        }
                        case 12: {
                            return "GEOSCOPE Multiplexed Format 24 bit integer";
                        }
                        case 13: {
                            return "GEOSCOPE Multiplexed Format 16 bit gain ranged, 3 bit exponent";
                        }
                        case 14: {
                            return "GEOSCOPE Multiplexed Format 16 bit gain ranged, 4 bit exponent";
                        }
                        case 15: {
                            return "US National Network compression";
                        }
                        case 16: {
                            return "CDSN 16 bit gain ranged";
                        }
                        case 17: {
                            return "Graefenberg 16 bit gain ranged";
                        }
                        case 18: {
                            return "IPG - Strasbourg 16 bit gain ranged";
                        }
                        case 19: {
                            return "STEIM (3) Compression";
                        }
                        case 30: {
                            return "SRO Format";
                        }
                        case 31: {
                            return "HGLP Format";
                        }
                        case 32: {
                            return "DWWSSN Gain Ranged Format";
                        }
                        case 33: {
                            return "RSTN 16 bit gain ranged";
                        }
                    }
                    return "Undefined encoding format";
                }
                if (fieldNum != 4) break;
                int val = Integer.parseInt(value.toString());
                if (val > 0) {
                    return "68000/SPARC word order";
                }
                return "VAX/8086 word order";
            }
            default: {
                return "Value Undefined";
            }
        }
        return "Value Undefined";
    }

    private static String getField(int blkType, int fieldNum) throws SeedException {
        String blkDefString = BlocketteFactory.getBlocketteDefinition(blkType);
        int begin = 0;
        int end = 0;
        int i = 0;
        while (i < fieldNum) {
            end = blkDefString.indexOf("\n", begin);
            if (end == -1) {
                throw new SeedException("field number " + fieldNum + "not defined for blockette " + blkType);
            }
            begin = end + 1;
            ++i;
        }
        end = blkDefString.indexOf("\n", begin);
        if (end == -1) {
            return blkDefString.substring(begin);
        }
        return blkDefString.substring(begin, end);
    }

    private static String getField(int blkType, int fieldNum, int colNum) throws SeedException {
        String defLine = BlocketteFactory.getField(blkType, fieldNum);
        int begin = 0;
        int end = 0;
        int prevBegin = 0;
        int i = 1;
        while (i <= colNum) {
            prevBegin = end;
            while (prevBegin == end) {
                end = defLine.indexOf("\t", begin);
                prevBegin = begin;
                begin = end + 1;
            }
            ++i;
        }
        begin = prevBegin;
        if (end == -1) {
            return defLine.substring(begin);
        }
        return defLine.substring(begin, end);
    }

    public static void main(String[] args) {
        try {
            int blkType = 10;
            String blkStr = "010009502.3121992,001,00:00:00.0000~1992,002,00:00:00.0000~1993,029~IRIS_DMC~Data for 1992,001~";
            byte[] blkArr = blkStr.getBytes();
            Blockette myBlockette = BlocketteFactory.createBlockette(blkArr, false, false);
            System.out.println("I am blockette type " + myBlockette.getType());
            System.out.println("In field 4, the logical record length exponent is " + myBlockette.getFieldVal(4).toString());
            System.out.println("In field 6, the end time is " + myBlockette.getFieldVal(6).toString());
            System.out.println("In field 9, the label is " + myBlockette.getFieldVal(9).toString());
            blkType = 50;
            blkStr = "0500098ANMO +34.946200-106.456700+1740.00006001Albuquerque, New Mexico, USA~0013210101989,241~~NIU";
            blkArr = blkStr.getBytes();
            myBlockette = BlocketteFactory.createBlockette(blkArr, false, false);
            System.out.println("I am blockette type " + myBlockette.getType());
            System.out.println("The station name is " + myBlockette.getFieldVal(3).toString());
            System.out.println("The longitude is " + myBlockette.getFieldVal(5).toString());
            System.out.println("The elevation is " + myBlockette.getFieldVal(6).toString());
            System.out.println("The start effective date is " + myBlockette.getFieldVal(13).toString());
            System.out.println("The update flag is " + myBlockette.getFieldVal(15).toString());
            System.out.println("Which translates to " + myBlockette.translate(15));
            blkType = 52;
            blkStr = "0520119  BHE0000004~001002+34.946200-106.456700+1740.0100.0090.0+00.0000112 2.000E+01 2.000E-030000CG~1991,042,20:48~~N";
            blkArr = blkStr.getBytes();
            Blockette chanBlockette = BlocketteFactory.createBlockette(blkArr, false, false);
            int whereIndex = myBlockette.addChildBlockette(chanBlockette);
            System.out.println("Added a child blockette.  myBlockette contains " + myBlockette.numberofChildBlockettes() + " blockettes.");
            Blockette grabChild = myBlockette.getChildBlockette(whereIndex);
            System.out.println("I am blockette type " + grabChild.getType());
            System.out.println("My definition is as follows:\n" + grabChild.getDefinition());
            System.out.println("The channel name is " + grabChild.getFieldVal(4).toString());
            System.out.println("using the shorter toString() call, the value is " + grabChild.toString(4));
            System.out.println("The " + grabChild.getFieldName(8) + " is " + grabChild.getFieldVal(8).toString());
            System.out.println("using the shorter toString() call, the value is " + grabChild.toString(8));
            System.out.println("The " + grabChild.getFieldName(18) + " is " + grabChild.getFieldVal(18).toString());
            System.out.println("using the shorter toString() call, the value is " + grabChild.toString(18));
            System.out.println("The " + grabChild.getFieldName(19) + " is " + grabChild.getFieldVal(19).toString());
            System.out.println("using the shorter toString() call, the value is " + grabChild.toString(19));
            System.out.println("The " + grabChild.getFieldName(21) + " is " + grabChild.toString(21));
            System.out.println("which translated means: " + grabChild.translate(21));
            blkType = 53;
            blkStr = "0530382B 1007008 7.87395E+00 5.00000E-02  3 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00 0.00000E+00-1.27000E+01 0.00000E+00 0.00000E+00 0.00000E+00  4-1.96418E-03 1.96418E-03 0.00000E+00 0.00000E+00-1.96418E-03-1.96418E-03 0.00000E+00 0.00000E+00-6.23500E+00 7.81823E+00 0.00000E+00 0.00000E+00-6.23500E+00-7.81823E+00 0.00000E+00 0.00000E+00";
            blkArr = blkStr.getBytes();
            chanBlockette = BlocketteFactory.createBlockette(blkArr, false, false);
            whereIndex = myBlockette.addChildBlockette(chanBlockette);
            System.out.println("Added a child blockette.  myBlockette contains " + myBlockette.numberofChildBlockettes() + " blockettes.");
            grabChild = myBlockette.getChildBlockette(whereIndex);
            System.out.println("I am blockette type " + grabChild.getType());
            System.out.println("The " + grabChild.getFieldName(14) + " is " + grabChild.getFieldVal(14).toString());
            System.out.println("The " + grabChild.getFieldName(15) + " at index 2 is " + grabChild.getFieldVal(15, 2).toString());
            System.out.println("which I can also print with the toString() method as " + grabChild.toString(15, 2));
            System.out.println("The " + grabChild.getFieldName(16) + " at index 0 is " + grabChild.getFieldVal(16, 0).toString());
            System.out.println("which I can also print with the toString() method as " + grabChild.toString(16, 0));
            System.out.println("Now I want to add an additional coefficient set to the complex zeros...");
            Vector<Float> zerosVec = new Vector<Float>(4);
            zerosVec.add(new Float(0.01732));
            zerosVec.add(new Float(-0.01732));
            zerosVec.add(new Float(0.0f));
            zerosVec.add(new Float(0.0f));
            grabChild.addFieldGrp(10, zerosVec);
            System.out.println("...and then I want to read back all of the values");
            System.out.println("there are " + grabChild.toString(9) + " field groups here");
            int numGrps = Integer.parseInt(grabChild.toString(9));
            int i = 0;
            while (i < numGrps) {
                Vector fieldVec = grabChild.getFieldGrp(10, i);
                System.out.print("" + i + ": ");
                int j = 0;
                while (j < fieldVec.size()) {
                    System.out.print("" + BlocketteFactory.formatDecimal(blkType, 10 + j, fieldVec.get(j).toString()) + ",");
                    ++j;
                }
                System.out.println("");
                ++i;
            }
            blkStr = "999|D|1900|ANMO|  |BHZ|IU|1998,001|3849|20|1|68|12|144|0|2829|256|0";
            Blockette fsdhBlockette = BlocketteFactory.createBlockette(blkStr);
            System.out.println("\n\nI am blockette type " + fsdhBlockette.getType());
            System.out.println("which means I am called a " + fsdhBlockette.getName());
            int i2 = 2;
            while (i2 < 19) {
                System.out.println("The " + fsdhBlockette.getFieldName(i2) + " is " + fsdhBlockette.toString(i2));
                System.out.println("which translates to: " + fsdhBlockette.translate(i2));
                ++i2;
            }
            blkStr = "06000650402030098007600430301003404040033004400550066050200030002";
            blkArr = blkStr.getBytes();
            Blockette blockette60 = BlocketteFactory.createBlockette(blkArr, false, false);
            System.out.println("\n\nI am blockette type " + blockette60.getType());
            System.out.println("which means I am called a " + blockette60.getName());
            int i3 = 2;
            while (i3 <= blockette60.getNumFields()) {
                System.out.println("The " + blockette60.getFieldName(i3) + " is " + blockette60.toString(i3));
                System.out.println("which translates to: " + blockette60.translate(i3));
                if (i3 == 3) {
                    int numStages = Integer.parseInt(blockette60.toString(i3));
                    int j = 0;
                    while (j < numStages) {
                        Vector stageVec = blockette60.getFieldGrp(4, j);
                        System.out.print("Stage " + j + ": ");
                        int k = 0;
                        while (k < stageVec.size()) {
                            System.out.print("" + BlocketteFactory.formatDecimal(60, 4 + k, stageVec.get(k).toString()) + ",");
                            ++k;
                        }
                        System.out.println("");
                        ++j;
                    }
                    break;
                }
                ++i3;
            }
        }
        catch (SeedException e) {
            System.out.println("Caught exception: " + e);
        }
    }

    static {
        try {
            int i = 0;
            while (i < numberOfBlocketteTypes) {
                int bType = blocketteTypes[i];
                BlocketteFactory.blocketteTypeMap[bType] = i;
                BlocketteFactory.arrayBlkName[i] = BlocketteFactory.getName(bType);
                BlocketteFactory.arrayBlkCategory[i] = BlocketteFactory.getCategory(bType);
                BlocketteFactory.arrayNumFields[i] = BlocketteFactory.getNumFields(bType);
                int numFields = BlocketteFactory.getNumFields(bType, 99.9f);
                BlocketteFactory.arrayFieldName[i] = new String[numFields];
                BlocketteFactory.arrayFieldType[i] = new char[numFields];
                BlocketteFactory.arrayFieldLength[i] = new String[numFields];
                BlocketteFactory.arrayFieldMask[i] = new String[numFields];
                BlocketteFactory.arrayFieldRepeat[i] = new int[numFields];
                int j = 0;
                while (j < numFields) {
                    BlocketteFactory.arrayFieldName[i][j] = BlocketteFactory.getFieldName(bType, j + 1);
                    BlocketteFactory.arrayFieldType[i][j] = BlocketteFactory.getFieldType(bType, j + 1).charAt(0);
                    BlocketteFactory.arrayFieldLength[i][j] = BlocketteFactory.getFieldLength(bType, j + 1);
                    BlocketteFactory.arrayFieldMask[i][j] = BlocketteFactory.getFieldMask(bType, j + 1);
                    BlocketteFactory.arrayFieldRepeat[i][j] = BlocketteFactory.getFieldRepeat(bType, j + 1);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        optimized = true;
    }
}

