/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.PoleZeroFilter;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.TransferType;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.fissuresUtil.sac.SacPoleZero;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.util.Calendar;
import java.util.Date;

public class FissuresToSac {
    public static SacTimeSeries getSAC(LocalSeismogramImpl seis) throws CodecException {
        float[] floatSamps;
        SacTimeSeries sac = new SacTimeSeries();
        try {
            if (seis.can_convert_to_long()) {
                int[] idata = seis.get_as_longs();
                floatSamps = new float[idata.length];
                for (int i = 0; i < idata.length; ++i) {
                    floatSamps[i] = idata[i];
                }
            } else {
                floatSamps = seis.get_as_floats();
            }
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                throw (CodecException)e.getCause();
            }
            throw new CodecException(e.the_error.error_description);
        }
        sac.y = floatSamps;
        sac.npts = sac.y.length;
        sac.b = 0.0f;
        sac.iztype = 9;
        SamplingImpl samp = (SamplingImpl)seis.sampling_info;
        TimeInterval period = samp.getPeriod();
        period = period.convertTo(UnitImpl.SECOND);
        float f = (float)period.get_value();
        sac.e = (float)sac.npts * f;
        sac.iftype = 1;
        sac.leven = 1;
        sac.delta = f;
        sac.idep = 5;
        UnitImpl yUnit = (UnitImpl)seis.y_unit;
        QuantityImpl min = seis.getMinValue();
        sac.depmin = (float)min.convertTo((UnitImpl)yUnit).value;
        QuantityImpl max = seis.getMaxValue();
        sac.depmax = (float)max.convertTo((UnitImpl)yUnit).value;
        QuantityImpl mean = seis.getMeanValue();
        sac.depmen = (float)mean.convertTo((UnitImpl)yUnit).value;
        FissuresToSac.setKZTime(sac, new MicroSecondDate(seis.begin_time));
        sac.knetwk = seis.channel_id.network_id.network_code;
        sac.kstnm = seis.channel_id.station_code;
        sac.kcmpnm = !seis.channel_id.site_code.equals("  ") ? seis.channel_id.site_code + seis.channel_id.channel_code : seis.channel_id.channel_code;
        sac.khole = seis.channel_id.site_code;
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addChannel(sac, channel);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Origin origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addOrigin(sac, origin);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel, Origin origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        if (channel != null) {
            FissuresToSac.addChannel(sac, channel);
        }
        if (origin != null) {
            FissuresToSac.addOrigin(sac, origin);
        }
        if (origin != null && channel != null) {
            DistAz distAz = new DistAz(channel, origin);
            sac.gcarc = (float)distAz.getDelta();
        }
        return sac;
    }

    public static void addChannel(SacTimeSeries sac, Channel channel) {
        sac.stla = channel.my_site.my_location.latitude;
        sac.stlo = channel.my_site.my_location.longitude;
        QuantityImpl z = (QuantityImpl)channel.my_site.my_location.elevation;
        sac.stel = (float)z.convertTo((UnitImpl)UnitImpl.METER).value;
        z = (QuantityImpl)channel.my_site.my_location.depth;
        sac.stdp = (float)z.convertTo((UnitImpl)UnitImpl.METER).value;
        sac.cmpaz = channel.an_orientation.azimuth;
        sac.cmpinc = 90.0f + channel.an_orientation.dip;
    }

    public static void addOrigin(SacTimeSeries sac, Origin origin) {
        sac.evla = origin.my_location.latitude;
        sac.evlo = origin.my_location.longitude;
        QuantityImpl z = (QuantityImpl)origin.my_location.elevation;
        sac.evel = (float)z.convertTo((UnitImpl)UnitImpl.METER).value;
        z = (QuantityImpl)origin.my_location.depth;
        sac.evdp = (float)z.convertTo((UnitImpl)UnitImpl.METER).value;
        ISOTime isoTime = new ISOTime(sac.nzyear, sac.nzjday, sac.nzhour, sac.nzmin, (float)sac.nzsec + (float)sac.nzmsec / 1000.0f);
        MicroSecondDate beginTime = isoTime.getDate();
        MicroSecondDate originTime = new MicroSecondDate(origin.origin_time);
        FissuresToSac.setKZTime(sac, originTime);
        TimeInterval sacBMarker = beginTime.subtract(originTime);
        sacBMarker = (TimeInterval)sacBMarker.convertTo(UnitImpl.SECOND);
        sac.b = (float)sacBMarker.value;
        sac.o = 0.0f;
        if (origin.magnitudes.length > 0) {
            sac.mag = origin.magnitudes[0].value;
        }
    }

    public static void setKZTime(SacTimeSeries sac, MicroSecondDate date) {
        Calendar cal = ClockUtil.getGMTCalendar();
        cal.setTime((Date)date);
        sac.nzyear = cal.get(1);
        sac.nzjday = cal.get(6);
        sac.nzhour = cal.get(11);
        sac.nzmin = cal.get(12);
        sac.nzsec = cal.get(13);
        sac.nzmsec = cal.get(14);
    }

    public static SacPoleZero getPoleZero(Response response) throws InvalidResponse {
        InstrumentationLoader.repairResponse(response);
        if (!InstrumentationLoader.isValid(response)) {
            throw new IllegalArgumentException("response is not valid");
        }
        Stage stage = response.stages[0];
        Filter filter = stage.filters[0];
        if (filter.discriminator().value() != 1) {
            throw new IllegalArgumentException("Unexpected response type " + filter.discriminator().value());
        }
        PoleZeroFilter pz = filter.pole_zero_filter();
        int gamma = 0;
        UnitImpl unit = (UnitImpl)stage.input_units;
        if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND)) {
            gamma = 1;
        } else if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            gamma = 2;
        }
        int num_zeros = pz.zeros.length + gamma;
        double mulFactor = 1.0;
        if (stage.type == TransferType.ANALOG) {
            mulFactor = Math.PI * 2;
        }
        Cmplx[] zeros = SacPoleZero.initCmplx(num_zeros);
        for (int i = 0; i < pz.zeros.length; ++i) {
            zeros[i] = new Cmplx((double)pz.zeros[i].real * mulFactor, (double)pz.zeros[i].imaginary * mulFactor);
        }
        Cmplx[] poles = SacPoleZero.initCmplx(pz.poles.length);
        for (int i = 0; i < pz.poles.length; ++i) {
            poles[i] = new Cmplx((double)pz.poles[i].real * mulFactor, (double)pz.poles[i].imaginary * mulFactor);
        }
        float constant = stage.the_normalization[0].ao_normalization_factor;
        double sd = response.the_sensitivity.sensitivity_factor;
        double fs = response.the_sensitivity.frequency;
        sd *= Math.pow(Math.PI * 2 * fs, gamma);
        double A0 = stage.the_normalization[0].ao_normalization_factor;
        double fn = stage.the_normalization[0].normalization_freq;
        A0 /= Math.pow(Math.PI * 2 * fn, gamma);
        if (stage.type == TransferType.ANALOG) {
            A0 *= Math.pow(Math.PI * 2, pz.poles.length - pz.zeros.length);
        }
        constant = poles.length == 0 && zeros.length == 0 ? (float)(sd * A0) : (float)(sd * FissuresToSac.calc_A0(poles, zeros, fs));
        return new SacPoleZero(poles, zeros, constant);
    }

    private static double calc_A0(Cmplx[] poles, Cmplx[] zeros, double ref_freq) {
        int i;
        Cmplx f0 = new Cmplx(0.0, Math.PI * 2 * ref_freq);
        Cmplx hold = zeros[0];
        Cmplx denom = Cmplx.sub(f0, hold);
        for (i = 1; i < zeros.length; ++i) {
            hold = zeros[i];
            denom = Cmplx.mul(denom, Cmplx.sub(f0, hold));
        }
        hold = poles[0];
        Cmplx numer = Cmplx.sub(f0, hold);
        for (i = 1; i < poles.length; ++i) {
            hold = poles[i];
            numer = Cmplx.mul(numer, Cmplx.sub(f0, hold));
        }
        double a0 = Cmplx.div(numer, denom).mag();
        return a0;
    }
}

