/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.Location;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCLocation;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.rt130.XYReader;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class StationLocationUpdater {
    private static boolean dryRun = false;
    private static final Logger logger = Logger.getLogger((Class)StationLocationUpdater.class);

    public static void update(Connection conn, Map stationToLocationId) throws SQLException {
        Statement stmt = conn.createStatement();
        Iterator it = stationToLocationId.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String code = (String)entry.getKey();
            Object locId = entry.getValue();
            int stationsUpdated = stmt.executeUpdate("UPDATE station SET loc_id = " + locId + " WHERE sta_code = '" + code + "';");
            int siteUpdated = stmt.executeUpdate("UPDATE site SET loc_id = " + locId + " WHERE site_id IN ( select site_id FROM site JOIN station on (station.sta_id = site.sta_id) WHERE station.sta_code = '" + code + "' );");
            logger.debug((Object)(stationsUpdated + " station updates and " + siteUpdated + " site updates"));
        }
    }

    public static Map getIncorrectLocations(Connection conn, Map stationToLocation) throws SQLException, NotFound {
        HashMap<String, Integer> stationToCorrectLocId = new HashMap<String, Integer>();
        JDBCLocation locationTable = new JDBCLocation(conn);
        Iterator it = stationToLocation.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry entry = it.next();
            Location loc = (Location)entry.getValue();
            int locId = locationTable.put(loc);
            String code = (String)entry.getKey();
            ResultSet rs = conn.createStatement().executeQuery("SELECT loc_id FROM station WHERE sta_code = '" + code + "';");
            while (rs.next()) {
                int staLocId = rs.getInt("loc_id");
                if (staLocId == locId) continue;
                stationToCorrectLocId.put(code, new Integer(locId));
                Location incorrectLocation = locationTable.get(staLocId);
                logger.info((Object)(code + "'s location " + XYReader.toString(incorrectLocation) + " being replaced by " + XYReader.toString(loc)));
                continue block0;
            }
        }
        return stationToCorrectLocId;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, SQLException, NotFound {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--dry-run") && !args[i].equals("-n")) continue;
            dryRun = true;
            logger.info((Object)(args[i] + " specified so no changes being made."));
        }
        Properties props = Initializer.loadProperties(args);
        PropertyConfigurator.configure((Properties)props);
        String xyFileLoc = props.getProperty("stationLocationUpdater.xyfile");
        Map stationLocations = XYReader.read(new BufferedReader(new FileReader(xyFileLoc)));
        ConnMgr.installDbProperties(props, args);
        Connection conn = ConnMgr.createConnection();
        Map incorrects = StationLocationUpdater.getIncorrectLocations(conn, stationLocations);
        if (!dryRun) {
            StationLocationUpdater.update(conn, incorrects);
        }
    }
}

