/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.ConnectionCreator;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.seismogram.JDBCSeismogramFiles;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130Report;
import edu.sc.seis.fissuresUtil.rt130.FileNameParser;
import edu.sc.seis.fissuresUtil.rt130.LeapSecondApplier;
import edu.sc.seis.fissuresUtil.rt130.NCFile;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandlerFlag;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.rt130.XYReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RT130FileHandler {
    private RT130ToLocalSeismogram toSeismogram;
    private List flags;
    private NCFile ncFile;
    private RT130Report report;
    private Connection conn;
    private Properties props;
    private JDBCSeismogramFiles jdbcSeisFile;
    private Map stationLocations;
    private Map datastreamToChannel = new HashMap();
    private Map datastreamToFileData = new HashMap();
    private static final Logger logger = Logger.getLogger((Class)RT130FileHandler.class);

    public RT130FileHandler(Properties props, List rt130FileHandlerFlags) throws SQLException, FileNotFoundException, IOException, ParseException {
        this.flags = rt130FileHandlerFlags;
        this.checkFlagsForIncompatibleSettings();
        LeapSecondApplier.addLeapSeconds(props.getProperty("leapSecondFile"));
        LeapSecondApplier.addCorrections(props.getProperty("powerUpTimes"));
        this.ncFile = new NCFile(props.getProperty("NCFile"));
        logger.debug((Object)("NC file location: " + this.ncFile.getCanonicalPath()));
        String xyFileLoc = props.getProperty("XYFile");
        logger.debug((Object)("XY file location: " + xyFileLoc));
        if (this.flags.contains(RT130FileHandlerFlag.FULL)) {
            ConnectionCreator connCreator = new ConnectionCreator(props);
            this.conn = connCreator.createConnection();
            this.jdbcSeisFile = new JDBCSeismogramFiles(this.conn);
        }
        this.report = new RT130Report();
        this.props = props;
        this.stationLocations = XYReader.read(new BufferedReader(new FileReader(xyFileLoc)));
        this.toSeismogram = RT130ToLocalSeismogram.create(props);
    }

    public boolean processSingleRefTekScan(String fileLoc, String fileName) throws IOException, SQLException, NotFound, ParseException {
        File file = new File(fileLoc);
        String yearAndDay = file.getParentFile().getParentFile().getParentFile().getName();
        String unitIdNumber = file.getParentFile().getParentFile().getName();
        String datastream = file.getParentFile().getName();
        if (!this.datastreamToFileData.containsKey(unitIdNumber + datastream)) {
            PacketType[] fileData;
            RT130FileReader rtFileReader = new RT130FileReader(fileLoc, false);
            try {
                fileData = rtFileReader.processRT130Data();
            }
            catch (RT130FormatException e) {
                this.report.addProblemFile(fileLoc, fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage());
                logger.error((Object)(fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage()));
                return false;
            }
            this.datastreamToFileData.put(unitIdNumber + datastream, fileData[0]);
        }
        if (!this.datastreamToChannel.containsKey(unitIdNumber + datastream) && !datastream.equals("0")) {
            Channel[] newChannel = this.createChannels(unitIdNumber, datastream);
            this.datastreamToChannel.put(unitIdNumber + datastream, newChannel);
        }
        if (fileName.endsWith("00000000")) {
            Channel[] channel = (Channel[])this.datastreamToChannel.get(unitIdNumber + datastream);
            for (int i = 0; i < channel.length; ++i) {
                this.processSingleRefTekWithKnownChannel(fileLoc, fileName, channel[i], unitIdNumber);
            }
            return true;
        }
        try {
            MicroSecondDate beginTime = FileNameParser.getBeginTime(yearAndDay, fileName);
            beginTime = LeapSecondApplier.applyLeapSecondCorrection(unitIdNumber, beginTime);
            TimeInterval lengthOfData = FileNameParser.getLengthOfData(fileName);
            double nominalLengthOfData = Double.valueOf(this.props.getProperty("nominalLengthOfData"));
            if (lengthOfData.value > nominalLengthOfData + nominalLengthOfData * 0.05) {
                Channel[] channel = (Channel[])this.datastreamToChannel.get(unitIdNumber + datastream);
                this.report.addProblemFile(fileLoc, fileName + " seems to be an invalid rt130 file name. The file will be read to determine its true length.");
                logger.error((Object)(fileName + " seems to be an invalid rt130 file name. The file was read to determine its true length."));
                for (int i = 0; i < channel.length; ++i) {
                    this.processSingleRefTekWithKnownChannel(fileLoc, fileName, channel[i], unitIdNumber);
                }
                return true;
            }
            MicroSecondDate endTime = beginTime.add(lengthOfData);
            Channel[] channel = (Channel[])this.datastreamToChannel.get(unitIdNumber + datastream);
            for (int i = 0; i < channel.length; ++i) {
                this.addSeismogramToReport(channel[i], beginTime, endTime);
            }
            return true;
        }
        catch (RT130FormatException e) {
            this.report.addProblemFile(fileLoc, fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage());
            logger.error((Object)(fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage()));
            return false;
        }
    }

    public boolean processSingleRefTekFull(String fileLoc, String fileName) throws IOException, SQLException, NotFound, ParseException {
        if (this.ncFile == null) {
            logger.debug((Object)"No NC (Network Configuration) file was specified. The channel IDs created will not be correct.");
        }
        RT130FileReader toSeismogramDataPackets = new RT130FileReader(fileLoc, true);
        PacketType[] seismogramDataPacketArray = null;
        try {
            seismogramDataPacketArray = toSeismogramDataPackets.processRT130Data();
        }
        catch (RT130FormatException e) {
            this.report.addProblemFile(fileLoc, fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage());
            logger.error((Object)(fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage()));
            return false;
        }
        LocalSeismogramImpl[] seismogramArray = this.toSeismogram.ConvertRT130ToLocalSeismogram(seismogramDataPacketArray);
        Channel[] channel = this.toSeismogram.getChannels();
        for (int i = 0; i < seismogramArray.length; ++i) {
            if (this.flags.contains(RT130FileHandlerFlag.SCAN) || this.flags.contains(RT130FileHandlerFlag.FULL)) {
                this.addSeismogramToReport(channel[i], seismogramArray[i].getBeginTime(), seismogramArray[i].getEndTime());
                continue;
            }
            Channel closeChannel = this.jdbcSeisFile.findCloseChannel(channel[i], new QuantityImpl(1.0, (Unit)UnitImpl.KILOMETER));
            if (closeChannel == null) {
                this.addSeismogramToReport(channel[i], seismogramArray[i].getBeginTime(), seismogramArray[i].getEndTime());
                continue;
            }
            this.jdbcSeisFile.setChannelBeginTimeToEarliest(closeChannel, channel[i]);
            this.addSeismogramToReport(closeChannel, seismogramArray[i].getBeginTime(), seismogramArray[i].getEndTime());
        }
        return true;
    }

    private Channel[] createChannels(String unitIdNumber, String datastream) {
        Time networkBeginTime;
        String stationCode = this.ncFile.getUnitName(((PacketType)this.datastreamToFileData.get((Object)new StringBuffer().append((String)unitIdNumber).append((String)datastream).toString())).begin_time_from_state_of_health_file, unitIdNumber);
        String networkIdString = this.props.getProperty("network.remap.XX");
        Time channelBeginTime = networkBeginTime = this.ncFile.network_begin_time.getFissuresTime();
        NetworkId networkId = PopulationProperties.getNetworkAttr(networkIdString, this.props).get_id();
        networkId.begin_time = networkBeginTime;
        String tempCode = "B";
        if (((PacketType)this.datastreamToFileData.get((Object)new StringBuffer().append((String)unitIdNumber).append((String)datastream).toString())).sample_rate < 10) {
            tempCode = "L";
        }
        ChannelId[] channelId = new ChannelId[]{new ChannelId(networkId, stationCode, "00", tempCode + "HZ", channelBeginTime), new ChannelId(networkId, stationCode, "00", tempCode + "HN", channelBeginTime), new ChannelId(networkId, stationCode, "00", tempCode + "HE", channelBeginTime)};
        TimeRange effectiveChannelTime = new TimeRange(channelBeginTime, TimeUtils.timeUnknown);
        SiteId siteId = new SiteId(networkId, stationCode, "00", channelBeginTime);
        StationId stationId = new StationId(networkId, stationCode, channelBeginTime);
        Location location = new Location(0.0f, 0.0f, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC);
        if (this.stationLocations.containsKey(stationCode)) {
            location = (Location)this.stationLocations.get(stationCode);
        } else {
            logger.error((Object)("XY file did not contain a location for unit " + stationCode + ".\n" + "The location used for the unit will be a lat/long of 0/0."));
        }
        NetworkAttrImpl networkAttr = PopulationProperties.getNetworkAttr(networkIdString, this.props);
        StationImpl station = new StationImpl(stationId, "", location, effectiveChannelTime, "", "", "", (NetworkAttr)networkAttr);
        SiteImpl site = new SiteImpl(siteId, location, effectiveChannelTime, (Station)station, "");
        SamplingImpl sampling = new SamplingImpl(((PacketType)this.datastreamToFileData.get((Object)new StringBuffer().append((String)unitIdNumber).append((String)datastream).toString())).sample_rate, new TimeInterval(1.0, UnitImpl.SECOND));
        ChannelImpl[] newChannel = new ChannelImpl[channelId.length];
        for (int i = 0; i < channelId.length; ++i) {
            if (channelId[i].channel_code.endsWith("N")) {
                newChannel[i] = new ChannelImpl(channelId[i], "", new Orientation(0.0f, 0.0f), (Sampling)sampling, effectiveChannelTime, (Site)site);
                continue;
            }
            if (channelId[i].channel_code.endsWith("E")) {
                newChannel[i] = new ChannelImpl(channelId[i], "", new Orientation(90.0f, 0.0f), (Sampling)sampling, effectiveChannelTime, (Site)site);
                continue;
            }
            if (!channelId[i].channel_code.endsWith("Z")) continue;
            newChannel[i] = new ChannelImpl(channelId[i], "", new Orientation(0.0f, -90.0f), (Sampling)sampling, effectiveChannelTime, (Site)site);
        }
        return newChannel;
    }

    private boolean processSingleRefTekWithKnownChannel(String fileLoc, String fileName, Channel knownChannel, String unitIdNumber) throws IOException, SQLException, NotFound, ParseException {
        RT130FileReader toSeismogramDataPackets = new RT130FileReader(fileLoc, false);
        PacketType[] seismogramDataPacketArray = null;
        try {
            seismogramDataPacketArray = toSeismogramDataPackets.processRT130Data();
        }
        catch (RT130FormatException e) {
            this.report.addProblemFile(fileLoc, fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage());
            logger.error((Object)(fileName + " seems to be an invalid rt130 file." + "\n" + e.getMessage()));
            return false;
        }
        LocalSeismogramImpl[] seismogramArray = this.toSeismogram.ConvertRT130ToLocalSeismogram(seismogramDataPacketArray);
        for (int i = 0; i < seismogramArray.length; ++i) {
            this.addSeismogramToReport(knownChannel, LeapSecondApplier.applyLeapSecondCorrection(unitIdNumber, seismogramArray[i].getBeginTime()), LeapSecondApplier.applyLeapSecondCorrection(unitIdNumber, seismogramArray[i].getEndTime()));
        }
        return true;
    }

    private void addSeismogramToReport(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) throws SQLException, NotFound {
        this.report.addRefTekSeismogram(channel, beginTime, endTime);
    }

    private void checkFlagsForIncompatibleSettings() {
        if (this.flags.contains(RT130FileHandlerFlag.SCAN) && this.flags.contains(RT130FileHandlerFlag.FULL)) {
            while (this.flags.contains(RT130FileHandlerFlag.FULL)) {
                this.flags.remove(RT130FileHandlerFlag.FULL);
            }
            logger.warn((Object)"Both -scan and -full flags were set.");
            logger.warn((Object)"Scan processing of RT130 data: ON");
        }
        if (this.flags.contains(RT130FileHandlerFlag.NO_LOGS) && this.flags.contains(RT130FileHandlerFlag.MAKE_LOGS)) {
            while (this.flags.contains(RT130FileHandlerFlag.NO_LOGS)) {
                this.flags.remove(RT130FileHandlerFlag.NO_LOGS);
            }
            logger.warn((Object)"Both -nologs and -makelogs flags were set.");
            logger.warn((Object)"Log creation: ON");
        }
    }

    public List getFlags() {
        return this.flags;
    }

    public RT130Report getReport() {
        return this.report;
    }

    public Properties getProps() {
        return this.props;
    }

    public JDBCSeismogramFiles getJDBCSeismogramFiles() {
        return this.jdbcSeisFile;
    }
}

