/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.parmo3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class Text2D
extends Shape3D {
    private static Hashtable metricsTable = new Hashtable();
    float rectangleScaleFactor = 0.00390625f;
    Point3f position = new Point3f();
    Color3f color = new Color3f();
    String fontName = new String();
    int fontSize;
    int fontStyle;

    public Text2D(String text, Point3f position, Color3f color, String fontName, int fontSize, int fontStyle) {
        this.color.set((Tuple3f)color);
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.position = position;
        this.updateText2D(text, position, color, fontName, fontSize, fontStyle);
    }

    private void setString(String text) {
        this.updateText2D(text, this.position, this.color, this.fontName, this.fontSize, this.fontStyle);
    }

    private void updateText2D(String text, Point3f position, Color3f color, String fontName, int fontSize, int fontStyle) {
        BufferedImage bImage = this.setupImage(text, color, fontName, fontSize, fontStyle);
        Texture2D t2d = this.setupTexture(bImage);
        QuadArray rect = this.setupGeometry(bImage.getWidth(), bImage.getHeight(), position);
        Appearance appearance = this.setupAppearance(t2d);
        this.setGeometry((Geometry)rect);
        this.setAppearance(appearance);
    }

    public void setRectangleScaleFactor(float newScaleFactor) {
        this.rectangleScaleFactor = newScaleFactor;
    }

    public float getRectangleScaleFactor() {
        return this.rectangleScaleFactor;
    }

    private Texture2D setupTexture(BufferedImage bImage) {
        ImageComponent2D imageComponent = new ImageComponent2D(2, bImage);
        Texture2D t2d = new Texture2D(1, 6, bImage.getWidth(), bImage.getHeight());
        t2d.setMinFilter(3);
        t2d.setMagFilter(3);
        t2d.setImage(0, (ImageComponent)imageComponent);
        t2d.setEnable(true);
        return t2d;
    }

    private BufferedImage setupImage(String text, Color3f color, String fontName, int fontSize, int fontStyle) {
        int i;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics metrics = (FontMetrics)metricsTable.get(font);
        if (metrics == null) {
            metrics = toolkit.getFontMetrics(font);
            metricsTable.put(font, metrics);
        }
        int width = metrics.stringWidth(text);
        int descent = metrics.getMaxDescent();
        int ascent = metrics.getMaxAscent();
        int leading = metrics.getLeading();
        int height = descent + ascent;
        int pow = 1;
        for (i = 1; i < 32 && width > (pow *= 2); ++i) {
        }
        width = Math.max(width, pow);
        pow = 1;
        for (i = 1; i < 32 && height > (pow *= 2); ++i) {
        }
        height = Math.max(height, pow);
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D offscreenGraphics = bImage.createGraphics();
        Color myFill = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        offscreenGraphics.setColor(myFill);
        offscreenGraphics.fillRect(0, 0, width, height);
        offscreenGraphics.setFont(font);
        Color myTextColor = new Color(color.x, color.y, color.z, 1.0f);
        offscreenGraphics.setColor(myTextColor);
        ((Graphics)offscreenGraphics).drawString(text, 0, height - descent);
        return bImage;
    }

    private QuadArray setupGeometry(int width, int height, Point3f position) {
        float[] loc = new float[]{0.0f, 0.0f, 0.0f};
        position.get(loc);
        float xPosition = loc[0];
        float yPosition = loc[1];
        float zPosition = loc[2];
        float rectWidth = (float)width * this.rectangleScaleFactor;
        float rectHeight = (float)height * this.rectangleScaleFactor;
        float[] verts1 = new float[]{xPosition + rectWidth, yPosition, zPosition, xPosition + rectWidth, yPosition + rectHeight, zPosition, xPosition, yPosition + rectHeight, zPosition, xPosition, yPosition, zPosition};
        float[] texCoords = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, -1.0f};
        QuadArray rect = new QuadArray(4, 33);
        rect.setCoordinates(0, verts1);
        rect.setTextureCoordinates(0, texCoords);
        return rect;
    }

    private Appearance setupAppearance(Texture2D t2d) {
        TransparencyAttributes transp = new TransparencyAttributes();
        transp.setTransparencyMode(2);
        transp.setTransparency(0.0f);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(transp);
        appearance.setTexture((Texture)t2d);
        Material m = new Material();
        m.setLightingEnable(false);
        appearance.setMaterial(m);
        return appearance;
    }
}

