/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.namingService;

import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CreateNameContexts {
    static String[] interfaces = new String[]{"PlottableDC", "NetworkDC", "DataCenter", "EventDC"};
    private static final Logger logger = Logger.getLogger((Class)CreateNameContexts.class);

    public static void main(String[] args) throws NotFound, CannotProceed, InvalidName {
        int i;
        BasicConfigurator.configure();
        Initializer.init(args);
        String dns = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-dns") && i2 < args.length - 1) {
                dns = args[i2 + 1];
                continue;
            }
            if (!args[0].equals("-h") && !args[0].equals("--help")) continue;
            CreateNameContexts.printHelp();
            return;
        }
        if (dns == null) {
            CreateNameContexts.printHelp();
            return;
        }
        String dnsWithKind = FissuresNamingService.appendKindNames(dns);
        FissuresNamingService fisName = Initializer.getNS();
        NamingContextExt topLevel = fisName.getNameService();
        NameComponent[] name = topLevel.to_name(dnsWithKind);
        NamingContextExt lastContext = topLevel;
        NameComponent[] subName = new NameComponent[1];
        for (i = 0; i < name.length; ++i) {
            try {
                logger.debug((java.lang.Object)("Binding " + name[i].id + "." + name[i].kind + " as new context"));
                System.arraycopy(name, i, subName, 0, subName.length);
                logger.debug((java.lang.Object)("NameComponent: " + CreateNameContexts.nameComponentToString(subName)));
                lastContext = lastContext.bind_new_context(subName);
                continue;
            }
            catch (AlreadyBound e) {
                lastContext = NamingContextHelper.narrow((Object)lastContext.resolve(subName));
            }
        }
        for (i = 0; i < interfaces.length; ++i) {
            try {
                subName[0] = new NameComponent(interfaces[i], "interface");
                lastContext.bind_new_context(subName);
                continue;
            }
            catch (AlreadyBound e) {
                // empty catch block
            }
        }
    }

    static String nameComponentToString(NameComponent[] name) {
        String out = "";
        for (int i = 0; i < name.length; ++i) {
            out = out + "/" + name[i].id + "." + name[i].kind;
        }
        return out;
    }

    static void printHelp() {
        System.out.println("Options: -props propfile\n    -dns dnsname\n\nfor example: java ...CreateNameContext -props server.props -dns edu/sc/seis");
    }
}

