/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.flow.querier;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAccessSeqHolder;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.iris.Fissures.IfEvent.EventSeqIter;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.sc.seis.fissuresUtil.flow.querier.EventFinderQuery;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class EventFinderIterator
implements Iterator {
    private EventAccessOperations[] currentEvents;
    private int positionInCurrent;
    private final int eventsPerNext;
    private EventSeqIter iter;
    private static final Logger logger = Logger.getLogger((Class)EventFinderIterator.class);

    public static EventFinderIterator create(EventFinder ef) {
        return EventFinderIterator.create(ef, new EventFinderQuery());
    }

    public static EventFinderIterator create(EventFinder ef, EventFinderQuery eq) {
        return EventFinderIterator.create(ef, eq, 100);
    }

    public static EventFinderIterator create(EventFinder ef, EventFinderQuery eq, int eventsPerServerCall) {
        EventSeqIterHolder holder = new EventSeqIterHolder();
        EventAccessOperations[] events = EventFinderIterator.getEvents(eq, ef, holder, eventsPerServerCall);
        return new EventFinderIterator(events, holder.value, eventsPerServerCall);
    }

    public static EventAccessOperations[] getEvents(EventFinderQuery q, EventFinder finder, EventSeqIterHolder holder, int eventsPerServerCall) {
        return finder.query_events(q.getArea(), q.getMinDepthQuantity(), q.getMaxDepthQuantity(), q.getTime().getFissuresTimeRange(), q.getTypes(), q.getMinMag(), q.getMaxMag(), q.getCatalogs(), q.getContributors(), eventsPerServerCall, holder);
    }

    public EventFinderIterator(EventAccessOperations[] initialEvents, EventSeqIter iter, int eventsPerNext) {
        this.eventsPerNext = eventsPerNext;
        logger.debug((Object)("got " + initialEvents.length + " events from initial query"));
        this.currentEvents = initialEvents;
        this.iter = iter;
    }

    public boolean hasNext() {
        boolean result;
        boolean bl = result = this.positionInCurrent < this.currentEvents.length || this.eventsInIter();
        if (!result && this.iter != null) {
            this.iter.destroy();
        }
        return result;
    }

    public Object next() {
        if (this.positionInCurrent >= this.currentEvents.length) {
            if (this.eventsInIter()) {
                EventAccessSeqHolder eHolder = new EventAccessSeqHolder();
                this.iter.next_n(this.eventsPerNext, eHolder);
                this.currentEvents = eHolder.value;
                this.positionInCurrent = 0;
            } else {
                throw new NoSuchElementException("No more items in event iterator.  Call hasNext() before calling next()");
            }
        }
        return this.currentEvents[this.positionInCurrent++];
    }

    private boolean eventsInIter() {
        return this.iter != null && this.iter.how_many_remain() > 0;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove events returned from server");
    }
}

