/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.Section;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class HTMLReporter
implements ExceptionReporter {
    private File directory;
    private int numErrors;

    public HTMLReporter(File directory) throws IOException {
        this.directory = directory;
        this.numErrors = this.getLastHandledErNo();
        this.initIndexFile();
    }

    public void report(String message, Throwable e, List sections) throws IOException {
        File outFile = new File(this.directory, "Exception_" + ++this.numErrors + ".html");
        this.appendToIndexFile(outFile, e);
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));
        String str = this.getHeader(e, this.numErrors);
        str = str + message;
        str = str + "\n<br/>\n<br/>\n";
        String stackTrace = "<h2>Stack Trace</h2><br/>";
        str = str + stackTrace + this.makeDivider(stackTrace.length()) + "<pre>" + ExceptionReporterUtils.getTrace(e) + "</pre>";
        bw.write(this.constructString(str, sections));
        bw.close();
    }

    protected void initIndexFile() throws IOException {
        char q = '\"';
        File index = new File(this.directory, "index.html");
        if (index.exists()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(index, true));
            this.writeln(out, "<hr>");
            this.writeln(out, "Restarted at " + ClockUtil.now() + ".<br>");
            this.writeln(out, "There have been " + this.numErrors + " errors so far.");
            this.writeln(out, "<hr>");
            out.close();
        } else {
            BufferedWriter out = new BufferedWriter(new FileWriter(index));
            this.writeln(out, "<html>");
            this.writeln(out, "   <head>");
            this.writeln(out, "      <title>Errors</title>");
            this.writeln(out, "      <style media=" + q + "all" + q + ">@import " + q + "../main.css" + q + ";</style>");
            this.writeln(out, "   </head>");
            this.writeln(out, "   <body>");
            this.writeln(out, "      <div id=" + q + "Header" + q + ">Errors found:</div>");
            this.writeln(out, "<br/>");
            this.writeln(out, "<div id=" + q + "Content" + q + ">");
            out.close();
        }
    }

    protected void appendToIndexFile(File errorFile, Throwable t) throws IOException {
        File index = new File(this.directory, "index.html");
        BufferedWriter out = new BufferedWriter(new FileWriter(index, true));
        this.writeln(out, new MicroSecondDate() + " <a href=" + '\"' + errorFile.getName() + '\"' + ">" + t.getClass().getName() + "</a><br/>");
        out.close();
    }

    protected void writeln(BufferedWriter out, String s) throws IOException {
        out.write(s);
        out.newLine();
    }

    protected int getLastHandledErNo() {
        File[] files = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.substring(0, 10).equals("Exception_");
            }
        });
        return files.length;
    }

    private String constructString(String initialBit, List sections) {
        Iterator it = sections.iterator();
        while (it.hasNext()) {
            initialBit = initialBit + "<hr/><br/>\n" + this.constructString((Section)it.next());
        }
        return initialBit;
    }

    private String constructString(Section sec) {
        String result = sec.getName() + "<br/>" + this.makeDivider(sec.getName().length());
        result = result + "<pre>" + sec.getContents() + "</pre>";
        return result;
    }

    private String makeDivider(int len) {
        return "<hr/>";
    }

    protected String getHeader(Throwable t, int i) {
        String s = "<html>\n";
        s = s + "  <head>\n";
        s = s + "     <title>" + t.getClass().getName() + " " + i + "</title>\n";
        s = s + "  </head>\n";
        s = s + "  <body>\n";
        return s;
    }
}

