/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.IndividualizedAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import org.w3c.dom.Element;

public class AmpConfigConfiguration
implements Cloneable {
    private String type;
    private AmpConfigConfiguration ampConfigForIndividualizedInternal;
    private static ConfigDefinitions defs = new ConfigDefinitions();

    public void configure(Element element) {
        this.type = DOMHelper.extractText(element, "type");
        if (this.type.equals("individual") && DOMHelper.hasElement(element, "ampConfig")) {
            Element ampConfigEl = DOMHelper.getElement(element, "ampConfig");
            this.ampConfigForIndividualizedInternal = AmpConfigConfiguration.create(ampConfigEl);
        }
    }

    public AmpConfig createAmpConfig() {
        AmpConfig ac = null;
        if (this.type.equals("basic")) {
            ac = new BasicAmpConfig();
        } else if (this.type.equals("rmean")) {
            ac = new RMeanAmpConfig();
        } else if (this.type.equals("individual")) {
            ac = new IndividualizedAmpConfig(this.ampConfigForIndividualizedInternal.createAmpConfig());
        }
        return ac;
    }

    public static AmpConfigConfiguration create(Element el) {
        AmpConfigConfiguration c = null;
        if (defs.hasDefinition(el)) {
            AmpConfigConfiguration base = (AmpConfigConfiguration)defs.getDefinition(el);
            c = (AmpConfigConfiguration)base.clone();
        } else {
            c = new AmpConfigConfiguration();
        }
        c.configure(el);
        defs.updateDefinitions(el, c);
        return c;
    }

    public Object clone() {
        AmpConfigConfiguration clone = new AmpConfigConfiguration();
        clone.type = this.type;
        clone.ampConfigForIndividualizedInternal = this.ampConfigForIndividualizedInternal;
        return clone;
    }
}

