/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SeismogramPrinter
implements Printable {
    private static final int CANCELLED = -1;
    private Dimension[] sizes;
    private boolean[] topBorder;
    private boolean[] bottomBorder;
    private BasicSeismogramDisplay[] displays;
    private int pageCount;
    private boolean initialized = false;
    private int seisPerPage = -1;
    private static EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);

    public static void print(BasicSeismogramDisplay[] displays) {
        new SeismogramPrinter(displays);
    }

    private SeismogramPrinter(BasicSeismogramDisplay[] displays) {
        this.displays = displays;
        if (displays.length == 0) {
            return;
        }
        this.sizes = new Dimension[displays.length];
        this.bottomBorder = new boolean[displays.length];
        this.topBorder = new boolean[displays.length];
        for (int i = 0; i < displays.length; ++i) {
            displays[i].setDoubleBuffered(false);
            this.sizes[i] = displays[i].getSize();
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        if (this.initialize() != -1 && pj.printDialog()) {
            try {
                pj.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < displays.length; ++i) {
            displays[i].setDoubleBuffered(true);
            if (!this.bottomBorder[i]) {
                // empty if block
            }
            if (!this.topBorder[i]) {
                // empty if block
            }
            displays[i].setSize(this.sizes[i]);
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.pageCount) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension imageableSize = new Dimension();
        imageableSize.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight() / (double)this.seisPerPage);
        for (int i = pageIndex * this.seisPerPage; i < this.displays.length && i < (pageIndex + 1) * this.seisPerPage; ++i) {
            this.displays[i].setSize(imageableSize);
            this.displays[i].paint(g2);
            g2.translate(0.0, pageFormat.getImageableHeight() / (double)this.seisPerPage);
        }
        return 0;
    }

    private int initialize() {
        final int numOfSeis = this.displays.length;
        final JDialog dialog = new JDialog();
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setTitle("Printing Options");
        dialog.setModal(true);
        JLabel information = new JLabel("Seismograms per page:  ");
        Integer[] numbers = new Integer[numOfSeis];
        for (int i = 0; i < numOfSeis; ++i) {
            numbers[i] = new Integer(i + 1);
        }
        final JComboBox<Integer> options = new JComboBox<Integer>(numbers);
        options.setEditable(true);
        options.setMaximumSize(options.getMinimumSize());
        options.setPreferredSize(options.getMinimumSize());
        JButton next = new JButton("Next");
        next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int currentNumber = (Integer)options.getSelectedItem();
                if (currentNumber < 0) {
                    JOptionPane.showMessageDialog(null, "The number of seismograms selected must be greater than 0", "Selected Too Few", 2);
                } else if (currentNumber > numOfSeis) {
                    JOptionPane.showMessageDialog(null, "The number of seismograms selected must less than " + (numOfSeis + 1), "Selected Too Many", 2);
                } else {
                    SeismogramPrinter.this.setSeisPerPage(currentNumber);
                    dialog.dispose();
                }
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeismogramPrinter.this.setSeisPerPage(-1);
                dialog.dispose();
            }
        });
        JPanel north = new JPanel(new BorderLayout());
        north.setBorder(emptyBorder);
        north.add((Component)information, "West");
        north.add(options, "East");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(emptyBorder);
        south.add((Component)cancel, "West");
        south.add((Component)next, "East");
        dialog.getContentPane().add((Component)north, "North");
        dialog.getContentPane().add((Component)south, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        dialog.setLocation(tk.getScreenSize().width / 2, tk.getScreenSize().height / 2);
        dialog.pack();
        dialog.show();
        this.pageCount = this.displays.length / this.seisPerPage + (this.displays.length % this.seisPerPage > 0 ? 1 : 0);
        return this.seisPerPage;
    }

    private void setSeisPerPage(int seisPerPage) {
        this.seisPerPage = seisPerPage;
    }
}

