/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SeismogramPDFBuilder {
    private static int leftMargin = 50;
    private static int rightMargin = 50;
    private static int topMargin = 50;
    private static int bottomMargin = 50;
    private static int horizMargins = leftMargin + rightMargin;
    private static int vertMargins = topMargin + bottomMargin;

    public static void createPDF(SeismogramDisplay disp, String fileName) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(disp, fileName, 1);
    }

    public static void createPDF(SeismogramDisplay disp, String fileName, boolean landscape) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(disp, fileName, 1, landscape);
    }

    public static void createPDF(SeismogramDisplay disp, String fileName, int dispPerPage) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(disp, new File(fileName), dispPerPage);
    }

    public static void createPDF(SeismogramDisplay disp, String fileName, int dispPerPage, boolean landscape) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(disp, new File(fileName), dispPerPage, landscape);
    }

    public static void createPDF(SeismogramDisplay disp, File f, int dispPerPage) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(disp, f, dispPerPage, false);
    }

    public static void createPDF(SeismogramDisplay disp, File f, int dispPerPage, boolean landscape) throws FileNotFoundException {
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        SeismogramPDFBuilder.createPDF(disp, new FileOutputStream(f), dispPerPage, landscape);
    }

    public static void createPDF(SeismogramDisplay disp, FileOutputStream fos, int dispPerPage) {
        SeismogramPDFBuilder.createPDF(disp, fos, dispPerPage, false);
    }

    public static void createPDF(SeismogramDisplay disp, FileOutputStream fos, int dispPerPage, boolean landscape) {
        AbstractList displays = new ArrayList<SeismogramDisplay>();
        if (disp instanceof VerticalSeismogramDisplay) {
            displays = ((VerticalSeismogramDisplay)disp).getDisplays();
            Iterator it = displays.iterator();
            while (it.hasNext()) {
                BasicSeismogramDisplay cur = (BasicSeismogramDisplay)it.next();
                cur.clear(7);
                if (cur.isFilled(1)) continue;
                cur.add(new TimeBorder(cur), 1);
            }
        } else {
            displays.add(disp);
        }
        Document document = new Document(PageSize.LETTER);
        try {
            int pixelsPerDisplayW;
            int pixelsPerDisplayH;
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
            document.open();
            int pageW = (int)PageSize.LETTER.width();
            int pageH = (int)PageSize.LETTER.height();
            if (landscape) {
                pixelsPerDisplayH = (int)Math.floor((double)(pageW - horizMargins) / (double)dispPerPage);
                pixelsPerDisplayW = (int)Math.floor(pageH - vertMargins);
            } else {
                pixelsPerDisplayH = (int)Math.floor((double)(pageH - vertMargins) / (double)dispPerPage);
                pixelsPerDisplayW = (int)Math.floor(pageW - horizMargins);
            }
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tpTraces = cb.createTemplate((float)pageW, (float)pageH);
            Graphics2D g2Traces = tpTraces.createGraphics((float)pageW, (float)pageH);
            if (landscape) {
                g2Traces.translate(pageW, 0);
                g2Traces.rotate(Math.toRadians(90.0));
            }
            g2Traces.translate(rightMargin, topMargin);
            int seisOnCurPage = 0;
            Iterator it = displays.iterator();
            while (it.hasNext()) {
                SeismogramDisplay sd = (SeismogramDisplay)it.next();
                sd.renderToGraphics(g2Traces, new Dimension(pixelsPerDisplayW, pixelsPerDisplayH));
                if (++seisOnCurPage == dispPerPage) {
                    cb.addTemplate(tpTraces, 0.0f, 0.0f);
                    g2Traces.dispose();
                    document.newPage();
                    tpTraces = cb.createTemplate((float)pageW, (float)pageH);
                    g2Traces = tpTraces.createGraphics((float)pageW, (float)pageH);
                    if (landscape) {
                        g2Traces.translate(pageW, 0);
                        g2Traces.rotate(Math.toRadians(90.0));
                    }
                    g2Traces.translate(rightMargin, topMargin);
                    seisOnCurPage = 0;
                    continue;
                }
                g2Traces.translate(0, pixelsPerDisplayH);
            }
            if (seisOnCurPage != 0) {
                cb.addTemplate(tpTraces, 0.0f, 0.0f);
                g2Traces.dispose();
            }
        }
        catch (DocumentException ex) {
            GlobalExceptionHandler.handle("problem saving to pdf", ex);
        }
        document.close();
        if (disp instanceof VerticalSeismogramDisplay) {
            ((VerticalSeismogramDisplay)disp).setBorders();
        }
    }
}

