/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.TitleBorder;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.IndividualizedAmpConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Component;

public class ComponentSortedSeismogramDisplay
extends VerticalSeismogramDisplay {
    private boolean handleBorders = true;
    private BasicSeismogramDisplay north;
    private BasicSeismogramDisplay east;
    private BasicSeismogramDisplay z;

    public ComponentSortedSeismogramDisplay() {
        this(true);
    }

    public ComponentSortedSeismogramDisplay(boolean handleBorders) {
        this.handleBorders = handleBorders;
    }

    public void add(DataSetSeismogram[] dss) {
        DataSetSeismogram[][] componentSorted = DisplayUtils.sortByComponents(dss);
        this.z = this.addToDisplay(this.z, componentSorted[2], "Up");
        this.north = this.addToDisplay(this.north, componentSorted[0], "North");
        this.east = this.addToDisplay(this.east, componentSorted[1], "East");
        if (this.handleBorders) {
            this.setBorders();
        }
    }

    public void setZ(BasicSeismogramDisplay sd) {
        this.z = sd;
        this.setupDisplay(sd, "East");
    }

    public void setNorth(BasicSeismogramDisplay sd) {
        this.north = sd;
        this.setupDisplay(sd, "North");
    }

    public void setEast(BasicSeismogramDisplay sd) {
        this.east = sd;
        this.setupDisplay(sd, "East");
    }

    private BasicSeismogramDisplay addToDisplay(BasicSeismogramDisplay display, DataSetSeismogram[] seismos, String orientation) {
        if (seismos.length > 0) {
            if (display == null) {
                display = new BasicSeismogramDisplay();
                this.setupDisplay(display, orientation);
                this.addOrientationTitleBorder(display, orientation);
            }
            display.add(seismos);
        }
        return display;
    }

    private int setupDisplay(BasicSeismogramDisplay display, String orientation) {
        display.setTimeConfig(this.tc);
        display.setParentDisplay(this);
        int position = -1;
        if (orientation == "Up") {
            position = 0;
        } else if (orientation == "North") {
            position = this.z != null ? 1 : 0;
        }
        this.getCenter().add((Component)display, position);
        return position;
    }

    private void addOrientationTitleBorder(BasicSeismogramDisplay disp, String orientation) {
        disp.add(new TitleBorder(0, 1, orientation), 5);
    }

    public void setIndividualizedAmpConfig(AmpConfig ac) {
        Class<?> configClass = ac.getClass();
        for (int i = 0; i < this.getCenter().getComponentCount(); ++i) {
            try {
                IndividualizedAmpConfig newAmp = new IndividualizedAmpConfig((AmpConfig)configClass.newInstance());
                ((SeismogramDisplay)this.getCenter().getComponent(i)).setAmpConfig(newAmp);
                continue;
            }
            catch (IllegalAccessException e) {
                GlobalExceptionHandler.handle("Problem creating ampConfig from class", e);
                continue;
            }
            catch (InstantiationException e) {
                GlobalExceptionHandler.handle("Problem creating ampConfig from class", e);
            }
        }
    }

    public boolean removeDisplay(BasicSeismogramDisplay display) {
        if (display == this.north) {
            this.north = null;
        } else if (display == this.east) {
            this.east = null;
        } else {
            this.z = null;
        }
        return super.removeDisplay(display);
    }
}

